/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import android.media.ImageReader;
import android.util.Size;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.AndroidImageReaderProxy;
import androidx.camera.core.ImageInfo;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Logger;
import androidx.camera.core.SettableImageProxy;
import androidx.camera.core.SettableImageProxyBundle;
import androidx.camera.core.impl.CaptureProcessor;
import androidx.camera.core.impl.ImageProxyBundle;
import androidx.camera.core.impl.ImageReaderProxy;
import androidx.camera.core.impl.utils.executor.CameraXExecutors;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.core.util.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;

@RequiresApi(value=21)
class CaptureProcessorPipeline
implements CaptureProcessor {
    private static final String TAG = "CaptureProcessorPipeline";
    @NonNull
    private final CaptureProcessor mPreCaptureProcessor;
    @NonNull
    private final CaptureProcessor mPostCaptureProcessor;
    @NonNull
    private final ListenableFuture<List<Void>> mUnderlyingCaptureProcessorsCloseFuture;
    @NonNull
    final Executor mExecutor;
    private final int mMaxImages;
    private ImageReaderProxy mIntermediateImageReader = null;
    private ImageInfo mSourceImageInfo = null;
    private final Object mLock = new Object();
    @GuardedBy(value="mLock")
    private boolean mClosed = false;
    @GuardedBy(value="mLock")
    private boolean mProcessing = false;
    @GuardedBy(value="mLock")
    CallbackToFutureAdapter.Completer<Void> mCloseCompleter;
    @GuardedBy(value="mLock")
    private ListenableFuture<Void> mCloseFuture;

    CaptureProcessorPipeline(@NonNull CaptureProcessor preCaptureProcessor, int maxImages, @NonNull CaptureProcessor postCaptureProcessor, @NonNull Executor executor) {
        this.mPreCaptureProcessor = preCaptureProcessor;
        this.mPostCaptureProcessor = postCaptureProcessor;
        ArrayList<ListenableFuture<Void>> closeFutureList = new ArrayList<ListenableFuture<Void>>();
        closeFutureList.add(this.mPreCaptureProcessor.getCloseFuture());
        closeFutureList.add(this.mPostCaptureProcessor.getCloseFuture());
        this.mUnderlyingCaptureProcessorsCloseFuture = Futures.allAsList(closeFutureList);
        this.mExecutor = executor;
        this.mMaxImages = maxImages;
    }

    @Override
    public void onOutputSurface(@NonNull Surface surface, int imageFormat) {
        this.mPostCaptureProcessor.onOutputSurface(surface, imageFormat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process(@NonNull ImageProxyBundle bundle) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClosed) {
                return;
            }
            this.mProcessing = true;
        }
        List<Integer> ids = bundle.getCaptureIds();
        ListenableFuture<ImageProxy> imageProxyListenableFuture = bundle.getImageProxy(ids.get(0));
        Preconditions.checkArgument((boolean)imageProxyListenableFuture.isDone());
        try {
            ImageInfo imageInfo;
            ImageProxy imageProxy = (ImageProxy)imageProxyListenableFuture.get();
            this.mSourceImageInfo = imageInfo = imageProxy.getImageInfo();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalArgumentException("Can not successfully extract ImageProxy from the ImageProxyBundle.");
        }
        this.mPreCaptureProcessor.process(bundle);
    }

    @Override
    public void onResolutionUpdate(@NonNull Size size) {
        this.mIntermediateImageReader = new AndroidImageReaderProxy(ImageReader.newInstance((int)size.getWidth(), (int)size.getHeight(), (int)35, (int)this.mMaxImages));
        this.mPreCaptureProcessor.onOutputSurface(this.mIntermediateImageReader.getSurface(), 35);
        this.mPreCaptureProcessor.onResolutionUpdate(size);
        this.mPostCaptureProcessor.onResolutionUpdate(size);
        this.mIntermediateImageReader.setOnImageAvailableListener(imageReader -> {
            ImageProxy image = imageReader.acquireNextImage();
            try {
                this.mExecutor.execute(() -> this.postProcess(image));
            }
            catch (RejectedExecutionException e) {
                Logger.e(TAG, "The executor for post-processing might have been shutting down or terminated!");
                image.close();
            }
        }, CameraXExecutors.directExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postProcess(ImageProxy imageProxy) {
        boolean closed;
        Object object = this.mLock;
        synchronized (object) {
            closed = this.mClosed;
        }
        if (!closed) {
            Size resolution = new Size(imageProxy.getWidth(), imageProxy.getHeight());
            Preconditions.checkNotNull((Object)this.mSourceImageInfo);
            String tagBundleKey = this.mSourceImageInfo.getTagBundle().listKeys().iterator().next();
            int captureId = (Integer)this.mSourceImageInfo.getTagBundle().getTag(tagBundleKey);
            SettableImageProxy settableImageProxy = new SettableImageProxy(imageProxy, resolution, this.mSourceImageInfo);
            this.mSourceImageInfo = null;
            SettableImageProxyBundle settableImageProxyBundle = new SettableImageProxyBundle(Collections.singletonList(captureId), tagBundleKey);
            settableImageProxyBundle.addImageProxy(settableImageProxy);
            try {
                this.mPostCaptureProcessor.process(settableImageProxyBundle);
            }
            catch (Exception e) {
                Logger.e(TAG, "Post processing image failed! " + e.getMessage());
            }
        }
        object = this.mLock;
        synchronized (object) {
            this.mProcessing = false;
        }
        this.closeAndCompleteFutureIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClosed) {
                return;
            }
            this.mClosed = true;
        }
        this.mPreCaptureProcessor.close();
        this.mPostCaptureProcessor.close();
        this.closeAndCompleteFutureIfNecessary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeAndCompleteFutureIfNecessary() {
        CallbackToFutureAdapter.Completer<Void> closeCompleter;
        boolean processing;
        boolean closed;
        Object object = this.mLock;
        synchronized (object) {
            closed = this.mClosed;
            processing = this.mProcessing;
            closeCompleter = this.mCloseCompleter;
            if (closed && !processing) {
                this.mIntermediateImageReader.close();
            }
        }
        if (closed && !processing && closeCompleter != null) {
            this.mUnderlyingCaptureProcessorsCloseFuture.addListener(() -> closeCompleter.set(null), CameraXExecutors.directExecutor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public ListenableFuture<Void> getCloseFuture() {
        Object closeFuture;
        Object object = this.mLock;
        synchronized (object) {
            if (this.mClosed && !this.mProcessing) {
                closeFuture = Futures.transform(this.mUnderlyingCaptureProcessorsCloseFuture, nullVoid -> null, CameraXExecutors.directExecutor());
            } else {
                if (this.mCloseFuture == null) {
                    this.mCloseFuture = CallbackToFutureAdapter.getFuture(completer -> {
                        Object object = this.mLock;
                        synchronized (object) {
                            this.mCloseCompleter = completer;
                        }
                        return "CaptureProcessorPipeline-close";
                    });
                }
                closeFuture = Futures.nonCancellationPropagating(this.mCloseFuture);
            }
        }
        return closeFuture;
    }
}

