/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.content.ClipData;
import android.content.ClipDescription;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.util.Pair;
import android.view.ContentInfo;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.util.Preconditions;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public final class ContentInfoCompat {
    public static final int SOURCE_APP = 0;
    public static final int SOURCE_CLIPBOARD = 1;
    public static final int SOURCE_INPUT_METHOD = 2;
    public static final int SOURCE_DRAG_AND_DROP = 3;
    public static final int SOURCE_AUTOFILL = 4;
    public static final int SOURCE_PROCESS_TEXT = 5;
    public static final int FLAG_CONVERT_TO_PLAIN_TEXT = 1;
    @NonNull
    private final Compat mCompat;

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @NonNull
    static String sourceToString(int source) {
        switch (source) {
            case 0: {
                return "SOURCE_APP";
            }
            case 1: {
                return "SOURCE_CLIPBOARD";
            }
            case 2: {
                return "SOURCE_INPUT_METHOD";
            }
            case 3: {
                return "SOURCE_DRAG_AND_DROP";
            }
            case 4: {
                return "SOURCE_AUTOFILL";
            }
            case 5: {
                return "SOURCE_PROCESS_TEXT";
            }
        }
        return String.valueOf(source);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    @NonNull
    static String flagsToString(int flags) {
        if ((flags & 1) != 0) {
            return "FLAG_CONVERT_TO_PLAIN_TEXT";
        }
        return String.valueOf(flags);
    }

    ContentInfoCompat(@NonNull Compat compat) {
        this.mCompat = compat;
    }

    @RequiresApi(value=31)
    @NonNull
    public static ContentInfoCompat toContentInfoCompat(@NonNull ContentInfo platContentInfo) {
        return new ContentInfoCompat(new Compat31Impl(platContentInfo));
    }

    @RequiresApi(value=31)
    @NonNull
    public ContentInfo toContentInfo() {
        return Objects.requireNonNull(this.mCompat.getWrapped());
    }

    @NonNull
    public String toString() {
        return this.mCompat.toString();
    }

    @NonNull
    public ClipData getClip() {
        return this.mCompat.getClip();
    }

    public int getSource() {
        return this.mCompat.getSource();
    }

    public int getFlags() {
        return this.mCompat.getFlags();
    }

    @Nullable
    public Uri getLinkUri() {
        return this.mCompat.getLinkUri();
    }

    @Nullable
    public Bundle getExtras() {
        return this.mCompat.getExtras();
    }

    @NonNull
    public Pair<ContentInfoCompat, ContentInfoCompat> partition(@NonNull androidx.core.util.Predicate<ClipData.Item> itemPredicate) {
        ClipData clip = this.mCompat.getClip();
        if (clip.getItemCount() == 1) {
            boolean matched = itemPredicate.test(clip.getItemAt(0));
            return Pair.create((Object)(matched ? this : null), (Object)(matched ? null : this));
        }
        Pair<ClipData, ClipData> split = ContentInfoCompat.partition(clip, itemPredicate);
        if (split.first == null) {
            return Pair.create(null, (Object)this);
        }
        if (split.second == null) {
            return Pair.create((Object)this, null);
        }
        return Pair.create((Object)new Builder(this).setClip((ClipData)split.first).build(), (Object)new Builder(this).setClip((ClipData)split.second).build());
    }

    @NonNull
    static Pair<ClipData, ClipData> partition(@NonNull ClipData clip, @NonNull androidx.core.util.Predicate<ClipData.Item> itemPredicate) {
        ArrayList<ClipData.Item> acceptedItems = null;
        ArrayList<ClipData.Item> remainingItems = null;
        for (int i = 0; i < clip.getItemCount(); ++i) {
            ClipData.Item item = clip.getItemAt(i);
            if (itemPredicate.test(item)) {
                acceptedItems = acceptedItems == null ? new ArrayList<ClipData.Item>() : acceptedItems;
                acceptedItems.add(item);
                continue;
            }
            remainingItems = remainingItems == null ? new ArrayList<ClipData.Item>() : remainingItems;
            remainingItems.add(item);
        }
        if (acceptedItems == null) {
            return Pair.create(null, (Object)clip);
        }
        if (remainingItems == null) {
            return Pair.create((Object)clip, null);
        }
        return Pair.create((Object)ContentInfoCompat.buildClipData(clip.getDescription(), acceptedItems), (Object)ContentInfoCompat.buildClipData(clip.getDescription(), (List<ClipData.Item>)remainingItems));
    }

    @NonNull
    static ClipData buildClipData(@NonNull ClipDescription description, @NonNull List<ClipData.Item> items) {
        ClipData clip = new ClipData(new ClipDescription(description), items.get(0));
        for (int i = 1; i < items.size(); ++i) {
            clip.addItem(items.get(i));
        }
        return clip;
    }

    @RequiresApi(value=31)
    @NonNull
    public static Pair<ContentInfo, ContentInfo> partition(@NonNull ContentInfo payload, @NonNull Predicate<ClipData.Item> itemPredicate) {
        return Api31Impl.partition(payload, itemPredicate);
    }

    @RequiresApi(value=31)
    private static final class BuilderCompat31Impl
    implements BuilderCompat {
        @NonNull
        private final ContentInfo.Builder mPlatformBuilder;

        BuilderCompat31Impl(@NonNull ClipData clip, int source) {
            this.mPlatformBuilder = new ContentInfo.Builder(clip, source);
        }

        BuilderCompat31Impl(@NonNull ContentInfoCompat other) {
            this.mPlatformBuilder = new ContentInfo.Builder(other.toContentInfo());
        }

        @Override
        public void setClip(@NonNull ClipData clip) {
            this.mPlatformBuilder.setClip(clip);
        }

        @Override
        public void setSource(int source) {
            this.mPlatformBuilder.setSource(source);
        }

        @Override
        public void setFlags(int flags) {
            this.mPlatformBuilder.setFlags(flags);
        }

        @Override
        public void setLinkUri(@Nullable Uri linkUri) {
            this.mPlatformBuilder.setLinkUri(linkUri);
        }

        @Override
        public void setExtras(@Nullable Bundle extras) {
            this.mPlatformBuilder.setExtras(extras);
        }

        @Override
        @NonNull
        public ContentInfoCompat build() {
            return new ContentInfoCompat(new Compat31Impl(this.mPlatformBuilder.build()));
        }
    }

    private static final class BuilderCompatImpl
    implements BuilderCompat {
        @NonNull
        ClipData mClip;
        int mSource;
        int mFlags;
        @Nullable
        Uri mLinkUri;
        @Nullable
        Bundle mExtras;

        BuilderCompatImpl(@NonNull ClipData clip, int source) {
            this.mClip = clip;
            this.mSource = source;
        }

        BuilderCompatImpl(@NonNull ContentInfoCompat other) {
            this.mClip = other.getClip();
            this.mSource = other.getSource();
            this.mFlags = other.getFlags();
            this.mLinkUri = other.getLinkUri();
            this.mExtras = other.getExtras();
        }

        @Override
        public void setClip(@NonNull ClipData clip) {
            this.mClip = clip;
        }

        @Override
        public void setSource(int source) {
            this.mSource = source;
        }

        @Override
        public void setFlags(int flags) {
            this.mFlags = flags;
        }

        @Override
        public void setLinkUri(@Nullable Uri linkUri) {
            this.mLinkUri = linkUri;
        }

        @Override
        public void setExtras(@Nullable Bundle extras) {
            this.mExtras = extras;
        }

        @Override
        @NonNull
        public ContentInfoCompat build() {
            return new ContentInfoCompat(new CompatImpl(this));
        }
    }

    private static interface BuilderCompat {
        public void setClip(@NonNull ClipData var1);

        public void setSource(int var1);

        public void setFlags(int var1);

        public void setLinkUri(@Nullable Uri var1);

        public void setExtras(@Nullable Bundle var1);

        @NonNull
        public ContentInfoCompat build();
    }

    public static final class Builder {
        @NonNull
        private final BuilderCompat mBuilderCompat;

        public Builder(@NonNull ContentInfoCompat other) {
            this.mBuilderCompat = Build.VERSION.SDK_INT >= 31 ? new BuilderCompat31Impl(other) : new BuilderCompatImpl(other);
        }

        public Builder(@NonNull ClipData clip, int source) {
            this.mBuilderCompat = Build.VERSION.SDK_INT >= 31 ? new BuilderCompat31Impl(clip, source) : new BuilderCompatImpl(clip, source);
        }

        @NonNull
        public Builder setClip(@NonNull ClipData clip) {
            this.mBuilderCompat.setClip(clip);
            return this;
        }

        @NonNull
        public Builder setSource(int source) {
            this.mBuilderCompat.setSource(source);
            return this;
        }

        @NonNull
        public Builder setFlags(int flags) {
            this.mBuilderCompat.setFlags(flags);
            return this;
        }

        @NonNull
        public Builder setLinkUri(@Nullable Uri linkUri) {
            this.mBuilderCompat.setLinkUri(linkUri);
            return this;
        }

        @NonNull
        public Builder setExtras(@Nullable Bundle extras) {
            this.mBuilderCompat.setExtras(extras);
            return this;
        }

        @NonNull
        public ContentInfoCompat build() {
            return this.mBuilderCompat.build();
        }
    }

    @RequiresApi(value=31)
    private static final class Compat31Impl
    implements Compat {
        @NonNull
        private final ContentInfo mWrapped;

        Compat31Impl(@NonNull ContentInfo wrapped) {
            this.mWrapped = Preconditions.checkNotNull(wrapped);
        }

        @Override
        @NonNull
        public ContentInfo getWrapped() {
            return this.mWrapped;
        }

        @Override
        @NonNull
        public ClipData getClip() {
            return this.mWrapped.getClip();
        }

        @Override
        public int getSource() {
            return this.mWrapped.getSource();
        }

        @Override
        public int getFlags() {
            return this.mWrapped.getFlags();
        }

        @Override
        @Nullable
        public Uri getLinkUri() {
            return this.mWrapped.getLinkUri();
        }

        @Override
        @Nullable
        public Bundle getExtras() {
            return this.mWrapped.getExtras();
        }

        @NonNull
        public String toString() {
            return "ContentInfoCompat{" + this.mWrapped + "}";
        }
    }

    private static final class CompatImpl
    implements Compat {
        @NonNull
        private final ClipData mClip;
        private final int mSource;
        private final int mFlags;
        @Nullable
        private final Uri mLinkUri;
        @Nullable
        private final Bundle mExtras;

        CompatImpl(BuilderCompatImpl b) {
            this.mClip = Preconditions.checkNotNull(b.mClip);
            this.mSource = Preconditions.checkArgumentInRange(b.mSource, 0, 5, "source");
            this.mFlags = Preconditions.checkFlagsArgument(b.mFlags, 1);
            this.mLinkUri = b.mLinkUri;
            this.mExtras = b.mExtras;
        }

        @Override
        @Nullable
        public ContentInfo getWrapped() {
            return null;
        }

        @Override
        @NonNull
        public ClipData getClip() {
            return this.mClip;
        }

        @Override
        public int getSource() {
            return this.mSource;
        }

        @Override
        public int getFlags() {
            return this.mFlags;
        }

        @Override
        @Nullable
        public Uri getLinkUri() {
            return this.mLinkUri;
        }

        @Override
        @Nullable
        public Bundle getExtras() {
            return this.mExtras;
        }

        @NonNull
        public String toString() {
            return "ContentInfoCompat{clip=" + this.mClip.getDescription() + ", source=" + ContentInfoCompat.sourceToString(this.mSource) + ", flags=" + ContentInfoCompat.flagsToString(this.mFlags) + (this.mLinkUri == null ? "" : ", hasLinkUri(" + this.mLinkUri.toString().length() + ")") + (this.mExtras == null ? "" : ", hasExtras") + "}";
        }
    }

    private static interface Compat {
        @Nullable
        public ContentInfo getWrapped();

        @NonNull
        public ClipData getClip();

        public int getSource();

        public int getFlags();

        @Nullable
        public Uri getLinkUri();

        @Nullable
        public Bundle getExtras();
    }

    @RequiresApi(value=31)
    private static final class Api31Impl {
        private Api31Impl() {
        }

        @DoNotInline
        @NonNull
        public static Pair<ContentInfo, ContentInfo> partition(@NonNull ContentInfo payload, @NonNull Predicate<ClipData.Item> itemPredicate) {
            ClipData clip = payload.getClip();
            if (clip.getItemCount() == 1) {
                boolean matched = itemPredicate.test(clip.getItemAt(0));
                return Pair.create((Object)(matched ? payload : null), (Object)(matched ? null : payload));
            }
            Pair<ClipData, ClipData> split = ContentInfoCompat.partition(clip, itemPredicate::test);
            if (split.first == null) {
                return Pair.create(null, (Object)payload);
            }
            if (split.second == null) {
                return Pair.create((Object)payload, null);
            }
            return Pair.create((Object)new ContentInfo.Builder(payload).setClip((ClipData)split.first).build(), (Object)new ContentInfo.Builder(payload).setClip((ClipData)split.second).build());
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static @interface Flags {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static @interface Source {
    }
}

