/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.os.Build;
import android.util.Log;
import android.view.MenuItem;
import android.view.View;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.internal.view.SupportMenuItem;
import androidx.core.view.ActionProvider;

public final class MenuItemCompat {
    private static final String TAG = "MenuItemCompat";
    @Deprecated
    public static final int SHOW_AS_ACTION_NEVER = 0;
    @Deprecated
    public static final int SHOW_AS_ACTION_IF_ROOM = 1;
    @Deprecated
    public static final int SHOW_AS_ACTION_ALWAYS = 2;
    @Deprecated
    public static final int SHOW_AS_ACTION_WITH_TEXT = 4;
    @Deprecated
    public static final int SHOW_AS_ACTION_COLLAPSE_ACTION_VIEW = 8;

    @Deprecated
    public static void setShowAsAction(MenuItem item, int actionEnum) {
        item.setShowAsAction(actionEnum);
    }

    @Deprecated
    public static MenuItem setActionView(MenuItem item, View view) {
        return item.setActionView(view);
    }

    @Deprecated
    public static MenuItem setActionView(MenuItem item, int resId) {
        return item.setActionView(resId);
    }

    @Deprecated
    public static View getActionView(MenuItem item) {
        return item.getActionView();
    }

    @Nullable
    public static MenuItem setActionProvider(@NonNull MenuItem item, @Nullable ActionProvider provider) {
        if (item instanceof SupportMenuItem) {
            return ((SupportMenuItem)item).setSupportActionProvider(provider);
        }
        Log.w((String)TAG, (String)"setActionProvider: item does not implement SupportMenuItem; ignoring");
        return item;
    }

    @Nullable
    public static ActionProvider getActionProvider(@NonNull MenuItem item) {
        if (item instanceof SupportMenuItem) {
            return ((SupportMenuItem)item).getSupportActionProvider();
        }
        Log.w((String)TAG, (String)"getActionProvider: item does not implement SupportMenuItem; returning null");
        return null;
    }

    @Deprecated
    public static boolean expandActionView(MenuItem item) {
        return item.expandActionView();
    }

    @Deprecated
    public static boolean collapseActionView(MenuItem item) {
        return item.collapseActionView();
    }

    @Deprecated
    public static boolean isActionViewExpanded(MenuItem item) {
        return item.isActionViewExpanded();
    }

    @Deprecated
    public static MenuItem setOnActionExpandListener(MenuItem item, final OnActionExpandListener listener) {
        return item.setOnActionExpandListener(new MenuItem.OnActionExpandListener(){

            public boolean onMenuItemActionExpand(MenuItem item) {
                return listener.onMenuItemActionExpand(item);
            }

            public boolean onMenuItemActionCollapse(MenuItem item) {
                return listener.onMenuItemActionCollapse(item);
            }
        });
    }

    public static void setContentDescription(@NonNull MenuItem item, @Nullable CharSequence contentDescription) {
        if (item instanceof SupportMenuItem) {
            ((SupportMenuItem)item).setContentDescription(contentDescription);
        } else if (Build.VERSION.SDK_INT >= 26) {
            Api26Impl.setContentDescription(item, contentDescription);
        }
    }

    @Nullable
    public static CharSequence getContentDescription(@NonNull MenuItem item) {
        if (item instanceof SupportMenuItem) {
            return ((SupportMenuItem)item).getContentDescription();
        }
        if (Build.VERSION.SDK_INT >= 26) {
            return Api26Impl.getContentDescription(item);
        }
        return null;
    }

    public static void setTooltipText(@NonNull MenuItem item, @Nullable CharSequence tooltipText) {
        if (item instanceof SupportMenuItem) {
            ((SupportMenuItem)item).setTooltipText(tooltipText);
        } else if (Build.VERSION.SDK_INT >= 26) {
            Api26Impl.setTooltipText(item, tooltipText);
        }
    }

    @Nullable
    public static CharSequence getTooltipText(@NonNull MenuItem item) {
        if (item instanceof SupportMenuItem) {
            return ((SupportMenuItem)item).getTooltipText();
        }
        if (Build.VERSION.SDK_INT >= 26) {
            return Api26Impl.getTooltipText(item);
        }
        return null;
    }

    public static void setShortcut(@NonNull MenuItem item, char numericChar, char alphaChar, int numericModifiers, int alphaModifiers) {
        if (item instanceof SupportMenuItem) {
            ((SupportMenuItem)item).setShortcut(numericChar, alphaChar, numericModifiers, alphaModifiers);
        } else if (Build.VERSION.SDK_INT >= 26) {
            Api26Impl.setShortcut(item, numericChar, alphaChar, numericModifiers, alphaModifiers);
        }
    }

    public static void setNumericShortcut(@NonNull MenuItem item, char numericChar, int numericModifiers) {
        if (item instanceof SupportMenuItem) {
            ((SupportMenuItem)item).setNumericShortcut(numericChar, numericModifiers);
        } else if (Build.VERSION.SDK_INT >= 26) {
            Api26Impl.setNumericShortcut(item, numericChar, numericModifiers);
        }
    }

    public static int getNumericModifiers(@NonNull MenuItem item) {
        if (item instanceof SupportMenuItem) {
            return ((SupportMenuItem)item).getNumericModifiers();
        }
        if (Build.VERSION.SDK_INT >= 26) {
            return Api26Impl.getNumericModifiers(item);
        }
        return 0;
    }

    public static void setAlphabeticShortcut(@NonNull MenuItem item, char alphaChar, int alphaModifiers) {
        if (item instanceof SupportMenuItem) {
            ((SupportMenuItem)item).setAlphabeticShortcut(alphaChar, alphaModifiers);
        } else if (Build.VERSION.SDK_INT >= 26) {
            Api26Impl.setAlphabeticShortcut(item, alphaChar, alphaModifiers);
        }
    }

    public static int getAlphabeticModifiers(@NonNull MenuItem item) {
        if (item instanceof SupportMenuItem) {
            return ((SupportMenuItem)item).getAlphabeticModifiers();
        }
        if (Build.VERSION.SDK_INT >= 26) {
            return Api26Impl.getAlphabeticModifiers(item);
        }
        return 0;
    }

    public static void setIconTintList(@NonNull MenuItem item, @Nullable ColorStateList tint) {
        if (item instanceof SupportMenuItem) {
            ((SupportMenuItem)item).setIconTintList(tint);
        } else if (Build.VERSION.SDK_INT >= 26) {
            Api26Impl.setIconTintList(item, tint);
        }
    }

    @Nullable
    public static ColorStateList getIconTintList(@NonNull MenuItem item) {
        if (item instanceof SupportMenuItem) {
            return ((SupportMenuItem)item).getIconTintList();
        }
        if (Build.VERSION.SDK_INT >= 26) {
            return Api26Impl.getIconTintList(item);
        }
        return null;
    }

    public static void setIconTintMode(@NonNull MenuItem item, @Nullable PorterDuff.Mode tintMode) {
        if (item instanceof SupportMenuItem) {
            ((SupportMenuItem)item).setIconTintMode(tintMode);
        } else if (Build.VERSION.SDK_INT >= 26) {
            Api26Impl.setIconTintMode(item, tintMode);
        }
    }

    @Nullable
    public static PorterDuff.Mode getIconTintMode(@NonNull MenuItem item) {
        if (item instanceof SupportMenuItem) {
            return ((SupportMenuItem)item).getIconTintMode();
        }
        if (Build.VERSION.SDK_INT >= 26) {
            return Api26Impl.getIconTintMode(item);
        }
        return null;
    }

    private MenuItemCompat() {
    }

    @RequiresApi(value=26)
    static class Api26Impl {
        private Api26Impl() {
        }

        @DoNotInline
        static MenuItem setContentDescription(MenuItem menuItem, CharSequence contentDescription) {
            return menuItem.setContentDescription(contentDescription);
        }

        @DoNotInline
        static CharSequence getContentDescription(MenuItem menuItem) {
            return menuItem.getContentDescription();
        }

        @DoNotInline
        static MenuItem setTooltipText(MenuItem menuItem, CharSequence tooltipText) {
            return menuItem.setTooltipText(tooltipText);
        }

        @DoNotInline
        static CharSequence getTooltipText(MenuItem menuItem) {
            return menuItem.getTooltipText();
        }

        @DoNotInline
        static MenuItem setShortcut(MenuItem menuItem, char numericChar, char alphaChar, int numericModifiers, int alphaModifiers) {
            return menuItem.setShortcut(numericChar, alphaChar, numericModifiers, alphaModifiers);
        }

        @DoNotInline
        static MenuItem setNumericShortcut(MenuItem menuItem, char numericChar, int numericModifiers) {
            return menuItem.setNumericShortcut(numericChar, numericModifiers);
        }

        @DoNotInline
        static int getNumericModifiers(MenuItem menuItem) {
            return menuItem.getNumericModifiers();
        }

        @DoNotInline
        static MenuItem setAlphabeticShortcut(MenuItem menuItem, char alphaChar, int alphaModifiers) {
            return menuItem.setAlphabeticShortcut(alphaChar, alphaModifiers);
        }

        @DoNotInline
        static int getAlphabeticModifiers(MenuItem menuItem) {
            return menuItem.getAlphabeticModifiers();
        }

        @DoNotInline
        static MenuItem setIconTintList(MenuItem menuItem, ColorStateList tint) {
            return menuItem.setIconTintList(tint);
        }

        @DoNotInline
        static ColorStateList getIconTintList(MenuItem menuItem) {
            return menuItem.getIconTintList();
        }

        @DoNotInline
        static MenuItem setIconTintMode(MenuItem menuItem, PorterDuff.Mode tintMode) {
            return menuItem.setIconTintMode(tintMode);
        }

        @DoNotInline
        static PorterDuff.Mode getIconTintMode(MenuItem menuItem) {
            return menuItem.getIconTintMode();
        }
    }

    @Deprecated
    public static interface OnActionExpandListener {
        public boolean onMenuItemActionExpand(MenuItem var1);

        public boolean onMenuItemActionCollapse(MenuItem var1);
    }
}

