/*
 * Decompiled with CFR 0.152.
 */
package androidx.activity.lint;

import com.android.builder.model.AndroidLibrary;
import com.android.builder.model.MavenCoordinates;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.GradleScanner;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KProperty1;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KCallablesJvm;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UIdentifier;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 ;2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001;B\u0005\u00a2\u0006\u0002\u0010\u0004J$\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00190\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020 H\u0002JB\u0010!\u001a\u00020\u00162\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020 2\b\u0010'\u001a\u0004\u0018\u00010 2\u0006\u0010(\u001a\u00020\u001d2\u0006\u0010)\u001a\u00020\u001dH\u0016J\u0018\u0010*\u001a\u00020\u00162\u0006\u0010+\u001a\u00020,2\u0006\u0010\"\u001a\u00020#H\u0002J\u0018\u0010-\u001a\u00020\u00162\u0006\u0010+\u001a\u00020,2\u0006\u0010\"\u001a\u00020#H\u0002J\u0012\u0010.\u001a\u0004\u0018\u00010/2\u0006\u0010\"\u001a\u000200H\u0016J\u0018\u00101\u001a\u0012\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020403\u0018\u000102H\u0016J\u0018\u00105\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u00106\u001a\u00020 H\u0002J\u0010\u00107\u001a\u00020 2\u0006\u0010%\u001a\u00020 H\u0002J\"\u00108\u001a\u00020\u00162\u0006\u0010%\u001a\u00020 2\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u00109\u001a\u00020\u0006H\u0002J\u0010\u0010:\u001a\u00020\u00062\u0006\u0010+\u001a\u00020,H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR*\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006<"}, d2={"Landroidx/activity/lint/ActivityResultFragmentVersionDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/Detector$UastScanner;", "Lcom/android/tools/lint/detector/api/GradleScanner;", "()V", "checkedImplementationDependencies", "", "expression", "Lorg/jetbrains/uast/UCallExpression;", "getExpression", "()Lorg/jetbrains/uast/UCallExpression;", "setExpression", "(Lorg/jetbrains/uast/UCallExpression;)V", "locations", "Ljava/util/ArrayList;", "Lcom/android/tools/lint/detector/api/Location;", "Lkotlin/collections/ArrayList;", "getLocations", "()Ljava/util/ArrayList;", "setLocations", "(Ljava/util/ArrayList;)V", "addIndirectAndroidLibraries", "", "libraries", "", "Lcom/android/builder/model/AndroidLibrary;", "result", "", "callFunctionWithReflection", "", "caller", "functionName", "", "checkDslPropertyAssignment", "context", "Lcom/android/tools/lint/detector/api/GradleContext;", "property", "value", "parent", "parentParent", "valueCookie", "statementCookie", "checkWithNewLintVersion", "project", "Lcom/android/tools/lint/detector/api/Project;", "checkWithOldLintVersion", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "Lcom/android/tools/lint/detector/api/JavaContext;", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "getMemberWithReflection", "memberName", "getStringLiteralValue", "reportIssue", "removeQuotes", "useNewLintVersion", "Companion", "activity-lint"})
@SourceDebugExtension(value={"SMAP\nActivityResultFragmentVersionDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ActivityResultFragmentVersionDetector.kt\nandroidx/activity/lint/ActivityResultFragmentVersionDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,228:1\n1855#2,2:229\n1855#2:231\n1855#2,2:232\n1856#2:234\n1855#2,2:235\n1855#2,2:237\n1855#2,2:239\n1855#2,2:241\n*S KotlinDebug\n*F\n+ 1 ActivityResultFragmentVersionDetector.kt\nandroidx/activity/lint/ActivityResultFragmentVersionDetector\n*L\n110#1:229,2\n123#1:231\n124#1:232,2\n123#1:234\n146#1:235,2\n156#1:237,2\n166#1:239,2\n202#1:241,2\n*E\n"})
public final class ActivityResultFragmentVersionDetector
extends Detector
implements Detector.UastScanner,
GradleScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private ArrayList<Location> locations = new ArrayList();
    public UCallExpression expression;
    private boolean checkedImplementationDependencies;
    @NotNull
    public static final String FRAGMENT_VERSION = "1.3.0";
    @NotNull
    private static final Issue ISSUE;

    @NotNull
    public final ArrayList<Location> getLocations() {
        return this.locations;
    }

    public final void setLocations(@NotNull ArrayList<Location> arrayList) {
        Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
        this.locations = arrayList;
    }

    @NotNull
    public final UCallExpression getExpression() {
        UCallExpression uCallExpression = this.expression;
        if (uCallExpression != null) {
            return uCallExpression;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"expression");
        return null;
    }

    public final void setExpression(@NotNull UCallExpression uCallExpression) {
        Intrinsics.checkNotNullParameter((Object)uCallExpression, (String)"<set-?>");
        this.expression = uCallExpression;
    }

    @Nullable
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        return CollectionsKt.listOf(UCallExpression.class);
    }

    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return new UElementHandler(this, context){
            final /* synthetic */ ActivityResultFragmentVersionDetector this$0;
            final /* synthetic */ JavaContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
            }

            public void visitCallExpression(@NotNull UCallExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                UIdentifier uIdentifier = node.getMethodIdentifier();
                if (!Intrinsics.areEqual((Object)(uIdentifier != null ? uIdentifier.getName() : null), (Object)"registerForActivityResult")) {
                    return;
                }
                this.this$0.setExpression(node);
                this.this$0.getLocations().add(this.$context.getLocation((UElement)node));
            }
        };
    }

    public void checkDslPropertyAssignment(@NotNull GradleContext context, @NotNull String property, @NotNull String value, @NotNull String parent, @Nullable String parentParent, @NotNull Object valueCookie, @NotNull Object statementCookie) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)valueCookie, (String)"valueCookie");
        Intrinsics.checkNotNullParameter((Object)statementCookie, (String)"statementCookie");
        if (this.locations.isEmpty()) {
            return;
        }
        if (Intrinsics.areEqual((Object)property, (Object)"api")) {
            ActivityResultFragmentVersionDetector.reportIssue$default(this, value, context, false, 4, null);
        } else if (!this.checkedImplementationDependencies) {
            Project project = context.getProject();
            if (this.useNewLintVersion(project)) {
                this.checkWithNewLintVersion(project, context);
            } else {
                this.checkWithOldLintVersion(project, context);
            }
        }
    }

    private final boolean useNewLintVersion(Project project) {
        Iterable $this$forEach$iv = KClasses.getMemberFunctions((KClass)Reflection.getOrCreateKotlinClass(project.getClass()));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KFunction function = (KFunction)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)function.getName(), (Object)"getBuildVariant")) continue;
            return true;
        }
        return false;
    }

    private final void checkWithNewLintVersion(Project project, GradleContext context) {
        Object buildVariant = this.callFunctionWithReflection(project, "getBuildVariant");
        Object mainArtifact = this.getMemberWithReflection(buildVariant, "mainArtifact");
        Object dependencies = this.getMemberWithReflection(mainArtifact, "dependencies");
        Object all = this.callFunctionWithReflection(dependencies, "getAll");
        Intrinsics.checkNotNull((Object)all, (String)"null cannot be cast to non-null type java.util.ArrayList<*>{ kotlin.collections.TypeAliasesKt.ArrayList<*> }");
        Iterable $this$forEach$iv = (ArrayList)all;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object lmLibrary = element$iv = iterator.next();
            boolean bl = false;
            Iterable $this$forEach$iv2 = KClasses.getMemberProperties((KClass)Reflection.getOrCreateKotlinClass(lmLibrary.getClass()));
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                KProperty1 libraryMembers = (KProperty1)element$iv2;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)libraryMembers.getName(), (Object)"resolvedCoordinates")) continue;
                KCallablesJvm.setAccessible((KCallable)((KCallable)libraryMembers), (boolean)true);
                Object[] objectArray = new Object[]{lmLibrary};
                this.reportIssue(String.valueOf(libraryMembers.call(objectArray)), context, false);
            }
        }
    }

    private final void checkWithOldLintVersion(Project project, GradleContext context) {
        Collection explicitLibraries = null;
        Object currentVariant = this.callFunctionWithReflection(project, "getCurrentVariant");
        Object mainArtifact = this.callFunctionWithReflection(currentVariant, "getMainArtifact");
        Object dependencies = this.callFunctionWithReflection(mainArtifact, "getDependencies");
        Object object = this.callFunctionWithReflection(dependencies, "getLibraries");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Collection<com.android.builder.model.AndroidLibrary>");
        explicitLibraries = (Collection)object;
        HashSet allLibraries = new HashSet();
        this.addIndirectAndroidLibraries(explicitLibraries, allLibraries);
        Iterable $this$forEach$iv = allLibraries;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            AndroidLibrary it = (AndroidLibrary)element$iv;
            boolean bl = false;
            MavenCoordinates resolvedCoords = it.getResolvedCoordinates();
            String groupId = resolvedCoords.getGroupId();
            String artifactId = resolvedCoords.getArtifactId();
            String version = resolvedCoords.getVersion();
            this.reportIssue(groupId + ":" + artifactId + ":" + version, context, false);
        }
    }

    private final Object callFunctionWithReflection(Object caller, String functionName) {
        Iterable $this$forEach$iv = KClasses.getMemberFunctions((KClass)Reflection.getOrCreateKotlinClass(caller.getClass()));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KFunction function = (KFunction)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)function.getName(), (Object)functionName)) continue;
            KCallablesJvm.setAccessible((KCallable)((KCallable)function), (boolean)true);
            Object[] objectArray = new Object[]{caller};
            Object object = function.call(objectArray);
            Intrinsics.checkNotNull((Object)object);
            return object;
        }
        return Unit.INSTANCE;
    }

    private final Object getMemberWithReflection(Object caller, String memberName) {
        Iterable $this$forEach$iv = KClasses.getMemberProperties((KClass)Reflection.getOrCreateKotlinClass(caller.getClass()));
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KProperty1 member = (KProperty1)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)member.getName(), (Object)memberName)) continue;
            KCallablesJvm.setAccessible((KCallable)((KCallable)member.getGetter()), (boolean)true);
            Object[] objectArray = new Object[]{caller};
            Object object = member.getGetter().call(objectArray);
            Intrinsics.checkNotNull((Object)object);
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void addIndirectAndroidLibraries(Collection<? extends AndroidLibrary> libraries, Set<AndroidLibrary> result) {
        for (AndroidLibrary androidLibrary : libraries) {
            if (result.contains(androidLibrary)) continue;
            result.add(androidLibrary);
            List list = androidLibrary.getLibraryDependencies();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"library.libraryDependencies");
            this.addIndirectAndroidLibraries(list, result);
        }
    }

    private final void reportIssue(String value, GradleContext context, boolean removeQuotes) {
        String currentVersion;
        String library = removeQuotes ? this.getStringLiteralValue(value) : value;
        if (((CharSequence)library).length() > 0 && !Intrinsics.areEqual((Object)library, (Object)(currentVersion = StringsKt.substringBeforeLast$default((String)StringsKt.substringAfter$default((String)library, (String)"androidx.fragment:fragment:", null, (int)2, null), (String)"-", null, (int)2, null))) && currentVersion.compareTo(FRAGMENT_VERSION) < 0) {
            Iterable $this$forEach$iv = this.locations;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Location location = (Location)element$iv;
                boolean bl = false;
                GradleContext.report$default((GradleContext)context, (Issue)ISSUE, (Object)this.getExpression(), (Location)location, (String)"Upgrade Fragment version to at least 1.3.0.", null, (int)16, null);
            }
        }
    }

    static /* synthetic */ void reportIssue$default(ActivityResultFragmentVersionDetector activityResultFragmentVersionDetector, String string, GradleContext gradleContext, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        activityResultFragmentVersionDetector.reportIssue(string, gradleContext, bl);
    }

    private final String getStringLiteralValue(String value) {
        if (value.length() > 2 && (StringsKt.startsWith$default((String)value, (String)"'", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)value, (String)"'", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)value, (String)"\"", (boolean)false, (int)2, null) && StringsKt.endsWith$default((String)value, (String)"\"", (boolean)false, (int)2, null))) {
            String string = value.substring(1, value.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            return string;
        }
        return "";
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.FATAL;
        EnumSet[] enumSetArray = new EnumSet[]{Scope.JAVA_FILE_SCOPE, Scope.GRADLE_SCOPE};
        Implementation implementation = new Implementation(ActivityResultFragmentVersionDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.GRADLE_FILE), enumSetArray);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"InvalidFragmentVersionForActivityResult", (String)"Update to Fragment 1.3.0 to use ActivityResult APIs", (String)"In order to use the ActivityResult APIs you must upgrade your \\\n                Fragment version to 1.3.0. Previous versions of FragmentActivity \\\n                failed to call super.onRequestPermissionsResult() and used invalid request codes", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, null, null, null, (int)3920, null).addMoreInfo("https://developer.android.com/training/permissions/requesting#make-the-request");
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Landroidx/activity/lint/ActivityResultFragmentVersionDetector$Companion;", "", "()V", "FRAGMENT_VERSION", "", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "activity-lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

