/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.app;

import android.app.RemoteInput;
import android.content.ClipData;
import android.content.ClipDescription;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class RemoteInput {
    public static final String RESULTS_CLIP_LABEL = "android.remoteinput.results";
    public static final String EXTRA_RESULTS_DATA = "android.remoteinput.resultsData";
    private static final String EXTRA_DATA_TYPE_RESULTS_DATA = "android.remoteinput.dataTypeResultsData";
    private static final String EXTRA_RESULTS_SOURCE = "android.remoteinput.resultsSource";
    public static final int SOURCE_FREE_FORM_INPUT = 0;
    public static final int SOURCE_CHOICE = 1;
    public static final int EDIT_CHOICES_BEFORE_SENDING_AUTO = 0;
    public static final int EDIT_CHOICES_BEFORE_SENDING_DISABLED = 1;
    public static final int EDIT_CHOICES_BEFORE_SENDING_ENABLED = 2;
    private final String mResultKey;
    private final CharSequence mLabel;
    private final CharSequence[] mChoices;
    private final boolean mAllowFreeFormTextInput;
    private final int mEditChoicesBeforeSending;
    private final Bundle mExtras;
    private final Set<String> mAllowedDataTypes;

    RemoteInput(String resultKey, CharSequence label, CharSequence[] choices, boolean allowFreeFormTextInput, int editChoicesBeforeSending, Bundle extras, Set<String> allowedDataTypes) {
        this.mResultKey = resultKey;
        this.mLabel = label;
        this.mChoices = choices;
        this.mAllowFreeFormTextInput = allowFreeFormTextInput;
        this.mEditChoicesBeforeSending = editChoicesBeforeSending;
        this.mExtras = extras;
        this.mAllowedDataTypes = allowedDataTypes;
        if (this.getEditChoicesBeforeSending() == 2 && !this.getAllowFreeFormInput()) {
            throw new IllegalArgumentException("setEditChoicesBeforeSending requires setAllowFreeFormInput");
        }
    }

    @NonNull
    public String getResultKey() {
        return this.mResultKey;
    }

    @Nullable
    public CharSequence getLabel() {
        return this.mLabel;
    }

    @Nullable
    public CharSequence[] getChoices() {
        return this.mChoices;
    }

    @Nullable
    public Set<String> getAllowedDataTypes() {
        return this.mAllowedDataTypes;
    }

    public boolean isDataOnly() {
        return !this.getAllowFreeFormInput() && (this.getChoices() == null || this.getChoices().length == 0) && this.getAllowedDataTypes() != null && !this.getAllowedDataTypes().isEmpty();
    }

    public boolean getAllowFreeFormInput() {
        return this.mAllowFreeFormTextInput;
    }

    public int getEditChoicesBeforeSending() {
        return this.mEditChoicesBeforeSending;
    }

    @NonNull
    public Bundle getExtras() {
        return this.mExtras;
    }

    @Nullable
    public static Map<String, Uri> getDataResultsFromIntent(@NonNull Intent intent, @NonNull String remoteInputResultKey) {
        if (Build.VERSION.SDK_INT >= 26) {
            return Api26Impl.getDataResultsFromIntent(intent, remoteInputResultKey);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            Intent clipDataIntent = RemoteInput.getClipDataIntentFromIntent(intent);
            if (clipDataIntent == null) {
                return null;
            }
            HashMap<String, Uri> results = new HashMap<String, Uri>();
            Bundle extras = clipDataIntent.getExtras();
            for (String key : extras.keySet()) {
                Bundle bundle;
                String uriStr;
                String mimeType;
                if (!key.startsWith(EXTRA_DATA_TYPE_RESULTS_DATA) || (mimeType = key.substring(EXTRA_DATA_TYPE_RESULTS_DATA.length())).isEmpty() || (uriStr = (bundle = clipDataIntent.getBundleExtra(key)).getString(remoteInputResultKey)) == null || uriStr.isEmpty()) continue;
                results.put(mimeType, Uri.parse((String)uriStr));
            }
            return results.isEmpty() ? null : results;
        }
        return null;
    }

    @Nullable
    public static Bundle getResultsFromIntent(@NonNull Intent intent) {
        if (Build.VERSION.SDK_INT >= 20) {
            return Api20Impl.getResultsFromIntent(intent);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            Intent clipDataIntent = RemoteInput.getClipDataIntentFromIntent(intent);
            if (clipDataIntent == null) {
                return null;
            }
            return (Bundle)clipDataIntent.getExtras().getParcelable(EXTRA_RESULTS_DATA);
        }
        return null;
    }

    public static void addResultsToIntent(@NonNull RemoteInput[] remoteInputs, @NonNull Intent intent, @NonNull Bundle results) {
        if (Build.VERSION.SDK_INT >= 26) {
            Api20Impl.addResultsToIntent(RemoteInput.fromCompat(remoteInputs), intent, results);
        } else if (Build.VERSION.SDK_INT >= 20) {
            Bundle existingTextResults = RemoteInput.getResultsFromIntent(intent);
            int resultsSource = RemoteInput.getResultsSource(intent);
            if (existingTextResults == null) {
                existingTextResults = results;
            } else {
                existingTextResults.putAll(results);
            }
            for (RemoteInput input : remoteInputs) {
                Map<String, Uri> existingDataResults = RemoteInput.getDataResultsFromIntent(intent, input.getResultKey());
                RemoteInput[] arr = new RemoteInput[]{input};
                Api20Impl.addResultsToIntent(RemoteInput.fromCompat(arr), intent, existingTextResults);
                if (existingDataResults == null) continue;
                RemoteInput.addDataResultToIntent(input, intent, existingDataResults);
            }
            RemoteInput.setResultsSource(intent, resultsSource);
        } else if (Build.VERSION.SDK_INT >= 16) {
            Bundle resultsBundle;
            Intent clipDataIntent = RemoteInput.getClipDataIntentFromIntent(intent);
            if (clipDataIntent == null) {
                clipDataIntent = new Intent();
            }
            if ((resultsBundle = clipDataIntent.getBundleExtra(EXTRA_RESULTS_DATA)) == null) {
                resultsBundle = new Bundle();
            }
            for (RemoteInput remoteInput : remoteInputs) {
                Object result = results.get(remoteInput.getResultKey());
                if (!(result instanceof CharSequence)) continue;
                resultsBundle.putCharSequence(remoteInput.getResultKey(), (CharSequence)result);
            }
            clipDataIntent.putExtra(EXTRA_RESULTS_DATA, resultsBundle);
            Api16Impl.setClipData(intent, ClipData.newIntent((CharSequence)RESULTS_CLIP_LABEL, (Intent)clipDataIntent));
        }
    }

    public static void addDataResultToIntent(@NonNull RemoteInput remoteInput, @NonNull Intent intent, @NonNull Map<String, Uri> results) {
        if (Build.VERSION.SDK_INT >= 26) {
            Api26Impl.addDataResultToIntent(remoteInput, intent, results);
        } else if (Build.VERSION.SDK_INT >= 16) {
            Intent clipDataIntent = RemoteInput.getClipDataIntentFromIntent(intent);
            if (clipDataIntent == null) {
                clipDataIntent = new Intent();
            }
            for (Map.Entry<String, Uri> entry : results.entrySet()) {
                String mimeType = entry.getKey();
                Uri uri = entry.getValue();
                if (mimeType == null) continue;
                Bundle resultsBundle = clipDataIntent.getBundleExtra(RemoteInput.getExtraResultsKeyForData(mimeType));
                if (resultsBundle == null) {
                    resultsBundle = new Bundle();
                }
                resultsBundle.putString(remoteInput.getResultKey(), uri.toString());
                clipDataIntent.putExtra(RemoteInput.getExtraResultsKeyForData(mimeType), resultsBundle);
            }
            Api16Impl.setClipData(intent, ClipData.newIntent((CharSequence)RESULTS_CLIP_LABEL, (Intent)clipDataIntent));
        }
    }

    public static void setResultsSource(@NonNull Intent intent, int source) {
        if (Build.VERSION.SDK_INT >= 28) {
            Api28Impl.setResultsSource(intent, source);
        } else if (Build.VERSION.SDK_INT >= 16) {
            Intent clipDataIntent = RemoteInput.getClipDataIntentFromIntent(intent);
            if (clipDataIntent == null) {
                clipDataIntent = new Intent();
            }
            clipDataIntent.putExtra(EXTRA_RESULTS_SOURCE, source);
            Api16Impl.setClipData(intent, ClipData.newIntent((CharSequence)RESULTS_CLIP_LABEL, (Intent)clipDataIntent));
        }
    }

    public static int getResultsSource(@NonNull Intent intent) {
        if (Build.VERSION.SDK_INT >= 28) {
            return Api28Impl.getResultsSource(intent);
        }
        if (Build.VERSION.SDK_INT >= 16) {
            Intent clipDataIntent = RemoteInput.getClipDataIntentFromIntent(intent);
            if (clipDataIntent == null) {
                return 0;
            }
            return clipDataIntent.getExtras().getInt(EXTRA_RESULTS_SOURCE, 0);
        }
        return 0;
    }

    private static String getExtraResultsKeyForData(String mimeType) {
        return EXTRA_DATA_TYPE_RESULTS_DATA + mimeType;
    }

    @RequiresApi(value=20)
    static android.app.RemoteInput[] fromCompat(RemoteInput[] srcArray) {
        if (srcArray == null) {
            return null;
        }
        android.app.RemoteInput[] result = new android.app.RemoteInput[srcArray.length];
        for (int i = 0; i < srcArray.length; ++i) {
            result[i] = RemoteInput.fromCompat(srcArray[i]);
        }
        return result;
    }

    @RequiresApi(value=20)
    static android.app.RemoteInput fromCompat(RemoteInput src) {
        return Api20Impl.fromCompat(src);
    }

    @RequiresApi(value=20)
    static RemoteInput fromPlatform(android.app.RemoteInput src) {
        return Api20Impl.fromPlatform(src);
    }

    @RequiresApi(value=16)
    private static Intent getClipDataIntentFromIntent(Intent intent) {
        ClipData clipData = Api16Impl.getClipData(intent);
        if (clipData == null) {
            return null;
        }
        ClipDescription clipDescription = clipData.getDescription();
        if (!clipDescription.hasMimeType("text/vnd.android.intent")) {
            return null;
        }
        if (!clipDescription.getLabel().toString().contentEquals(RESULTS_CLIP_LABEL)) {
            return null;
        }
        return clipData.getItemAt(0).getIntent();
    }

    @RequiresApi(value=28)
    static class Api28Impl {
        private Api28Impl() {
        }

        @DoNotInline
        static void setResultsSource(Intent intent, int source) {
            android.app.RemoteInput.setResultsSource((Intent)intent, (int)source);
        }

        @DoNotInline
        static int getResultsSource(Intent intent) {
            return android.app.RemoteInput.getResultsSource((Intent)intent);
        }
    }

    @RequiresApi(value=29)
    static class Api29Impl {
        private Api29Impl() {
        }

        @DoNotInline
        static int getEditChoicesBeforeSending(Object remoteInput) {
            return ((android.app.RemoteInput)remoteInput).getEditChoicesBeforeSending();
        }

        @DoNotInline
        static RemoteInput.Builder setEditChoicesBeforeSending(RemoteInput.Builder builder, int editChoicesBeforeSending) {
            return builder.setEditChoicesBeforeSending(editChoicesBeforeSending);
        }
    }

    @RequiresApi(value=16)
    static class Api16Impl {
        private Api16Impl() {
        }

        @DoNotInline
        static ClipData getClipData(Intent intent) {
            return intent.getClipData();
        }

        @DoNotInline
        static void setClipData(Intent intent, ClipData clip) {
            intent.setClipData(clip);
        }
    }

    @RequiresApi(value=20)
    static class Api20Impl {
        private Api20Impl() {
        }

        @DoNotInline
        static Bundle getResultsFromIntent(Intent intent) {
            return android.app.RemoteInput.getResultsFromIntent((Intent)intent);
        }

        @DoNotInline
        static void addResultsToIntent(Object remoteInputs, Intent intent, Bundle results) {
            android.app.RemoteInput.addResultsToIntent((android.app.RemoteInput[])((android.app.RemoteInput[])remoteInputs), (Intent)intent, (Bundle)results);
        }

        static RemoteInput fromPlatform(Object srcObj) {
            Set<String> allowedDataTypes;
            android.app.RemoteInput src = (android.app.RemoteInput)srcObj;
            Builder builder = new Builder(src.getResultKey()).setLabel(src.getLabel()).setChoices(src.getChoices()).setAllowFreeFormInput(src.getAllowFreeFormInput()).addExtras(src.getExtras());
            if (Build.VERSION.SDK_INT >= 26 && (allowedDataTypes = Api26Impl.getAllowedDataTypes(src)) != null) {
                for (String allowedDataType : allowedDataTypes) {
                    builder.setAllowDataType(allowedDataType, true);
                }
            }
            if (Build.VERSION.SDK_INT >= 29) {
                builder.setEditChoicesBeforeSending(Api29Impl.getEditChoicesBeforeSending(src));
            }
            return builder.build();
        }

        public static android.app.RemoteInput fromCompat(RemoteInput src) {
            Set<String> allowedDataTypes;
            RemoteInput.Builder builder = new RemoteInput.Builder(src.getResultKey()).setLabel(src.getLabel()).setChoices(src.getChoices()).setAllowFreeFormInput(src.getAllowFreeFormInput()).addExtras(src.getExtras());
            if (Build.VERSION.SDK_INT >= 26 && (allowedDataTypes = src.getAllowedDataTypes()) != null) {
                for (String allowedDataType : allowedDataTypes) {
                    Api26Impl.setAllowDataType(builder, allowedDataType, true);
                }
            }
            if (Build.VERSION.SDK_INT >= 29) {
                Api29Impl.setEditChoicesBeforeSending(builder, src.getEditChoicesBeforeSending());
            }
            return builder.build();
        }
    }

    @RequiresApi(value=26)
    static class Api26Impl {
        private Api26Impl() {
        }

        @DoNotInline
        static Map<String, Uri> getDataResultsFromIntent(Intent intent, String remoteInputResultKey) {
            return android.app.RemoteInput.getDataResultsFromIntent((Intent)intent, (String)remoteInputResultKey);
        }

        @DoNotInline
        static Set<String> getAllowedDataTypes(Object remoteInput) {
            return ((android.app.RemoteInput)remoteInput).getAllowedDataTypes();
        }

        @DoNotInline
        static void addDataResultToIntent(RemoteInput remoteInput, Intent intent, Map<String, Uri> results) {
            android.app.RemoteInput.addDataResultToIntent((android.app.RemoteInput)RemoteInput.fromCompat(remoteInput), (Intent)intent, results);
        }

        @DoNotInline
        static RemoteInput.Builder setAllowDataType(RemoteInput.Builder builder, String mimeType, boolean doAllow) {
            return builder.setAllowDataType(mimeType, doAllow);
        }
    }

    public static final class Builder {
        private final String mResultKey;
        private final Set<String> mAllowedDataTypes = new HashSet<String>();
        private final Bundle mExtras = new Bundle();
        private CharSequence mLabel;
        private CharSequence[] mChoices;
        private boolean mAllowFreeFormTextInput = true;
        private int mEditChoicesBeforeSending = 0;

        public Builder(@NonNull String resultKey) {
            if (resultKey == null) {
                throw new IllegalArgumentException("Result key can't be null");
            }
            this.mResultKey = resultKey;
        }

        @NonNull
        public Builder setLabel(@Nullable CharSequence label) {
            this.mLabel = label;
            return this;
        }

        @NonNull
        public Builder setChoices(@Nullable CharSequence[] choices) {
            this.mChoices = choices;
            return this;
        }

        @NonNull
        public Builder setAllowDataType(@NonNull String mimeType, boolean doAllow) {
            if (doAllow) {
                this.mAllowedDataTypes.add(mimeType);
            } else {
                this.mAllowedDataTypes.remove(mimeType);
            }
            return this;
        }

        @NonNull
        public Builder setAllowFreeFormInput(boolean allowFreeFormTextInput) {
            this.mAllowFreeFormTextInput = allowFreeFormTextInput;
            return this;
        }

        @NonNull
        public Builder setEditChoicesBeforeSending(int editChoicesBeforeSending) {
            this.mEditChoicesBeforeSending = editChoicesBeforeSending;
            return this;
        }

        @NonNull
        public Builder addExtras(@NonNull Bundle extras) {
            if (extras != null) {
                this.mExtras.putAll(extras);
            }
            return this;
        }

        @NonNull
        public Bundle getExtras() {
            return this.mExtras;
        }

        @NonNull
        public RemoteInput build() {
            return new RemoteInput(this.mResultKey, this.mLabel, this.mChoices, this.mAllowFreeFormTextInput, this.mEditChoicesBeforeSending, this.mExtras, this.mAllowedDataTypes);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static @interface EditChoicesBeforeSending {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
    public static @interface Source {
    }
}

