/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.graphics;

import android.graphics.Bitmap;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.ColorSpace;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.os.Build;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;

public final class BitmapCompat {
    public static boolean hasMipMap(@NonNull Bitmap bitmap) {
        if (Build.VERSION.SDK_INT >= 17) {
            return Api17Impl.hasMipMap(bitmap);
        }
        return false;
    }

    public static void setHasMipMap(@NonNull Bitmap bitmap, boolean hasMipMap) {
        if (Build.VERSION.SDK_INT >= 17) {
            Api17Impl.setHasMipMap(bitmap, hasMipMap);
        }
    }

    public static int getAllocationByteCount(@NonNull Bitmap bitmap) {
        if (Build.VERSION.SDK_INT >= 19) {
            return Api19Impl.getAllocationByteCount(bitmap);
        }
        return bitmap.getByteCount();
    }

    @NonNull
    public static Bitmap createScaledBitmap(@NonNull Bitmap srcBm, int dstW, int dstH, @Nullable Rect srcRect, boolean scaleInLinearSpace) {
        int srcY;
        if (dstW <= 0 || dstH <= 0) {
            throw new IllegalArgumentException("dstW and dstH must be > 0!");
        }
        if (srcRect != null && (srcRect.isEmpty() || srcRect.left < 0 || srcRect.right > srcBm.getWidth() || srcRect.top < 0 || srcRect.bottom > srcBm.getHeight())) {
            throw new IllegalArgumentException("srcRect must be contained by srcBm!");
        }
        Bitmap src = srcBm;
        if (Build.VERSION.SDK_INT >= 27) {
            src = Api27Impl.copyBitmapIfHardware(srcBm);
        }
        int srcW = srcRect != null ? srcRect.width() : srcBm.getWidth();
        int srcH = srcRect != null ? srcRect.height() : srcBm.getHeight();
        float sx = (float)dstW / (float)srcW;
        float sy = (float)dstH / (float)srcH;
        int srcX = srcRect != null ? srcRect.left : 0;
        int n = srcY = srcRect != null ? srcRect.top : 0;
        if (srcX == 0 && srcY == 0 && dstW == srcBm.getWidth() && dstH == srcBm.getHeight()) {
            if (srcBm.isMutable() && srcBm == src) {
                return srcBm.copy(srcBm.getConfig(), true);
            }
            return src;
        }
        Paint paint = new Paint(1);
        paint.setFilterBitmap(true);
        if (Build.VERSION.SDK_INT >= 29) {
            Api29Impl.setPaintBlendMode(paint);
        } else {
            paint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.SRC));
        }
        if (srcW == dstW && srcH == dstH) {
            Bitmap out = Bitmap.createBitmap((int)dstW, (int)dstH, (Bitmap.Config)src.getConfig());
            Canvas canvasForCopy = new Canvas(out);
            canvasForCopy.drawBitmap(src, (float)(-srcX), (float)(-srcY), paint);
            return out;
        }
        double log2 = Math.log(2.0);
        int stepsX = sx > 1.0f ? (int)Math.ceil(Math.log(sx) / log2) : (int)Math.floor(Math.log(sx) / log2);
        int stepsY = sy > 1.0f ? (int)Math.ceil(Math.log(sy) / log2) : (int)Math.floor(Math.log(sy) / log2);
        int totalStepsX = stepsX;
        int totalStepsY = stepsY;
        Bitmap dst = null;
        boolean needFinalConversion = false;
        if (scaleInLinearSpace && Build.VERSION.SDK_INT >= 27 && !Api27Impl.isAlreadyF16AndLinear(srcBm)) {
            int allocW = stepsX > 0 ? BitmapCompat.sizeAtStep(srcW, dstW, 1, totalStepsX) : srcW;
            int allocH = stepsY > 0 ? BitmapCompat.sizeAtStep(srcH, dstH, 1, totalStepsY) : srcH;
            dst = Api27Impl.createBitmapWithSourceColorspace(allocW, allocH, srcBm, true);
            Canvas canvasForCopy = new Canvas(dst);
            canvasForCopy.drawBitmap(src, (float)(-srcX), (float)(-srcY), paint);
            srcX = 0;
            srcY = 0;
            Bitmap swap = dst;
            dst = src;
            src = swap;
            needFinalConversion = true;
        }
        Rect currRect = new Rect(srcX, srcY, srcW, srcH);
        Rect nextRect = new Rect();
        while (stepsX != 0 || stepsY != 0) {
            boolean dstSizeIsFinal;
            if (stepsX < 0) {
                ++stepsX;
            } else if (stepsX > 0) {
                --stepsX;
            }
            if (stepsY < 0) {
                ++stepsY;
            } else if (stepsY > 0) {
                --stepsY;
            }
            int nextW = BitmapCompat.sizeAtStep(srcW, dstW, stepsX, totalStepsX);
            int nextH = BitmapCompat.sizeAtStep(srcH, dstH, stepsY, totalStepsY);
            nextRect.set(0, 0, nextW, nextH);
            boolean lastStep = stepsX == 0 && stepsY == 0;
            boolean bl = dstSizeIsFinal = dst != null && dst.getWidth() == dstW && dst.getHeight() == dstH;
            if (dst == null || dst == srcBm || scaleInLinearSpace && Build.VERSION.SDK_INT >= 27 && !Api27Impl.isAlreadyF16AndLinear(dst) || lastStep && (!dstSizeIsFinal || needFinalConversion)) {
                if (dst != srcBm && dst != null) {
                    dst.recycle();
                }
                int lastScratchStep = needFinalConversion ? 1 : 0;
                int allocW = BitmapCompat.sizeAtStep(srcW, dstW, stepsX > 0 ? lastScratchStep : stepsX, totalStepsX);
                int allocH = BitmapCompat.sizeAtStep(srcH, dstH, stepsY > 0 ? lastScratchStep : stepsY, totalStepsY);
                if (Build.VERSION.SDK_INT >= 27) {
                    boolean linear = scaleInLinearSpace && !lastStep;
                    dst = Api27Impl.createBitmapWithSourceColorspace(allocW, allocH, srcBm, linear);
                } else {
                    dst = Bitmap.createBitmap((int)allocW, (int)allocH, (Bitmap.Config)src.getConfig());
                }
            }
            Canvas canvas = new Canvas(dst);
            canvas.drawBitmap(src, currRect, nextRect, paint);
            Bitmap swap = src;
            src = dst;
            dst = swap;
            currRect.set(nextRect);
        }
        if (dst != srcBm && dst != null) {
            dst.recycle();
        }
        return src;
    }

    @VisibleForTesting
    public static int sizeAtStep(int srcSize, int dstSize, int step, int totalSteps) {
        if (step == 0) {
            return dstSize;
        }
        if (step > 0) {
            return srcSize * (1 << totalSteps - step);
        }
        return dstSize << -step - 1;
    }

    private BitmapCompat() {
    }

    @RequiresApi(value=31)
    static class Api31Impl {
        private Api31Impl() {
        }

        @DoNotInline
        static Bitmap.Config getHardwareBitmapConfig(Bitmap bm) {
            if (bm.getHardwareBuffer().getFormat() == 22) {
                return Bitmap.Config.RGBA_F16;
            }
            return Bitmap.Config.ARGB_8888;
        }
    }

    @RequiresApi(value=29)
    static class Api29Impl {
        private Api29Impl() {
        }

        @DoNotInline
        static void setPaintBlendMode(Paint paint) {
            paint.setBlendMode(BlendMode.SRC);
        }
    }

    @RequiresApi(value=27)
    static class Api27Impl {
        private Api27Impl() {
        }

        @DoNotInline
        static Bitmap createBitmapWithSourceColorspace(int w, int h, Bitmap src, boolean linear) {
            Bitmap.Config config = src.getConfig();
            ColorSpace colorSpace = src.getColorSpace();
            ColorSpace linearCs = ColorSpace.get((ColorSpace.Named)ColorSpace.Named.LINEAR_EXTENDED_SRGB);
            if (linear && !src.getColorSpace().equals((Object)linearCs)) {
                config = Bitmap.Config.RGBA_F16;
                colorSpace = linearCs;
            } else if (src.getConfig() == Bitmap.Config.HARDWARE) {
                config = Bitmap.Config.ARGB_8888;
                if (Build.VERSION.SDK_INT >= 31) {
                    config = Api31Impl.getHardwareBitmapConfig(src);
                }
            }
            return Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)config, (boolean)src.hasAlpha(), (ColorSpace)colorSpace);
        }

        @DoNotInline
        static boolean isAlreadyF16AndLinear(Bitmap b) {
            ColorSpace linearCs = ColorSpace.get((ColorSpace.Named)ColorSpace.Named.LINEAR_EXTENDED_SRGB);
            return b.getConfig() == Bitmap.Config.RGBA_F16 && b.getColorSpace().equals((Object)linearCs);
        }

        @DoNotInline
        static Bitmap copyBitmapIfHardware(Bitmap bm) {
            if (bm.getConfig() == Bitmap.Config.HARDWARE) {
                Bitmap.Config newConfig = Bitmap.Config.ARGB_8888;
                if (Build.VERSION.SDK_INT >= 31) {
                    newConfig = Api31Impl.getHardwareBitmapConfig(bm);
                }
                return bm.copy(newConfig, true);
            }
            return bm;
        }
    }

    @RequiresApi(value=19)
    static class Api19Impl {
        private Api19Impl() {
        }

        @DoNotInline
        static int getAllocationByteCount(Bitmap bitmap) {
            return bitmap.getAllocationByteCount();
        }
    }

    @RequiresApi(value=17)
    static class Api17Impl {
        private Api17Impl() {
        }

        @DoNotInline
        static boolean hasMipMap(Bitmap bitmap) {
            return bitmap.hasMipMap();
        }

        @DoNotInline
        static void setHasMipMap(Bitmap bitmap, boolean hasMipMap) {
            bitmap.setHasMipMap(hasMipMap);
        }
    }
}

