/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.graphics;

import android.annotation.SuppressLint;
import android.graphics.Typeface;
import android.util.Log;
import android.util.SparseArray;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.collection.LongSparseArray;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@SuppressLint(value={"SoonBlockedPrivateApi"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@RequiresApi(value=21)
final class WeightTypefaceApi21 {
    private static final String TAG = "WeightTypeface";
    private static final String NATIVE_INSTANCE_FIELD = "native_instance";
    private static final String NATIVE_CREATE_FROM_TYPEFACE_METHOD = "nativeCreateFromTypeface";
    private static final String NATIVE_CREATE_WEIGHT_ALIAS_METHOD = "nativeCreateWeightAlias";
    private static final Field sNativeInstance;
    private static final Method sNativeCreateFromTypeface;
    private static final Method sNativeCreateWeightAlias;
    private static final Constructor<Typeface> sConstructor;
    @GuardedBy(value="sWeightCacheLock")
    private static final LongSparseArray<SparseArray<Typeface>> sWeightTypefaceCache;
    private static final Object sWeightCacheLock;

    private static boolean isPrivateApiAvailable() {
        return sNativeInstance != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    static Typeface createWeightStyle(@NonNull Typeface base, int weight, boolean italic) {
        Typeface typeface;
        if (!WeightTypefaceApi21.isPrivateApiAvailable()) {
            return null;
        }
        int key = weight << 1 | (italic ? 1 : 0);
        Object object = sWeightCacheLock;
        synchronized (object) {
            long baseNativeInstance = WeightTypefaceApi21.getNativeInstance(base);
            SparseArray innerCache = (SparseArray)sWeightTypefaceCache.get(baseNativeInstance);
            if (innerCache == null) {
                innerCache = new SparseArray(4);
                sWeightTypefaceCache.put(baseNativeInstance, (Object)innerCache);
            } else {
                typeface = (Typeface)innerCache.get(key);
                if (typeface != null) {
                    return typeface;
                }
            }
            typeface = italic == base.isItalic() ? WeightTypefaceApi21.create(WeightTypefaceApi21.nativeCreateWeightAlias(baseNativeInstance, weight)) : WeightTypefaceApi21.create(WeightTypefaceApi21.nativeCreateFromTypefaceWithExactStyle(baseNativeInstance, weight, italic));
            innerCache.put(key, (Object)typeface);
        }
        return typeface;
    }

    private static long getNativeInstance(@NonNull Typeface typeface) {
        try {
            return sNativeInstance.getLong(typeface);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    @SuppressLint(value={"BanUncheckedReflection"})
    private static long nativeCreateFromTypefaceWithExactStyle(long nativeInstance, int weight, boolean italic) {
        try {
            int style = italic ? 2 : 0;
            nativeInstance = (Long)sNativeCreateFromTypeface.invoke(null, nativeInstance, style);
            return (Long)sNativeCreateWeightAlias.invoke(null, nativeInstance, weight);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @SuppressLint(value={"BanUncheckedReflection"})
    private static long nativeCreateWeightAlias(long nativeInstance, int weight) {
        try {
            return (Long)sNativeCreateWeightAlias.invoke(null, nativeInstance, weight);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private static Typeface create(long nativeInstance) {
        try {
            return sConstructor.newInstance(nativeInstance);
        }
        catch (IllegalAccessException e) {
            return null;
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (InvocationTargetException e) {
            return null;
        }
    }

    private WeightTypefaceApi21() {
    }

    static {
        Constructor constructor;
        Method nativeCreateWeightAlias;
        Method nativeCreateFromTypeface;
        Field nativeInstance;
        try {
            nativeInstance = Typeface.class.getDeclaredField(NATIVE_INSTANCE_FIELD);
            nativeCreateFromTypeface = Typeface.class.getDeclaredMethod(NATIVE_CREATE_FROM_TYPEFACE_METHOD, Long.TYPE, Integer.TYPE);
            nativeCreateFromTypeface.setAccessible(true);
            nativeCreateWeightAlias = Typeface.class.getDeclaredMethod(NATIVE_CREATE_WEIGHT_ALIAS_METHOD, Long.TYPE, Integer.TYPE);
            nativeCreateWeightAlias.setAccessible(true);
            constructor = Typeface.class.getDeclaredConstructor(Long.TYPE);
            constructor.setAccessible(true);
        }
        catch (NoSuchFieldException | NoSuchMethodException e) {
            Log.e((String)TAG, (String)e.getClass().getName(), (Throwable)e);
            nativeInstance = null;
            nativeCreateFromTypeface = null;
            nativeCreateWeightAlias = null;
            constructor = null;
        }
        sNativeInstance = nativeInstance;
        sNativeCreateFromTypeface = nativeCreateFromTypeface;
        sNativeCreateWeightAlias = nativeCreateWeightAlias;
        sConstructor = constructor;
        sWeightTypefaceCache = new LongSparseArray(3);
        sWeightCacheLock = new Object();
    }
}

