/*
 * Decompiled with CFR 0.152.
 */
package androidx.savedstate;

import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.savedstate.Recreator;
import androidx.savedstate.SavedStateRegistry;
import androidx.savedstate.SavedStateRegistryOwner;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000b\u001a\u00020\fH\u0007J\u0012\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0007J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u000fH\u0007R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Landroidx/savedstate/SavedStateRegistryController;", "", "owner", "Landroidx/savedstate/SavedStateRegistryOwner;", "(Landroidx/savedstate/SavedStateRegistryOwner;)V", "attached", "", "savedStateRegistry", "Landroidx/savedstate/SavedStateRegistry;", "getSavedStateRegistry", "()Landroidx/savedstate/SavedStateRegistry;", "performAttach", "", "performRestore", "savedState", "Landroid/os/Bundle;", "performSave", "outBundle", "Companion", "savedstate_release"})
public final class SavedStateRegistryController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SavedStateRegistryOwner owner;
    @NotNull
    private final SavedStateRegistry savedStateRegistry;
    private boolean attached;

    private SavedStateRegistryController(SavedStateRegistryOwner owner) {
        this.owner = owner;
        this.savedStateRegistry = new SavedStateRegistry();
    }

    @NotNull
    public final SavedStateRegistry getSavedStateRegistry() {
        return this.savedStateRegistry;
    }

    @MainThread
    public final void performAttach() {
        Lifecycle lifecycle = this.owner.getLifecycle();
        Intrinsics.checkNotNullExpressionValue((Object)lifecycle, (String)"owner.lifecycle");
        Lifecycle lifecycle2 = lifecycle;
        if (!(lifecycle2.getCurrentState() == Lifecycle.State.INITIALIZED)) {
            boolean bl = false;
            String string = "Restarter must be created only during owner's initialization stage";
            throw new IllegalStateException(string.toString());
        }
        lifecycle2.addObserver((LifecycleObserver)new Recreator(this.owner));
        this.savedStateRegistry.performAttach$savedstate_release(lifecycle2);
        this.attached = true;
    }

    @MainThread
    public final void performRestore(@Nullable Bundle savedState) {
        if (!this.attached) {
            this.performAttach();
        }
        Lifecycle lifecycle = this.owner.getLifecycle();
        Intrinsics.checkNotNullExpressionValue((Object)lifecycle, (String)"owner.lifecycle");
        Lifecycle lifecycle2 = lifecycle;
        if (!(!lifecycle2.getCurrentState().isAtLeast(Lifecycle.State.STARTED))) {
            boolean bl = false;
            String string = "performRestore cannot be called when owner is " + lifecycle2.getCurrentState();
            throw new IllegalStateException(string.toString());
        }
        this.savedStateRegistry.performRestore$savedstate_release(savedState);
    }

    @MainThread
    public final void performSave(@NotNull Bundle outBundle) {
        Intrinsics.checkNotNullParameter((Object)outBundle, (String)"outBundle");
        this.savedStateRegistry.performSave(outBundle);
    }

    @JvmStatic
    @NotNull
    public static final SavedStateRegistryController create(@NotNull SavedStateRegistryOwner owner) {
        return Companion.create(owner);
    }

    public /* synthetic */ SavedStateRegistryController(SavedStateRegistryOwner owner, DefaultConstructorMarker $constructor_marker) {
        this(owner);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Landroidx/savedstate/SavedStateRegistryController$Companion;", "", "()V", "create", "Landroidx/savedstate/SavedStateRegistryController;", "owner", "Landroidx/savedstate/SavedStateRegistryOwner;", "savedstate_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SavedStateRegistryController create(@NotNull SavedStateRegistryOwner owner) {
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            return new SavedStateRegistryController(owner, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

