/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.app;

import android.util.AttributeSet;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.lang.ref.WeakReference;
import java.util.ArrayDeque;
import java.util.Deque;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

class LayoutIncludeDetector {
    @NonNull
    private final Deque<WeakReference<XmlPullParser>> mXmlParserStack = new ArrayDeque<WeakReference<XmlPullParser>>();

    LayoutIncludeDetector() {
    }

    boolean detect(@NonNull AttributeSet attrs) {
        XmlPullParser xmlAttrs;
        if (attrs instanceof XmlPullParser && (xmlAttrs = (XmlPullParser)attrs).getDepth() == 1) {
            XmlPullParser ancestorXmlAttrs = LayoutIncludeDetector.popOutdatedAttrHolders(this.mXmlParserStack);
            this.mXmlParserStack.push(new WeakReference<XmlPullParser>(xmlAttrs));
            if (LayoutIncludeDetector.shouldInheritContext(xmlAttrs, ancestorXmlAttrs)) {
                return true;
            }
        }
        return false;
    }

    private static boolean shouldInheritContext(@NonNull XmlPullParser parser, @Nullable XmlPullParser previousParser) {
        if (previousParser != null && parser != previousParser) {
            try {
                if (previousParser.getEventType() == 2) {
                    return "include".equals(previousParser.getName());
                }
            }
            catch (XmlPullParserException xmlPullParserException) {
                // empty catch block
            }
        }
        return false;
    }

    @Nullable
    private static XmlPullParser popOutdatedAttrHolders(@NonNull Deque<WeakReference<XmlPullParser>> xmlParserStack) {
        while (!xmlParserStack.isEmpty()) {
            XmlPullParser parser = (XmlPullParser)xmlParserStack.peek().get();
            if (LayoutIncludeDetector.isParserOutdated(parser)) {
                xmlParserStack.pop();
                continue;
            }
            return parser;
        }
        return null;
    }

    private static boolean isParserOutdated(@Nullable XmlPullParser parser) {
        try {
            return parser == null || parser.getEventType() == 3 || parser.getEventType() == 1;
        }
        catch (XmlPullParserException e) {
            return true;
        }
    }
}

