/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.app;

import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.InflateException;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.R;
import androidx.appcompat.view.ContextThemeWrapper;
import androidx.appcompat.widget.AppCompatAutoCompleteTextView;
import androidx.appcompat.widget.AppCompatButton;
import androidx.appcompat.widget.AppCompatCheckBox;
import androidx.appcompat.widget.AppCompatCheckedTextView;
import androidx.appcompat.widget.AppCompatEditText;
import androidx.appcompat.widget.AppCompatImageButton;
import androidx.appcompat.widget.AppCompatImageView;
import androidx.appcompat.widget.AppCompatMultiAutoCompleteTextView;
import androidx.appcompat.widget.AppCompatRadioButton;
import androidx.appcompat.widget.AppCompatRatingBar;
import androidx.appcompat.widget.AppCompatSeekBar;
import androidx.appcompat.widget.AppCompatSpinner;
import androidx.appcompat.widget.AppCompatTextView;
import androidx.appcompat.widget.AppCompatToggleButton;
import androidx.appcompat.widget.TintContextWrapper;
import androidx.collection.SimpleArrayMap;
import androidx.core.view.ViewCompat;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class AppCompatViewInflater {
    private static final Class<?>[] sConstructorSignature = new Class[]{Context.class, AttributeSet.class};
    private static final int[] sOnClickAttrs = new int[]{16843375};
    private static final int[] sAccessibilityHeading = new int[]{16844160};
    private static final int[] sAccessibilityPaneTitle = new int[]{16844156};
    private static final int[] sScreenReaderFocusable = new int[]{16844148};
    private static final String[] sClassPrefixList = new String[]{"android.widget.", "android.view.", "android.webkit."};
    private static final String LOG_TAG = "AppCompatViewInflater";
    private static final SimpleArrayMap<String, Constructor<? extends View>> sConstructorMap = new SimpleArrayMap();
    private final Object[] mConstructorArgs = new Object[2];

    @Nullable
    public final View createView(@Nullable View parent, @NonNull String name, @NonNull Context context, @NonNull AttributeSet attrs, boolean inheritContext, boolean readAndroidTheme, boolean readAppTheme, boolean wrapContext) {
        Context originalContext = context;
        if (inheritContext && parent != null) {
            context = parent.getContext();
        }
        if (readAndroidTheme || readAppTheme) {
            context = AppCompatViewInflater.themifyContext(context, attrs, readAndroidTheme, readAppTheme);
        }
        if (wrapContext) {
            context = TintContextWrapper.wrap((Context)context);
        }
        Object view = null;
        switch (name) {
            case "TextView": {
                view = this.createTextView(context, attrs);
                this.verifyNotNull((View)view, name);
                break;
            }
            case "ImageView": {
                view = this.createImageView(context, attrs);
                this.verifyNotNull((View)view, name);
                break;
            }
            case "Button": {
                view = this.createButton(context, attrs);
                this.verifyNotNull((View)view, name);
                break;
            }
            case "EditText": {
                view = this.createEditText(context, attrs);
                this.verifyNotNull((View)view, name);
                break;
            }
            case "Spinner": {
                view = this.createSpinner(context, attrs);
                this.verifyNotNull((View)view, name);
                break;
            }
            case "ImageButton": {
                view = this.createImageButton(context, attrs);
                this.verifyNotNull((View)view, name);
                break;
            }
            case "CheckBox": {
                view = this.createCheckBox(context, attrs);
                this.verifyNotNull((View)view, name);
                break;
            }
            case "RadioButton": {
                view = this.createRadioButton(context, attrs);
                this.verifyNotNull((View)view, name);
                break;
            }
            case "CheckedTextView": {
                view = this.createCheckedTextView(context, attrs);
                this.verifyNotNull((View)view, name);
                break;
            }
            case "AutoCompleteTextView": {
                view = this.createAutoCompleteTextView(context, attrs);
                this.verifyNotNull((View)view, name);
                break;
            }
            case "MultiAutoCompleteTextView": {
                view = this.createMultiAutoCompleteTextView(context, attrs);
                this.verifyNotNull((View)view, name);
                break;
            }
            case "RatingBar": {
                view = this.createRatingBar(context, attrs);
                this.verifyNotNull((View)view, name);
                break;
            }
            case "SeekBar": {
                view = this.createSeekBar(context, attrs);
                this.verifyNotNull((View)view, name);
                break;
            }
            case "ToggleButton": {
                view = this.createToggleButton(context, attrs);
                this.verifyNotNull((View)view, name);
                break;
            }
            default: {
                view = this.createView(context, name, attrs);
            }
        }
        if (view == null && originalContext != context) {
            view = this.createViewFromTag(context, name, attrs);
        }
        if (view != null) {
            this.checkOnClickListener((View)view, attrs);
            this.backportAccessibilityAttributes(context, (View)view, attrs);
        }
        return view;
    }

    @NonNull
    protected AppCompatTextView createTextView(Context context, AttributeSet attrs) {
        return new AppCompatTextView(context, attrs);
    }

    @NonNull
    protected AppCompatImageView createImageView(Context context, AttributeSet attrs) {
        return new AppCompatImageView(context, attrs);
    }

    @NonNull
    protected AppCompatButton createButton(Context context, AttributeSet attrs) {
        return new AppCompatButton(context, attrs);
    }

    @NonNull
    protected AppCompatEditText createEditText(Context context, AttributeSet attrs) {
        return new AppCompatEditText(context, attrs);
    }

    @NonNull
    protected AppCompatSpinner createSpinner(Context context, AttributeSet attrs) {
        return new AppCompatSpinner(context, attrs);
    }

    @NonNull
    protected AppCompatImageButton createImageButton(Context context, AttributeSet attrs) {
        return new AppCompatImageButton(context, attrs);
    }

    @NonNull
    protected AppCompatCheckBox createCheckBox(Context context, AttributeSet attrs) {
        return new AppCompatCheckBox(context, attrs);
    }

    @NonNull
    protected AppCompatRadioButton createRadioButton(Context context, AttributeSet attrs) {
        return new AppCompatRadioButton(context, attrs);
    }

    @NonNull
    protected AppCompatCheckedTextView createCheckedTextView(Context context, AttributeSet attrs) {
        return new AppCompatCheckedTextView(context, attrs);
    }

    @NonNull
    protected AppCompatAutoCompleteTextView createAutoCompleteTextView(Context context, AttributeSet attrs) {
        return new AppCompatAutoCompleteTextView(context, attrs);
    }

    @NonNull
    protected AppCompatMultiAutoCompleteTextView createMultiAutoCompleteTextView(Context context, AttributeSet attrs) {
        return new AppCompatMultiAutoCompleteTextView(context, attrs);
    }

    @NonNull
    protected AppCompatRatingBar createRatingBar(Context context, AttributeSet attrs) {
        return new AppCompatRatingBar(context, attrs);
    }

    @NonNull
    protected AppCompatSeekBar createSeekBar(Context context, AttributeSet attrs) {
        return new AppCompatSeekBar(context, attrs);
    }

    @NonNull
    protected AppCompatToggleButton createToggleButton(Context context, AttributeSet attrs) {
        return new AppCompatToggleButton(context, attrs);
    }

    private void verifyNotNull(View view, String name) {
        if (view == null) {
            throw new IllegalStateException(this.getClass().getName() + " asked to inflate view for <" + name + ">, but returned null");
        }
    }

    @Nullable
    protected View createView(Context context, String name, AttributeSet attrs) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private View createViewFromTag(Context context, String name, AttributeSet attrs) {
        if (name.equals("view")) {
            name = attrs.getAttributeValue(null, "class");
        }
        try {
            this.mConstructorArgs[0] = context;
            this.mConstructorArgs[1] = attrs;
            if (-1 == name.indexOf(46)) {
                for (int i = 0; i < sClassPrefixList.length; ++i) {
                    View view = this.createViewByPrefix(context, name, sClassPrefixList[i]);
                    if (view == null) continue;
                    View view2 = view;
                    return view2;
                }
                View i = null;
                return i;
            }
            View i = this.createViewByPrefix(context, name, null);
            return i;
        }
        catch (Exception e) {
            View view = null;
            return view;
        }
        finally {
            this.mConstructorArgs[0] = null;
            this.mConstructorArgs[1] = null;
        }
    }

    private void checkOnClickListener(View view, AttributeSet attrs) {
        Context context = view.getContext();
        if (!(context instanceof ContextWrapper) || Build.VERSION.SDK_INT >= 15 && !ViewCompat.hasOnClickListeners((View)view)) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, sOnClickAttrs);
        String handlerName = a.getString(0);
        if (handlerName != null) {
            view.setOnClickListener((View.OnClickListener)new DeclaredOnClickListener(view, handlerName));
        }
        a.recycle();
    }

    private View createViewByPrefix(Context context, String name, String prefix) throws ClassNotFoundException, InflateException {
        Constructor<View> constructor = (Constructor<View>)sConstructorMap.get((Object)name);
        try {
            if (constructor == null) {
                Class<View> clazz = Class.forName(prefix != null ? prefix + name : name, false, context.getClassLoader()).asSubclass(View.class);
                constructor = clazz.getConstructor(sConstructorSignature);
                sConstructorMap.put((Object)name, constructor);
            }
            constructor.setAccessible(true);
            return (View)constructor.newInstance(this.mConstructorArgs);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Context themifyContext(Context context, AttributeSet attrs, boolean useAndroidTheme, boolean useAppTheme) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.View, 0, 0);
        int themeId = 0;
        if (useAndroidTheme) {
            themeId = a.getResourceId(R.styleable.View_android_theme, 0);
        }
        if (useAppTheme && themeId == 0 && (themeId = a.getResourceId(R.styleable.View_theme, 0)) != 0) {
            Log.i((String)LOG_TAG, (String)"app:theme is now deprecated. Please move to using android:theme instead.");
        }
        a.recycle();
        if (!(themeId == 0 || context instanceof ContextThemeWrapper && ((ContextThemeWrapper)((Object)context)).getThemeResId() == themeId)) {
            context = new ContextThemeWrapper((Context)context, themeId);
        }
        return context;
    }

    private void backportAccessibilityAttributes(@NonNull Context context, @NonNull View view, @NonNull AttributeSet attrs) {
        if (Build.VERSION.SDK_INT < 19 || Build.VERSION.SDK_INT > 28) {
            return;
        }
        TypedArray a = context.obtainStyledAttributes(attrs, sAccessibilityHeading);
        if (a.hasValue(0)) {
            ViewCompat.setAccessibilityHeading((View)view, (boolean)a.getBoolean(0, false));
        }
        a.recycle();
        a = context.obtainStyledAttributes(attrs, sAccessibilityPaneTitle);
        if (a.hasValue(0)) {
            ViewCompat.setAccessibilityPaneTitle((View)view, (CharSequence)a.getString(0));
        }
        a.recycle();
        a = context.obtainStyledAttributes(attrs, sScreenReaderFocusable);
        if (a.hasValue(0)) {
            ViewCompat.setScreenReaderFocusable((View)view, (boolean)a.getBoolean(0, false));
        }
        a.recycle();
    }

    private static class DeclaredOnClickListener
    implements View.OnClickListener {
        private final View mHostView;
        private final String mMethodName;
        private Method mResolvedMethod;
        private Context mResolvedContext;

        public DeclaredOnClickListener(@NonNull View hostView, @NonNull String methodName) {
            this.mHostView = hostView;
            this.mMethodName = methodName;
        }

        public void onClick(@NonNull View v) {
            if (this.mResolvedMethod == null) {
                this.resolveMethod(this.mHostView.getContext());
            }
            try {
                this.mResolvedMethod.invoke((Object)this.mResolvedContext, v);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException("Could not execute non-public method for android:onClick", e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException("Could not execute method for android:onClick", e);
            }
        }

        private void resolveMethod(@Nullable Context context) {
            while (context != null) {
                try {
                    Method method;
                    if (!context.isRestricted() && (method = context.getClass().getMethod(this.mMethodName, View.class)) != null) {
                        this.mResolvedMethod = method;
                        this.mResolvedContext = context;
                        return;
                    }
                }
                catch (NoSuchMethodException method) {
                    // empty catch block
                }
                if (context instanceof ContextWrapper) {
                    context = ((ContextWrapper)context).getBaseContext();
                    continue;
                }
                context = null;
            }
            int id2 = this.mHostView.getId();
            String idText = id2 == -1 ? "" : " with id '" + this.mHostView.getContext().getResources().getResourceEntryName(id2) + "'";
            throw new IllegalStateException("Could not find method " + this.mMethodName + "(View) in a parent or ancestor Context for android:onClick attribute defined on view " + this.mHostView.getClass() + idText);
        }
    }
}

