/*
 * Decompiled with CFR 0.152.
 */
package androidx.appcompat.app;

import android.content.ComponentName;
import android.content.Context;
import android.os.Build;
import android.util.Log;
import android.util.Xml;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatDelegate;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.Executor;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;
import org.xmlpull.v1.XmlSerializer;

class AppLocalesStorageHelper {
    static final String APPLICATION_LOCALES_RECORD_FILE = "androidx.appcompat.app.AppCompatDelegate.application_locales_record_file";
    static final String LOCALE_RECORD_ATTRIBUTE_TAG = "application_locales";
    static final String LOCALE_RECORD_FILE_TAG = "locales";
    static final String APP_LOCALES_META_DATA_HOLDER_SERVICE_NAME = "androidx.appcompat.app.AppLocalesMetadataHolderService";
    static final String TAG = "AppLocalesStorageHelper";

    private AppLocalesStorageHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    static String readLocales(@NonNull Context context) {
        FileInputStream fis;
        String appLocales = "";
        try {
            fis = context.openFileInput(APPLICATION_LOCALES_RECORD_FILE);
        }
        catch (FileNotFoundException fnfe) {
            Log.w((String)TAG, (String)"Reading app Locales : Locales record file not found: androidx.appcompat.app.AppCompatDelegate.application_locales_record_file");
            return appLocales;
        }
        try {
            int type;
            XmlPullParser parser = Xml.newPullParser();
            parser.setInput((InputStream)fis, "UTF-8");
            int outerDepth = parser.getDepth();
            while ((type = parser.next()) != 1 && (type != 3 || parser.getDepth() > outerDepth)) {
                String tagName;
                if (type == 3 || type == 4 || !(tagName = parser.getName()).equals(LOCALE_RECORD_FILE_TAG)) continue;
                appLocales = parser.getAttributeValue(null, LOCALE_RECORD_ATTRIBUTE_TAG);
                break;
            }
        }
        catch (IOException | XmlPullParserException e) {
            Log.w((String)TAG, (String)"Reading app Locales : Unable to parse through file :androidx.appcompat.app.AppCompatDelegate.application_locales_record_file");
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (!appLocales.isEmpty()) {
            Log.d((String)TAG, (String)("Reading app Locales : Locales read from file: androidx.appcompat.app.AppCompatDelegate.application_locales_record_file , appLocales: " + appLocales));
        } else {
            context.deleteFile(APPLICATION_LOCALES_RECORD_FILE);
        }
        return appLocales;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void persistLocales(@NonNull Context context, @NonNull String locales) {
        FileOutputStream fos;
        if (locales.equals("")) {
            context.deleteFile(APPLICATION_LOCALES_RECORD_FILE);
            return;
        }
        try {
            fos = context.openFileOutput(APPLICATION_LOCALES_RECORD_FILE, 0);
        }
        catch (FileNotFoundException fnfe) {
            Log.w((String)TAG, (String)String.format("Storing App Locales : FileNotFoundException: Cannot open file %s for writing ", APPLICATION_LOCALES_RECORD_FILE));
            return;
        }
        XmlSerializer serializer = Xml.newSerializer();
        try {
            serializer.setOutput((OutputStream)fos, null);
            serializer.startDocument("UTF-8", Boolean.valueOf(true));
            serializer.startTag(null, LOCALE_RECORD_FILE_TAG);
            serializer.attribute(null, LOCALE_RECORD_ATTRIBUTE_TAG, locales);
            serializer.endTag(null, LOCALE_RECORD_FILE_TAG);
            serializer.endDocument();
            Log.d((String)TAG, (String)("Storing App Locales : app-locales: " + locales + " persisted successfully."));
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("Storing App Locales : Failed to persist app-locales: " + locales), (Throwable)e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static void syncLocalesToFramework(Context context) {
        if (Build.VERSION.SDK_INT >= 33) {
            ComponentName app_locales_component = new ComponentName(context, APP_LOCALES_META_DATA_HOLDER_SERVICE_NAME);
            if (context.getPackageManager().getComponentEnabledSetting(app_locales_component) != 1) {
                if (AppCompatDelegate.getApplicationLocales().isEmpty()) {
                    String appLocales = AppLocalesStorageHelper.readLocales(context);
                    Object localeManager = context.getSystemService("locale");
                    if (localeManager != null) {
                        AppCompatDelegate.Api33Impl.localeManagerSetApplicationLocales(localeManager, AppCompatDelegate.Api24Impl.localeListForLanguageTags(appLocales));
                    }
                }
                context.getPackageManager().setComponentEnabledSetting(app_locales_component, 1, 1);
            }
        }
    }

    static class SerialExecutor
    implements Executor {
        private final Object mLock = new Object();
        final Queue<Runnable> mTasks = new ArrayDeque<Runnable>();
        final Executor mExecutor;
        Runnable mActive;

        SerialExecutor(Executor executor) {
            this.mExecutor = executor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable r) {
            Object object = this.mLock;
            synchronized (object) {
                this.mTasks.add(() -> {
                    try {
                        r.run();
                    }
                    finally {
                        this.scheduleNext();
                    }
                });
                if (this.mActive == null) {
                    this.scheduleNext();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void scheduleNext() {
            Object object = this.mLock;
            synchronized (object) {
                this.mActive = this.mTasks.poll();
                if (this.mActive != null) {
                    this.mExecutor.execute(this.mActive);
                }
            }
        }
    }

    static class ThreadPerTaskExecutor
    implements Executor {
        ThreadPerTaskExecutor() {
        }

        @Override
        public void execute(Runnable r) {
            new Thread(r).start();
        }
    }
}

