/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.app;

import android.app.NotificationChannel;
import android.app.NotificationChannelGroup;
import android.os.Build;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.app.NotificationChannelCompat;
import androidx.core.util.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class NotificationChannelGroupCompat {
    final String mId;
    CharSequence mName;
    String mDescription;
    private boolean mBlocked;
    private List<NotificationChannelCompat> mChannels = Collections.emptyList();

    NotificationChannelGroupCompat(@NonNull String id) {
        this.mId = Preconditions.checkNotNull(id);
    }

    @RequiresApi(value=28)
    NotificationChannelGroupCompat(@NonNull NotificationChannelGroup group) {
        this(group, Collections.emptyList());
    }

    @RequiresApi(value=26)
    NotificationChannelGroupCompat(@NonNull NotificationChannelGroup group, @NonNull List<NotificationChannel> allChannels) {
        this(Api26Impl.getId(group));
        this.mName = Api26Impl.getName(group);
        if (Build.VERSION.SDK_INT >= 28) {
            this.mDescription = Api28Impl.getDescription(group);
        }
        if (Build.VERSION.SDK_INT >= 28) {
            this.mBlocked = Api28Impl.isBlocked(group);
            this.mChannels = this.getChannelsCompat(Api26Impl.getChannels(group));
        } else {
            this.mChannels = this.getChannelsCompat(allChannels);
        }
    }

    @RequiresApi(value=26)
    private List<NotificationChannelCompat> getChannelsCompat(List<NotificationChannel> channels) {
        ArrayList<NotificationChannelCompat> channelsCompat = new ArrayList<NotificationChannelCompat>();
        for (NotificationChannel channel : channels) {
            if (!this.mId.equals(Api26Impl.getGroup(channel))) continue;
            channelsCompat.add(new NotificationChannelCompat(channel));
        }
        return channelsCompat;
    }

    NotificationChannelGroup getNotificationChannelGroup() {
        if (Build.VERSION.SDK_INT < 26) {
            return null;
        }
        NotificationChannelGroup group = Api26Impl.createNotificationChannelGroup(this.mId, this.mName);
        if (Build.VERSION.SDK_INT >= 28) {
            Api28Impl.setDescription(group, this.mDescription);
        }
        return group;
    }

    @NonNull
    public Builder toBuilder() {
        return new Builder(this.mId).setName(this.mName).setDescription(this.mDescription);
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    @Nullable
    public CharSequence getName() {
        return this.mName;
    }

    @Nullable
    public String getDescription() {
        return this.mDescription;
    }

    public boolean isBlocked() {
        return this.mBlocked;
    }

    @NonNull
    public List<NotificationChannelCompat> getChannels() {
        return this.mChannels;
    }

    @RequiresApi(value=26)
    static class Api26Impl {
        private Api26Impl() {
        }

        @DoNotInline
        static NotificationChannelGroup createNotificationChannelGroup(String id, CharSequence name) {
            return new NotificationChannelGroup(id, name);
        }

        @DoNotInline
        static String getId(NotificationChannelGroup notificationChannelGroup) {
            return notificationChannelGroup.getId();
        }

        @DoNotInline
        static CharSequence getName(NotificationChannelGroup notificationChannelGroup) {
            return notificationChannelGroup.getName();
        }

        @DoNotInline
        static List<NotificationChannel> getChannels(NotificationChannelGroup notificationChannelGroup) {
            return notificationChannelGroup.getChannels();
        }

        @DoNotInline
        static String getGroup(NotificationChannel notificationChannel) {
            return notificationChannel.getGroup();
        }
    }

    @RequiresApi(value=28)
    static class Api28Impl {
        private Api28Impl() {
        }

        @DoNotInline
        static boolean isBlocked(NotificationChannelGroup notificationChannelGroup) {
            return notificationChannelGroup.isBlocked();
        }

        @DoNotInline
        static String getDescription(NotificationChannelGroup notificationChannelGroup) {
            return notificationChannelGroup.getDescription();
        }

        @DoNotInline
        static void setDescription(NotificationChannelGroup notificationChannelGroup, String description) {
            notificationChannelGroup.setDescription(description);
        }
    }

    public static class Builder {
        final NotificationChannelGroupCompat mGroup;

        public Builder(@NonNull String id) {
            this.mGroup = new NotificationChannelGroupCompat(id);
        }

        @NonNull
        public Builder setName(@Nullable CharSequence name) {
            this.mGroup.mName = name;
            return this;
        }

        @NonNull
        public Builder setDescription(@Nullable String description) {
            this.mGroup.mDescription = description;
            return this;
        }

        @NonNull
        public NotificationChannelGroupCompat build() {
            return this.mGroup;
        }
    }
}

