/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.os;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.Process;
import android.os.UserHandle;
import androidx.annotation.RequiresApi;
import java.lang.reflect.Method;

public final class ProcessCompat {
    private ProcessCompat() {
    }

    public static boolean isApplicationUid(int uid) {
        if (Build.VERSION.SDK_INT >= 24) {
            return Api24Impl.isApplicationUid(uid);
        }
        if (Build.VERSION.SDK_INT >= 17) {
            return Api17Impl.isApplicationUid(uid);
        }
        if (Build.VERSION.SDK_INT == 16) {
            return Api16Impl.isApplicationUid(uid);
        }
        return true;
    }

    @RequiresApi(value=24)
    static class Api24Impl {
        private Api24Impl() {
        }

        static boolean isApplicationUid(int uid) {
            return Process.isApplicationUid((int)uid);
        }
    }

    @RequiresApi(value=17)
    static class Api17Impl {
        private static final Object sResolvedLock = new Object();
        private static Method sMethodUserHandleIsAppMethod;
        private static boolean sResolved;

        private Api17Impl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressLint(value={"DiscouragedPrivateApi"})
        static boolean isApplicationUid(int uid) {
            try {
                Object object = sResolvedLock;
                synchronized (object) {
                    if (!sResolved) {
                        sResolved = true;
                        sMethodUserHandleIsAppMethod = UserHandle.class.getDeclaredMethod("isApp", Integer.TYPE);
                    }
                }
                if (sMethodUserHandleIsAppMethod != null) {
                    Boolean result = (Boolean)sMethodUserHandleIsAppMethod.invoke(null, uid);
                    if (result == null) {
                        throw new NullPointerException();
                    }
                    return result;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
    }

    @RequiresApi(value=16)
    static class Api16Impl {
        private static final Object sResolvedLock = new Object();
        private static Method sMethodUserIdIsAppMethod;
        private static boolean sResolved;

        private Api16Impl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @SuppressLint(value={"PrivateApi"})
        static boolean isApplicationUid(int uid) {
            try {
                Object object = sResolvedLock;
                synchronized (object) {
                    if (!sResolved) {
                        sResolved = true;
                        sMethodUserIdIsAppMethod = Class.forName("android.os.UserId").getDeclaredMethod("isApp", Integer.TYPE);
                    }
                }
                if (sMethodUserIdIsAppMethod != null) {
                    Boolean result = (Boolean)sMethodUserIdIsAppMethod.invoke(null, uid);
                    if (result == null) {
                        throw new NullPointerException();
                    }
                    return result;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
    }
}

