/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.graphics.Rect;
import android.os.Build;
import android.view.Gravity;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;

public final class GravityCompat {
    public static final int RELATIVE_LAYOUT_DIRECTION = 0x800000;
    public static final int START = 0x800003;
    public static final int END = 0x800005;
    public static final int RELATIVE_HORIZONTAL_GRAVITY_MASK = 0x800007;

    public static void apply(int gravity, int w, int h, @NonNull Rect container, @NonNull Rect outRect, int layoutDirection) {
        if (Build.VERSION.SDK_INT >= 17) {
            Api17Impl.apply(gravity, w, h, container, outRect, layoutDirection);
        } else {
            Gravity.apply((int)gravity, (int)w, (int)h, (Rect)container, (Rect)outRect);
        }
    }

    public static void apply(int gravity, int w, int h, @NonNull Rect container, int xAdj, int yAdj, @NonNull Rect outRect, int layoutDirection) {
        if (Build.VERSION.SDK_INT >= 17) {
            Api17Impl.apply(gravity, w, h, container, xAdj, yAdj, outRect, layoutDirection);
        } else {
            Gravity.apply((int)gravity, (int)w, (int)h, (Rect)container, (int)xAdj, (int)yAdj, (Rect)outRect);
        }
    }

    public static void applyDisplay(int gravity, @NonNull Rect display, @NonNull Rect inoutObj, int layoutDirection) {
        if (Build.VERSION.SDK_INT >= 17) {
            Api17Impl.applyDisplay(gravity, display, inoutObj, layoutDirection);
        } else {
            Gravity.applyDisplay((int)gravity, (Rect)display, (Rect)inoutObj);
        }
    }

    public static int getAbsoluteGravity(int gravity, int layoutDirection) {
        if (Build.VERSION.SDK_INT >= 17) {
            return Gravity.getAbsoluteGravity((int)gravity, (int)layoutDirection);
        }
        return gravity & 0xFF7FFFFF;
    }

    private GravityCompat() {
    }

    @RequiresApi(value=17)
    static class Api17Impl {
        private Api17Impl() {
        }

        @DoNotInline
        static void apply(int gravity, int w, int h, Rect container, Rect outRect, int layoutDirection) {
            Gravity.apply((int)gravity, (int)w, (int)h, (Rect)container, (Rect)outRect, (int)layoutDirection);
        }

        @DoNotInline
        static void apply(int gravity, int w, int h, Rect container, int xAdj, int yAdj, Rect outRect, int layoutDirection) {
            Gravity.apply((int)gravity, (int)w, (int)h, (Rect)container, (int)xAdj, (int)yAdj, (Rect)outRect, (int)layoutDirection);
        }

        @DoNotInline
        static void applyDisplay(int gravity, Rect display, Rect inoutObj, int layoutDirection) {
            Gravity.applyDisplay((int)gravity, (Rect)display, (Rect)inoutObj, (int)layoutDirection);
        }
    }
}

