/*
 * Decompiled with CFR 0.152.
 */
package androidx.profileinstaller;

import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.Choreographer;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.profileinstaller.ProfileInstaller;
import androidx.startup.Initializer;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ProfileInstallerInitializer
implements Initializer<Result> {
    private static final int DELAY_MS = 5000;

    @NonNull
    public Result create(@NonNull Context context) {
        if (Build.VERSION.SDK_INT < 24) {
            return new Result();
        }
        this.delayAfterFirstFrame(context.getApplicationContext());
        return new Result();
    }

    @RequiresApi(value=16)
    void delayAfterFirstFrame(@NonNull Context appContext) {
        Choreographer16Impl.postFrameCallback(() -> this.installAfterDelay(appContext));
    }

    void installAfterDelay(@NonNull Context appContext) {
        Handler handler = Build.VERSION.SDK_INT >= 28 ? Handler28Impl.createAsync(Looper.getMainLooper()) : new Handler(Looper.getMainLooper());
        Random random = new Random();
        int extra = random.nextInt(Math.max(1000, 1));
        handler.postDelayed(() -> ProfileInstallerInitializer.writeInBackground(appContext), (long)(5000 + extra));
    }

    @NonNull
    public List<Class<? extends Initializer<?>>> dependencies() {
        return Collections.emptyList();
    }

    private static void writeInBackground(@NonNull Context context) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(0, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        executor.execute(() -> ProfileInstaller.writeProfile(context));
    }

    public static class Result {
    }

    @RequiresApi(value=16)
    private static class Choreographer16Impl {
        private Choreographer16Impl() {
        }

        @DoNotInline
        public static void postFrameCallback(Runnable r) {
            Choreographer.getInstance().postFrameCallback(frameTimeNanos -> r.run());
        }
    }

    @RequiresApi(value=28)
    private static class Handler28Impl {
        private Handler28Impl() {
        }

        @DoNotInline
        public static Handler createAsync(Looper looper) {
            return Handler.createAsync((Looper)looper);
        }
    }
}

