/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.graphics.Rect;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import androidx.collection.ArrayMap;
import androidx.core.app.SharedElementCallback;
import androidx.core.os.CancellationSignal;
import androidx.core.view.OneShotPreDrawListener;
import androidx.core.view.ViewCompat;
import androidx.core.view.ViewGroupCompat;
import androidx.fragment.app.DefaultSpecialEffectsController;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentAnim;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentTransition;
import androidx.fragment.app.FragmentTransitionImpl;
import androidx.fragment.app.SpecialEffectsController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0003*+,B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J(\u0010\t\u001a\u00020\u00062\u0016\u0010\n\u001a\u0012\u0012\u0004\u0012\u00020\f0\u000bj\b\u0012\u0004\u0012\u00020\f`\r2\u0006\u0010\u000e\u001a\u00020\fH\u0002J\u001e\u0010\u000f\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J$\u0010\u0014\u001a\u00020\u00062\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\f0\u00162\u0006\u0010\u000e\u001a\u00020\fH\u0002J@\u0010\u0018\u001a\u00020\u00062\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00112\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001c2\u0006\u0010\u001d\u001a\u00020\u00132\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00130\u001fH\u0002JL\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00130\u001f2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u00112\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u001c2\u0006\u0010\u0012\u001a\u00020\u00132\b\u0010#\u001a\u0004\u0018\u00010\b2\b\u0010$\u001a\u0004\u0018\u00010\bH\u0002J\u0016\u0010%\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\b0\u0011H\u0002J&\u0010&\u001a\u00020\u0006*\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\f0'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00170)H\u0002\u00a8\u0006-"}, d2={"Landroidx/fragment/app/DefaultSpecialEffectsController;", "Landroidx/fragment/app/SpecialEffectsController;", "container", "Landroid/view/ViewGroup;", "(Landroid/view/ViewGroup;)V", "applyContainerChanges", "", "operation", "Landroidx/fragment/app/SpecialEffectsController$Operation;", "captureTransitioningViews", "transitioningViews", "Ljava/util/ArrayList;", "Landroid/view/View;", "Lkotlin/collections/ArrayList;", "view", "executeOperations", "operations", "", "isPop", "", "findNamedViews", "namedViews", "", "", "startAnimations", "animationInfos", "Landroidx/fragment/app/DefaultSpecialEffectsController$AnimationInfo;", "awaitingContainerChanges", "", "startedAnyTransition", "startedTransitions", "", "startTransitions", "transitionInfos", "Landroidx/fragment/app/DefaultSpecialEffectsController$TransitionInfo;", "firstOut", "lastIn", "syncAnimations", "retainMatchingViews", "Landroidx/collection/ArrayMap;", "names", "", "AnimationInfo", "SpecialEffectsInfo", "TransitionInfo", "fragment_release"})
@SourceDebugExtension(value={"SMAP\nDefaultSpecialEffectsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DefaultSpecialEffectsController.kt\nandroidx/fragment/app/DefaultSpecialEffectsController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,877:1\n288#2,2:878\n533#2,6:880\n819#2:886\n847#2,2:887\n766#2:889\n857#2,2:890\n1789#2,3:892\n819#2:895\n847#2,2:896\n1855#2,2:898\n*S KotlinDebug\n*F\n+ 1 DefaultSpecialEffectsController.kt\nandroidx/fragment/app/DefaultSpecialEffectsController\n*L\n47#1:878,2\n53#1:880,6\n312#1:886\n312#1:887,2\n315#1:889\n315#1:890,2\n317#1:892,3\n629#1:895\n629#1:896,2\n632#1:898,2\n*E\n"})
public final class DefaultSpecialEffectsController
extends SpecialEffectsController {
    public DefaultSpecialEffectsController(@NotNull ViewGroup container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        super(container);
    }

    public void executeOperations(@NotNull List<? extends SpecialEffectsController.Operation> operations, boolean isPop) {
        SpecialEffectsController.Operation operation;
        SpecialEffectsController.Operation firstOut;
        block7: {
            Object v2;
            block6: {
                Intrinsics.checkNotNullParameter(operations, (String)"operations");
                Iterable $this$firstOrNull$iv = operations;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    SpecialEffectsController.Operation operation2 = (SpecialEffectsController.Operation)element$iv;
                    boolean bl = false;
                    View view = operation2.getFragment().mView;
                    Intrinsics.checkNotNullExpressionValue((Object)view, (String)"operation.fragment.mView");
                    SpecialEffectsController.Operation.State currentState = SpecialEffectsController.Operation.State.Companion.asOperationState(view);
                    boolean bl2 = currentState == SpecialEffectsController.Operation.State.VISIBLE && operation2.getFinalState() != SpecialEffectsController.Operation.State.VISIBLE;
                    if (!bl2) continue;
                    v2 = element$iv;
                    break block6;
                }
                v2 = null;
            }
            firstOut = v2;
            List<? extends SpecialEffectsController.Operation> $this$lastOrNull$iv = operations;
            boolean $i$f$lastOrNull = false;
            ListIterator<? extends SpecialEffectsController.Operation> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                SpecialEffectsController.Operation element$iv = iterator$iv.previous();
                SpecialEffectsController.Operation operation2 = element$iv;
                boolean bl = false;
                View view = operation2.getFragment().mView;
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"operation.fragment.mView");
                SpecialEffectsController.Operation.State currentState = SpecialEffectsController.Operation.State.Companion.asOperationState(view);
                boolean bl3 = currentState != SpecialEffectsController.Operation.State.VISIBLE && operation2.getFinalState() == SpecialEffectsController.Operation.State.VISIBLE;
                if (!bl3) continue;
                operation = element$iv;
                break block7;
            }
            operation = null;
        }
        SpecialEffectsController.Operation lastIn = operation;
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)"FragmentManager", (String)("Executing operations from " + firstOut + " to " + lastIn));
        }
        List animations = new ArrayList();
        List transitions = new ArrayList();
        List awaitingContainerChanges = CollectionsKt.toMutableList((Collection)operations);
        this.syncAnimations(operations);
        for (SpecialEffectsController.Operation operation3 : operations) {
            CancellationSignal animCancellationSignal = new CancellationSignal();
            operation3.markStartedSpecialEffect(animCancellationSignal);
            animations.add(new AnimationInfo(operation3, animCancellationSignal, isPop));
            CancellationSignal transitionCancellationSignal = new CancellationSignal();
            operation3.markStartedSpecialEffect(transitionCancellationSignal);
            transitions.add(new TransitionInfo(operation3, transitionCancellationSignal, isPop, isPop ? operation3 == firstOut : operation3 == lastIn));
            operation3.addCompletionListener(() -> DefaultSpecialEffectsController.executeOperations$lambda$2(awaitingContainerChanges, operation3, this));
        }
        Map<SpecialEffectsController.Operation, Boolean> startedTransitions = this.startTransitions(transitions, awaitingContainerChanges, isPop, firstOut, lastIn);
        boolean bl = startedTransitions.containsValue(true);
        this.startAnimations(animations, awaitingContainerChanges, bl, startedTransitions);
        for (SpecialEffectsController.Operation operation5 : awaitingContainerChanges) {
            this.applyContainerChanges(operation5);
        }
        awaitingContainerChanges.clear();
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)"FragmentManager", (String)("Completed executing operations from " + firstOut + " to " + lastIn));
        }
    }

    private final void syncAnimations(List<? extends SpecialEffectsController.Operation> operations) {
        Fragment lastOpFragment = ((SpecialEffectsController.Operation)CollectionsKt.last(operations)).getFragment();
        for (SpecialEffectsController.Operation operation : operations) {
            operation.getFragment().mAnimationInfo.mEnterAnim = lastOpFragment.mAnimationInfo.mEnterAnim;
            operation.getFragment().mAnimationInfo.mExitAnim = lastOpFragment.mAnimationInfo.mExitAnim;
            operation.getFragment().mAnimationInfo.mPopEnterAnim = lastOpFragment.mAnimationInfo.mPopEnterAnim;
            operation.getFragment().mAnimationInfo.mPopExitAnim = lastOpFragment.mAnimationInfo.mPopExitAnim;
        }
    }

    private final void startAnimations(List<AnimationInfo> animationInfos, List<SpecialEffectsController.Operation> awaitingContainerChanges, boolean startedAnyTransition, Map<SpecialEffectsController.Operation, Boolean> startedTransitions) {
        Context context = this.getContainer().getContext();
        List animationsToRun = new ArrayList();
        boolean startedAnyAnimator = false;
        for (AnimationInfo animationInfo : animationInfos) {
            boolean isHideOperation;
            if (animationInfo.isVisibilityUnchanged()) {
                animationInfo.completeSpecialEffect();
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            FragmentAnim.AnimationOrAnimator anim = animationInfo.getAnimation(context);
            if (anim == null) {
                animationInfo.completeSpecialEffect();
                continue;
            }
            Animator animator2 = anim.animator;
            if (animator2 == null) {
                animationsToRun.add(animationInfo);
                continue;
            }
            SpecialEffectsController.Operation operation = animationInfo.getOperation();
            Fragment fragment = operation.getFragment();
            boolean startedTransition = Intrinsics.areEqual((Object)startedTransitions.get(operation), (Object)true);
            if (startedTransition) {
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)("Ignoring Animator set on " + fragment + " as this Fragment was involved in a Transition."));
                }
                animationInfo.completeSpecialEffect();
                continue;
            }
            startedAnyAnimator = true;
            boolean bl = isHideOperation = operation.getFinalState() == SpecialEffectsController.Operation.State.GONE;
            if (isHideOperation) {
                awaitingContainerChanges.remove(operation);
            }
            View viewToAnimate = fragment.mView;
            this.getContainer().startViewTransition(viewToAnimate);
            animator2.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(this, viewToAnimate, isHideOperation, operation, animationInfo){
                final /* synthetic */ DefaultSpecialEffectsController this$0;
                final /* synthetic */ View $viewToAnimate;
                final /* synthetic */ boolean $isHideOperation;
                final /* synthetic */ SpecialEffectsController.Operation $operation;
                final /* synthetic */ AnimationInfo $animationInfo;
                {
                    this.this$0 = $receiver;
                    this.$viewToAnimate = $viewToAnimate;
                    this.$isHideOperation = $isHideOperation;
                    this.$operation = $operation;
                    this.$animationInfo = $animationInfo;
                }

                public void onAnimationEnd(@NotNull Animator anim) {
                    Intrinsics.checkNotNullParameter((Object)anim, (String)"anim");
                    this.this$0.getContainer().endViewTransition(this.$viewToAnimate);
                    if (this.$isHideOperation) {
                        SpecialEffectsController.Operation.State state = this.$operation.getFinalState();
                        View view = this.$viewToAnimate;
                        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"viewToAnimate");
                        state.applyState(view);
                    }
                    this.$animationInfo.completeSpecialEffect();
                    if (FragmentManager.isLoggingEnabled(2)) {
                        Log.v((String)"FragmentManager", (String)("Animator from operation " + this.$operation + " has ended."));
                    }
                }
            });
            animator2.setTarget((Object)viewToAnimate);
            animator2.start();
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)"FragmentManager", (String)("Animator from operation " + operation + " has started."));
            }
            CancellationSignal signal = animationInfo.getSignal();
            signal.setOnCancelListener(() -> DefaultSpecialEffectsController.startAnimations$lambda$3(animator2, operation));
        }
        for (AnimationInfo animationInfo : animationsToRun) {
            Animation anim;
            SpecialEffectsController.Operation operation = animationInfo.getOperation();
            Fragment fragment = operation.getFragment();
            if (startedAnyTransition) {
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)("Ignoring Animation set on " + fragment + " as Animations cannot run alongside Transitions."));
                }
                animationInfo.completeSpecialEffect();
                continue;
            }
            if (startedAnyAnimator) {
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)("Ignoring Animation set on " + fragment + " as Animations cannot run alongside Animators."));
                }
                animationInfo.completeSpecialEffect();
                continue;
            }
            View viewToAnimate = fragment.mView;
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
            FragmentAnim.AnimationOrAnimator animationOrAnimator = animationInfo.getAnimation(context);
            if (animationOrAnimator == null) {
                String isHideOperation = "Required value was null.";
                throw new IllegalStateException(isHideOperation.toString());
            }
            if (animationOrAnimator.animation == null) {
                String isHideOperation = "Required value was null.";
                throw new IllegalStateException(isHideOperation.toString());
            }
            SpecialEffectsController.Operation.State finalState = operation.getFinalState();
            if (finalState != SpecialEffectsController.Operation.State.REMOVED) {
                viewToAnimate.startAnimation(anim);
                animationInfo.completeSpecialEffect();
            } else {
                this.getContainer().startViewTransition(viewToAnimate);
                Animation animation = (Animation)new FragmentAnim.EndViewTransitionAnimation(anim, this.getContainer(), viewToAnimate);
                animation.setAnimationListener(new Animation.AnimationListener(operation, this, viewToAnimate, animationInfo){
                    final /* synthetic */ SpecialEffectsController.Operation $operation;
                    final /* synthetic */ DefaultSpecialEffectsController this$0;
                    final /* synthetic */ View $viewToAnimate;
                    final /* synthetic */ AnimationInfo $animationInfo;
                    {
                        this.$operation = $operation;
                        this.this$0 = $receiver;
                        this.$viewToAnimate = $viewToAnimate;
                        this.$animationInfo = $animationInfo;
                    }

                    public void onAnimationStart(@NotNull Animation animation) {
                        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                        if (FragmentManager.isLoggingEnabled(2)) {
                            Log.v((String)"FragmentManager", (String)("Animation from operation " + this.$operation + " has reached onAnimationStart."));
                        }
                    }

                    public void onAnimationEnd(@NotNull Animation animation) {
                        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                        this.this$0.getContainer().post(() -> startAnimations.3.onAnimationEnd$lambda$0(this.this$0, this.$viewToAnimate, this.$animationInfo));
                        if (FragmentManager.isLoggingEnabled(2)) {
                            Log.v((String)"FragmentManager", (String)("Animation from operation " + this.$operation + " has ended."));
                        }
                    }

                    public void onAnimationRepeat(@NotNull Animation animation) {
                        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
                    }

                    private static final void onAnimationEnd$lambda$0(DefaultSpecialEffectsController this$0, View $viewToAnimate, AnimationInfo $animationInfo) {
                        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                        Intrinsics.checkNotNullParameter((Object)$animationInfo, (String)"$animationInfo");
                        this$0.getContainer().endViewTransition($viewToAnimate);
                        $animationInfo.completeSpecialEffect();
                    }
                });
                viewToAnimate.startAnimation(animation);
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)("Animation from operation " + operation + " has started."));
                }
            }
            CancellationSignal signal = animationInfo.getSignal();
            signal.setOnCancelListener(() -> DefaultSpecialEffectsController.startAnimations$lambda$4(viewToAnimate, this, animationInfo, operation));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Map<SpecialEffectsController.Operation, Boolean> startTransitions(List<TransitionInfo> transitionInfos, List<SpecialEffectsController.Operation> awaitingContainerChanges, boolean isPop, SpecialEffectsController.Operation firstOut, SpecialEffectsController.Operation lastIn) {
        void $this$forEach$iv;
        Iterator $this$filterNotTo$iv$iv;
        Object transitioningViews;
        Object transition;
        Iterator<TransitionInfo> $this$fold$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        boolean bl;
        TransitionInfo transitionInfo;
        void $this$filterNotTo$iv$iv2;
        Map startedTransitions = new LinkedHashMap();
        Iterable $this$filterNot$iv = transitionInfos;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv2) {
            transitionInfo = (TransitionInfo)element$iv$iv;
            bl = false;
            if (transitionInfo.isVisibilityUnchanged()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterNot$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$filterNotTo$iv$iv2 = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo232 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            transitionInfo = (TransitionInfo)element$iv$iv;
            bl = false;
            if (!(transitionInfo.getHandlingImpl() != null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        FragmentTransitionImpl initial$iv = null;
        boolean $i$f$fold = false;
        FragmentTransitionImpl accumulator$iv = initial$iv;
        Iterator $i$f$filterTo232 = $this$fold$iv.iterator();
        while ($i$f$filterTo232.hasNext()) {
            void transitionInfo2;
            Object element$iv$iv;
            Object element$iv = $i$f$filterTo232.next();
            element$iv$iv = (TransitionInfo)element$iv;
            FragmentTransitionImpl chosenImpl = accumulator$iv;
            bl = false;
            FragmentTransitionImpl handlingImpl = transitionInfo2.getHandlingImpl();
            if (!(chosenImpl == null || handlingImpl == chosenImpl)) {
                boolean $i$a$-require-DefaultSpecialEffectsController$startTransitions$transitionImpl$3$232 = false;
                String $i$a$-require-DefaultSpecialEffectsController$startTransitions$transitionImpl$3$232 = "Mixing framework transitions and AndroidX transitions is not allowed. Fragment " + transitionInfo2.getOperation().getFragment() + " returned Transition " + transitionInfo2.getTransition() + " which uses a different Transition type than other Fragments.";
                throw new IllegalArgumentException($i$a$-require-DefaultSpecialEffectsController$startTransitions$transitionImpl$3$232.toString());
            }
            accumulator$iv = handlingImpl;
        }
        FragmentTransitionImpl transitionImpl = accumulator$iv;
        if (transitionImpl == null) {
            for (TransitionInfo transitionInfo3 : transitionInfos) {
                startedTransitions.put(transitionInfo3.getOperation(), false);
                transitionInfo3.completeSpecialEffect();
            }
            return startedTransitions;
        }
        View nonExistentView = new View(this.getContainer().getContext());
        Object sharedElementTransition = null;
        View firstOutEpicenterView = null;
        boolean hasLastInEpicenter = false;
        Rect lastInEpicenterRect = new Rect();
        ArrayList<View> sharedElementFirstOutViews = new ArrayList<View>();
        ArrayList<View> sharedElementLastInViews = new ArrayList<View>();
        ArrayMap sharedElementNameMapping = new ArrayMap();
        for (TransitionInfo transitionInfo4 : transitionInfos) {
            String epicenterViewName;
            View lastInEpicenterView;
            ArrayList<String> enteringNames;
            Object exitingNames;
            ArrayList<String> firstOutTargetNames;
            boolean hasSharedElementTransition = transitionInfo4.hasSharedElementTransition();
            if (!hasSharedElementTransition || firstOut == null || lastIn == null) continue;
            sharedElementTransition = transitionImpl.wrapTransitionInSet(transitionImpl.cloneTransition(transitionInfo4.getSharedElementTransition()));
            Intrinsics.checkNotNullExpressionValue(lastIn.getFragment().getSharedElementSourceNames(), (String)"lastIn.fragment.sharedElementSourceNames");
            Intrinsics.checkNotNullExpressionValue(firstOut.getFragment().getSharedElementSourceNames(), (String)"firstOut.fragment.sharedElementSourceNames");
            Intrinsics.checkNotNullExpressionValue(firstOut.getFragment().getSharedElementTargetNames(), (String)"firstOut.fragment.sharedElementTargetNames");
            int n = firstOutTargetNames.size();
            for (int index = 0; index < n; ++index) {
                ArrayList<String> firstOutSourceNames;
                int nameIndex = ((ArrayList)exitingNames).indexOf(firstOutTargetNames.get(index));
                if (nameIndex == -1) continue;
                ((ArrayList)exitingNames).set(nameIndex, firstOutSourceNames.get(index));
            }
            Intrinsics.checkNotNullExpressionValue(lastIn.getFragment().getSharedElementTargetNames(), (String)"lastIn.fragment.sharedElementTargetNames");
            Pair pair = !isPop ? TuplesKt.to((Object)firstOut.getFragment().getExitTransitionCallback(), (Object)lastIn.getFragment().getEnterTransitionCallback()) : TuplesKt.to((Object)firstOut.getFragment().getEnterTransitionCallback(), (Object)lastIn.getFragment().getExitTransitionCallback());
            SharedElementCallback exitingCallback = (SharedElementCallback)pair.component1();
            SharedElementCallback enteringCallback = (SharedElementCallback)pair.component2();
            int numSharedElements = ((ArrayList)exitingNames).size();
            for (int i = 0; i < numSharedElements; ++i) {
                String exitingName = (String)((ArrayList)exitingNames).get(i);
                String enteringName = enteringNames.get(i);
                ((Map)sharedElementNameMapping).put(exitingName, enteringName);
            }
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)"FragmentManager", (String)">>> entering view names <<<");
                for (String name : enteringNames) {
                    Log.v((String)"FragmentManager", (String)("Name: " + name));
                }
                Log.v((String)"FragmentManager", (String)">>> exiting view names <<<");
                Iterator<String> i = ((ArrayList)exitingNames).iterator();
                while (i.hasNext()) {
                    String name;
                    name = i.next();
                    Log.v((String)"FragmentManager", (String)("Name: " + name));
                }
            }
            ArrayMap firstOutViews = new ArrayMap();
            Map map = (Map)firstOutViews;
            View view = firstOut.getFragment().mView;
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"firstOut.fragment.mView");
            this.findNamedViews(map, view);
            firstOutViews.retainAll((Collection)exitingNames);
            if (exitingCallback != null) {
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)("Executing exit callback for operation " + firstOut));
                }
                exitingCallback.onMapSharedElements((List)exitingNames, (Map)firstOutViews);
                int name = ((ArrayList)exitingNames).size() + -1;
                if (0 <= name) {
                    do {
                        int i;
                        String name2;
                        View view2;
                        if ((view2 = (View)firstOutViews.get((Object)(name2 = (String)((ArrayList)exitingNames).get(i = name--)))) == null) {
                            sharedElementNameMapping.remove((Object)name2);
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)name2, (Object)ViewCompat.getTransitionName((View)view2))) continue;
                        String targetValue = (String)sharedElementNameMapping.remove((Object)name2);
                        ((Map)sharedElementNameMapping).put(ViewCompat.getTransitionName((View)view2), targetValue);
                    } while (0 <= name);
                }
            } else {
                sharedElementNameMapping.retainAll((Collection)firstOutViews.keySet());
            }
            ArrayMap lastInViews = new ArrayMap();
            Map map2 = (Map)lastInViews;
            View view2 = lastIn.getFragment().mView;
            Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"lastIn.fragment.mView");
            this.findNamedViews(map2, view2);
            lastInViews.retainAll((Collection)enteringNames);
            lastInViews.retainAll(sharedElementNameMapping.values());
            if (enteringCallback != null) {
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)("Executing enter callback for operation " + lastIn));
                }
                enteringCallback.onMapSharedElements((List)enteringNames, (Map)lastInViews);
                int i = enteringNames.size() + -1;
                if (0 <= i) {
                    do {
                        String key;
                        int i2;
                        String name;
                        View view4;
                        if ((view4 = (View)lastInViews.get((Object)(name = enteringNames.get(i2 = i--)))) == null) {
                            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                            key = FragmentTransition.findKeyForValue((ArrayMap<String, String>)sharedElementNameMapping, name);
                            if (key == null) continue;
                            sharedElementNameMapping.remove((Object)key);
                            continue;
                        }
                        if (Intrinsics.areEqual((Object)name, (Object)ViewCompat.getTransitionName((View)view4))) continue;
                        Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                        key = FragmentTransition.findKeyForValue((ArrayMap<String, String>)sharedElementNameMapping, name);
                        if (key == null) continue;
                        ((Map)sharedElementNameMapping).put(key, ViewCompat.getTransitionName((View)view4));
                    } while (0 <= i);
                }
            } else {
                FragmentTransition.retainValues((ArrayMap<String, String>)sharedElementNameMapping, (ArrayMap<String, View>)lastInViews);
            }
            Set set = sharedElementNameMapping.keySet();
            Intrinsics.checkNotNullExpressionValue((Object)set, (String)"sharedElementNameMapping.keys");
            this.retainMatchingViews((ArrayMap<String, View>)firstOutViews, set);
            Collection collection = sharedElementNameMapping.values();
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"sharedElementNameMapping.values");
            this.retainMatchingViews((ArrayMap<String, View>)lastInViews, collection);
            if (sharedElementNameMapping.isEmpty()) {
                sharedElementTransition = null;
                sharedElementFirstOutViews.clear();
                sharedElementLastInViews.clear();
                continue;
            }
            FragmentTransition.callSharedElementStartEnd(lastIn.getFragment(), firstOut.getFragment(), isPop, (ArrayMap<String, View>)firstOutViews, true);
            OneShotPreDrawListener.add((View)((View)this.getContainer()), () -> DefaultSpecialEffectsController.startTransitions$lambda$9(lastIn, firstOut, isPop, lastInViews));
            sharedElementFirstOutViews.addAll(firstOutViews.values());
            if (!((Collection)exitingNames).isEmpty()) {
                String epicenterViewName2 = (String)((ArrayList)exitingNames).get(0);
                firstOutEpicenterView = (View)firstOutViews.get((Object)epicenterViewName2);
                transitionImpl.setEpicenter(sharedElementTransition, firstOutEpicenterView);
            }
            sharedElementLastInViews.addAll(lastInViews.values());
            if (!((Collection)enteringNames).isEmpty() && (lastInEpicenterView = (View)lastInViews.get((Object)(epicenterViewName = enteringNames.get(0)))) != null) {
                hasLastInEpicenter = true;
                FragmentTransitionImpl impl = transitionImpl;
                OneShotPreDrawListener.add((View)((View)this.getContainer()), () -> DefaultSpecialEffectsController.startTransitions$lambda$10(impl, lastInEpicenterView, lastInEpicenterRect));
            }
            transitionImpl.setSharedElementTargets(sharedElementTransition, nonExistentView, sharedElementFirstOutViews);
            transitionImpl.scheduleRemoveTargets(sharedElementTransition, null, null, null, null, sharedElementTransition, sharedElementLastInViews);
            startedTransitions.put(firstOut, true);
            startedTransitions.put(lastIn, true);
        }
        ArrayList enteringViews = new ArrayList();
        Object mergedTransition = null;
        Object mergedNonOverlappingTransition = null;
        for (TransitionInfo transitionInfo5 : transitionInfos) {
            boolean involvedInSharedElementTransition;
            if (transitionInfo5.isVisibilityUnchanged()) {
                startedTransitions.put(transitionInfo5.getOperation(), false);
                transitionInfo5.completeSpecialEffect();
                continue;
            }
            transition = transitionImpl.cloneTransition(transitionInfo5.getTransition());
            SpecialEffectsController.Operation operation = transitionInfo5.getOperation();
            boolean bl2 = involvedInSharedElementTransition = sharedElementTransition != null && (operation == firstOut || operation == lastIn);
            if (transition == null) {
                if (involvedInSharedElementTransition) continue;
                startedTransitions.put(operation, false);
                transitionInfo5.completeSpecialEffect();
                continue;
            }
            transitioningViews = new ArrayList();
            View view = operation.getFragment().mView;
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"operation.fragment.mView");
            this.captureTransitioningViews((ArrayList<View>)transitioningViews, view);
            if (involvedInSharedElementTransition) {
                if (operation == firstOut) {
                    ((ArrayList)transitioningViews).removeAll(CollectionsKt.toSet((Iterable)sharedElementFirstOutViews));
                } else {
                    ((ArrayList)transitioningViews).removeAll(CollectionsKt.toSet((Iterable)sharedElementLastInViews));
                }
            }
            if (((ArrayList)transitioningViews).isEmpty()) {
                transitionImpl.addTarget(transition, nonExistentView);
            } else {
                transitionImpl.addTargets(transition, (ArrayList<View>)transitioningViews);
                transitionImpl.scheduleRemoveTargets(transition, transition, (ArrayList<View>)transitioningViews, null, null, null, null);
                if (operation.getFinalState() == SpecialEffectsController.Operation.State.GONE) {
                    awaitingContainerChanges.remove(operation);
                    ArrayList<View> transitioningViewsToHide = new ArrayList<View>((Collection)transitioningViews);
                    transitioningViewsToHide.remove(operation.getFragment().mView);
                    transitionImpl.scheduleHideFragmentView(transition, operation.getFragment().mView, transitioningViewsToHide);
                    OneShotPreDrawListener.add((View)((View)this.getContainer()), () -> DefaultSpecialEffectsController.startTransitions$lambda$11((ArrayList)transitioningViews));
                }
            }
            if (operation.getFinalState() == SpecialEffectsController.Operation.State.VISIBLE) {
                enteringViews.addAll((Collection)transitioningViews);
                if (hasLastInEpicenter) {
                    transitionImpl.setEpicenter(transition, lastInEpicenterRect);
                }
            } else {
                transitionImpl.setEpicenter(transition, firstOutEpicenterView);
            }
            startedTransitions.put(operation, true);
            if (transitionInfo5.isOverlapAllowed()) {
                mergedTransition = transitionImpl.mergeTransitionsTogether(mergedTransition, transition, null);
                continue;
            }
            mergedNonOverlappingTransition = transitionImpl.mergeTransitionsTogether(mergedNonOverlappingTransition, transition, null);
        }
        if ((mergedTransition = transitionImpl.mergeTransitionsInSequence(mergedTransition, mergedNonOverlappingTransition, sharedElementTransition)) == null) {
            return startedTransitions;
        }
        Iterable $this$filterNot$iv2 = transitionInfos;
        boolean $i$f$filterNot2 = false;
        transition = $this$filterNot$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterNotTo2 = false;
        transitioningViews = $this$filterNotTo$iv$iv.iterator();
        while (transitioningViews.hasNext()) {
            Object element$iv$iv = transitioningViews.next();
            TransitionInfo transitionInfo6 = (TransitionInfo)element$iv$iv;
            boolean bl3 = false;
            if (transitionInfo6.isVisibilityUnchanged()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filterNot$iv2 = (List)destination$iv$iv2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean involvedInSharedElementTransition;
            TransitionInfo transitionInfo7 = (TransitionInfo)element$iv;
            boolean bl4 = false;
            Object transition2 = transitionInfo7.getTransition();
            SpecialEffectsController.Operation operation = transitionInfo7.getOperation();
            boolean bl5 = involvedInSharedElementTransition = sharedElementTransition != null && (operation == firstOut || operation == lastIn);
            if (transition2 == null && !involvedInSharedElementTransition) continue;
            if (!ViewCompat.isLaidOut((View)((View)this.getContainer()))) {
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Container " + this.getContainer() + " has not been laid out. Completing operation " + operation));
                }
                transitionInfo7.completeSpecialEffect();
                continue;
            }
            transitionImpl.setListenerForTransitionEnd(transitionInfo7.getOperation().getFragment(), mergedTransition, transitionInfo7.getSignal(), () -> DefaultSpecialEffectsController.startTransitions$lambda$14$lambda$13(transitionInfo7, operation));
        }
        if (!ViewCompat.isLaidOut((View)((View)this.getContainer()))) {
            return startedTransitions;
        }
        FragmentTransition.setViewVisibility(enteringViews, 4);
        ArrayList<String> inNames = transitionImpl.prepareSetNameOverridesReordered(sharedElementLastInViews);
        if (FragmentManager.isLoggingEnabled(2)) {
            View view;
            Log.v((String)"FragmentManager", (String)">>>>> Beginning transition <<<<<");
            Log.v((String)"FragmentManager", (String)">>>>> SharedElementFirstOutViews <<<<<");
            for (Object e : sharedElementFirstOutViews) {
                Intrinsics.checkNotNullExpressionValue(e, (String)"sharedElementFirstOutViews");
                view = (View)e;
                Log.v((String)"FragmentManager", (String)("View: " + view + " Name: " + ViewCompat.getTransitionName((View)view)));
            }
            Log.v((String)"FragmentManager", (String)">>>>> SharedElementLastInViews <<<<<");
            for (Object object : sharedElementLastInViews) {
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"sharedElementLastInViews");
                view = (View)object;
                Log.v((String)"FragmentManager", (String)("View: " + view + " Name: " + ViewCompat.getTransitionName((View)view)));
            }
        }
        transitionImpl.beginDelayedTransition(this.getContainer(), mergedTransition);
        transitionImpl.setNameOverridesReordered((View)this.getContainer(), sharedElementFirstOutViews, sharedElementLastInViews, inNames, (Map)sharedElementNameMapping);
        FragmentTransition.setViewVisibility(enteringViews, 0);
        transitionImpl.swapSharedElementTargets(sharedElementTransition, sharedElementFirstOutViews, sharedElementLastInViews);
        return startedTransitions;
    }

    private final void retainMatchingViews(ArrayMap<String, View> $this$retainMatchingViews, Collection<String> names) {
        Set set = $this$retainMatchingViews.entrySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"entries");
        CollectionsKt.retainAll((Iterable)set, (Function1)((Function1)new Function1<Map.Entry<String, View>, Boolean>(names){
            final /* synthetic */ Collection<String> $names;
            {
                this.$names = $names;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Map.Entry<String, View> entry) {
                Intrinsics.checkNotNullParameter(entry, (String)"entry");
                return CollectionsKt.contains((Iterable)this.$names, (Object)ViewCompat.getTransitionName((View)entry.getValue()));
            }
        }));
    }

    private final void captureTransitioningViews(ArrayList<View> transitioningViews, View view) {
        if (view instanceof ViewGroup) {
            if (ViewGroupCompat.isTransitionGroup((ViewGroup)((ViewGroup)view))) {
                if (!transitioningViews.contains(view)) {
                    transitioningViews.add(view);
                }
            } else {
                int count = ((ViewGroup)view).getChildCount();
                for (int i = 0; i < count; ++i) {
                    View child = ((ViewGroup)view).getChildAt(i);
                    if (child.getVisibility() != 0) continue;
                    Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                    this.captureTransitioningViews(transitioningViews, child);
                }
            }
        } else if (!transitioningViews.contains(view)) {
            transitioningViews.add(view);
        }
    }

    private final void findNamedViews(Map<String, View> namedViews, View view) {
        String transitionName = ViewCompat.getTransitionName((View)view);
        if (transitionName != null) {
            namedViews.put(transitionName, view);
        }
        if (view instanceof ViewGroup) {
            int count = ((ViewGroup)view).getChildCount();
            for (int i = 0; i < count; ++i) {
                View child = ((ViewGroup)view).getChildAt(i);
                if (child.getVisibility() != 0) continue;
                Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                this.findNamedViews(namedViews, child);
            }
        }
    }

    private final void applyContainerChanges(SpecialEffectsController.Operation operation) {
        View view = operation.getFragment().mView;
        SpecialEffectsController.Operation.State state = operation.getFinalState();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"view");
        state.applyState(view);
    }

    private static final void executeOperations$lambda$2(List $awaitingContainerChanges, SpecialEffectsController.Operation $operation, DefaultSpecialEffectsController this$0) {
        Intrinsics.checkNotNullParameter((Object)$awaitingContainerChanges, (String)"$awaitingContainerChanges");
        Intrinsics.checkNotNullParameter((Object)$operation, (String)"$operation");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        if ($awaitingContainerChanges.contains($operation)) {
            $awaitingContainerChanges.remove($operation);
            this$0.applyContainerChanges($operation);
        }
    }

    private static final void startAnimations$lambda$3(Animator $animator, SpecialEffectsController.Operation $operation) {
        Intrinsics.checkNotNullParameter((Object)$operation, (String)"$operation");
        $animator.end();
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)"FragmentManager", (String)("Animator from operation " + $operation + " has been canceled."));
        }
    }

    private static final void startAnimations$lambda$4(View $viewToAnimate, DefaultSpecialEffectsController this$0, AnimationInfo $animationInfo, SpecialEffectsController.Operation $operation) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$animationInfo, (String)"$animationInfo");
        Intrinsics.checkNotNullParameter((Object)$operation, (String)"$operation");
        $viewToAnimate.clearAnimation();
        this$0.getContainer().endViewTransition($viewToAnimate);
        $animationInfo.completeSpecialEffect();
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)"FragmentManager", (String)("Animation from operation " + $operation + " has been cancelled."));
        }
    }

    private static final void startTransitions$lambda$9(SpecialEffectsController.Operation $lastIn, SpecialEffectsController.Operation $firstOut, boolean $isPop, ArrayMap $lastInViews) {
        Intrinsics.checkNotNullParameter((Object)$lastInViews, (String)"$lastInViews");
        FragmentTransition.callSharedElementStartEnd($lastIn.getFragment(), $firstOut.getFragment(), $isPop, (ArrayMap<String, View>)$lastInViews, false);
    }

    private static final void startTransitions$lambda$10(FragmentTransitionImpl $impl, View $lastInEpicenterView, Rect $lastInEpicenterRect) {
        Intrinsics.checkNotNullParameter((Object)$impl, (String)"$impl");
        Intrinsics.checkNotNullParameter((Object)$lastInEpicenterRect, (String)"$lastInEpicenterRect");
        $impl.getBoundsOnScreen($lastInEpicenterView, $lastInEpicenterRect);
    }

    private static final void startTransitions$lambda$11(ArrayList $transitioningViews) {
        Intrinsics.checkNotNullParameter((Object)$transitioningViews, (String)"$transitioningViews");
        FragmentTransition.setViewVisibility($transitioningViews, 4);
    }

    private static final void startTransitions$lambda$14$lambda$13(TransitionInfo $transitionInfo, SpecialEffectsController.Operation $operation) {
        Intrinsics.checkNotNullParameter((Object)$transitionInfo, (String)"$transitionInfo");
        Intrinsics.checkNotNullParameter((Object)$operation, (String)"$operation");
        $transitionInfo.completeSpecialEffect();
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)"FragmentManager", (String)("Transition for operation " + $operation + " has completed"));
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\r\u001a\u00020\u000eR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Landroidx/fragment/app/DefaultSpecialEffectsController$AnimationInfo;", "Landroidx/fragment/app/DefaultSpecialEffectsController$SpecialEffectsInfo;", "operation", "Landroidx/fragment/app/SpecialEffectsController$Operation;", "signal", "Landroidx/core/os/CancellationSignal;", "isPop", "", "(Landroidx/fragment/app/SpecialEffectsController$Operation;Landroidx/core/os/CancellationSignal;Z)V", "animation", "Landroidx/fragment/app/FragmentAnim$AnimationOrAnimator;", "isAnimLoaded", "getAnimation", "context", "Landroid/content/Context;", "fragment_release"})
    private static final class AnimationInfo
    extends SpecialEffectsInfo {
        private final boolean isPop;
        private boolean isAnimLoaded;
        @Nullable
        private FragmentAnim.AnimationOrAnimator animation;

        public AnimationInfo(@NotNull SpecialEffectsController.Operation operation, @NotNull CancellationSignal signal, boolean isPop) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)signal, (String)"signal");
            super(operation, signal);
            this.isPop = isPop;
        }

        @Nullable
        public final FragmentAnim.AnimationOrAnimator getAnimation(@NotNull Context context) {
            FragmentAnim.AnimationOrAnimator animationOrAnimator;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            if (this.isAnimLoaded) {
                animationOrAnimator = this.animation;
            } else {
                FragmentAnim.AnimationOrAnimator animationOrAnimator2;
                FragmentAnim.AnimationOrAnimator it = animationOrAnimator2 = FragmentAnim.loadAnimation(context, this.getOperation().getFragment(), this.getOperation().getFinalState() == SpecialEffectsController.Operation.State.VISIBLE, this.isPop);
                boolean bl = false;
                this.animation = it;
                this.isAnimLoaded = true;
                animationOrAnimator = animationOrAnimator2;
            }
            return animationOrAnimator;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\b\u0012\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0010"}, d2={"Landroidx/fragment/app/DefaultSpecialEffectsController$SpecialEffectsInfo;", "", "operation", "Landroidx/fragment/app/SpecialEffectsController$Operation;", "signal", "Landroidx/core/os/CancellationSignal;", "(Landroidx/fragment/app/SpecialEffectsController$Operation;Landroidx/core/os/CancellationSignal;)V", "isVisibilityUnchanged", "", "()Z", "getOperation", "()Landroidx/fragment/app/SpecialEffectsController$Operation;", "getSignal", "()Landroidx/core/os/CancellationSignal;", "completeSpecialEffect", "", "fragment_release"})
    private static class SpecialEffectsInfo {
        @NotNull
        private final SpecialEffectsController.Operation operation;
        @NotNull
        private final CancellationSignal signal;

        public SpecialEffectsInfo(@NotNull SpecialEffectsController.Operation operation, @NotNull CancellationSignal signal) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)signal, (String)"signal");
            this.operation = operation;
            this.signal = signal;
        }

        @NotNull
        public final SpecialEffectsController.Operation getOperation() {
            return this.operation;
        }

        @NotNull
        public final CancellationSignal getSignal() {
            return this.signal;
        }

        public final boolean isVisibilityUnchanged() {
            View view = this.operation.getFragment().mView;
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"operation.fragment.mView");
            SpecialEffectsController.Operation.State currentState = SpecialEffectsController.Operation.State.Companion.asOperationState(view);
            SpecialEffectsController.Operation.State finalState = this.operation.getFinalState();
            return currentState == finalState || currentState != SpecialEffectsController.Operation.State.VISIBLE && finalState != SpecialEffectsController.Operation.State.VISIBLE;
        }

        public final void completeSpecialEffect() {
            this.operation.completeSpecialEffect(this.signal);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\u0014\u0010\f\u001a\u0004\u0018\u00010\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0011H\u0002J\u0006\u0010\u0016\u001a\u00020\u0007R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u0017"}, d2={"Landroidx/fragment/app/DefaultSpecialEffectsController$TransitionInfo;", "Landroidx/fragment/app/DefaultSpecialEffectsController$SpecialEffectsInfo;", "operation", "Landroidx/fragment/app/SpecialEffectsController$Operation;", "signal", "Landroidx/core/os/CancellationSignal;", "isPop", "", "providesSharedElementTransition", "(Landroidx/fragment/app/SpecialEffectsController$Operation;Landroidx/core/os/CancellationSignal;ZZ)V", "handlingImpl", "Landroidx/fragment/app/FragmentTransitionImpl;", "getHandlingImpl", "()Landroidx/fragment/app/FragmentTransitionImpl;", "isOverlapAllowed", "()Z", "sharedElementTransition", "", "getSharedElementTransition", "()Ljava/lang/Object;", "transition", "getTransition", "hasSharedElementTransition", "fragment_release"})
    private static final class TransitionInfo
    extends SpecialEffectsInfo {
        @Nullable
        private final Object transition;
        private final boolean isOverlapAllowed;
        @Nullable
        private final Object sharedElementTransition;

        public TransitionInfo(@NotNull SpecialEffectsController.Operation operation, @NotNull CancellationSignal signal, boolean isPop, boolean providesSharedElementTransition) {
            Intrinsics.checkNotNullParameter((Object)operation, (String)"operation");
            Intrinsics.checkNotNullParameter((Object)signal, (String)"signal");
            super(operation, signal);
            Object object = operation.getFinalState() == SpecialEffectsController.Operation.State.VISIBLE ? (isPop ? operation.getFragment().getReenterTransition() : operation.getFragment().getEnterTransition()) : (this.transition = isPop ? operation.getFragment().getReturnTransition() : operation.getFragment().getExitTransition());
            boolean bl = operation.getFinalState() == SpecialEffectsController.Operation.State.VISIBLE ? (isPop ? operation.getFragment().getAllowReturnTransitionOverlap() : operation.getFragment().getAllowEnterTransitionOverlap()) : (this.isOverlapAllowed = true);
            this.sharedElementTransition = providesSharedElementTransition ? (isPop ? operation.getFragment().getSharedElementReturnTransition() : operation.getFragment().getSharedElementEnterTransition()) : null;
        }

        @Nullable
        public final Object getTransition() {
            return this.transition;
        }

        public final boolean isOverlapAllowed() {
            return this.isOverlapAllowed;
        }

        @Nullable
        public final Object getSharedElementTransition() {
            return this.sharedElementTransition;
        }

        public final boolean hasSharedElementTransition() {
            return this.sharedElementTransition != null;
        }

        @Nullable
        public final FragmentTransitionImpl getHandlingImpl() {
            FragmentTransitionImpl transitionImpl = this.getHandlingImpl(this.transition);
            FragmentTransitionImpl sharedElementTransitionImpl = this.getHandlingImpl(this.sharedElementTransition);
            if (!(transitionImpl == null || sharedElementTransitionImpl == null || transitionImpl == sharedElementTransitionImpl)) {
                boolean bl = false;
                String string = "Mixing framework transitions and AndroidX transitions is not allowed. Fragment " + this.getOperation().getFragment() + " returned Transition " + this.transition + " which uses a different Transition  type than its shared element transition " + this.sharedElementTransition;
                throw new IllegalArgumentException(string.toString());
            }
            FragmentTransitionImpl fragmentTransitionImpl = transitionImpl;
            if (fragmentTransitionImpl == null) {
                fragmentTransitionImpl = sharedElementTransitionImpl;
            }
            return fragmentTransitionImpl;
        }

        private final FragmentTransitionImpl getHandlingImpl(Object transition) {
            if (transition == null) {
                return null;
            }
            if (FragmentTransition.PLATFORM_IMPL != null && FragmentTransition.PLATFORM_IMPL.canHandle(transition)) {
                return FragmentTransition.PLATFORM_IMPL;
            }
            if (FragmentTransition.SUPPORT_IMPL != null && FragmentTransition.SUPPORT_IMPL.canHandle(transition)) {
                return FragmentTransition.SUPPORT_IMPL;
            }
            throw new IllegalArgumentException("Transition " + transition + " for fragment " + this.getOperation().getFragment() + " is not a valid framework Transition or AndroidX Transition");
        }
    }
}

