/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.app.Activity;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;
import android.util.SparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import androidx.fragment.R;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentContainer;
import androidx.fragment.app.FragmentContainerView;
import androidx.fragment.app.FragmentFactory;
import androidx.fragment.app.FragmentHostCallback;
import androidx.fragment.app.FragmentLifecycleCallbacksDispatcher;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentState;
import androidx.fragment.app.FragmentStore;
import androidx.fragment.app.SpecialEffectsController;
import androidx.fragment.app.strictmode.FragmentStrictMode;
import androidx.lifecycle.ViewModelStoreOwner;

class FragmentStateManager {
    private static final String TAG = "FragmentManager";
    static final String FRAGMENT_STATE_KEY = "state";
    static final String SAVED_INSTANCE_STATE_KEY = "savedInstanceState";
    static final String REGISTRY_STATE_KEY = "registryState";
    static final String CHILD_FRAGMENT_MANAGER_KEY = "childFragmentManager";
    static final String VIEW_STATE_KEY = "viewState";
    static final String VIEW_REGISTRY_STATE_KEY = "viewRegistryState";
    static final String ARGUMENTS_KEY = "arguments";
    private final FragmentLifecycleCallbacksDispatcher mDispatcher;
    private final FragmentStore mFragmentStore;
    @NonNull
    private final Fragment mFragment;
    private boolean mMovingToState = false;
    private int mFragmentManagerState = -1;

    FragmentStateManager(@NonNull FragmentLifecycleCallbacksDispatcher dispatcher, @NonNull FragmentStore fragmentStore, @NonNull Fragment fragment) {
        this.mDispatcher = dispatcher;
        this.mFragmentStore = fragmentStore;
        this.mFragment = fragment;
    }

    FragmentStateManager(@NonNull FragmentLifecycleCallbacksDispatcher dispatcher, @NonNull FragmentStore fragmentStore, @NonNull ClassLoader classLoader, @NonNull FragmentFactory fragmentFactory, @NonNull Bundle state) {
        this.mDispatcher = dispatcher;
        this.mFragmentStore = fragmentStore;
        FragmentState fs = (FragmentState)state.getParcelable(FRAGMENT_STATE_KEY);
        this.mFragment = fs.instantiate(fragmentFactory, classLoader);
        this.mFragment.mSavedFragmentState = state;
        Bundle arguments = state.getBundle(ARGUMENTS_KEY);
        if (arguments != null) {
            arguments.setClassLoader(classLoader);
        }
        this.mFragment.setArguments(arguments);
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("Instantiated fragment " + this.mFragment));
        }
    }

    FragmentStateManager(@NonNull FragmentLifecycleCallbacksDispatcher dispatcher, @NonNull FragmentStore fragmentStore, @NonNull Fragment retainedFragment, @NonNull Bundle state) {
        this.mDispatcher = dispatcher;
        this.mFragmentStore = fragmentStore;
        this.mFragment = retainedFragment;
        this.mFragment.mSavedViewState = null;
        this.mFragment.mSavedViewRegistryState = null;
        this.mFragment.mBackStackNesting = 0;
        this.mFragment.mInLayout = false;
        this.mFragment.mAdded = false;
        this.mFragment.mTargetWho = this.mFragment.mTarget != null ? this.mFragment.mTarget.mWho : null;
        this.mFragment.mTarget = null;
        this.mFragment.mSavedFragmentState = state;
        this.mFragment.mArguments = state.getBundle(ARGUMENTS_KEY);
    }

    @NonNull
    Fragment getFragment() {
        return this.mFragment;
    }

    void setFragmentManagerState(int state) {
        this.mFragmentManagerState = state;
    }

    int computeExpectedState() {
        if (this.mFragment.mFragmentManager == null) {
            return this.mFragment.mState;
        }
        int maxState = this.mFragmentManagerState;
        switch (this.mFragment.mMaxState) {
            case RESUMED: {
                break;
            }
            case STARTED: {
                maxState = Math.min(maxState, 5);
                break;
            }
            case CREATED: {
                maxState = Math.min(maxState, 1);
                break;
            }
            case INITIALIZED: {
                maxState = Math.min(maxState, 0);
                break;
            }
            default: {
                maxState = Math.min(maxState, -1);
            }
        }
        if (this.mFragment.mFromLayout) {
            if (this.mFragment.mInLayout) {
                maxState = Math.max(this.mFragmentManagerState, 2);
                if (this.mFragment.mView != null && this.mFragment.mView.getParent() == null) {
                    maxState = Math.min(maxState, 2);
                }
            } else {
                maxState = this.mFragmentManagerState < 4 ? Math.min(maxState, this.mFragment.mState) : Math.min(maxState, 1);
            }
        }
        if (!this.mFragment.mAdded) {
            maxState = Math.min(maxState, 1);
        }
        SpecialEffectsController.Operation.LifecycleImpact awaitingEffect = null;
        if (this.mFragment.mContainer != null) {
            SpecialEffectsController controller = SpecialEffectsController.getOrCreateController(this.mFragment.mContainer, this.mFragment.getParentFragmentManager());
            awaitingEffect = controller.getAwaitingCompletionLifecycleImpact(this);
        }
        if (awaitingEffect == SpecialEffectsController.Operation.LifecycleImpact.ADDING) {
            maxState = Math.min(maxState, 6);
        } else if (awaitingEffect == SpecialEffectsController.Operation.LifecycleImpact.REMOVING) {
            maxState = Math.max(maxState, 3);
        } else if (this.mFragment.mRemoving) {
            maxState = this.mFragment.isInBackStack() ? Math.min(maxState, 1) : Math.min(maxState, -1);
        }
        if (this.mFragment.mDeferStart && this.mFragment.mState < 5) {
            maxState = Math.min(maxState, 4);
        }
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("computeExpectedState() of " + maxState + " for " + this.mFragment));
        }
        return maxState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void moveToExpectedState() {
        if (this.mMovingToState) {
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)TAG, (String)("Ignoring re-entrant call to moveToExpectedState() for " + this.getFragment()));
            }
            return;
        }
        try {
            int newState;
            this.mMovingToState = true;
            boolean stateWasChanged = false;
            while ((newState = this.computeExpectedState()) != this.mFragment.mState) {
                SpecialEffectsController controller;
                int nextStep;
                stateWasChanged = true;
                if (newState > this.mFragment.mState) {
                    nextStep = this.mFragment.mState + 1;
                    switch (nextStep) {
                        case 0: {
                            this.attach();
                            break;
                        }
                        case 1: {
                            this.create();
                            break;
                        }
                        case 2: {
                            this.ensureInflatedView();
                            this.createView();
                            break;
                        }
                        case 3: {
                            this.activityCreated();
                            break;
                        }
                        case 4: {
                            if (this.mFragment.mView != null && this.mFragment.mContainer != null) {
                                controller = SpecialEffectsController.getOrCreateController(this.mFragment.mContainer, this.mFragment.getParentFragmentManager());
                                int visibility = this.mFragment.mView.getVisibility();
                                SpecialEffectsController.Operation.State finalState = SpecialEffectsController.Operation.State.from(visibility);
                                controller.enqueueAdd(finalState, this);
                            }
                            this.mFragment.mState = 4;
                            break;
                        }
                        case 5: {
                            this.start();
                            break;
                        }
                        case 6: {
                            this.mFragment.mState = 6;
                            break;
                        }
                        case 7: {
                            this.resume();
                        }
                    }
                    continue;
                }
                nextStep = this.mFragment.mState - 1;
                switch (nextStep) {
                    case 6: {
                        this.pause();
                        break;
                    }
                    case 5: {
                        this.mFragment.mState = 5;
                        break;
                    }
                    case 4: {
                        this.stop();
                        break;
                    }
                    case 3: {
                        if (FragmentManager.isLoggingEnabled(3)) {
                            Log.d((String)TAG, (String)("movefrom ACTIVITY_CREATED: " + this.mFragment));
                        }
                        if (this.mFragment.mBeingSaved) {
                            this.mFragmentStore.setSavedState(this.mFragment.mWho, this.saveState());
                        } else if (this.mFragment.mView != null && this.mFragment.mSavedViewState == null) {
                            this.saveViewState();
                        }
                        if (this.mFragment.mView != null && this.mFragment.mContainer != null) {
                            controller = SpecialEffectsController.getOrCreateController(this.mFragment.mContainer, this.mFragment.getParentFragmentManager());
                            controller.enqueueRemove(this);
                        }
                        this.mFragment.mState = 3;
                        break;
                    }
                    case 2: {
                        this.mFragment.mInLayout = false;
                        this.mFragment.mState = 2;
                        break;
                    }
                    case 1: {
                        this.destroyFragmentView();
                        this.mFragment.mState = 1;
                        break;
                    }
                    case 0: {
                        if (this.mFragment.mBeingSaved && this.mFragmentStore.getSavedState(this.mFragment.mWho) == null) {
                            this.mFragmentStore.setSavedState(this.mFragment.mWho, this.saveState());
                        }
                        this.destroy();
                        break;
                    }
                    case -1: {
                        this.detach();
                    }
                }
            }
            if (!stateWasChanged && this.mFragment.mState == -1 && this.mFragment.mRemoving && !this.mFragment.isInBackStack() && !this.mFragment.mBeingSaved) {
                if (FragmentManager.isLoggingEnabled(3)) {
                    Log.d((String)TAG, (String)("Cleaning up state of never attached fragment: " + this.mFragment));
                }
                this.mFragmentStore.getNonConfig().clearNonConfigState(this.mFragment, true);
                this.mFragmentStore.makeInactive(this);
                if (FragmentManager.isLoggingEnabled(3)) {
                    Log.d((String)TAG, (String)("initState called for fragment: " + this.mFragment));
                }
                this.mFragment.initState();
            }
            if (this.mFragment.mHiddenChanged) {
                if (this.mFragment.mView != null && this.mFragment.mContainer != null) {
                    SpecialEffectsController controller = SpecialEffectsController.getOrCreateController(this.mFragment.mContainer, this.mFragment.getParentFragmentManager());
                    if (this.mFragment.mHidden) {
                        controller.enqueueHide(this);
                    } else {
                        controller.enqueueShow(this);
                    }
                }
                if (this.mFragment.mFragmentManager != null) {
                    this.mFragment.mFragmentManager.invalidateMenuForFragment(this.mFragment);
                }
                this.mFragment.mHiddenChanged = false;
                this.mFragment.onHiddenChanged(this.mFragment.mHidden);
                this.mFragment.mChildFragmentManager.dispatchOnHiddenChanged();
            }
        }
        finally {
            this.mMovingToState = false;
        }
    }

    void ensureInflatedView() {
        if (this.mFragment.mFromLayout && this.mFragment.mInLayout && !this.mFragment.mPerformedCreateView) {
            if (FragmentManager.isLoggingEnabled(3)) {
                Log.d((String)TAG, (String)("moveto CREATE_VIEW: " + this.mFragment));
            }
            Bundle savedInstanceState = null;
            if (this.mFragment.mSavedFragmentState != null) {
                savedInstanceState = this.mFragment.mSavedFragmentState.getBundle(SAVED_INSTANCE_STATE_KEY);
            }
            this.mFragment.performCreateView(this.mFragment.performGetLayoutInflater(savedInstanceState), null, savedInstanceState);
            if (this.mFragment.mView != null) {
                this.mFragment.mView.setSaveFromParentEnabled(false);
                this.mFragment.mView.setTag(R.id.fragment_container_view_tag, (Object)this.mFragment);
                if (this.mFragment.mHidden) {
                    this.mFragment.mView.setVisibility(8);
                }
                this.mFragment.performViewCreated();
                this.mDispatcher.dispatchOnFragmentViewCreated(this.mFragment, this.mFragment.mView, savedInstanceState, false);
                this.mFragment.mState = 2;
            }
        }
    }

    void restoreState(@NonNull ClassLoader classLoader) {
        if (this.mFragment.mSavedFragmentState == null) {
            return;
        }
        this.mFragment.mSavedFragmentState.setClassLoader(classLoader);
        Bundle savedInstanceState = this.mFragment.mSavedFragmentState.getBundle(SAVED_INSTANCE_STATE_KEY);
        if (savedInstanceState == null) {
            this.mFragment.mSavedFragmentState.putBundle(SAVED_INSTANCE_STATE_KEY, new Bundle());
        }
        this.mFragment.mSavedViewState = this.mFragment.mSavedFragmentState.getSparseParcelableArray(VIEW_STATE_KEY);
        this.mFragment.mSavedViewRegistryState = this.mFragment.mSavedFragmentState.getBundle(VIEW_REGISTRY_STATE_KEY);
        FragmentState fs = (FragmentState)this.mFragment.mSavedFragmentState.getParcelable(FRAGMENT_STATE_KEY);
        if (fs != null) {
            this.mFragment.mTargetWho = fs.mTargetWho;
            this.mFragment.mTargetRequestCode = fs.mTargetRequestCode;
            if (this.mFragment.mSavedUserVisibleHint != null) {
                this.mFragment.mUserVisibleHint = this.mFragment.mSavedUserVisibleHint;
                this.mFragment.mSavedUserVisibleHint = null;
            } else {
                this.mFragment.mUserVisibleHint = fs.mUserVisibleHint;
            }
        }
        if (!this.mFragment.mUserVisibleHint) {
            this.mFragment.mDeferStart = true;
        }
    }

    void attach() {
        FragmentStateManager targetFragmentStateManager;
        if (FragmentManager.isLoggingEnabled(3)) {
            Log.d((String)TAG, (String)("moveto ATTACHED: " + this.mFragment));
        }
        if (this.mFragment.mTarget != null) {
            targetFragmentStateManager = this.mFragmentStore.getFragmentStateManager(this.mFragment.mTarget.mWho);
            if (targetFragmentStateManager == null) {
                throw new IllegalStateException("Fragment " + this.mFragment + " declared target fragment " + this.mFragment.mTarget + " that does not belong to this FragmentManager!");
            }
            this.mFragment.mTargetWho = this.mFragment.mTarget.mWho;
            this.mFragment.mTarget = null;
        } else if (this.mFragment.mTargetWho != null) {
            targetFragmentStateManager = this.mFragmentStore.getFragmentStateManager(this.mFragment.mTargetWho);
            if (targetFragmentStateManager == null) {
                throw new IllegalStateException("Fragment " + this.mFragment + " declared target fragment " + this.mFragment.mTargetWho + " that does not belong to this FragmentManager!");
            }
        } else {
            targetFragmentStateManager = null;
        }
        if (targetFragmentStateManager != null) {
            targetFragmentStateManager.moveToExpectedState();
        }
        this.mFragment.mHost = this.mFragment.mFragmentManager.getHost();
        this.mFragment.mParentFragment = this.mFragment.mFragmentManager.getParent();
        this.mDispatcher.dispatchOnFragmentPreAttached(this.mFragment, false);
        this.mFragment.performAttach();
        this.mDispatcher.dispatchOnFragmentAttached(this.mFragment, false);
    }

    void create() {
        if (FragmentManager.isLoggingEnabled(3)) {
            Log.d((String)TAG, (String)("moveto CREATED: " + this.mFragment));
        }
        Bundle savedInstanceState = null;
        if (this.mFragment.mSavedFragmentState != null) {
            savedInstanceState = this.mFragment.mSavedFragmentState.getBundle(SAVED_INSTANCE_STATE_KEY);
        }
        if (!this.mFragment.mIsCreated) {
            this.mDispatcher.dispatchOnFragmentPreCreated(this.mFragment, savedInstanceState, false);
            this.mFragment.performCreate(savedInstanceState);
            this.mDispatcher.dispatchOnFragmentCreated(this.mFragment, savedInstanceState, false);
        } else {
            this.mFragment.mState = 1;
            this.mFragment.restoreChildFragmentState();
        }
    }

    void createView() {
        if (this.mFragment.mFromLayout) {
            return;
        }
        if (FragmentManager.isLoggingEnabled(3)) {
            Log.d((String)TAG, (String)("moveto CREATE_VIEW: " + this.mFragment));
        }
        Bundle savedInstanceState = null;
        if (this.mFragment.mSavedFragmentState != null) {
            savedInstanceState = this.mFragment.mSavedFragmentState.getBundle(SAVED_INSTANCE_STATE_KEY);
        }
        LayoutInflater layoutInflater = this.mFragment.performGetLayoutInflater(savedInstanceState);
        ViewGroup container = null;
        if (this.mFragment.mContainer != null) {
            container = this.mFragment.mContainer;
        } else if (this.mFragment.mContainerId != 0) {
            if (this.mFragment.mContainerId == -1) {
                throw new IllegalArgumentException("Cannot create fragment " + this.mFragment + " for a container view with no id");
            }
            FragmentContainer fragmentContainer = this.mFragment.mFragmentManager.getContainer();
            container = (ViewGroup)fragmentContainer.onFindViewById(this.mFragment.mContainerId);
            if (container == null) {
                if (!this.mFragment.mRestored) {
                    String resName;
                    try {
                        resName = this.mFragment.getResources().getResourceName(this.mFragment.mContainerId);
                    }
                    catch (Resources.NotFoundException e) {
                        resName = "unknown";
                    }
                    throw new IllegalArgumentException("No view found for id 0x" + Integer.toHexString(this.mFragment.mContainerId) + " (" + resName + ") for fragment " + this.mFragment);
                }
            } else if (!(container instanceof FragmentContainerView)) {
                FragmentStrictMode.onWrongFragmentContainer(this.mFragment, container);
            }
        }
        this.mFragment.mContainer = container;
        this.mFragment.performCreateView(layoutInflater, container, savedInstanceState);
        if (this.mFragment.mView != null) {
            if (FragmentManager.isLoggingEnabled(3)) {
                Log.d((String)TAG, (String)("moveto VIEW_CREATED: " + this.mFragment));
            }
            this.mFragment.mView.setSaveFromParentEnabled(false);
            this.mFragment.mView.setTag(R.id.fragment_container_view_tag, (Object)this.mFragment);
            if (container != null) {
                this.addViewToContainer();
            }
            if (this.mFragment.mHidden) {
                this.mFragment.mView.setVisibility(8);
            }
            if (ViewCompat.isAttachedToWindow((View)this.mFragment.mView)) {
                ViewCompat.requestApplyInsets((View)this.mFragment.mView);
            } else {
                final View fragmentView = this.mFragment.mView;
                fragmentView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                    public void onViewAttachedToWindow(View v) {
                        fragmentView.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                        ViewCompat.requestApplyInsets((View)fragmentView);
                    }

                    public void onViewDetachedFromWindow(View v) {
                    }
                });
            }
            this.mFragment.performViewCreated();
            this.mDispatcher.dispatchOnFragmentViewCreated(this.mFragment, this.mFragment.mView, savedInstanceState, false);
            int postOnViewCreatedVisibility = this.mFragment.mView.getVisibility();
            float postOnViewCreatedAlpha = this.mFragment.mView.getAlpha();
            this.mFragment.setPostOnViewCreatedAlpha(postOnViewCreatedAlpha);
            if (this.mFragment.mContainer != null && postOnViewCreatedVisibility == 0) {
                View focusedView = this.mFragment.mView.findFocus();
                if (focusedView != null) {
                    this.mFragment.setFocusedView(focusedView);
                    if (FragmentManager.isLoggingEnabled(2)) {
                        Log.v((String)TAG, (String)("requestFocus: Saved focused view " + focusedView + " for Fragment " + this.mFragment));
                    }
                }
                this.mFragment.mView.setAlpha(0.0f);
            }
        }
        this.mFragment.mState = 2;
    }

    void activityCreated() {
        if (FragmentManager.isLoggingEnabled(3)) {
            Log.d((String)TAG, (String)("moveto ACTIVITY_CREATED: " + this.mFragment));
        }
        Bundle savedInstanceState = null;
        if (this.mFragment.mSavedFragmentState != null) {
            savedInstanceState = this.mFragment.mSavedFragmentState.getBundle(SAVED_INSTANCE_STATE_KEY);
        }
        this.mFragment.performActivityCreated(savedInstanceState);
        this.mDispatcher.dispatchOnFragmentActivityCreated(this.mFragment, savedInstanceState, false);
    }

    void start() {
        if (FragmentManager.isLoggingEnabled(3)) {
            Log.d((String)TAG, (String)("moveto STARTED: " + this.mFragment));
        }
        this.mFragment.performStart();
        this.mDispatcher.dispatchOnFragmentStarted(this.mFragment, false);
    }

    void resume() {
        View focusedView;
        if (FragmentManager.isLoggingEnabled(3)) {
            Log.d((String)TAG, (String)("moveto RESUMED: " + this.mFragment));
        }
        if ((focusedView = this.mFragment.getFocusedView()) != null && this.isFragmentViewChild(focusedView)) {
            boolean success = focusedView.requestFocus();
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)TAG, (String)("requestFocus: Restoring focused view " + focusedView + " " + (success ? "succeeded" : "failed") + " on Fragment " + this.mFragment + " resulting in focused view " + this.mFragment.mView.findFocus()));
            }
        }
        this.mFragment.setFocusedView(null);
        this.mFragment.performResume();
        this.mDispatcher.dispatchOnFragmentResumed(this.mFragment, false);
        this.mFragmentStore.setSavedState(this.mFragment.mWho, null);
        this.mFragment.mSavedFragmentState = null;
        this.mFragment.mSavedViewState = null;
        this.mFragment.mSavedViewRegistryState = null;
    }

    private boolean isFragmentViewChild(@NonNull View view) {
        if (view == this.mFragment.mView) {
            return true;
        }
        for (ViewParent parent = view.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != this.mFragment.mView) continue;
            return true;
        }
        return false;
    }

    void pause() {
        if (FragmentManager.isLoggingEnabled(3)) {
            Log.d((String)TAG, (String)("movefrom RESUMED: " + this.mFragment));
        }
        this.mFragment.performPause();
        this.mDispatcher.dispatchOnFragmentPaused(this.mFragment, false);
    }

    void stop() {
        if (FragmentManager.isLoggingEnabled(3)) {
            Log.d((String)TAG, (String)("movefrom STARTED: " + this.mFragment));
        }
        this.mFragment.performStop();
        this.mDispatcher.dispatchOnFragmentStopped(this.mFragment, false);
    }

    @NonNull
    Bundle saveState() {
        Bundle stateBundle = new Bundle();
        if (this.mFragment.mState == -1 && this.mFragment.mSavedFragmentState != null) {
            stateBundle.putAll(this.mFragment.mSavedFragmentState);
        }
        FragmentState fs = new FragmentState(this.mFragment);
        stateBundle.putParcelable(FRAGMENT_STATE_KEY, (Parcelable)fs);
        if (this.mFragment.mState > -1) {
            Bundle childFragmentManagerState;
            Bundle savedInstanceState = new Bundle();
            this.mFragment.performSaveInstanceState(savedInstanceState);
            if (!savedInstanceState.isEmpty()) {
                stateBundle.putBundle(SAVED_INSTANCE_STATE_KEY, savedInstanceState);
            }
            this.mDispatcher.dispatchOnFragmentSaveInstanceState(this.mFragment, savedInstanceState, false);
            Bundle savedStateRegistryState = new Bundle();
            this.mFragment.mSavedStateRegistryController.performSave(savedStateRegistryState);
            if (!savedStateRegistryState.isEmpty()) {
                stateBundle.putBundle(REGISTRY_STATE_KEY, savedStateRegistryState);
            }
            if (!(childFragmentManagerState = this.mFragment.mChildFragmentManager.saveAllStateInternal()).isEmpty()) {
                stateBundle.putBundle(CHILD_FRAGMENT_MANAGER_KEY, childFragmentManagerState);
            }
            if (this.mFragment.mView != null) {
                this.saveViewState();
            }
            if (this.mFragment.mSavedViewState != null) {
                stateBundle.putSparseParcelableArray(VIEW_STATE_KEY, this.mFragment.mSavedViewState);
            }
            if (this.mFragment.mSavedViewRegistryState != null) {
                stateBundle.putBundle(VIEW_REGISTRY_STATE_KEY, this.mFragment.mSavedViewRegistryState);
            }
        }
        if (this.mFragment.mArguments != null) {
            stateBundle.putBundle(ARGUMENTS_KEY, this.mFragment.mArguments);
        }
        return stateBundle;
    }

    @Nullable
    Fragment.SavedState saveInstanceState() {
        if (this.mFragment.mState > -1) {
            return new Fragment.SavedState(this.saveState());
        }
        return null;
    }

    void saveViewState() {
        if (this.mFragment.mView == null) {
            return;
        }
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)TAG, (String)("Saving view state for fragment " + this.mFragment + " with view " + this.mFragment.mView));
        }
        SparseArray mStateArray = new SparseArray();
        this.mFragment.mView.saveHierarchyState(mStateArray);
        if (mStateArray.size() > 0) {
            this.mFragment.mSavedViewState = mStateArray;
        }
        Bundle outBundle = new Bundle();
        this.mFragment.mViewLifecycleOwner.performSave(outBundle);
        if (!outBundle.isEmpty()) {
            this.mFragment.mSavedViewRegistryState = outBundle;
        }
    }

    void destroyFragmentView() {
        if (FragmentManager.isLoggingEnabled(3)) {
            Log.d((String)TAG, (String)("movefrom CREATE_VIEW: " + this.mFragment));
        }
        if (this.mFragment.mContainer != null && this.mFragment.mView != null) {
            this.mFragment.mContainer.removeView(this.mFragment.mView);
        }
        this.mFragment.performDestroyView();
        this.mDispatcher.dispatchOnFragmentViewDestroyed(this.mFragment, false);
        this.mFragment.mContainer = null;
        this.mFragment.mView = null;
        this.mFragment.mViewLifecycleOwner = null;
        this.mFragment.mViewLifecycleOwnerLiveData.setValue(null);
        this.mFragment.mInLayout = false;
    }

    void destroy() {
        boolean shouldDestroy;
        boolean beingRemoved;
        if (FragmentManager.isLoggingEnabled(3)) {
            Log.d((String)TAG, (String)("movefrom CREATED: " + this.mFragment));
        }
        boolean bl = beingRemoved = this.mFragment.mRemoving && !this.mFragment.isInBackStack();
        if (beingRemoved && !this.mFragment.mBeingSaved) {
            this.mFragmentStore.setSavedState(this.mFragment.mWho, null);
        }
        boolean bl2 = shouldDestroy = beingRemoved || this.mFragmentStore.getNonConfig().shouldDestroy(this.mFragment);
        if (shouldDestroy) {
            Activity activity;
            FragmentHostCallback<?> host = this.mFragment.mHost;
            boolean shouldClear = host instanceof ViewModelStoreOwner ? this.mFragmentStore.getNonConfig().isCleared() : (host.getContext() instanceof Activity ? !(activity = (Activity)host.getContext()).isChangingConfigurations() : true);
            if (beingRemoved && !this.mFragment.mBeingSaved || shouldClear) {
                this.mFragmentStore.getNonConfig().clearNonConfigState(this.mFragment, false);
            }
            this.mFragment.performDestroy();
            this.mDispatcher.dispatchOnFragmentDestroyed(this.mFragment, false);
            for (FragmentStateManager fragmentStateManager : this.mFragmentStore.getActiveFragmentStateManagers()) {
                if (fragmentStateManager == null) continue;
                Fragment fragment = fragmentStateManager.getFragment();
                if (!this.mFragment.mWho.equals(fragment.mTargetWho)) continue;
                fragment.mTarget = this.mFragment;
                fragment.mTargetWho = null;
            }
            if (this.mFragment.mTargetWho != null) {
                this.mFragment.mTarget = this.mFragmentStore.findActiveFragment(this.mFragment.mTargetWho);
            }
            this.mFragmentStore.makeInactive(this);
        } else {
            Fragment target;
            if (this.mFragment.mTargetWho != null && (target = this.mFragmentStore.findActiveFragment(this.mFragment.mTargetWho)) != null && target.mRetainInstance) {
                this.mFragment.mTarget = target;
            }
            this.mFragment.mState = 0;
        }
    }

    void detach() {
        boolean beingRemoved;
        if (FragmentManager.isLoggingEnabled(3)) {
            Log.d((String)TAG, (String)("movefrom ATTACHED: " + this.mFragment));
        }
        this.mFragment.performDetach();
        this.mDispatcher.dispatchOnFragmentDetached(this.mFragment, false);
        this.mFragment.mState = -1;
        this.mFragment.mHost = null;
        this.mFragment.mParentFragment = null;
        this.mFragment.mFragmentManager = null;
        boolean bl = beingRemoved = this.mFragment.mRemoving && !this.mFragment.isInBackStack();
        if (beingRemoved || this.mFragmentStore.getNonConfig().shouldDestroy(this.mFragment)) {
            if (FragmentManager.isLoggingEnabled(3)) {
                Log.d((String)TAG, (String)("initState called for fragment: " + this.mFragment));
            }
            this.mFragment.initState();
        }
    }

    void addViewToContainer() {
        Fragment expectedParent = FragmentManager.findViewFragment((View)this.mFragment.mContainer);
        Fragment actualParent = this.mFragment.getParentFragment();
        if (expectedParent != null && !expectedParent.equals(actualParent)) {
            FragmentStrictMode.onWrongNestedHierarchy(this.mFragment, expectedParent, this.mFragment.mContainerId);
        }
        int index = this.mFragmentStore.findFragmentIndexInContainer(this.mFragment);
        this.mFragment.mContainer.addView(this.mFragment.mView, index);
    }
}

