/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import androidx.annotation.CallSuper;
import androidx.core.os.CancellationSignal;
import androidx.core.view.ViewCompat;
import androidx.fragment.R;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentManager;
import androidx.fragment.app.FragmentStateManager;
import androidx.fragment.app.SpecialEffectsControllerFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u000b\b \u0018\u0000 *2\u00020\u0001:\u0003*+,B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015J#\u0010\u001a\u001a\u00020\u000f2\u0011\u0010\u001b\u001a\r\u0012\t\u0012\u00070\f\u00a2\u0006\u0002\b\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\bH&J\u0006\u0010\u001f\u001a\u00020\u000fJ\u0012\u0010 \u001a\u0004\u0018\u00010\f2\u0006\u0010!\u001a\u00020\"H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\f2\u0006\u0010!\u001a\u00020\"H\u0002J\u0006\u0010$\u001a\u00020\u000fJ\u0006\u0010%\u001a\u00020\u000fJ\u0010\u0010&\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010'\u001a\u00020\u000fJ\b\u0010(\u001a\u00020\u000fH\u0002J\u000e\u0010)\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Landroidx/fragment/app/SpecialEffectsController;", "", "container", "Landroid/view/ViewGroup;", "(Landroid/view/ViewGroup;)V", "getContainer", "()Landroid/view/ViewGroup;", "isContainerPostponed", "", "operationDirectionIsPop", "pendingOperations", "", "Landroidx/fragment/app/SpecialEffectsController$Operation;", "runningOperations", "enqueue", "", "finalState", "Landroidx/fragment/app/SpecialEffectsController$Operation$State;", "lifecycleImpact", "Landroidx/fragment/app/SpecialEffectsController$Operation$LifecycleImpact;", "fragmentStateManager", "Landroidx/fragment/app/FragmentStateManager;", "enqueueAdd", "enqueueHide", "enqueueRemove", "enqueueShow", "executeOperations", "operations", "", "Lkotlin/jvm/JvmSuppressWildcards;", "isPop", "executePendingOperations", "findPendingOperation", "fragment", "Landroidx/fragment/app/Fragment;", "findRunningOperation", "forceCompleteAllOperations", "forcePostponedExecutePendingOperations", "getAwaitingCompletionLifecycleImpact", "markPostponedState", "updateFinalState", "updateOperationDirection", "Companion", "FragmentStateManagerOperation", "Operation", "fragment_release"})
@SourceDebugExtension(value={"SMAP\nSpecialEffectsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecialEffectsController.kt\nandroidx/fragment/app/SpecialEffectsController\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,710:1\n288#2,2:711\n288#2,2:713\n533#2,6:715\n*S KotlinDebug\n*F\n+ 1 SpecialEffectsController.kt\nandroidx/fragment/app/SpecialEffectsController\n*L\n69#1:711,2\n75#1:713,2\n166#1:715,6\n*E\n"})
public abstract class SpecialEffectsController {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ViewGroup container;
    @NotNull
    private final List<Operation> pendingOperations;
    @NotNull
    private final List<Operation> runningOperations;
    private boolean operationDirectionIsPop;
    private boolean isContainerPostponed;

    public SpecialEffectsController(@NotNull ViewGroup container) {
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        this.container = container;
        this.pendingOperations = new ArrayList();
        this.runningOperations = new ArrayList();
    }

    @NotNull
    public final ViewGroup getContainer() {
        return this.container;
    }

    @Nullable
    public final Operation.LifecycleImpact getAwaitingCompletionLifecycleImpact(@NotNull FragmentStateManager fragmentStateManager) {
        Operation.LifecycleImpact lifecycleImpact;
        Intrinsics.checkNotNullParameter((Object)fragmentStateManager, (String)"fragmentStateManager");
        Fragment fragment = fragmentStateManager.getFragment();
        Intrinsics.checkNotNullExpressionValue((Object)fragment, (String)"fragmentStateManager.fragment");
        Fragment fragment2 = fragment;
        Operation operation = this.findPendingOperation(fragment2);
        Operation.LifecycleImpact pendingLifecycleImpact = operation != null ? operation.getLifecycleImpact() : null;
        Operation operation2 = this.findRunningOperation(fragment2);
        Operation.LifecycleImpact runningLifecycleImpact = operation2 != null ? operation2.getLifecycleImpact() : null;
        Operation.LifecycleImpact lifecycleImpact2 = pendingLifecycleImpact;
        switch (lifecycleImpact2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[lifecycleImpact2.ordinal()]) {
            case -1: {
                lifecycleImpact = runningLifecycleImpact;
                break;
            }
            case 1: {
                lifecycleImpact = runningLifecycleImpact;
                break;
            }
            default: {
                lifecycleImpact = pendingLifecycleImpact;
            }
        }
        return lifecycleImpact;
    }

    private final Operation findPendingOperation(Fragment fragment) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.pendingOperations;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Operation operation = (Operation)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)operation.getFragment(), (Object)fragment) && !operation.isCanceled())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    private final Operation findRunningOperation(Fragment fragment) {
        Object v0;
        block1: {
            Iterable $this$firstOrNull$iv = this.runningOperations;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Operation operation = (Operation)element$iv;
                boolean bl = false;
                if (!(Intrinsics.areEqual((Object)operation.getFragment(), (Object)fragment) && !operation.isCanceled())) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final void enqueueAdd(@NotNull Operation.State finalState, @NotNull FragmentStateManager fragmentStateManager) {
        Intrinsics.checkNotNullParameter((Object)((Object)finalState), (String)"finalState");
        Intrinsics.checkNotNullParameter((Object)fragmentStateManager, (String)"fragmentStateManager");
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Enqueuing add operation for fragment " + fragmentStateManager.getFragment()));
        }
        this.enqueue(finalState, Operation.LifecycleImpact.ADDING, fragmentStateManager);
    }

    public final void enqueueShow(@NotNull FragmentStateManager fragmentStateManager) {
        Intrinsics.checkNotNullParameter((Object)fragmentStateManager, (String)"fragmentStateManager");
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Enqueuing show operation for fragment " + fragmentStateManager.getFragment()));
        }
        this.enqueue(Operation.State.VISIBLE, Operation.LifecycleImpact.NONE, fragmentStateManager);
    }

    public final void enqueueHide(@NotNull FragmentStateManager fragmentStateManager) {
        Intrinsics.checkNotNullParameter((Object)fragmentStateManager, (String)"fragmentStateManager");
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Enqueuing hide operation for fragment " + fragmentStateManager.getFragment()));
        }
        this.enqueue(Operation.State.GONE, Operation.LifecycleImpact.NONE, fragmentStateManager);
    }

    public final void enqueueRemove(@NotNull FragmentStateManager fragmentStateManager) {
        Intrinsics.checkNotNullParameter((Object)fragmentStateManager, (String)"fragmentStateManager");
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Enqueuing remove operation for fragment " + fragmentStateManager.getFragment()));
        }
        this.enqueue(Operation.State.REMOVED, Operation.LifecycleImpact.REMOVING, fragmentStateManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void enqueue(Operation.State finalState, Operation.LifecycleImpact lifecycleImpact, FragmentStateManager fragmentStateManager) {
        List<Operation> list = this.pendingOperations;
        synchronized (list) {
            boolean bl = false;
            CancellationSignal signal = new CancellationSignal();
            Fragment fragment = fragmentStateManager.getFragment();
            Intrinsics.checkNotNullExpressionValue((Object)fragment, (String)"fragmentStateManager.fragment");
            Operation existingOperation = this.findPendingOperation(fragment);
            if (existingOperation != null) {
                existingOperation.mergeWith(finalState, lifecycleImpact);
                return;
            }
            FragmentStateManagerOperation operation = new FragmentStateManagerOperation(finalState, lifecycleImpact, fragmentStateManager, signal);
            this.pendingOperations.add(operation);
            operation.addCompletionListener(() -> SpecialEffectsController.enqueue$lambda$4$lambda$2(this, operation));
            operation.addCompletionListener(() -> SpecialEffectsController.enqueue$lambda$4$lambda$3(this, operation));
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void updateOperationDirection(boolean isPop) {
        this.operationDirectionIsPop = isPop;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void markPostponedState() {
        List<Operation> list = this.pendingOperations;
        synchronized (list) {
            Fragment lastEnteringFragment;
            Operation operation;
            block4: {
                boolean bl = false;
                this.updateFinalState();
                List<Operation> $this$lastOrNull$iv = this.pendingOperations;
                boolean $i$f$lastOrNull = false;
                ListIterator<Operation> iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
                while (iterator$iv.hasPrevious()) {
                    Operation element$iv;
                    Operation operation2 = element$iv = iterator$iv.previous();
                    boolean bl2 = false;
                    View view = operation2.getFragment().mView;
                    Intrinsics.checkNotNullExpressionValue((Object)view, (String)"operation.fragment.mView");
                    Operation.State currentState = Operation.State.Companion.asOperationState(view);
                    boolean bl3 = operation2.getFinalState() == Operation.State.VISIBLE && currentState != Operation.State.VISIBLE;
                    if (!bl3) continue;
                    operation = element$iv;
                    break block4;
                }
                operation = null;
            }
            Operation operation3 = operation;
            Fragment fragment = lastEnteringFragment = operation3 != null ? operation3.getFragment() : null;
            this.isContainerPostponed = fragment != null ? fragment.isPostponed() : false;
            Unit unit = Unit.INSTANCE;
        }
    }

    public final void forcePostponedExecutePendingOperations() {
        if (this.isContainerPostponed) {
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)"FragmentManager", (String)"SpecialEffectsController: Forcing postponed operations");
            }
            this.isContainerPostponed = false;
            this.executePendingOperations();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void executePendingOperations() {
        if (this.isContainerPostponed) {
            return;
        }
        if (!ViewCompat.isAttachedToWindow((View)((View)this.container))) {
            this.forceCompleteAllOperations();
            this.operationDirectionIsPop = false;
            return;
        }
        List<Operation> list = this.pendingOperations;
        synchronized (list) {
            boolean bl = false;
            if (!((Collection)this.pendingOperations).isEmpty()) {
                List currentlyRunningOperations = CollectionsKt.toMutableList((Collection)this.runningOperations);
                this.runningOperations.clear();
                for (Operation operation : currentlyRunningOperations) {
                    if (FragmentManager.isLoggingEnabled(2)) {
                        Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Cancelling operation " + operation));
                    }
                    operation.cancel();
                    if (operation.isComplete()) continue;
                    this.runningOperations.add(operation);
                }
                this.updateFinalState();
                List newPendingOperations = CollectionsKt.toMutableList((Collection)this.pendingOperations);
                this.pendingOperations.clear();
                this.runningOperations.addAll(newPendingOperations);
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)"SpecialEffectsController: Executing pending operations");
                }
                for (Operation operation : newPendingOperations) {
                    operation.onStart();
                }
                this.executeOperations(newPendingOperations, this.operationDirectionIsPop);
                this.operationDirectionIsPop = false;
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)"SpecialEffectsController: Finished executing pending operations");
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void forceCompleteAllOperations() {
        if (FragmentManager.isLoggingEnabled(2)) {
            Log.v((String)"FragmentManager", (String)"SpecialEffectsController: Forcing all operations to complete");
        }
        boolean attachedToWindow = ViewCompat.isAttachedToWindow((View)((View)this.container));
        List<Operation> list = this.pendingOperations;
        synchronized (list) {
            boolean bl = false;
            this.updateFinalState();
            for (Operation operation : this.pendingOperations) {
                operation.onStart();
            }
            List runningOperations = CollectionsKt.toMutableList((Collection)this.runningOperations);
            for (Operation operation : runningOperations) {
                if (FragmentManager.isLoggingEnabled(2)) {
                    String notAttachedMessage = attachedToWindow ? "" : "Container " + this.container + " is not attached to window. ";
                    Log.v((String)"FragmentManager", (String)("SpecialEffectsController: " + notAttachedMessage + "Cancelling running operation " + operation));
                }
                operation.cancel();
            }
            List list2 = CollectionsKt.toMutableList((Collection)this.pendingOperations);
            for (Operation operation : list2) {
                if (FragmentManager.isLoggingEnabled(2)) {
                    String notAttachedMessage = attachedToWindow ? "" : "Container " + this.container + " is not attached to window. ";
                    Log.v((String)"FragmentManager", (String)("SpecialEffectsController: " + notAttachedMessage + "Cancelling pending operation " + operation));
                }
                operation.cancel();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void updateFinalState() {
        for (Operation operation : this.pendingOperations) {
            View view;
            if (operation.getLifecycleImpact() != Operation.LifecycleImpact.ADDING) continue;
            Fragment fragment = operation.getFragment();
            Intrinsics.checkNotNullExpressionValue((Object)fragment.requireView(), (String)"fragment.requireView()");
            Operation.State finalState = Operation.State.Companion.from(view.getVisibility());
            operation.mergeWith(finalState, Operation.LifecycleImpact.NONE);
        }
    }

    public abstract void executeOperations(@NotNull List<Operation> var1, boolean var2);

    private static final void enqueue$lambda$4$lambda$2(SpecialEffectsController this$0, FragmentStateManagerOperation $operation) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$operation, (String)"$operation");
        if (this$0.pendingOperations.contains($operation)) {
            Operation.State state = $operation.getFinalState();
            View view = $operation.getFragment().mView;
            Intrinsics.checkNotNullExpressionValue((Object)view, (String)"operation.fragment.mView");
            state.applyState(view);
        }
    }

    private static final void enqueue$lambda$4$lambda$3(SpecialEffectsController this$0, FragmentStateManagerOperation $operation) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$operation, (String)"$operation");
        this$0.pendingOperations.remove($operation);
        this$0.runningOperations.remove($operation);
    }

    @JvmStatic
    @NotNull
    public static final SpecialEffectsController getOrCreateController(@NotNull ViewGroup container, @NotNull FragmentManager fragmentManager) {
        return Companion.getOrCreateController(container, fragmentManager);
    }

    @JvmStatic
    @NotNull
    public static final SpecialEffectsController getOrCreateController(@NotNull ViewGroup container, @NotNull SpecialEffectsControllerFactory factory) {
        return Companion.getOrCreateController(container, factory);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Landroidx/fragment/app/SpecialEffectsController$Companion;", "", "()V", "getOrCreateController", "Landroidx/fragment/app/SpecialEffectsController;", "container", "Landroid/view/ViewGroup;", "fragmentManager", "Landroidx/fragment/app/FragmentManager;", "factory", "Landroidx/fragment/app/SpecialEffectsControllerFactory;", "fragment_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final SpecialEffectsController getOrCreateController(@NotNull ViewGroup container, @NotNull FragmentManager fragmentManager) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            Intrinsics.checkNotNullParameter((Object)fragmentManager, (String)"fragmentManager");
            SpecialEffectsControllerFactory specialEffectsControllerFactory = fragmentManager.getSpecialEffectsControllerFactory();
            Intrinsics.checkNotNullExpressionValue((Object)specialEffectsControllerFactory, (String)"fragmentManager.specialEffectsControllerFactory");
            SpecialEffectsControllerFactory factory = specialEffectsControllerFactory;
            return this.getOrCreateController(container, factory);
        }

        @JvmStatic
        @NotNull
        public final SpecialEffectsController getOrCreateController(@NotNull ViewGroup container, @NotNull SpecialEffectsControllerFactory factory) {
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
            Object controller = container.getTag(R.id.special_effects_controller_view_tag);
            if (controller instanceof SpecialEffectsController) {
                return (SpecialEffectsController)controller;
            }
            SpecialEffectsController specialEffectsController = factory.createController(container);
            Intrinsics.checkNotNullExpressionValue((Object)specialEffectsController, (String)"factory.createController(container)");
            SpecialEffectsController newController = specialEffectsController;
            container.setTag(R.id.special_effects_controller_view_tag, (Object)newController);
            return newController;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/fragment/app/SpecialEffectsController$FragmentStateManagerOperation;", "Landroidx/fragment/app/SpecialEffectsController$Operation;", "finalState", "Landroidx/fragment/app/SpecialEffectsController$Operation$State;", "lifecycleImpact", "Landroidx/fragment/app/SpecialEffectsController$Operation$LifecycleImpact;", "fragmentStateManager", "Landroidx/fragment/app/FragmentStateManager;", "cancellationSignal", "Landroidx/core/os/CancellationSignal;", "(Landroidx/fragment/app/SpecialEffectsController$Operation$State;Landroidx/fragment/app/SpecialEffectsController$Operation$LifecycleImpact;Landroidx/fragment/app/FragmentStateManager;Landroidx/core/os/CancellationSignal;)V", "complete", "", "onStart", "fragment_release"})
    private static final class FragmentStateManagerOperation
    extends Operation {
        @NotNull
        private final FragmentStateManager fragmentStateManager;

        public FragmentStateManagerOperation(@NotNull Operation.State finalState, @NotNull Operation.LifecycleImpact lifecycleImpact, @NotNull FragmentStateManager fragmentStateManager, @NotNull CancellationSignal cancellationSignal) {
            Intrinsics.checkNotNullParameter((Object)((Object)finalState), (String)"finalState");
            Intrinsics.checkNotNullParameter((Object)((Object)lifecycleImpact), (String)"lifecycleImpact");
            Intrinsics.checkNotNullParameter((Object)fragmentStateManager, (String)"fragmentStateManager");
            Intrinsics.checkNotNullParameter((Object)cancellationSignal, (String)"cancellationSignal");
            Fragment fragment = fragmentStateManager.getFragment();
            Intrinsics.checkNotNullExpressionValue((Object)fragment, (String)"fragmentStateManager.fragment");
            super(finalState, lifecycleImpact, fragment, cancellationSignal);
            this.fragmentStateManager = fragmentStateManager;
        }

        @Override
        public void onStart() {
            if (this.getLifecycleImpact() == Operation.LifecycleImpact.ADDING) {
                Fragment fragment = this.fragmentStateManager.getFragment();
                Intrinsics.checkNotNullExpressionValue((Object)fragment, (String)"fragmentStateManager.fragment");
                Fragment fragment2 = fragment;
                View focusedView = fragment2.mView.findFocus();
                if (focusedView != null) {
                    fragment2.setFocusedView(focusedView);
                    if (FragmentManager.isLoggingEnabled(2)) {
                        Log.v((String)"FragmentManager", (String)("requestFocus: Saved focused view " + focusedView + " for Fragment " + fragment2));
                    }
                }
                View view = this.getFragment().requireView();
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"this.fragment.requireView()");
                View view2 = view;
                if (view2.getParent() == null) {
                    this.fragmentStateManager.addViewToContainer();
                    view2.setAlpha(0.0f);
                }
                if (view2.getAlpha() == 0.0f && view2.getVisibility() == 0) {
                    view2.setVisibility(4);
                }
                view2.setAlpha(fragment2.getPostOnViewCreatedAlpha());
            } else if (this.getLifecycleImpact() == Operation.LifecycleImpact.REMOVING) {
                Fragment fragment = this.fragmentStateManager.getFragment();
                Intrinsics.checkNotNullExpressionValue((Object)fragment, (String)"fragmentStateManager.fragment");
                Fragment fragment3 = fragment;
                View view = fragment3.requireView();
                Intrinsics.checkNotNullExpressionValue((Object)view, (String)"fragment.requireView()");
                View view3 = view;
                if (FragmentManager.isLoggingEnabled(2)) {
                    Log.v((String)"FragmentManager", (String)("Clearing focus " + view3.findFocus() + " on view " + view3 + " for Fragment " + fragment3));
                }
                view3.clearFocus();
            }
        }

        @Override
        public void complete() {
            super.complete();
            this.fragmentStateManager.moveToExpectedState();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010#\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0010\u0018\u00002\u00020\u0001:\u0002+,B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\rJ\u0006\u0010\"\u001a\u00020 J\b\u0010#\u001a\u00020 H\u0017J\u000e\u0010$\u001a\u00020 2\u0006\u0010%\u001a\u00020\tJ\u000e\u0010&\u001a\u00020 2\u0006\u0010%\u001a\u00020\tJ\u0016\u0010'\u001a\u00020 2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010(\u001a\u00020 H\u0016J\b\u0010)\u001a\u00020*H\u0016R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u0015@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0017R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Landroidx/fragment/app/SpecialEffectsController$Operation;", "", "finalState", "Landroidx/fragment/app/SpecialEffectsController$Operation$State;", "lifecycleImpact", "Landroidx/fragment/app/SpecialEffectsController$Operation$LifecycleImpact;", "fragment", "Landroidx/fragment/app/Fragment;", "cancellationSignal", "Landroidx/core/os/CancellationSignal;", "(Landroidx/fragment/app/SpecialEffectsController$Operation$State;Landroidx/fragment/app/SpecialEffectsController$Operation$LifecycleImpact;Landroidx/fragment/app/Fragment;Landroidx/core/os/CancellationSignal;)V", "completionListeners", "", "Ljava/lang/Runnable;", "getFinalState", "()Landroidx/fragment/app/SpecialEffectsController$Operation$State;", "setFinalState", "(Landroidx/fragment/app/SpecialEffectsController$Operation$State;)V", "getFragment", "()Landroidx/fragment/app/Fragment;", "<set-?>", "", "isCanceled", "()Z", "isComplete", "getLifecycleImpact", "()Landroidx/fragment/app/SpecialEffectsController$Operation$LifecycleImpact;", "setLifecycleImpact", "(Landroidx/fragment/app/SpecialEffectsController$Operation$LifecycleImpact;)V", "specialEffectsSignals", "", "addCompletionListener", "", "listener", "cancel", "complete", "completeSpecialEffect", "signal", "markStartedSpecialEffect", "mergeWith", "onStart", "toString", "", "LifecycleImpact", "State", "fragment_release"})
    @SourceDebugExtension(value={"SMAP\nSpecialEffectsController.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpecialEffectsController.kt\nandroidx/fragment/app/SpecialEffectsController$Operation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,710:1\n1855#2,2:711\n*S KotlinDebug\n*F\n+ 1 SpecialEffectsController.kt\nandroidx/fragment/app/SpecialEffectsController$Operation\n*L\n607#1:711,2\n*E\n"})
    public static class Operation {
        @NotNull
        private State finalState;
        @NotNull
        private LifecycleImpact lifecycleImpact;
        @NotNull
        private final Fragment fragment;
        @NotNull
        private final List<Runnable> completionListeners;
        @NotNull
        private final Set<CancellationSignal> specialEffectsSignals;
        private boolean isCanceled;
        private boolean isComplete;

        public Operation(@NotNull State finalState, @NotNull LifecycleImpact lifecycleImpact, @NotNull Fragment fragment, @NotNull CancellationSignal cancellationSignal) {
            Intrinsics.checkNotNullParameter((Object)((Object)finalState), (String)"finalState");
            Intrinsics.checkNotNullParameter((Object)((Object)lifecycleImpact), (String)"lifecycleImpact");
            Intrinsics.checkNotNullParameter((Object)fragment, (String)"fragment");
            Intrinsics.checkNotNullParameter((Object)cancellationSignal, (String)"cancellationSignal");
            this.finalState = finalState;
            this.lifecycleImpact = lifecycleImpact;
            this.fragment = fragment;
            this.completionListeners = new ArrayList();
            this.specialEffectsSignals = new LinkedHashSet();
            cancellationSignal.setOnCancelListener(() -> Operation._init_$lambda$0(this));
        }

        @NotNull
        public final State getFinalState() {
            return this.finalState;
        }

        public final void setFinalState(@NotNull State state) {
            Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"<set-?>");
            this.finalState = state;
        }

        @NotNull
        public final LifecycleImpact getLifecycleImpact() {
            return this.lifecycleImpact;
        }

        public final void setLifecycleImpact(@NotNull LifecycleImpact lifecycleImpact) {
            Intrinsics.checkNotNullParameter((Object)((Object)lifecycleImpact), (String)"<set-?>");
            this.lifecycleImpact = lifecycleImpact;
        }

        @NotNull
        public final Fragment getFragment() {
            return this.fragment;
        }

        public final boolean isCanceled() {
            return this.isCanceled;
        }

        public final boolean isComplete() {
            return this.isComplete;
        }

        @NotNull
        public String toString() {
            String identityHash = Integer.toHexString(System.identityHashCode(this));
            return "Operation {" + identityHash + "} {finalState = " + (Object)((Object)this.finalState) + " lifecycleImpact = " + (Object)((Object)this.lifecycleImpact) + " fragment = " + this.fragment + '}';
        }

        public final void cancel() {
            if (this.isCanceled) {
                return;
            }
            this.isCanceled = true;
            if (this.specialEffectsSignals.isEmpty()) {
                this.complete();
            } else {
                Set signals = CollectionsKt.toMutableSet((Iterable)this.specialEffectsSignals);
                for (CancellationSignal signal : signals) {
                    signal.cancel();
                }
            }
        }

        public final void mergeWith(@NotNull State finalState, @NotNull LifecycleImpact lifecycleImpact) {
            Intrinsics.checkNotNullParameter((Object)((Object)finalState), (String)"finalState");
            Intrinsics.checkNotNullParameter((Object)((Object)lifecycleImpact), (String)"lifecycleImpact");
            switch (WhenMappings.$EnumSwitchMapping$0[lifecycleImpact.ordinal()]) {
                case 1: {
                    if (this.finalState != State.REMOVED) break;
                    if (FragmentManager.isLoggingEnabled(2)) {
                        Log.v((String)"FragmentManager", (String)("SpecialEffectsController: For fragment " + this.fragment + " mFinalState = REMOVED -> VISIBLE. mLifecycleImpact = " + (Object)((Object)this.lifecycleImpact) + " to ADDING."));
                    }
                    this.finalState = State.VISIBLE;
                    this.lifecycleImpact = LifecycleImpact.ADDING;
                    break;
                }
                case 2: {
                    if (FragmentManager.isLoggingEnabled(2)) {
                        Log.v((String)"FragmentManager", (String)("SpecialEffectsController: For fragment " + this.fragment + " mFinalState = " + (Object)((Object)this.finalState) + " -> REMOVED. mLifecycleImpact  = " + (Object)((Object)this.lifecycleImpact) + " to REMOVING."));
                    }
                    this.finalState = State.REMOVED;
                    this.lifecycleImpact = LifecycleImpact.REMOVING;
                    break;
                }
                case 3: {
                    if (this.finalState == State.REMOVED) break;
                    if (FragmentManager.isLoggingEnabled(2)) {
                        Log.v((String)"FragmentManager", (String)("SpecialEffectsController: For fragment " + this.fragment + " mFinalState = " + (Object)((Object)this.finalState) + " -> " + (Object)((Object)finalState) + '.'));
                    }
                    this.finalState = finalState;
                }
            }
        }

        public final void addCompletionListener(@NotNull Runnable listener) {
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            this.completionListeners.add(listener);
        }

        public void onStart() {
        }

        public final void markStartedSpecialEffect(@NotNull CancellationSignal signal) {
            Intrinsics.checkNotNullParameter((Object)signal, (String)"signal");
            this.onStart();
            this.specialEffectsSignals.add(signal);
        }

        public final void completeSpecialEffect(@NotNull CancellationSignal signal) {
            Intrinsics.checkNotNullParameter((Object)signal, (String)"signal");
            if (this.specialEffectsSignals.remove(signal) && this.specialEffectsSignals.isEmpty()) {
                this.complete();
            }
        }

        @CallSuper
        public void complete() {
            if (this.isComplete) {
                return;
            }
            if (FragmentManager.isLoggingEnabled(2)) {
                Log.v((String)"FragmentManager", (String)("SpecialEffectsController: " + this + " has called complete."));
            }
            this.isComplete = true;
            Iterable $this$forEach$iv = this.completionListeners;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Runnable listener = (Runnable)element$iv;
                boolean bl = false;
                listener.run();
            }
        }

        private static final void _init_$lambda$0(Operation this$0) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            this$0.cancel();
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0080\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Landroidx/fragment/app/SpecialEffectsController$Operation$LifecycleImpact;", "", "(Ljava/lang/String;I)V", "NONE", "ADDING", "REMOVING", "fragment_release"})
        public static final class LifecycleImpact
        extends Enum<LifecycleImpact> {
            public static final /* enum */ LifecycleImpact NONE = new LifecycleImpact();
            public static final /* enum */ LifecycleImpact ADDING = new LifecycleImpact();
            public static final /* enum */ LifecycleImpact REMOVING = new LifecycleImpact();
            private static final /* synthetic */ LifecycleImpact[] $VALUES;

            public static LifecycleImpact[] values() {
                return (LifecycleImpact[])$VALUES.clone();
            }

            public static LifecycleImpact valueOf(String value) {
                return Enum.valueOf(LifecycleImpact.class, value);
            }

            static {
                $VALUES = lifecycleImpactArray = new LifecycleImpact[]{LifecycleImpact.NONE, LifecycleImpact.ADDING, LifecycleImpact.REMOVING};
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0080\u0001\u0018\u0000 \u000b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u000bB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\f"}, d2={"Landroidx/fragment/app/SpecialEffectsController$Operation$State;", "", "(Ljava/lang/String;I)V", "applyState", "", "view", "Landroid/view/View;", "REMOVED", "VISIBLE", "GONE", "INVISIBLE", "Companion", "fragment_release"})
        public static final class State
        extends Enum<State> {
            @NotNull
            public static final Companion Companion;
            public static final /* enum */ State REMOVED;
            public static final /* enum */ State VISIBLE;
            public static final /* enum */ State GONE;
            public static final /* enum */ State INVISIBLE;
            private static final /* synthetic */ State[] $VALUES;

            public final void applyState(@NotNull View view) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                switch (WhenMappings.$EnumSwitchMapping$0[this.ordinal()]) {
                    case 1: {
                        ViewGroup parent;
                        ViewParent viewParent = view.getParent();
                        ViewGroup viewGroup = parent = viewParent instanceof ViewGroup ? (ViewGroup)viewParent : null;
                        if (parent == null) break;
                        if (FragmentManager.isLoggingEnabled(2)) {
                            Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Removing view " + view + " from container " + parent));
                        }
                        parent.removeView(view);
                        break;
                    }
                    case 2: {
                        if (FragmentManager.isLoggingEnabled(2)) {
                            Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Setting view " + view + " to VISIBLE"));
                        }
                        view.setVisibility(0);
                        break;
                    }
                    case 3: {
                        if (FragmentManager.isLoggingEnabled(2)) {
                            Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Setting view " + view + " to GONE"));
                        }
                        view.setVisibility(8);
                        break;
                    }
                    case 4: {
                        if (FragmentManager.isLoggingEnabled(2)) {
                            Log.v((String)"FragmentManager", (String)("SpecialEffectsController: Setting view " + view + " to INVISIBLE"));
                        }
                        view.setVisibility(4);
                    }
                }
            }

            public static State[] values() {
                return (State[])$VALUES.clone();
            }

            public static State valueOf(String value) {
                return Enum.valueOf(State.class, value);
            }

            @JvmStatic
            @NotNull
            public static final State from(int visibility) {
                return Companion.from(visibility);
            }

            static {
                REMOVED = new State();
                VISIBLE = new State();
                GONE = new State();
                INVISIBLE = new State();
                $VALUES = stateArray = new State[]{State.REMOVED, State.VISIBLE, State.GONE, State.INVISIBLE};
                Companion = new Companion(null);
            }

            @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\n\u0010\u0007\u001a\u00020\u0004*\u00020\b\u00a8\u0006\t"}, d2={"Landroidx/fragment/app/SpecialEffectsController$Operation$State$Companion;", "", "()V", "from", "Landroidx/fragment/app/SpecialEffectsController$Operation$State;", "visibility", "", "asOperationState", "Landroid/view/View;", "fragment_release"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final State asOperationState(@NotNull View $this$asOperationState) {
                    Intrinsics.checkNotNullParameter((Object)$this$asOperationState, (String)"<this>");
                    return $this$asOperationState.getAlpha() == 0.0f && $this$asOperationState.getVisibility() == 0 ? INVISIBLE : this.from($this$asOperationState.getVisibility());
                }

                @JvmStatic
                @NotNull
                public final State from(int visibility) {
                    State state;
                    switch (visibility) {
                        case 0: {
                            state = VISIBLE;
                            break;
                        }
                        case 4: {
                            state = INVISIBLE;
                            break;
                        }
                        case 8: {
                            state = GONE;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown visibility " + visibility);
                        }
                    }
                    return state;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }

            @Metadata(mv={1, 8, 0}, k=3, xi=48)
            public final class WhenMappings {
                public static final /* synthetic */ int[] $EnumSwitchMapping$0;

                static {
                    int[] nArray = new int[State.values().length];
                    try {
                        nArray[State.REMOVED.ordinal()] = 1;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[State.VISIBLE.ordinal()] = 2;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[State.GONE.ordinal()] = 3;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    try {
                        nArray[State.INVISIBLE.ordinal()] = 4;
                    }
                    catch (NoSuchFieldError noSuchFieldError) {
                        // empty catch block
                    }
                    $EnumSwitchMapping$0 = nArray;
                }
            }
        }

        @Metadata(mv={1, 8, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[LifecycleImpact.values().length];
                try {
                    nArray[LifecycleImpact.ADDING.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LifecycleImpact.REMOVING.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[LifecycleImpact.NONE.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Operation.LifecycleImpact.values().length];
            try {
                nArray[Operation.LifecycleImpact.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

