/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.lint;

import androidx.fragment.lint.LintUtilsKt;
import com.android.tools.lint.checks.DataFlowAnalyzer;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016J\u001d\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0012J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u000bH\u0002J\u001d\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u0016J(\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u0010H\u0002J \u0010\u001a\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016\u00a8\u0006\u001c"}, d2={"Landroidx/fragment/lint/AttachAndDetachInSameTransactionDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "checkTransactionCommits", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "calledMethod", "Lcom/intellij/psi/PsiMethod;", "getApplicableMethodNames", "", "", "isAttachFragmentMethodCall", "", "call", "isAttachFragmentMethodCall$fragment_lint", "isBeginTransaction", "method", "isDetachFragmentMethodCall", "isDetachFragmentMethodCall$fragment_lint", "isMethodOnFragmentClass", "fragmentClass", "returnForUnresolved", "visitMethodCall", "Issues", "fragment-lint"})
public final class AttachAndDetachInSameTransactionDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Issue DETACH_ATTACH_OPERATIONS_ISSUE;
    @NotNull
    private static final String ATTACH = "attach";
    @NotNull
    private static final String BEGIN_TRANSACTION = "beginTransaction";
    @NotNull
    private static final String DETACH = "detach";
    @NotNull
    private static final String FRAGMENT_CLS = "androidx.fragment.app.Fragment";
    @NotNull
    private static final String FRAGMENT_MANAGER_CLS = "androidx.fragment.app.FragmentManager";
    @NotNull
    private static final String FRAGMENT_TRANSACTION_CLS = "androidx.fragment.app.FragmentTransaction";

    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)BEGIN_TRANSACTION);
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        String string = method.getName();
        switch (string.hashCode()) {
            case -1295962507: {
                if (string.equals(BEGIN_TRANSACTION)) {
                    this.checkTransactionCommits(context, node, method);
                    break;
                }
            }
            default: {
                super.visitMethodCall(context, node, method);
            }
        }
    }

    private final void checkTransactionCommits(JavaContext context, UCallExpression node, PsiMethod calledMethod) {
        if (this.isBeginTransaction(context, calledMethod)) {
            UMethod uMethod = (UMethod)UastUtils.getParentOfType$default((UElement)((UElement)node), UMethod.class, (boolean)false, (int)2, null);
            if (uMethod == null) {
                return;
            }
            UMethod method = uMethod;
            Ref.ObjectRef attachingFragment = new Ref.ObjectRef();
            Ref.ObjectRef detachingFragment = new Ref.ObjectRef();
            Set set = SetsKt.setOf((Object)node);
            List list = CollectionsKt.emptyList();
            DataFlowAnalyzer visitor2 = new DataFlowAnalyzer(this, context, (Ref.ObjectRef<UElement>)attachingFragment, (Ref.ObjectRef<UElement>)detachingFragment, set, list){
                final /* synthetic */ AttachAndDetachInSameTransactionDetector this$0;
                final /* synthetic */ JavaContext $context;
                final /* synthetic */ Ref.ObjectRef<UElement> $attachingFragment;
                final /* synthetic */ Ref.ObjectRef<UElement> $detachingFragment;
                {
                    this.this$0 = $receiver;
                    this.$context = $context;
                    this.$attachingFragment = $attachingFragment;
                    this.$detachingFragment = $detachingFragment;
                    super((Collection)$super_call_param$1, (Collection)$super_call_param$2);
                }

                public void receiver(@NotNull UCallExpression call) {
                    UExpression arg;
                    UExpression it;
                    Iterable $this$firstOrNull$iv;
                    boolean $i$f$firstOrNull;
                    JavaContext javaContext;
                    Intrinsics.checkNotNullParameter((Object)call, (String)"call");
                    if (this.this$0.isAttachFragmentMethodCall$fragment_lint(this.$context, call)) {
                        UExpression uExpression;
                        Object v0;
                        block4: {
                            Iterable iterable = call.getValueArguments();
                            javaContext = this.$context;
                            $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                it = (UExpression)element$iv;
                                boolean bl = false;
                                if (!LintUtilsKt.extends(it.getExpressionType(), javaContext, "androidx.fragment.app.Fragment", false)) continue;
                                v0 = element$iv;
                                break block4;
                            }
                            v0 = null;
                        }
                        Object object = (uExpression = (arg = (UExpression)v0)) != null && (uExpression = UastUtils.tryResolve((UElement)((UElement)uExpression))) != null ? UastContextKt.toUElement((PsiElement)uExpression) : (this.$attachingFragment.element = null);
                    }
                    if (this.this$0.isDetachFragmentMethodCall$fragment_lint(this.$context, call)) {
                        UExpression uExpression;
                        Object v3;
                        block5: {
                            $this$firstOrNull$iv = call.getValueArguments();
                            javaContext = this.$context;
                            $i$f$firstOrNull = false;
                            for (T element$iv : $this$firstOrNull$iv) {
                                it = (UExpression)element$iv;
                                boolean bl = false;
                                if (!LintUtilsKt.extends(it.getExpressionType(), javaContext, "androidx.fragment.app.Fragment", false)) continue;
                                v3 = element$iv;
                                break block5;
                            }
                            v3 = null;
                        }
                        this.$detachingFragment.element = (uExpression = (arg = (UExpression)v3)) != null && (uExpression = UastUtils.tryResolve((UElement)((UElement)uExpression))) != null ? UastContextKt.toUElement((PsiElement)uExpression) : null;
                    }
                }
            };
            method.accept((UastVisitor)visitor2);
            if (attachingFragment.element != null && Intrinsics.areEqual((Object)attachingFragment.element, (Object)detachingFragment.element)) {
                String message = "Calling detach() and attach() in the same FragmentTransaction is a no-op, meaning it does not recreate the Fragment's view. If you would like the view to be recreated, separate these operations into separate transactions.";
                JavaContext.report$default((JavaContext)context, (Issue)DETACH_ATTACH_OPERATIONS_ISSUE, (UElement)((UElement)node), (Location)context.getNameLocation((UElement)node), (String)message, null, (int)16, null);
            }
        }
    }

    private final boolean isBeginTransaction(JavaContext context, PsiMethod method) {
        return Intrinsics.areEqual((Object)BEGIN_TRANSACTION, (Object)method.getName()) && JavaEvaluator.isMemberInSubClassOf$default((JavaEvaluator)context.getEvaluator(), (PsiMember)((PsiMember)method), (String)FRAGMENT_MANAGER_CLS, (boolean)false, (int)4, null);
    }

    public final boolean isAttachFragmentMethodCall$fragment_lint(@NotNull JavaContext context, @NotNull UCallExpression call) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        String methodName = Lint.getMethodName((UCallExpression)call);
        return Intrinsics.areEqual((Object)ATTACH, (Object)methodName) && this.isMethodOnFragmentClass(context, call, FRAGMENT_TRANSACTION_CLS, true);
    }

    public final boolean isDetachFragmentMethodCall$fragment_lint(@NotNull JavaContext context, @NotNull UCallExpression call) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)call, (String)"call");
        String methodName = Lint.getMethodName((UCallExpression)call);
        return Intrinsics.areEqual((Object)DETACH, (Object)methodName) && this.isMethodOnFragmentClass(context, call, FRAGMENT_TRANSACTION_CLS, true);
    }

    private final boolean isMethodOnFragmentClass(JavaContext context, UCallExpression call, String fragmentClass, boolean returnForUnresolved) {
        PsiMethod psiMethod = call.resolve();
        if (psiMethod == null) {
            return returnForUnresolved;
        }
        PsiMethod method = psiMethod;
        return JavaEvaluator.isMemberInSubClassOf$default((JavaEvaluator)context.getEvaluator(), (PsiMember)((PsiMember)method), (String)fragmentClass, (boolean)false, (int)4, null);
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(AttachAndDetachInSameTransactionDetector.class, Scope.JAVA_FILE_SCOPE);
        DETACH_ATTACH_OPERATIONS_ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"DetachAndAttachSameFragment", (String)"Separate attach() and detach() into separate FragmentTransactions", (String)"When doing a FragmentTransaction that includes both attach() \\\n                and detach() operations being committed on the same fragment instance, it is a \\\n                no-op. The reason for this is that the FragmentManager optimizes all operations \\\n                within a single transaction so the attach() and detach() cancel each other out \\\n                and neither is actually executed. To get the desired behavior, you should separate \\\n                the attach() and detach() calls into separate FragmentTransactions.", (Implementation)implementation, null, (Category)category, (int)0, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3408, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Landroidx/fragment/lint/AttachAndDetachInSameTransactionDetector$Issues;", "", "()V", "ATTACH", "", "BEGIN_TRANSACTION", "DETACH", "DETACH_ATTACH_OPERATIONS_ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getDETACH_ATTACH_OPERATIONS_ISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "FRAGMENT_CLS", "FRAGMENT_MANAGER_CLS", "FRAGMENT_TRANSACTION_CLS", "fragment-lint"})
    public static final class Issues {
        private Issues() {
        }

        @NotNull
        public final Issue getDETACH_ATTACH_OPERATIONS_ISSUE() {
            return DETACH_ATTACH_OPERATIONS_ISSUE;
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

