/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.lint;

import androidx.fragment.lint.LintUtilsKt;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.lang.jvm.types.JvmReferenceType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00152\u00020\u00012\u00020\u0002:\u0001\u0015B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u0005H\u0002J\u0010\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016\u00a8\u0006\u0016"}, d2={"Landroidx/fragment/lint/UseGetLayoutInflater;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "()V", "correctMethod", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "createFix", "Lcom/android/tools/lint/detector/api/LintFix;", "parameter", "getApplicableMethodNames", "", "startLintForJava", "", "node", "Lorg/jetbrains/uast/UCallExpression;", "startLintForKotlin", "visitMethodCall", "method", "Lcom/intellij/psi/PsiMethod;", "Issues", "fragment-lint"})
public final class UseGetLayoutInflater
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private static final Issue ISSUE;

    @Nullable
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)"from");
    }

    public void visitMethodCall(@NotNull JavaContext context, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return;
        }
        PsiClass containingClass = psiClass;
        JavaEvaluator evaluator = context.getEvaluator();
        if (Intrinsics.areEqual((Object)evaluator.getQualifiedName(containingClass), (Object)"android.view.LayoutInflater") && evaluator.getParameterCount(method) == 1) {
            if (!Lint.isKotlin((PsiElement)((PsiElement)context.getPsiFile()))) {
                this.startLintForJava(context, node);
            } else {
                this.startLintForKotlin(context, node);
            }
        }
    }

    private final void startLintForJava(JavaContext context, UCallExpression node) {
        UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)node));
        if (!Intrinsics.areEqual((Object)(uClass != null && (uClass = uClass.getSuperClassType()) != null ? uClass.getName() : null), (Object)"DialogFragment")) {
            return;
        }
        String methodParameter = node.getValueArguments().get(0).toString();
        context.report(ISSUE, context.getLocation((UElement)node), "Use of LayoutInflater.from(" + methodParameter + ") detected. Consider using " + this.correctMethod(context) + " instead", this.createFix(this.correctMethod(context), methodParameter));
    }

    private final void startLintForKotlin(JavaContext context, UCallExpression node) {
        PsiType classType;
        UClass uClass = UastUtils.getContainingUClass((UElement)((UElement)node));
        JvmReferenceType jvmReferenceType = uClass != null ? uClass.getSuperClassType() : null;
        PsiType psiType = classType = jvmReferenceType instanceof PsiType ? (PsiType)jvmReferenceType : null;
        if (!Intrinsics.areEqual((Object)(psiType != null ? psiType.getPresentableText() : null), (Object)"DialogFragment") && !LintUtilsKt.extends$default(classType, context, "DialogFragment", false, 4, null)) {
            return;
        }
        context.report(ISSUE, context.getLocation((UElement)node), "Use of LayoutInflater.from(Context) detected. Consider using " + this.correctMethod(context) + " instead", null);
    }

    private final String correctMethod(JavaContext context) {
        return Lint.isKotlin((PsiElement)((PsiElement)context.getPsiFile())) ? "layoutInflater" : "getLayoutInflater()";
    }

    private final LintFix createFix(String correctMethod, String parameter) {
        return this.fix().replace().text("LayoutInflater.from(" + parameter + ")").name("Replace with " + correctMethod).with(correctMethod).autoFix().build();
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(UseGetLayoutInflater.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default((Issue.Companion)companion, (String)"UseGetLayoutInflater", (String)"Use getLayoutInflater() to get the LayoutInflater instead of calling LayoutInflater.from(Context).", (String)"Using LayoutInflater.from(Context) can return a LayoutInflater  \\\n                that does not have the correct theme.", (Implementation)implementation, null, (Category)category, (int)9, (Severity)severity, (boolean)false, (Boolean)true, null, null, (int)3344, null);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/fragment/lint/UseGetLayoutInflater$Issues;", "", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "fragment-lint"})
    public static final class Issues {
        private Issues() {
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

