/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.datatransport.runtime;

import android.util.Base64;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.google.android.datatransport.Priority;
import com.google.android.datatransport.runtime.AutoValue_TransportContext;
import com.google.auto.value.AutoValue;

@AutoValue
public abstract class TransportContext {
    public abstract String getBackendName();

    @Nullable
    public abstract byte[] getExtras();

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public abstract Priority getPriority();

    public final String toString() {
        return String.format("TransportContext(%s, %s, %s)", this.getBackendName(), this.getPriority(), this.getExtras() == null ? "" : Base64.encodeToString((byte[])this.getExtras(), (int)2));
    }

    public static Builder builder() {
        return new AutoValue_TransportContext.Builder().setPriority(Priority.DEFAULT);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public TransportContext withPriority(Priority priority) {
        return TransportContext.builder().setBackendName(this.getBackendName()).setPriority(priority).setExtras(this.getExtras()).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setBackendName(String var1);

        public abstract Builder setExtras(@Nullable byte[] var1);

        @RestrictTo(value={RestrictTo.Scope.LIBRARY})
        public abstract Builder setPriority(Priority var1);

        public abstract TransportContext build();
    }
}

