/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CaptureRequest;
import android.os.Handler;
import android.view.Surface;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.CaptureSessionRepository;
import androidx.camera.camera2.internal.SynchronizedCaptureSession;
import androidx.camera.camera2.internal.SynchronizedCaptureSessionBaseImpl;
import androidx.camera.camera2.internal.compat.params.SessionConfigurationCompat;
import androidx.camera.camera2.internal.compat.workaround.ForceCloseCaptureSession;
import androidx.camera.camera2.internal.compat.workaround.ForceCloseDeferrableSurface;
import androidx.camera.camera2.internal.compat.workaround.WaitForRepeatingRequestStart;
import androidx.camera.core.Logger;
import androidx.camera.core.impl.DeferrableSurface;
import androidx.camera.core.impl.Quirks;
import androidx.camera.core.impl.utils.futures.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;

@RequiresApi(value=21)
class SynchronizedCaptureSessionImpl
extends SynchronizedCaptureSessionBaseImpl {
    private static final String TAG = "SyncCaptureSessionImpl";
    private final Object mObjectLock = new Object();
    @Nullable
    @GuardedBy(value="mObjectLock")
    private List<DeferrableSurface> mDeferrableSurfaces;
    @Nullable
    @GuardedBy(value="mObjectLock")
    ListenableFuture<Void> mOpeningCaptureSession;
    private final ForceCloseDeferrableSurface mCloseSurfaceQuirk;
    private final WaitForRepeatingRequestStart mWaitForOtherSessionCompleteQuirk;
    private final ForceCloseCaptureSession mForceCloseSessionQuirk;

    SynchronizedCaptureSessionImpl(@NonNull Quirks cameraQuirks, @NonNull Quirks deviceQuirks, @NonNull CaptureSessionRepository repository, @NonNull Executor executor, @NonNull ScheduledExecutorService scheduledExecutorService, @NonNull Handler compatHandler) {
        super(repository, executor, scheduledExecutorService, compatHandler);
        this.mCloseSurfaceQuirk = new ForceCloseDeferrableSurface(cameraQuirks, deviceQuirks);
        this.mWaitForOtherSessionCompleteQuirk = new WaitForRepeatingRequestStart(cameraQuirks);
        this.mForceCloseSessionQuirk = new ForceCloseCaptureSession(deviceQuirks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public ListenableFuture<Void> openCaptureSession(@NonNull CameraDevice cameraDevice, @NonNull SessionConfigurationCompat sessionConfigurationCompat, @NonNull List<DeferrableSurface> deferrableSurfaces) {
        Object object = this.mObjectLock;
        synchronized (object) {
            this.mOpeningCaptureSession = this.mWaitForOtherSessionCompleteQuirk.openCaptureSession(cameraDevice, sessionConfigurationCompat, deferrableSurfaces, this.mCaptureSessionRepository.getClosingCaptureSession(), (x$0, x$1, x$2) -> super.openCaptureSession(x$0, x$1, x$2));
            return Futures.nonCancellationPropagating(this.mOpeningCaptureSession);
        }
    }

    @Override
    @NonNull
    public ListenableFuture<Void> getOpeningBlocker() {
        return this.mWaitForOtherSessionCompleteQuirk.getStartStreamFuture();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public ListenableFuture<List<Surface>> startWithDeferrableSurface(@NonNull List<DeferrableSurface> deferrableSurfaces, long timeout) {
        Object object = this.mObjectLock;
        synchronized (object) {
            this.mDeferrableSurfaces = deferrableSurfaces;
            return super.startWithDeferrableSurface(deferrableSurfaces, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean stop() {
        Object object = this.mObjectLock;
        synchronized (object) {
            if (this.isCameraCaptureSessionOpen()) {
                this.mCloseSurfaceQuirk.onSessionEnd(this.mDeferrableSurfaces);
            } else if (this.mOpeningCaptureSession != null) {
                this.mOpeningCaptureSession.cancel(true);
            }
            return super.stop();
        }
    }

    @Override
    public int setSingleRepeatingRequest(@NonNull CaptureRequest request, @NonNull CameraCaptureSession.CaptureCallback listener) throws CameraAccessException {
        return this.mWaitForOtherSessionCompleteQuirk.setSingleRepeatingRequest(request, listener, (CaptureRequest x$0, CameraCaptureSession.CaptureCallback x$1) -> super.setSingleRepeatingRequest(x$0, x$1));
    }

    @Override
    public void onConfigured(@NonNull SynchronizedCaptureSession session) {
        this.debugLog("Session onConfigured()");
        this.mForceCloseSessionQuirk.onSessionConfigured(session, this.mCaptureSessionRepository.getCreatingCaptureSessions(), this.mCaptureSessionRepository.getCaptureSessions(), x$0 -> super.onConfigured(x$0));
    }

    @Override
    public void close() {
        this.debugLog("Session call close()");
        this.mWaitForOtherSessionCompleteQuirk.onSessionEnd();
        this.mWaitForOtherSessionCompleteQuirk.getStartStreamFuture().addListener(() -> {
            this.debugLog("Session call super.close()");
            super.close();
        }, this.getExecutor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClosed(@NonNull SynchronizedCaptureSession session) {
        Object object = this.mObjectLock;
        synchronized (object) {
            this.mCloseSurfaceQuirk.onSessionEnd(this.mDeferrableSurfaces);
        }
        this.debugLog("onClosed()");
        super.onClosed(session);
    }

    void debugLog(String message) {
        Logger.d((String)TAG, (String)("[" + this + "] " + message));
    }
}

