/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat;

import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCaptureSession;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.params.InputConfiguration;
import android.os.Handler;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.CameraAccessExceptionCompat;
import androidx.camera.camera2.internal.compat.CameraCaptureSessionCompat;
import androidx.camera.camera2.internal.compat.CameraDeviceCompatApi23Impl;
import androidx.camera.camera2.internal.compat.CameraDeviceCompatBaseImpl;
import androidx.camera.camera2.internal.compat.params.InputConfigurationCompat;
import androidx.camera.camera2.internal.compat.params.OutputConfigurationCompat;
import androidx.camera.camera2.internal.compat.params.SessionConfigurationCompat;
import androidx.core.util.Preconditions;
import java.util.List;

@RequiresApi(value=24)
class CameraDeviceCompatApi24Impl
extends CameraDeviceCompatApi23Impl {
    CameraDeviceCompatApi24Impl(@NonNull CameraDevice cameraDevice, @Nullable Object implParams) {
        super(cameraDevice, implParams);
    }

    static CameraDeviceCompatApi24Impl create(@NonNull CameraDevice cameraDevice, @NonNull Handler compatHandler) {
        return new CameraDeviceCompatApi24Impl(cameraDevice, new CameraDeviceCompatBaseImpl.CameraDeviceCompatParamsApi21(compatHandler));
    }

    @Override
    public void createCaptureSession(@NonNull SessionConfigurationCompat config) throws CameraAccessExceptionCompat {
        CameraDeviceCompatApi24Impl.checkPreconditions(this.mCameraDevice, config);
        CameraCaptureSessionCompat.StateCallbackExecutorWrapper cb = new CameraCaptureSessionCompat.StateCallbackExecutorWrapper(config.getExecutor(), config.getStateCallback());
        List<OutputConfigurationCompat> outputs = config.getOutputConfigurations();
        CameraDeviceCompatBaseImpl.CameraDeviceCompatParamsApi21 params = (CameraDeviceCompatBaseImpl.CameraDeviceCompatParamsApi21)this.mImplParams;
        Handler handler = ((CameraDeviceCompatBaseImpl.CameraDeviceCompatParamsApi21)Preconditions.checkNotNull((Object)params)).mCompatHandler;
        InputConfigurationCompat inputConfigCompat = config.getInputConfiguration();
        try {
            if (inputConfigCompat != null) {
                InputConfiguration inputConfig = (InputConfiguration)inputConfigCompat.unwrap();
                Preconditions.checkNotNull((Object)inputConfig);
                this.mCameraDevice.createReprocessableCaptureSessionByConfigurations(inputConfig, SessionConfigurationCompat.transformFromCompat(outputs), (CameraCaptureSession.StateCallback)cb, handler);
            } else if (config.getSessionType() == 1) {
                this.mCameraDevice.createConstrainedHighSpeedCaptureSession(CameraDeviceCompatApi24Impl.unpackSurfaces(outputs), (CameraCaptureSession.StateCallback)cb, handler);
            } else {
                this.mCameraDevice.createCaptureSessionByOutputConfigurations(SessionConfigurationCompat.transformFromCompat(outputs), (CameraCaptureSession.StateCallback)cb, handler);
            }
        }
        catch (CameraAccessException e) {
            throw CameraAccessExceptionCompat.toCameraAccessExceptionCompat(e);
        }
    }
}

