/*
 * Decompiled with CFR 0.152.
 */
package androidx.emoji2.text;

import android.content.res.AssetManager;
import androidx.annotation.AnyThread;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.emoji2.text.flatbuffer.MetadataList;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
@AnyThread
@RequiresApi(value=19)
class MetadataListReader {
    private static final int EMJI_TAG = 1164798569;
    private static final int EMJI_TAG_DEPRECATED = 1701669481;
    private static final int META_TABLE_NAME = 1835365473;

    static MetadataList read(InputStream inputStream) throws IOException {
        InputStreamOpenTypeReader openTypeReader = new InputStreamOpenTypeReader(inputStream);
        OffsetInfo offsetInfo = MetadataListReader.findOffsetInfo(openTypeReader);
        openTypeReader.skip((int)(offsetInfo.getStartOffset() - openTypeReader.getPosition()));
        ByteBuffer buffer = ByteBuffer.allocate((int)offsetInfo.getLength());
        int numRead = inputStream.read(buffer.array());
        if ((long)numRead != offsetInfo.getLength()) {
            throw new IOException("Needed " + offsetInfo.getLength() + " bytes, got " + numRead);
        }
        return MetadataList.getRootAsMetadataList(buffer);
    }

    static MetadataList read(ByteBuffer byteBuffer) throws IOException {
        ByteBuffer newBuffer = byteBuffer.duplicate();
        ByteBufferReader reader = new ByteBufferReader(newBuffer);
        OffsetInfo offsetInfo = MetadataListReader.findOffsetInfo(reader);
        newBuffer.position((int)offsetInfo.getStartOffset());
        return MetadataList.getRootAsMetadataList(newBuffer);
    }

    static MetadataList read(AssetManager assetManager, String assetPath) throws IOException {
        try (InputStream inputStream = assetManager.open(assetPath);){
            MetadataList metadataList = MetadataListReader.read(inputStream);
            return metadataList;
        }
    }

    private static OffsetInfo findOffsetInfo(OpenTypeReader reader) throws IOException {
        reader.skip(4);
        int tableCount = reader.readUnsignedShort();
        if (tableCount > 100) {
            throw new IOException("Cannot read metadata.");
        }
        reader.skip(6);
        long metaOffset = -1L;
        for (int i = 0; i < tableCount; ++i) {
            int tag = reader.readTag();
            reader.skip(4);
            long offset = reader.readUnsignedInt();
            reader.skip(4);
            if (1835365473 != tag) continue;
            metaOffset = offset;
            break;
        }
        if (metaOffset != -1L) {
            reader.skip((int)(metaOffset - reader.getPosition()));
            reader.skip(12);
            long mapsCount = reader.readUnsignedInt();
            int i = 0;
            while ((long)i < mapsCount) {
                int tag = reader.readTag();
                long dataOffset = reader.readUnsignedInt();
                long dataLength = reader.readUnsignedInt();
                if (1164798569 == tag || 1701669481 == tag) {
                    return new OffsetInfo(dataOffset + metaOffset, dataLength);
                }
                ++i;
            }
        }
        throw new IOException("Cannot read metadata.");
    }

    static int toUnsignedShort(short value) {
        return value & 0xFFFF;
    }

    static long toUnsignedInt(int value) {
        return (long)value & 0xFFFFFFFFL;
    }

    private MetadataListReader() {
    }

    private static class ByteBufferReader
    implements OpenTypeReader {
        @NonNull
        private final ByteBuffer mByteBuffer;

        ByteBufferReader(@NonNull ByteBuffer byteBuffer) {
            this.mByteBuffer = byteBuffer;
            this.mByteBuffer.order(ByteOrder.BIG_ENDIAN);
        }

        @Override
        public int readUnsignedShort() throws IOException {
            return MetadataListReader.toUnsignedShort(this.mByteBuffer.getShort());
        }

        @Override
        public long readUnsignedInt() throws IOException {
            return MetadataListReader.toUnsignedInt(this.mByteBuffer.getInt());
        }

        @Override
        public int readTag() throws IOException {
            return this.mByteBuffer.getInt();
        }

        @Override
        public void skip(int numOfBytes) throws IOException {
            this.mByteBuffer.position(this.mByteBuffer.position() + numOfBytes);
        }

        @Override
        public long getPosition() {
            return this.mByteBuffer.position();
        }
    }

    private static class InputStreamOpenTypeReader
    implements OpenTypeReader {
        @NonNull
        private final byte[] mByteArray;
        @NonNull
        private final ByteBuffer mByteBuffer;
        @NonNull
        private final InputStream mInputStream;
        private long mPosition = 0L;

        InputStreamOpenTypeReader(@NonNull InputStream inputStream) {
            this.mInputStream = inputStream;
            this.mByteArray = new byte[4];
            this.mByteBuffer = ByteBuffer.wrap(this.mByteArray);
            this.mByteBuffer.order(ByteOrder.BIG_ENDIAN);
        }

        @Override
        public int readUnsignedShort() throws IOException {
            this.mByteBuffer.position(0);
            this.read(2);
            return MetadataListReader.toUnsignedShort(this.mByteBuffer.getShort());
        }

        @Override
        public long readUnsignedInt() throws IOException {
            this.mByteBuffer.position(0);
            this.read(4);
            return MetadataListReader.toUnsignedInt(this.mByteBuffer.getInt());
        }

        @Override
        public int readTag() throws IOException {
            this.mByteBuffer.position(0);
            this.read(4);
            return this.mByteBuffer.getInt();
        }

        @Override
        public void skip(int numOfBytes) throws IOException {
            while (numOfBytes > 0) {
                int skipped = (int)this.mInputStream.skip(numOfBytes);
                if (skipped < 1) {
                    throw new IOException("Skip didn't move at least 1 byte forward");
                }
                numOfBytes -= skipped;
                this.mPosition += (long)skipped;
            }
        }

        @Override
        public long getPosition() {
            return this.mPosition;
        }

        private void read(@IntRange(from=0L, to=4L) int numOfBytes) throws IOException {
            if (this.mInputStream.read(this.mByteArray, 0, numOfBytes) != numOfBytes) {
                throw new IOException("read failed");
            }
            this.mPosition += (long)numOfBytes;
        }
    }

    private static interface OpenTypeReader {
        public static final int UINT16_BYTE_COUNT = 2;
        public static final int UINT32_BYTE_COUNT = 4;

        public int readUnsignedShort() throws IOException;

        public long readUnsignedInt() throws IOException;

        public int readTag() throws IOException;

        public void skip(int var1) throws IOException;

        public long getPosition();
    }

    private static class OffsetInfo {
        private final long mStartOffset;
        private final long mLength;

        OffsetInfo(long startOffset, long length) {
            this.mStartOffset = startOffset;
            this.mLength = length;
        }

        long getStartOffset() {
            return this.mStartOffset;
        }

        long getLength() {
            return this.mLength;
        }
    }
}

