/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.CaptureBundle;
import androidx.camera.core.impl.CaptureStage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RequiresApi(value=21)
final class CaptureBundles {
    @NonNull
    static CaptureBundle singleDefaultCaptureBundle() {
        return CaptureBundles.createCaptureBundle(new CaptureStage.DefaultCaptureStage());
    }

    @NonNull
    static CaptureBundle createCaptureBundle(CaptureStage ... captureStages) {
        return new CaptureBundleImpl(Arrays.asList(captureStages));
    }

    @NonNull
    static CaptureBundle createCaptureBundle(@NonNull List<CaptureStage> captureStageList) {
        return new CaptureBundleImpl(captureStageList);
    }

    private CaptureBundles() {
    }

    static final class CaptureBundleImpl
    implements CaptureBundle {
        final List<CaptureStage> mCaptureStageList;

        CaptureBundleImpl(List<CaptureStage> captureStageList) {
            if (captureStageList == null || captureStageList.isEmpty()) {
                throw new IllegalArgumentException("Cannot set an empty CaptureStage list.");
            }
            this.mCaptureStageList = Collections.unmodifiableList(new ArrayList<CaptureStage>(captureStageList));
        }

        @Override
        public List<CaptureStage> getCaptureStages() {
            return this.mCaptureStageList;
        }
    }
}

