/*
 * Decompiled with CFR 0.152.
 */
package androidx.activity;

import android.annotation.SuppressLint;
import android.window.OnBackInvokedCallback;
import android.window.OnBackInvokedDispatcher;
import androidx.activity.Cancellable;
import androidx.activity.OnBackPressedCallback;
import androidx.annotation.DoNotInline;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.core.os.BuildCompat;
import androidx.core.util.Consumer;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import java.util.ArrayDeque;
import java.util.Iterator;

public final class OnBackPressedDispatcher {
    @Nullable
    private final Runnable mFallbackOnBackPressed;
    final ArrayDeque<OnBackPressedCallback> mOnBackPressedCallbacks = new ArrayDeque();
    private Consumer<Boolean> mEnabledConsumer;
    private OnBackInvokedCallback mOnBackInvokedCallback;
    private OnBackInvokedDispatcher mInvokedDispatcher;
    private boolean mBackInvokedCallbackRegistered = false;

    @RequiresApi(value=33)
    public void setOnBackInvokedDispatcher(@NonNull OnBackInvokedDispatcher invoker) {
        this.mInvokedDispatcher = invoker;
        this.updateBackInvokedCallbackState();
    }

    @RequiresApi(value=33)
    void updateBackInvokedCallbackState() {
        boolean shouldBeRegistered = this.hasEnabledCallbacks();
        if (this.mInvokedDispatcher != null) {
            if (shouldBeRegistered && !this.mBackInvokedCallbackRegistered) {
                Api33Impl.registerOnBackInvokedCallback(this.mInvokedDispatcher, 0, this.mOnBackInvokedCallback);
                this.mBackInvokedCallbackRegistered = true;
            } else if (!shouldBeRegistered && this.mBackInvokedCallbackRegistered) {
                Api33Impl.unregisterOnBackInvokedCallback(this.mInvokedDispatcher, this.mOnBackInvokedCallback);
                this.mBackInvokedCallbackRegistered = false;
            }
        }
    }

    public OnBackPressedDispatcher() {
        this(null);
    }

    @OptIn(markerClass={BuildCompat.PrereleaseSdkCheck.class})
    public OnBackPressedDispatcher(@Nullable Runnable fallbackOnBackPressed) {
        this.mFallbackOnBackPressed = fallbackOnBackPressed;
        if (BuildCompat.isAtLeastT()) {
            this.mEnabledConsumer = aBoolean -> {
                if (BuildCompat.isAtLeastT()) {
                    this.updateBackInvokedCallbackState();
                }
            };
            this.mOnBackInvokedCallback = Api33Impl.createOnBackInvokedCallback(this::onBackPressed);
        }
    }

    @MainThread
    public void addCallback(@NonNull OnBackPressedCallback onBackPressedCallback) {
        this.addCancellableCallback(onBackPressedCallback);
    }

    @OptIn(markerClass={BuildCompat.PrereleaseSdkCheck.class})
    @MainThread
    @NonNull
    Cancellable addCancellableCallback(@NonNull OnBackPressedCallback onBackPressedCallback) {
        this.mOnBackPressedCallbacks.add(onBackPressedCallback);
        OnBackPressedCancellable cancellable = new OnBackPressedCancellable(onBackPressedCallback);
        onBackPressedCallback.addCancellable(cancellable);
        if (BuildCompat.isAtLeastT()) {
            this.updateBackInvokedCallbackState();
            onBackPressedCallback.setIsEnabledConsumer(this.mEnabledConsumer);
        }
        return cancellable;
    }

    @OptIn(markerClass={BuildCompat.PrereleaseSdkCheck.class})
    @SuppressLint(value={"LambdaLast"})
    @MainThread
    public void addCallback(@NonNull LifecycleOwner owner, @NonNull OnBackPressedCallback onBackPressedCallback) {
        Lifecycle lifecycle = owner.getLifecycle();
        if (lifecycle.getCurrentState() == Lifecycle.State.DESTROYED) {
            return;
        }
        onBackPressedCallback.addCancellable(new LifecycleOnBackPressedCancellable(lifecycle, onBackPressedCallback));
        if (BuildCompat.isAtLeastT()) {
            this.updateBackInvokedCallbackState();
            onBackPressedCallback.setIsEnabledConsumer(this.mEnabledConsumer);
        }
    }

    @MainThread
    public boolean hasEnabledCallbacks() {
        Iterator<OnBackPressedCallback> iterator = this.mOnBackPressedCallbacks.descendingIterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isEnabled()) continue;
            return true;
        }
        return false;
    }

    @MainThread
    public void onBackPressed() {
        Iterator<OnBackPressedCallback> iterator = this.mOnBackPressedCallbacks.descendingIterator();
        while (iterator.hasNext()) {
            OnBackPressedCallback callback = iterator.next();
            if (!callback.isEnabled()) continue;
            callback.handleOnBackPressed();
            return;
        }
        if (this.mFallbackOnBackPressed != null) {
            this.mFallbackOnBackPressed.run();
        }
    }

    @RequiresApi(value=33)
    static class Api33Impl {
        private Api33Impl() {
        }

        @DoNotInline
        static void registerOnBackInvokedCallback(Object dispatcher, int priority, Object callback) {
            OnBackInvokedDispatcher onBackInvokedDispatcher = (OnBackInvokedDispatcher)dispatcher;
            OnBackInvokedCallback onBackInvokedCallback = (OnBackInvokedCallback)callback;
            onBackInvokedDispatcher.registerOnBackInvokedCallback(priority, onBackInvokedCallback);
        }

        @DoNotInline
        static void unregisterOnBackInvokedCallback(Object dispatcher, Object callback) {
            OnBackInvokedDispatcher onBackInvokedDispatcher = (OnBackInvokedDispatcher)dispatcher;
            OnBackInvokedCallback onBackInvokedCallback = (OnBackInvokedCallback)callback;
            onBackInvokedDispatcher.unregisterOnBackInvokedCallback(onBackInvokedCallback);
        }

        @DoNotInline
        static OnBackInvokedCallback createOnBackInvokedCallback(Runnable runnable) {
            return runnable::run;
        }
    }

    private class LifecycleOnBackPressedCancellable
    implements LifecycleEventObserver,
    Cancellable {
        private final Lifecycle mLifecycle;
        private final OnBackPressedCallback mOnBackPressedCallback;
        @Nullable
        private Cancellable mCurrentCancellable;

        LifecycleOnBackPressedCancellable(@NonNull Lifecycle lifecycle, OnBackPressedCallback onBackPressedCallback) {
            this.mLifecycle = lifecycle;
            this.mOnBackPressedCallback = onBackPressedCallback;
            lifecycle.addObserver((LifecycleObserver)this);
        }

        public void onStateChanged(@NonNull LifecycleOwner source, @NonNull Lifecycle.Event event) {
            if (event == Lifecycle.Event.ON_START) {
                this.mCurrentCancellable = OnBackPressedDispatcher.this.addCancellableCallback(this.mOnBackPressedCallback);
            } else if (event == Lifecycle.Event.ON_STOP) {
                if (this.mCurrentCancellable != null) {
                    this.mCurrentCancellable.cancel();
                }
            } else if (event == Lifecycle.Event.ON_DESTROY) {
                this.cancel();
            }
        }

        @Override
        public void cancel() {
            this.mLifecycle.removeObserver((LifecycleObserver)this);
            this.mOnBackPressedCallback.removeCancellable(this);
            if (this.mCurrentCancellable != null) {
                this.mCurrentCancellable.cancel();
                this.mCurrentCancellable = null;
            }
        }
    }

    private class OnBackPressedCancellable
    implements Cancellable {
        private final OnBackPressedCallback mOnBackPressedCallback;

        OnBackPressedCancellable(OnBackPressedCallback onBackPressedCallback) {
            this.mOnBackPressedCallback = onBackPressedCallback;
        }

        @Override
        @OptIn(markerClass={BuildCompat.PrereleaseSdkCheck.class})
        public void cancel() {
            OnBackPressedDispatcher.this.mOnBackPressedCallbacks.remove(this.mOnBackPressedCallback);
            this.mOnBackPressedCallback.removeCancellable(this);
            if (BuildCompat.isAtLeastT()) {
                this.mOnBackPressedCallback.setIsEnabledConsumer(null);
                OnBackPressedDispatcher.this.updateBackInvokedCallbackState();
            }
        }
    }
}

