/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.content.Context;
import org.apache.cordova.AllowList;
import org.apache.cordova.ConfigXmlParser;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CordovaPreferences;
import org.xmlpull.v1.XmlPullParser;

public class AllowListPlugin
extends CordovaPlugin {
    public static final String PLUGIN_NAME = "CordovaAllowListPlugin";
    protected static final String LOG_TAG = "CordovaAllowListPlugin";
    private AllowList allowedNavigations;
    private AllowList allowedIntents;
    private AllowList allowedRequests;

    public AllowListPlugin() {
    }

    public AllowListPlugin(Context context) {
        this(new AllowList(), new AllowList(), null);
        new CustomConfigXmlParser().parse(context);
    }

    public AllowListPlugin(XmlPullParser xmlParser) {
        this(new AllowList(), new AllowList(), null);
        new CustomConfigXmlParser().parse(xmlParser);
    }

    public AllowListPlugin(AllowList allowedNavigations, AllowList allowedIntents, AllowList allowedRequests) {
        if (allowedRequests == null) {
            allowedRequests = new AllowList();
            allowedRequests.addAllowListEntry("file:///*", false);
            allowedRequests.addAllowListEntry("data:*", false);
        }
        this.allowedNavigations = allowedNavigations;
        this.allowedIntents = allowedIntents;
        this.allowedRequests = allowedRequests;
    }

    @Override
    public void pluginInitialize() {
        if (this.allowedNavigations == null) {
            this.allowedNavigations = new AllowList();
            this.allowedIntents = new AllowList();
            this.allowedRequests = new AllowList();
            new CustomConfigXmlParser().parse(this.webView.getContext());
        }
    }

    @Override
    public Boolean shouldAllowNavigation(String url) {
        return this.allowedNavigations.isUrlAllowListed(url) ? Boolean.valueOf(true) : null;
    }

    @Override
    public Boolean shouldAllowRequest(String url) {
        return Boolean.TRUE.equals(this.shouldAllowNavigation(url)) || this.allowedRequests.isUrlAllowListed(url) ? Boolean.valueOf(true) : null;
    }

    @Override
    public Boolean shouldOpenExternalUrl(String url) {
        return this.allowedIntents.isUrlAllowListed(url) ? Boolean.valueOf(true) : null;
    }

    public AllowList getAllowedNavigations() {
        return this.allowedNavigations;
    }

    public void setAllowedNavigations(AllowList allowedNavigations) {
        this.allowedNavigations = allowedNavigations;
    }

    public AllowList getAllowedIntents() {
        return this.allowedIntents;
    }

    public void setAllowedIntents(AllowList allowedIntents) {
        this.allowedIntents = allowedIntents;
    }

    public AllowList getAllowedRequests() {
        return this.allowedRequests;
    }

    public void setAllowedRequests(AllowList allowedRequests) {
        this.allowedRequests = allowedRequests;
    }

    private class CustomConfigXmlParser
    extends ConfigXmlParser {
        private CordovaPreferences prefs = new CordovaPreferences();

        private CustomConfigXmlParser() {
        }

        @Override
        public void handleStartTag(XmlPullParser xml) {
            String origin;
            String strNode = xml.getName();
            if (strNode.equals("content")) {
                String startPage = xml.getAttributeValue(null, "src");
                AllowListPlugin.this.allowedNavigations.addAllowListEntry(startPage, false);
            } else if (strNode.equals("allow-navigation")) {
                String origin2 = xml.getAttributeValue(null, "href");
                if ("*".equals(origin2)) {
                    AllowListPlugin.this.allowedNavigations.addAllowListEntry("http://*/*", false);
                    AllowListPlugin.this.allowedNavigations.addAllowListEntry("https://*/*", false);
                    AllowListPlugin.this.allowedNavigations.addAllowListEntry("data:*", false);
                } else {
                    AllowListPlugin.this.allowedNavigations.addAllowListEntry(origin2, false);
                }
            } else if (strNode.equals("allow-intent")) {
                String origin3 = xml.getAttributeValue(null, "href");
                AllowListPlugin.this.allowedIntents.addAllowListEntry(origin3, false);
            } else if (strNode.equals("access") && (origin = xml.getAttributeValue(null, "origin")) != null) {
                if ("*".equals(origin)) {
                    AllowListPlugin.this.allowedRequests.addAllowListEntry("http://*/*", false);
                    AllowListPlugin.this.allowedRequests.addAllowListEntry("https://*/*", false);
                } else {
                    String subdomains = xml.getAttributeValue(null, "subdomains");
                    AllowListPlugin.this.allowedRequests.addAllowListEntry(origin, subdomains != null && subdomains.compareToIgnoreCase("true") == 0);
                }
            }
        }

        @Override
        public void handleEndTag(XmlPullParser xml) {
        }
    }
}

