/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.annotation.SuppressLint;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.widget.FrameLayout;
import java.lang.reflect.Constructor;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPreferences;
import org.apache.cordova.CordovaResourceApi;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.CordovaWebViewEngine;
import org.apache.cordova.CoreAndroid;
import org.apache.cordova.ICordovaCookieManager;
import org.apache.cordova.LOG;
import org.apache.cordova.NativeToJsMessageQueue;
import org.apache.cordova.PluginEntry;
import org.apache.cordova.PluginManager;
import org.apache.cordova.PluginResult;
import org.apache.cordova.engine.SystemWebViewEngine;
import org.json.JSONException;
import org.json.JSONObject;

public class CordovaWebViewImpl
implements CordovaWebView {
    public static final String TAG = "CordovaWebViewImpl";
    private PluginManager pluginManager;
    protected final CordovaWebViewEngine engine;
    private CordovaInterface cordova;
    private int loadUrlTimeout = 0;
    private CordovaResourceApi resourceApi;
    private CordovaPreferences preferences;
    private CoreAndroid appPlugin;
    private NativeToJsMessageQueue nativeToJsMessageQueue;
    private EngineClient engineClient = new EngineClient();
    private boolean hasPausedEver;
    String loadedUrl;
    private View mCustomView;
    private WebChromeClient.CustomViewCallback mCustomViewCallback;
    private Set<Integer> boundKeyCodes = new HashSet<Integer>();

    public static CordovaWebViewEngine createEngine(Context context, CordovaPreferences preferences) {
        String className = preferences.getString("webview", SystemWebViewEngine.class.getCanonicalName());
        try {
            Class<?> webViewClass = Class.forName(className);
            Constructor<?> constructor = webViewClass.getConstructor(Context.class, CordovaPreferences.class);
            return (CordovaWebViewEngine)constructor.newInstance(context, preferences);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create webview. ", e);
        }
    }

    public CordovaWebViewImpl(CordovaWebViewEngine cordovaWebViewEngine) {
        this.engine = cordovaWebViewEngine;
    }

    public void init(CordovaInterface cordova) {
        this.init(cordova, new ArrayList<PluginEntry>(), new CordovaPreferences());
    }

    @Override
    @SuppressLint(value={"Assert"})
    public void init(CordovaInterface cordova, List<PluginEntry> pluginEntries, CordovaPreferences preferences) {
        if (this.cordova != null) {
            throw new IllegalStateException();
        }
        this.cordova = cordova;
        this.preferences = preferences;
        this.pluginManager = new PluginManager(this, this.cordova, pluginEntries);
        this.resourceApi = new CordovaResourceApi(this.engine.getView().getContext(), this.pluginManager);
        this.nativeToJsMessageQueue = new NativeToJsMessageQueue();
        this.nativeToJsMessageQueue.addBridgeMode(new NativeToJsMessageQueue.NoOpBridgeMode());
        this.nativeToJsMessageQueue.addBridgeMode(new NativeToJsMessageQueue.LoadUrlBridgeMode(this.engine, cordova));
        if (preferences.getBoolean("DisallowOverscroll", false)) {
            this.engine.getView().setOverScrollMode(2);
        }
        this.engine.init(this, cordova, this.engineClient, this.resourceApi, this.pluginManager, this.nativeToJsMessageQueue);
        assert (this.engine.getView() instanceof CordovaWebViewEngine.EngineView);
        this.pluginManager.addService("CoreAndroid", "org.apache.cordova.CoreAndroid");
        this.pluginManager.init();
    }

    @Override
    public boolean isInitialized() {
        return this.cordova != null;
    }

    @Override
    public void loadUrlIntoView(final String url, boolean recreatePlugins) {
        LOG.d(TAG, ">>> loadUrl(" + url + ")");
        if (url.equals("about:blank") || url.startsWith("javascript:")) {
            this.engine.loadUrl(url, false);
            return;
        }
        boolean bl = recreatePlugins = recreatePlugins || this.loadedUrl == null;
        if (recreatePlugins) {
            if (this.loadedUrl != null) {
                this.appPlugin = null;
                this.pluginManager.init();
            }
            this.loadedUrl = url;
        }
        final int currentLoadUrlTimeout = this.loadUrlTimeout;
        final int loadUrlTimeoutValue = this.preferences.getInteger("LoadUrlTimeoutValue", 20000);
        final Runnable loadError = new Runnable(){

            @Override
            public void run() {
                CordovaWebViewImpl.this.stopLoading();
                LOG.e(CordovaWebViewImpl.TAG, "CordovaWebView: TIMEOUT ERROR!");
                JSONObject data = new JSONObject();
                try {
                    data.put("errorCode", -6);
                    data.put("description", (Object)"The connection to the server was unsuccessful.");
                    data.put("url", (Object)url);
                }
                catch (JSONException jSONException) {
                    // empty catch block
                }
                CordovaWebViewImpl.this.pluginManager.postMessage("onReceivedError", data);
            }
        };
        final Runnable timeoutCheck = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    2 var1_1 = this;
                    synchronized (var1_1) {
                        this.wait(loadUrlTimeoutValue);
                    }
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (CordovaWebViewImpl.this.loadUrlTimeout == currentLoadUrlTimeout && CordovaWebViewImpl.this.cordova.getActivity() != null) {
                    CordovaWebViewImpl.this.cordova.getActivity().runOnUiThread(loadError);
                } else if (CordovaWebViewImpl.this.cordova.getActivity() == null) {
                    LOG.d(CordovaWebViewImpl.TAG, "Cordova activity does not exist.");
                }
            }
        };
        if (this.cordova.getActivity() != null) {
            final boolean _recreatePlugins = recreatePlugins;
            this.cordova.getActivity().runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (loadUrlTimeoutValue > 0) {
                        CordovaWebViewImpl.this.cordova.getThreadPool().execute(timeoutCheck);
                    }
                    CordovaWebViewImpl.this.engine.loadUrl(url, _recreatePlugins);
                }
            });
        } else {
            LOG.d(TAG, "Cordova activity does not exist.");
        }
    }

    @Override
    public void loadUrl(String url) {
        this.loadUrlIntoView(url, true);
    }

    @Override
    public void showWebPage(String url, boolean openExternal, boolean clearHistory, Map<String, Object> params) {
        LOG.d(TAG, "showWebPage(%s, %b, %b, HashMap)", url, openExternal, clearHistory);
        if (clearHistory) {
            this.engine.clearHistory();
        }
        if (!openExternal) {
            if (this.pluginManager.shouldAllowNavigation(url)) {
                this.loadUrlIntoView(url, true);
                return;
            }
            LOG.w(TAG, "showWebPage: Refusing to load URL into webview since it is not in the <allow-navigation> allow list. URL=" + url);
            return;
        }
        if (!this.pluginManager.shouldOpenExternalUrl(url).booleanValue()) {
            LOG.w(TAG, "showWebPage: Refusing to send intent for URL since it is not in the <allow-intent> allow list. URL=" + url);
            return;
        }
        Intent intent = null;
        try {
            if (url.startsWith("intent://")) {
                intent = Intent.parseUri((String)url, (int)1);
            } else {
                intent = new Intent("android.intent.action.VIEW");
                intent.addCategory("android.intent.category.BROWSABLE");
                Uri uri = Uri.parse((String)url);
                if ("file".equals(uri.getScheme())) {
                    intent.setDataAndType(uri, this.resourceApi.getMimeType(uri));
                } else {
                    intent.setData(uri);
                }
            }
            if (this.cordova.getActivity() != null) {
                this.cordova.getActivity().startActivity(intent);
            } else {
                LOG.d(TAG, "Cordova activity does not exist.");
            }
        }
        catch (URISyntaxException e) {
            LOG.e(TAG, "Error parsing url " + url, e);
        }
        catch (ActivityNotFoundException e) {
            if (url.startsWith("intent://") && intent != null && intent.getStringExtra("browser_fallback_url") != null) {
                this.showWebPage(intent.getStringExtra("browser_fallback_url"), openExternal, clearHistory, params);
            }
            LOG.e(TAG, "Error loading url " + url, e);
        }
    }

    @Override
    @Deprecated
    public void showCustomView(View view, WebChromeClient.CustomViewCallback callback) {
        LOG.d(TAG, "showing Custom View");
        if (this.mCustomView != null) {
            callback.onCustomViewHidden();
            return;
        }
        WrapperView wrapperView = new WrapperView(this.getContext(), this.engine);
        wrapperView.addView(view);
        this.mCustomView = wrapperView;
        this.mCustomViewCallback = callback;
        ViewGroup parent = (ViewGroup)this.engine.getView().getParent();
        parent.addView((View)wrapperView, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 17));
        this.engine.getView().setVisibility(8);
        parent.setVisibility(0);
        parent.bringToFront();
    }

    @Override
    @Deprecated
    public void hideCustomView() {
        if (this.mCustomView == null) {
            return;
        }
        LOG.d(TAG, "Hiding Custom View");
        this.mCustomView.setVisibility(8);
        ViewGroup parent = (ViewGroup)this.engine.getView().getParent();
        parent.removeView(this.mCustomView);
        this.mCustomView = null;
        this.mCustomViewCallback.onCustomViewHidden();
        this.engine.getView().setVisibility(0);
        this.engine.getView().requestFocus();
    }

    @Override
    @Deprecated
    public boolean isCustomViewShowing() {
        return this.mCustomView != null;
    }

    @Override
    @Deprecated
    public void sendJavascript(String statement) {
        this.nativeToJsMessageQueue.addJavaScript(statement);
    }

    @Override
    public void sendPluginResult(PluginResult cr, String callbackId) {
        this.nativeToJsMessageQueue.addPluginResult(cr, callbackId);
    }

    @Override
    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Override
    public CordovaPreferences getPreferences() {
        return this.preferences;
    }

    @Override
    public ICordovaCookieManager getCookieManager() {
        return this.engine.getCookieManager();
    }

    @Override
    public CordovaResourceApi getResourceApi() {
        return this.resourceApi;
    }

    @Override
    public CordovaWebViewEngine getEngine() {
        return this.engine;
    }

    @Override
    public View getView() {
        return this.engine.getView();
    }

    @Override
    public Context getContext() {
        return this.engine.getView().getContext();
    }

    private void sendJavascriptEvent(String event) {
        if (this.appPlugin == null) {
            this.appPlugin = (CoreAndroid)this.pluginManager.getPlugin("CoreAndroid");
        }
        if (this.appPlugin == null) {
            LOG.w(TAG, "Unable to fire event without existing plugin");
            return;
        }
        this.appPlugin.fireJavascriptEvent(event);
    }

    @Override
    public void setButtonPlumbedToJs(int keyCode, boolean override) {
        switch (keyCode) {
            case 4: 
            case 24: 
            case 25: 
            case 82: {
                if (override) {
                    this.boundKeyCodes.add(keyCode);
                } else {
                    this.boundKeyCodes.remove(keyCode);
                }
                return;
            }
        }
        throw new IllegalArgumentException("Unsupported keycode: " + keyCode);
    }

    @Override
    public boolean isButtonPlumbedToJs(int keyCode) {
        return this.boundKeyCodes.contains(keyCode);
    }

    @Override
    public Object postMessage(String id2, Object data) {
        return this.pluginManager.postMessage(id2, data);
    }

    @Override
    public String getUrl() {
        return this.engine.getUrl();
    }

    @Override
    public void stopLoading() {
        ++this.loadUrlTimeout;
    }

    @Override
    public boolean canGoBack() {
        return this.engine.canGoBack();
    }

    @Override
    public void clearCache() {
        this.engine.clearCache();
    }

    @Override
    @Deprecated
    public void clearCache(boolean b) {
        this.engine.clearCache();
    }

    @Override
    public void clearHistory() {
        this.engine.clearHistory();
    }

    @Override
    public boolean backHistory() {
        return this.engine.goBack();
    }

    @Override
    public void onNewIntent(Intent intent) {
        if (this.pluginManager != null) {
            this.pluginManager.onNewIntent(intent);
        }
    }

    @Override
    public void handlePause(boolean keepRunning) {
        if (!this.isInitialized()) {
            return;
        }
        this.hasPausedEver = true;
        this.pluginManager.onPause(keepRunning);
        this.sendJavascriptEvent("pause");
        if (!keepRunning) {
            this.engine.setPaused(true);
        }
    }

    @Override
    public void handleResume(boolean keepRunning) {
        if (!this.isInitialized()) {
            return;
        }
        this.engine.setPaused(false);
        this.pluginManager.onResume(keepRunning);
        if (this.hasPausedEver) {
            this.sendJavascriptEvent("resume");
        }
    }

    @Override
    public void handleStart() {
        if (!this.isInitialized()) {
            return;
        }
        this.pluginManager.onStart();
    }

    @Override
    public void handleStop() {
        if (!this.isInitialized()) {
            return;
        }
        this.pluginManager.onStop();
    }

    @Override
    public void handleDestroy() {
        if (!this.isInitialized()) {
            return;
        }
        ++this.loadUrlTimeout;
        this.pluginManager.onDestroy();
        this.loadUrl("about:blank");
        this.engine.destroy();
        this.hideCustomView();
    }

    protected class EngineClient
    implements CordovaWebViewEngine.Client {
        protected EngineClient() {
        }

        @Override
        public void clearLoadTimeoutTimer() {
            CordovaWebViewImpl.this.loadUrlTimeout++;
        }

        @Override
        public void onPageStarted(String newUrl) {
            LOG.d(CordovaWebViewImpl.TAG, "onPageDidNavigate(" + newUrl + ")");
            CordovaWebViewImpl.this.boundKeyCodes.clear();
            CordovaWebViewImpl.this.pluginManager.onReset();
            CordovaWebViewImpl.this.pluginManager.postMessage("onPageStarted", newUrl);
        }

        @Override
        public void onReceivedError(int errorCode, String description, String failingUrl) {
            this.clearLoadTimeoutTimer();
            JSONObject data = new JSONObject();
            try {
                data.put("errorCode", errorCode);
                data.put("description", (Object)description);
                data.put("url", (Object)failingUrl);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            CordovaWebViewImpl.this.pluginManager.postMessage("onReceivedError", data);
        }

        @Override
        public void onPageFinishedLoading(String url) {
            LOG.d(CordovaWebViewImpl.TAG, "onPageFinished(" + url + ")");
            this.clearLoadTimeoutTimer();
            CordovaWebViewImpl.this.pluginManager.postMessage("onPageFinished", url);
            if (CordovaWebViewImpl.this.engine.getView().getVisibility() != 0) {
                Thread t = new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(2000L);
                            if (CordovaWebViewImpl.this.cordova.getActivity() != null) {
                                CordovaWebViewImpl.this.cordova.getActivity().runOnUiThread(new Runnable(){

                                    @Override
                                    public void run() {
                                        CordovaWebViewImpl.this.pluginManager.postMessage("spinner", "stop");
                                    }
                                });
                            } else {
                                LOG.d(CordovaWebViewImpl.TAG, "Cordova activity does not exist.");
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                });
                t.start();
            }
            if (url.equals("about:blank")) {
                CordovaWebViewImpl.this.pluginManager.postMessage("exit", null);
            }
        }

        @Override
        public Boolean onDispatchKeyEvent(KeyEvent event) {
            boolean isBackButton;
            int keyCode = event.getKeyCode();
            boolean bl = isBackButton = keyCode == 4;
            if (event.getAction() == 0) {
                if (isBackButton && CordovaWebViewImpl.this.mCustomView != null) {
                    return true;
                }
                if (CordovaWebViewImpl.this.boundKeyCodes.contains(keyCode)) {
                    return true;
                }
                if (isBackButton) {
                    return CordovaWebViewImpl.this.engine.canGoBack();
                }
            } else if (event.getAction() == 1) {
                if (isBackButton && CordovaWebViewImpl.this.mCustomView != null) {
                    CordovaWebViewImpl.this.hideCustomView();
                    return true;
                }
                if (CordovaWebViewImpl.this.boundKeyCodes.contains(keyCode)) {
                    String eventName = null;
                    switch (keyCode) {
                        case 25: {
                            eventName = "volumedownbutton";
                            break;
                        }
                        case 24: {
                            eventName = "volumeupbutton";
                            break;
                        }
                        case 84: {
                            eventName = "searchbutton";
                            break;
                        }
                        case 82: {
                            eventName = "menubutton";
                            break;
                        }
                        case 4: {
                            eventName = "backbutton";
                        }
                    }
                    if (eventName != null) {
                        CordovaWebViewImpl.this.sendJavascriptEvent(eventName);
                        return true;
                    }
                } else if (isBackButton) {
                    return CordovaWebViewImpl.this.engine.goBack();
                }
            }
            return null;
        }

        @Override
        public boolean onNavigationAttempt(String url) {
            if (CordovaWebViewImpl.this.pluginManager.onOverrideUrlLoading(url)) {
                return true;
            }
            if (CordovaWebViewImpl.this.pluginManager.shouldAllowNavigation(url)) {
                return false;
            }
            if (CordovaWebViewImpl.this.pluginManager.shouldOpenExternalUrl(url).booleanValue()) {
                CordovaWebViewImpl.this.showWebPage(url, true, false, null);
                return true;
            }
            LOG.w(CordovaWebViewImpl.TAG, "Blocked (possibly sub-frame) navigation to non-allowed URL: " + url);
            return true;
        }
    }

    private static class WrapperView
    extends FrameLayout {
        private final CordovaWebViewEngine engine;

        public WrapperView(Context context, CordovaWebViewEngine engine) {
            super(context);
            this.engine = engine;
        }

        public boolean dispatchKeyEvent(KeyEvent event) {
            boolean ret = this.engine.getView().dispatchKeyEvent(event);
            if (!ret) {
                ret = super.dispatchKeyEvent(event);
            }
            return ret;
        }
    }
}

