/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cordova;

import android.content.Intent;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Debug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.cordova.CallbackContext;
import org.apache.cordova.CordovaInterface;
import org.apache.cordova.CordovaPlugin;
import org.apache.cordova.CordovaPluginPathHandler;
import org.apache.cordova.CordovaWebView;
import org.apache.cordova.ICordovaClientCertRequest;
import org.apache.cordova.ICordovaHttpAuthHandler;
import org.apache.cordova.LOG;
import org.apache.cordova.PluginEntry;
import org.apache.cordova.PluginResult;
import org.json.JSONException;

public class PluginManager {
    private static String TAG = "PluginManager";
    private static String SCHEME_HTTPS = "https";
    private static String DEFAULT_HOSTNAME = "localhost";
    private static final int SLOW_EXEC_WARNING_THRESHOLD = Debug.isDebuggerConnected() ? 60 : 16;
    private final Map<String, CordovaPlugin> pluginMap = Collections.synchronizedMap(new LinkedHashMap());
    private final Map<String, PluginEntry> entryMap = Collections.synchronizedMap(new LinkedHashMap());
    private final CordovaInterface ctx;
    private final CordovaWebView app;
    private boolean isInitialized;
    private CordovaPlugin permissionRequester;

    public PluginManager(CordovaWebView cordovaWebView, CordovaInterface cordova, Collection<PluginEntry> pluginEntries) {
        this.ctx = cordova;
        this.app = cordovaWebView;
        this.setPluginEntries(pluginEntries);
    }

    public Collection<PluginEntry> getPluginEntries() {
        return this.entryMap.values();
    }

    public void setPluginEntries(Collection<PluginEntry> pluginEntries) {
        if (this.isInitialized) {
            this.onPause(false);
            this.onDestroy();
            this.pluginMap.clear();
            this.entryMap.clear();
        }
        for (PluginEntry entry : pluginEntries) {
            this.addService(entry);
        }
        if (this.isInitialized) {
            this.startupPlugins();
        }
    }

    public void init() {
        LOG.d(TAG, "init()");
        this.isInitialized = true;
        this.onPause(false);
        this.onDestroy();
        this.pluginMap.clear();
        this.startupPlugins();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startupPlugins() {
        Map<String, PluginEntry> map = this.entryMap;
        synchronized (map) {
            for (PluginEntry entry : this.entryMap.values()) {
                if (entry.onload) {
                    this.getPlugin(entry.service);
                    continue;
                }
                LOG.d(TAG, "startupPlugins: put - " + entry.service);
                this.pluginMap.put(entry.service, null);
            }
        }
    }

    public void exec(String service, String action, String callbackId, String rawArgs) {
        CordovaPlugin plugin = this.getPlugin(service);
        if (plugin == null) {
            LOG.d(TAG, "exec() call to unknown plugin: " + service);
            PluginResult cr = new PluginResult(PluginResult.Status.CLASS_NOT_FOUND_EXCEPTION);
            this.app.sendPluginResult(cr, callbackId);
            return;
        }
        CallbackContext callbackContext = new CallbackContext(callbackId, this.app);
        try {
            long pluginStartTime = System.currentTimeMillis();
            boolean wasValidAction = plugin.execute(action, rawArgs, callbackContext);
            long duration = System.currentTimeMillis() - pluginStartTime;
            if (duration > (long)SLOW_EXEC_WARNING_THRESHOLD) {
                LOG.w(TAG, "THREAD WARNING: exec() call to " + service + "." + action + " blocked the main thread for " + duration + "ms. Plugin should use CordovaInterface.getThreadPool().");
            }
            if (!wasValidAction) {
                PluginResult cr = new PluginResult(PluginResult.Status.INVALID_ACTION);
                callbackContext.sendPluginResult(cr);
            }
        }
        catch (JSONException e) {
            PluginResult cr = new PluginResult(PluginResult.Status.JSON_EXCEPTION);
            callbackContext.sendPluginResult(cr);
        }
        catch (Exception e) {
            LOG.e(TAG, "Uncaught exception from plugin", e);
            callbackContext.error(e.getMessage());
        }
    }

    public CordovaPlugin getPlugin(String service) {
        CordovaPlugin ret = this.pluginMap.get(service);
        if (ret == null) {
            PluginEntry pe = this.entryMap.get(service);
            if (pe == null) {
                return null;
            }
            ret = pe.plugin != null ? pe.plugin : this.instantiatePlugin(pe.pluginClass);
            ret.privateInitialize(service, this.ctx, this.app, this.app.getPreferences());
            LOG.d(TAG, "getPlugin - put: " + service);
            this.pluginMap.put(service, ret);
        }
        return ret;
    }

    public void addService(String service, String className) {
        PluginEntry entry = new PluginEntry(service, className, false);
        this.addService(entry);
    }

    public void addService(PluginEntry entry) {
        this.entryMap.put(entry.service, entry);
        if (entry.plugin != null) {
            entry.plugin.privateInitialize(entry.service, this.ctx, this.app, this.app.getPreferences());
            LOG.d(TAG, "addService: put - " + entry.service);
            this.pluginMap.put(entry.service, entry.plugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onPause(boolean multitasking) {
        Map<String, CordovaPlugin> map = this.pluginMap;
        synchronized (map) {
            for (CordovaPlugin plugin : this.pluginMap.values()) {
                if (plugin == null) continue;
                plugin.onPause(multitasking);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onReceivedHttpAuthRequest(CordovaWebView view, ICordovaHttpAuthHandler handler, String host, String realm) {
        Map<String, CordovaPlugin> map = this.pluginMap;
        synchronized (map) {
            for (CordovaPlugin plugin : this.pluginMap.values()) {
                if (plugin == null || !plugin.onReceivedHttpAuthRequest(this.app, handler, host, realm)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onReceivedClientCertRequest(CordovaWebView view, ICordovaClientCertRequest request) {
        Map<String, CordovaPlugin> map = this.pluginMap;
        synchronized (map) {
            for (CordovaPlugin plugin : this.pluginMap.values()) {
                if (plugin == null || !plugin.onReceivedClientCertRequest(this.app, request)) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onResume(boolean multitasking) {
        Map<String, CordovaPlugin> map = this.pluginMap;
        synchronized (map) {
            for (CordovaPlugin plugin : this.pluginMap.values()) {
                if (plugin == null) continue;
                plugin.onResume(multitasking);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStart() {
        Map<String, CordovaPlugin> map = this.pluginMap;
        synchronized (map) {
            for (CordovaPlugin plugin : this.pluginMap.values()) {
                if (plugin == null) continue;
                plugin.onStart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStop() {
        Map<String, CordovaPlugin> map = this.pluginMap;
        synchronized (map) {
            for (CordovaPlugin plugin : this.pluginMap.values()) {
                if (plugin == null) continue;
                plugin.onStop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        Map<String, CordovaPlugin> map = this.pluginMap;
        synchronized (map) {
            for (CordovaPlugin plugin : this.pluginMap.values()) {
                if (plugin == null) continue;
                plugin.onDestroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object postMessage(String id2, Object data) {
        LOG.d(TAG, "postMessage: " + id2);
        Map<String, CordovaPlugin> map = this.pluginMap;
        synchronized (map) {
            if (Build.VERSION.SDK_INT >= 24) {
                this.pluginMap.forEach((s, plugin) -> {
                    if (plugin != null) {
                        plugin.onMessage(id2, data);
                    }
                });
            } else {
                for (CordovaPlugin plugin2 : this.pluginMap.values()) {
                    Object obj;
                    if (plugin2 == null || (obj = plugin2.onMessage(id2, data)) == null) continue;
                    return obj;
                }
            }
        }
        return this.ctx.onMessage(id2, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNewIntent(Intent intent) {
        Map<String, CordovaPlugin> map = this.pluginMap;
        synchronized (map) {
            for (CordovaPlugin plugin : this.pluginMap.values()) {
                if (plugin == null) continue;
                plugin.onNewIntent(intent);
            }
        }
    }

    private String getLaunchUrlPrefix() {
        if (!this.app.getPreferences().getBoolean("AndroidInsecureFileModeEnabled", false)) {
            String scheme = this.app.getPreferences().getString("scheme", SCHEME_HTTPS).toLowerCase();
            String hostname = this.app.getPreferences().getString("hostname", DEFAULT_HOSTNAME);
            return scheme + "://" + hostname + '/';
        }
        return "file://";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldAllowRequest(String url) {
        Map<String, PluginEntry> map = this.entryMap;
        synchronized (map) {
            for (PluginEntry entry : this.entryMap.values()) {
                Boolean result;
                CordovaPlugin plugin = this.pluginMap.get(entry.service);
                if (plugin == null || (result = plugin.shouldAllowRequest(url)) == null) continue;
                return result;
            }
        }
        if (url.startsWith("blob:") || url.startsWith("data:") || url.startsWith("about:blank")) {
            return true;
        }
        if (url.startsWith("https://ssl.gstatic.com/accessibility/javascript/android/")) {
            return true;
        }
        if (url.startsWith("file://")) {
            return !url.contains("/app_webview/");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldAllowNavigation(String url) {
        Map<String, PluginEntry> map = this.entryMap;
        synchronized (map) {
            for (PluginEntry entry : this.entryMap.values()) {
                Boolean result;
                CordovaPlugin plugin = this.pluginMap.get(entry.service);
                if (plugin == null || (result = plugin.shouldAllowNavigation(url)) == null) continue;
                return result;
            }
        }
        return url.startsWith(this.getLaunchUrlPrefix()) || url.startsWith("about:blank");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldAllowBridgeAccess(String url) {
        Map<String, PluginEntry> map = this.entryMap;
        synchronized (map) {
            for (PluginEntry entry : this.entryMap.values()) {
                Boolean result;
                CordovaPlugin plugin = this.pluginMap.get(entry.service);
                if (plugin == null || (result = plugin.shouldAllowBridgeAccess(url)) == null) continue;
                return result;
            }
        }
        return url.startsWith(this.getLaunchUrlPrefix());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Boolean shouldOpenExternalUrl(String url) {
        Map<String, PluginEntry> map = this.entryMap;
        synchronized (map) {
            for (PluginEntry entry : this.entryMap.values()) {
                Boolean result;
                CordovaPlugin plugin = this.pluginMap.get(entry.service);
                if (plugin == null || (result = plugin.shouldOpenExternalUrl(url)) == null) continue;
                return result;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onOverrideUrlLoading(String url) {
        Map<String, PluginEntry> map = this.entryMap;
        synchronized (map) {
            for (PluginEntry entry : this.entryMap.values()) {
                CordovaPlugin plugin = this.pluginMap.get(entry.service);
                if (plugin == null || !plugin.onOverrideUrlLoading(url)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReset() {
        Map<String, CordovaPlugin> map = this.pluginMap;
        synchronized (map) {
            for (CordovaPlugin plugin : this.pluginMap.values()) {
                if (plugin == null) continue;
                plugin.onReset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Uri remapUri(Uri uri) {
        Map<String, CordovaPlugin> map = this.pluginMap;
        synchronized (map) {
            for (CordovaPlugin plugin : this.pluginMap.values()) {
                Uri ret;
                if (plugin == null || (ret = plugin.remapUri(uri)) == null) continue;
                return ret;
            }
        }
        return null;
    }

    private CordovaPlugin instantiatePlugin(String className) {
        CordovaPlugin ret = null;
        try {
            Class<?> c = null;
            if (className != null && !"".equals(className)) {
                c = Class.forName(className);
            }
            if (c != null & CordovaPlugin.class.isAssignableFrom(c)) {
                ret = (CordovaPlugin)c.newInstance();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error adding plugin " + className + ".");
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onConfigurationChanged(Configuration newConfig) {
        Map<String, CordovaPlugin> map = this.pluginMap;
        synchronized (map) {
            for (CordovaPlugin plugin : this.pluginMap.values()) {
                if (plugin == null) continue;
                plugin.onConfigurationChanged(newConfig);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle onSaveInstanceState() {
        Bundle state = new Bundle();
        Map<String, CordovaPlugin> map = this.pluginMap;
        synchronized (map) {
            for (CordovaPlugin plugin : this.pluginMap.values()) {
                Bundle pluginState;
                if (plugin == null || (pluginState = plugin.onSaveInstanceState()) == null) continue;
                state.putBundle(plugin.getServiceName(), pluginState);
            }
        }
        return state;
    }

    public ArrayList<CordovaPluginPathHandler> getPluginPathHandlers() {
        ArrayList<CordovaPluginPathHandler> handlers = new ArrayList<CordovaPluginPathHandler>();
        for (CordovaPlugin plugin : this.pluginMap.values()) {
            if (plugin == null || plugin.getPathHandler() == null) continue;
            handlers.add(plugin.getPathHandler());
        }
        return handlers;
    }
}

