/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;

@RequiresApi(value=21)
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class TransformUtils {
    public static final RectF NORMALIZED_RECT = new RectF(-1.0f, -1.0f, 1.0f, 1.0f);

    private TransformUtils() {
    }

    @NonNull
    public static Size rectToSize(@NonNull Rect rect) {
        return new Size(rect.width(), rect.height());
    }

    @NonNull
    public static RectF verticesToRect(@NonNull float[] vertices) {
        return new RectF(TransformUtils.min(vertices[0], vertices[2], vertices[4], vertices[6]), TransformUtils.min(vertices[1], vertices[3], vertices[5], vertices[7]), TransformUtils.max(vertices[0], vertices[2], vertices[4], vertices[6]), TransformUtils.max(vertices[1], vertices[3], vertices[5], vertices[7]));
    }

    public static float max(float value1, float value2, float value3, float value4) {
        return Math.max(Math.max(value1, value2), Math.max(value3, value4));
    }

    public static float min(float value1, float value2, float value3, float value4) {
        return Math.min(Math.min(value1, value2), Math.min(value3, value4));
    }

    public static int surfaceRotationToRotationDegrees(int rotationValue) {
        switch (rotationValue) {
            case 0: {
                return 0;
            }
            case 1: {
                return 90;
            }
            case 2: {
                return 180;
            }
            case 3: {
                return 270;
            }
        }
        throw new IllegalStateException("Unexpected rotation value " + rotationValue);
    }

    public static boolean is90or270(int rotationDegrees) {
        if (rotationDegrees == 90 || rotationDegrees == 270) {
            return true;
        }
        if (rotationDegrees == 0 || rotationDegrees == 180) {
            return false;
        }
        throw new IllegalArgumentException("Invalid rotation degrees: " + rotationDegrees);
    }

    @NonNull
    public static float[] sizeToVertices(@NonNull Size size) {
        return new float[]{0.0f, 0.0f, size.getWidth(), 0.0f, size.getWidth(), size.getHeight(), 0.0f, size.getHeight()};
    }

    @NonNull
    public static float[] rectToVertices(@NonNull RectF rectF) {
        return new float[]{rectF.left, rectF.top, rectF.right, rectF.top, rectF.right, rectF.bottom, rectF.left, rectF.bottom};
    }

    public static boolean isAspectRatioMatchingWithRoundingError(@NonNull Size size1, boolean isAccurate1, @NonNull Size size2, boolean isAccurate2) {
        float ratio2LowerBound;
        float ratio2UpperBound;
        float ratio1LowerBound;
        float ratio1UpperBound;
        if (isAccurate1) {
            ratio1LowerBound = ratio1UpperBound = (float)size1.getWidth() / (float)size1.getHeight();
        } else {
            ratio1UpperBound = ((float)size1.getWidth() + 1.0f) / ((float)size1.getHeight() - 1.0f);
            ratio1LowerBound = ((float)size1.getWidth() - 1.0f) / ((float)size1.getHeight() + 1.0f);
        }
        if (isAccurate2) {
            ratio2LowerBound = ratio2UpperBound = (float)size2.getWidth() / (float)size2.getHeight();
        } else {
            ratio2UpperBound = ((float)size2.getWidth() + 1.0f) / ((float)size2.getHeight() - 1.0f);
            ratio2LowerBound = ((float)size2.getWidth() - 1.0f) / ((float)size2.getHeight() + 1.0f);
        }
        return ratio1UpperBound >= ratio2LowerBound && ratio2UpperBound >= ratio1LowerBound;
    }

    @NonNull
    public static Matrix getRectToRect(@NonNull RectF source, @NonNull RectF target, int rotationDegrees) {
        Matrix matrix = new Matrix();
        matrix.setRectToRect(source, NORMALIZED_RECT, Matrix.ScaleToFit.FILL);
        matrix.postRotate((float)rotationDegrees);
        matrix.postConcat(TransformUtils.getNormalizedToBuffer(target));
        return matrix;
    }

    @NonNull
    public static Matrix getNormalizedToBuffer(@NonNull Rect viewPortRect) {
        return TransformUtils.getNormalizedToBuffer(new RectF(viewPortRect));
    }

    @NonNull
    private static Matrix getNormalizedToBuffer(@NonNull RectF viewPortRect) {
        Matrix normalizedToBuffer = new Matrix();
        normalizedToBuffer.setRectToRect(NORMALIZED_RECT, viewPortRect, Matrix.ScaleToFit.FILL);
        return normalizedToBuffer;
    }

    @NonNull
    public static Matrix getExifTransform(int exifOrientation, int width, int height) {
        Matrix matrix = new Matrix();
        RectF rect = new RectF(0.0f, 0.0f, (float)width, (float)height);
        matrix.setRectToRect(rect, NORMALIZED_RECT, Matrix.ScaleToFit.FILL);
        boolean isWidthHeightSwapped = false;
        switch (exifOrientation) {
            case 2: {
                matrix.postScale(-1.0f, 1.0f);
                break;
            }
            case 3: {
                matrix.postRotate(180.0f);
                break;
            }
            case 4: {
                matrix.postScale(1.0f, -1.0f);
                break;
            }
            case 5: {
                matrix.postScale(-1.0f, 1.0f);
                matrix.postRotate(270.0f);
                isWidthHeightSwapped = true;
                break;
            }
            case 6: {
                matrix.postRotate(90.0f);
                isWidthHeightSwapped = true;
                break;
            }
            case 7: {
                matrix.postScale(-1.0f, 1.0f);
                matrix.postRotate(90.0f);
                isWidthHeightSwapped = true;
                break;
            }
            case 8: {
                matrix.postRotate(270.0f);
                isWidthHeightSwapped = true;
                break;
            }
        }
        RectF restoredRect = isWidthHeightSwapped ? new RectF(0.0f, 0.0f, (float)height, (float)width) : rect;
        Matrix restore = new Matrix();
        restore.setRectToRect(NORMALIZED_RECT, restoredRect, Matrix.ScaleToFit.FILL);
        matrix.postConcat(restore);
        return matrix;
    }
}

