/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.core.impl;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.camera.core.impl.AutoValue_SurfaceConfig;
import com.google.auto.value.AutoValue;

@RequiresApi(value=21)
@AutoValue
public abstract class SurfaceConfig {
    SurfaceConfig() {
    }

    @NonNull
    public static SurfaceConfig create(@NonNull ConfigType type, @NonNull ConfigSize size) {
        return new AutoValue_SurfaceConfig(type, size);
    }

    @NonNull
    public abstract ConfigType getConfigType();

    @NonNull
    public abstract ConfigSize getConfigSize();

    public final boolean isSupported(@NonNull SurfaceConfig surfaceConfig) {
        boolean isSupported = false;
        ConfigType configType = surfaceConfig.getConfigType();
        ConfigSize configSize = surfaceConfig.getConfigSize();
        if (configSize.getId() <= this.getConfigSize().getId() && configType == this.getConfigType()) {
            isSupported = true;
        }
        return isSupported;
    }

    public static enum ConfigSize {
        ANALYSIS(0),
        PREVIEW(1),
        RECORD(2),
        MAXIMUM(3),
        NOT_SUPPORT(4);

        final int mId;

        private ConfigSize(int id) {
            this.mId = id;
        }

        int getId() {
            return this.mId;
        }
    }

    public static enum ConfigType {
        PRIV,
        YUV,
        JPEG,
        RAW;

    }
}

