/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.app;

import android.app.Notification;
import android.app.NotificationChannel;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.Build;
import android.provider.Settings;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.util.Preconditions;

public class NotificationChannelCompat {
    public static final String DEFAULT_CHANNEL_ID = "miscellaneous";
    private static final boolean DEFAULT_SHOW_BADGE = true;
    private static final int DEFAULT_LIGHT_COLOR = 0;
    @NonNull
    final String mId;
    CharSequence mName;
    int mImportance;
    String mDescription;
    String mGroupId;
    boolean mShowBadge = true;
    Uri mSound = Settings.System.DEFAULT_NOTIFICATION_URI;
    AudioAttributes mAudioAttributes;
    boolean mLights;
    int mLightColor = 0;
    boolean mVibrationEnabled;
    long[] mVibrationPattern;
    String mParentId;
    String mConversationId;
    private boolean mBypassDnd;
    private int mLockscreenVisibility;
    private boolean mCanBubble;
    private boolean mImportantConversation;

    NotificationChannelCompat(@NonNull String id2, int importance) {
        this.mId = Preconditions.checkNotNull(id2);
        this.mImportance = importance;
        if (Build.VERSION.SDK_INT >= 21) {
            this.mAudioAttributes = Notification.AUDIO_ATTRIBUTES_DEFAULT;
        }
    }

    @RequiresApi(value=26)
    NotificationChannelCompat(@NonNull NotificationChannel channel) {
        this(Api26Impl.getId(channel), Api26Impl.getImportance(channel));
        this.mName = Api26Impl.getName(channel);
        this.mDescription = Api26Impl.getDescription(channel);
        this.mGroupId = Api26Impl.getGroup(channel);
        this.mShowBadge = Api26Impl.canShowBadge(channel);
        this.mSound = Api26Impl.getSound(channel);
        this.mAudioAttributes = Api26Impl.getAudioAttributes(channel);
        this.mLights = Api26Impl.shouldShowLights(channel);
        this.mLightColor = Api26Impl.getLightColor(channel);
        this.mVibrationEnabled = Api26Impl.shouldVibrate(channel);
        this.mVibrationPattern = Api26Impl.getVibrationPattern(channel);
        if (Build.VERSION.SDK_INT >= 30) {
            this.mParentId = Api30Impl.getParentChannelId(channel);
            this.mConversationId = Api30Impl.getConversationId(channel);
        }
        this.mBypassDnd = Api26Impl.canBypassDnd(channel);
        this.mLockscreenVisibility = Api26Impl.getLockscreenVisibility(channel);
        if (Build.VERSION.SDK_INT >= 29) {
            this.mCanBubble = Api29Impl.canBubble(channel);
        }
        if (Build.VERSION.SDK_INT >= 30) {
            this.mImportantConversation = Api30Impl.isImportantConversation(channel);
        }
    }

    NotificationChannel getNotificationChannel() {
        if (Build.VERSION.SDK_INT < 26) {
            return null;
        }
        NotificationChannel channel = Api26Impl.createNotificationChannel(this.mId, this.mName, this.mImportance);
        Api26Impl.setDescription(channel, this.mDescription);
        Api26Impl.setGroup(channel, this.mGroupId);
        Api26Impl.setShowBadge(channel, this.mShowBadge);
        Api26Impl.setSound(channel, this.mSound, this.mAudioAttributes);
        Api26Impl.enableLights(channel, this.mLights);
        Api26Impl.setLightColor(channel, this.mLightColor);
        Api26Impl.setVibrationPattern(channel, this.mVibrationPattern);
        Api26Impl.enableVibration(channel, this.mVibrationEnabled);
        if (Build.VERSION.SDK_INT >= 30 && this.mParentId != null && this.mConversationId != null) {
            Api30Impl.setConversationId(channel, this.mParentId, this.mConversationId);
        }
        return channel;
    }

    @NonNull
    public Builder toBuilder() {
        return new Builder(this.mId, this.mImportance).setName(this.mName).setDescription(this.mDescription).setGroup(this.mGroupId).setShowBadge(this.mShowBadge).setSound(this.mSound, this.mAudioAttributes).setLightsEnabled(this.mLights).setLightColor(this.mLightColor).setVibrationEnabled(this.mVibrationEnabled).setVibrationPattern(this.mVibrationPattern).setConversationId(this.mParentId, this.mConversationId);
    }

    @NonNull
    public String getId() {
        return this.mId;
    }

    @Nullable
    public CharSequence getName() {
        return this.mName;
    }

    @Nullable
    public String getDescription() {
        return this.mDescription;
    }

    public int getImportance() {
        return this.mImportance;
    }

    @Nullable
    public Uri getSound() {
        return this.mSound;
    }

    @Nullable
    public AudioAttributes getAudioAttributes() {
        return this.mAudioAttributes;
    }

    public boolean shouldShowLights() {
        return this.mLights;
    }

    public int getLightColor() {
        return this.mLightColor;
    }

    public boolean shouldVibrate() {
        return this.mVibrationEnabled;
    }

    @Nullable
    public long[] getVibrationPattern() {
        return this.mVibrationPattern;
    }

    public boolean canShowBadge() {
        return this.mShowBadge;
    }

    @Nullable
    public String getGroup() {
        return this.mGroupId;
    }

    @Nullable
    public String getParentChannelId() {
        return this.mParentId;
    }

    @Nullable
    public String getConversationId() {
        return this.mConversationId;
    }

    public boolean canBypassDnd() {
        return this.mBypassDnd;
    }

    public int getLockscreenVisibility() {
        return this.mLockscreenVisibility;
    }

    public boolean canBubble() {
        return this.mCanBubble;
    }

    public boolean isImportantConversation() {
        return this.mImportantConversation;
    }

    @RequiresApi(value=26)
    static class Api26Impl {
        private Api26Impl() {
        }

        @DoNotInline
        static NotificationChannel createNotificationChannel(String id2, CharSequence name, int importance) {
            return new NotificationChannel(id2, name, importance);
        }

        @DoNotInline
        static String getId(NotificationChannel notificationChannel) {
            return notificationChannel.getId();
        }

        @DoNotInline
        static int getImportance(NotificationChannel notificationChannel) {
            return notificationChannel.getImportance();
        }

        @DoNotInline
        static CharSequence getName(NotificationChannel notificationChannel) {
            return notificationChannel.getName();
        }

        @DoNotInline
        static String getDescription(NotificationChannel notificationChannel) {
            return notificationChannel.getDescription();
        }

        @DoNotInline
        static void setDescription(NotificationChannel notificationChannel, String description) {
            notificationChannel.setDescription(description);
        }

        @DoNotInline
        static String getGroup(NotificationChannel notificationChannel) {
            return notificationChannel.getGroup();
        }

        @DoNotInline
        static void setGroup(NotificationChannel notificationChannel, String groupId) {
            notificationChannel.setGroup(groupId);
        }

        @DoNotInline
        static boolean canShowBadge(NotificationChannel notificationChannel) {
            return notificationChannel.canShowBadge();
        }

        @DoNotInline
        static void setShowBadge(NotificationChannel notificationChannel, boolean showBadge) {
            notificationChannel.setShowBadge(showBadge);
        }

        @DoNotInline
        static Uri getSound(NotificationChannel notificationChannel) {
            return notificationChannel.getSound();
        }

        @DoNotInline
        static void setSound(NotificationChannel notificationChannel, Uri sound, AudioAttributes audioAttributes) {
            notificationChannel.setSound(sound, audioAttributes);
        }

        @DoNotInline
        static AudioAttributes getAudioAttributes(NotificationChannel notificationChannel) {
            return notificationChannel.getAudioAttributes();
        }

        @DoNotInline
        static boolean shouldShowLights(NotificationChannel notificationChannel) {
            return notificationChannel.shouldShowLights();
        }

        @DoNotInline
        static void enableLights(NotificationChannel notificationChannel, boolean lights) {
            notificationChannel.enableLights(lights);
        }

        @DoNotInline
        static int getLightColor(NotificationChannel notificationChannel) {
            return notificationChannel.getLightColor();
        }

        @DoNotInline
        static void setLightColor(NotificationChannel notificationChannel, int argb) {
            notificationChannel.setLightColor(argb);
        }

        @DoNotInline
        static boolean shouldVibrate(NotificationChannel notificationChannel) {
            return notificationChannel.shouldVibrate();
        }

        @DoNotInline
        static void enableVibration(NotificationChannel notificationChannel, boolean vibration) {
            notificationChannel.enableVibration(vibration);
        }

        @DoNotInline
        static long[] getVibrationPattern(NotificationChannel notificationChannel) {
            return notificationChannel.getVibrationPattern();
        }

        @DoNotInline
        static void setVibrationPattern(NotificationChannel notificationChannel, long[] vibrationPattern) {
            notificationChannel.setVibrationPattern(vibrationPattern);
        }

        @DoNotInline
        static boolean canBypassDnd(NotificationChannel notificationChannel) {
            return notificationChannel.canBypassDnd();
        }

        @DoNotInline
        static int getLockscreenVisibility(NotificationChannel notificationChannel) {
            return notificationChannel.getLockscreenVisibility();
        }
    }

    @RequiresApi(value=30)
    static class Api30Impl {
        private Api30Impl() {
        }

        @DoNotInline
        static String getParentChannelId(NotificationChannel notificationChannel) {
            return notificationChannel.getParentChannelId();
        }

        @DoNotInline
        static String getConversationId(NotificationChannel notificationChannel) {
            return notificationChannel.getConversationId();
        }

        @DoNotInline
        static void setConversationId(NotificationChannel notificationChannel, String parentChannelId, String conversationId) {
            notificationChannel.setConversationId(parentChannelId, conversationId);
        }

        @DoNotInline
        static boolean isImportantConversation(NotificationChannel notificationChannel) {
            return notificationChannel.isImportantConversation();
        }
    }

    @RequiresApi(value=29)
    static class Api29Impl {
        private Api29Impl() {
        }

        @DoNotInline
        static boolean canBubble(NotificationChannel notificationChannel) {
            return notificationChannel.canBubble();
        }
    }

    public static class Builder {
        private final NotificationChannelCompat mChannel;

        public Builder(@NonNull String id2, int importance) {
            this.mChannel = new NotificationChannelCompat(id2, importance);
        }

        @NonNull
        public Builder setName(@Nullable CharSequence name) {
            this.mChannel.mName = name;
            return this;
        }

        @NonNull
        public Builder setImportance(int importance) {
            this.mChannel.mImportance = importance;
            return this;
        }

        @NonNull
        public Builder setDescription(@Nullable String description) {
            this.mChannel.mDescription = description;
            return this;
        }

        @NonNull
        public Builder setGroup(@Nullable String groupId) {
            this.mChannel.mGroupId = groupId;
            return this;
        }

        @NonNull
        public Builder setShowBadge(boolean showBadge) {
            this.mChannel.mShowBadge = showBadge;
            return this;
        }

        @NonNull
        public Builder setSound(@Nullable Uri sound, @Nullable AudioAttributes audioAttributes) {
            this.mChannel.mSound = sound;
            this.mChannel.mAudioAttributes = audioAttributes;
            return this;
        }

        @NonNull
        public Builder setLightsEnabled(boolean lights) {
            this.mChannel.mLights = lights;
            return this;
        }

        @NonNull
        public Builder setLightColor(int argb) {
            this.mChannel.mLightColor = argb;
            return this;
        }

        @NonNull
        public Builder setVibrationEnabled(boolean vibration) {
            this.mChannel.mVibrationEnabled = vibration;
            return this;
        }

        @NonNull
        public Builder setVibrationPattern(@Nullable long[] vibrationPattern) {
            this.mChannel.mVibrationEnabled = vibrationPattern != null && vibrationPattern.length > 0;
            this.mChannel.mVibrationPattern = vibrationPattern;
            return this;
        }

        @NonNull
        public Builder setConversationId(@NonNull String parentChannelId, @NonNull String conversationId) {
            if (Build.VERSION.SDK_INT >= 30) {
                this.mChannel.mParentId = parentChannelId;
                this.mChannel.mConversationId = conversationId;
            }
            return this;
        }

        @NonNull
        public NotificationChannelCompat build() {
            return this.mChannel;
        }
    }
}

