/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.graphics;

import android.graphics.BlendMode;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Xfermode;
import android.os.Build;
import androidx.annotation.DoNotInline;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.graphics.BlendModeCompat;
import androidx.core.graphics.BlendModeUtils;
import androidx.core.util.Pair;

public final class PaintCompat {
    private static final String TOFU_STRING = "\udb3f\udffd";
    private static final String EM_STRING = "m";
    private static final ThreadLocal<Pair<Rect, Rect>> sRectThreadLocal = new ThreadLocal();

    public static boolean hasGlyph(@NonNull Paint paint, @NonNull String string2) {
        if (Build.VERSION.SDK_INT >= 23) {
            return Api23Impl.hasGlyph(paint, string2);
        }
        int length = string2.length();
        if (length == 1 && Character.isWhitespace(string2.charAt(0))) {
            return true;
        }
        float missingGlyphWidth = paint.measureText(TOFU_STRING);
        float emGlyphWidth = paint.measureText(EM_STRING);
        float width = paint.measureText(string2);
        if (width == 0.0f) {
            return false;
        }
        if (string2.codePointCount(0, string2.length()) > 1) {
            int charCount;
            if (width > 2.0f * emGlyphWidth) {
                return false;
            }
            float sumWidth = 0.0f;
            for (int i = 0; i < length; i += charCount) {
                charCount = Character.charCount(string2.codePointAt(i));
                sumWidth += paint.measureText(string2, i, i + charCount);
            }
            if (width >= sumWidth) {
                return false;
            }
        }
        if (width != missingGlyphWidth) {
            return true;
        }
        Pair<Rect, Rect> rects = PaintCompat.obtainEmptyRects();
        paint.getTextBounds(TOFU_STRING, 0, TOFU_STRING.length(), (Rect)rects.first);
        paint.getTextBounds(string2, 0, length, (Rect)rects.second);
        return !((Rect)rects.first).equals(rects.second);
    }

    public static boolean setBlendMode(@NonNull Paint paint, @Nullable BlendModeCompat blendMode) {
        if (Build.VERSION.SDK_INT >= 29) {
            Object blendModePlatform = blendMode != null ? BlendModeUtils.Api29Impl.obtainBlendModeFromCompat(blendMode) : null;
            Api29Impl.setBlendMode(paint, blendModePlatform);
            return true;
        }
        if (blendMode != null) {
            PorterDuff.Mode mode = BlendModeUtils.obtainPorterDuffFromCompat(blendMode);
            paint.setXfermode((Xfermode)(mode != null ? new PorterDuffXfermode(mode) : null));
            return mode != null;
        }
        paint.setXfermode(null);
        return true;
    }

    private static Pair<Rect, Rect> obtainEmptyRects() {
        Pair<Rect, Rect> rects = sRectThreadLocal.get();
        if (rects == null) {
            rects = new Pair<Rect, Rect>(new Rect(), new Rect());
            sRectThreadLocal.set(rects);
        } else {
            ((Rect)rects.first).setEmpty();
            ((Rect)rects.second).setEmpty();
        }
        return rects;
    }

    private PaintCompat() {
    }

    @RequiresApi(value=23)
    static class Api23Impl {
        private Api23Impl() {
        }

        @DoNotInline
        static boolean hasGlyph(Paint paint, String string2) {
            return paint.hasGlyph(string2);
        }
    }

    @RequiresApi(value=29)
    static class Api29Impl {
        private Api29Impl() {
        }

        @DoNotInline
        static void setBlendMode(Paint paint, Object blendmode) {
            paint.setBlendMode((BlendMode)blendmode);
        }
    }
}

