/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.graphics;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.graphics.Typeface;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.core.content.res.FontResourcesParserCompat;
import androidx.core.graphics.TypefaceCompatBaseImpl;
import androidx.core.graphics.TypefaceCompatUtil;
import androidx.core.graphics.WeightTypefaceApi21;
import androidx.core.provider.FontsContractCompat;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP_PREFIX})
@RequiresApi(value=21)
class TypefaceCompatApi21Impl
extends TypefaceCompatBaseImpl {
    private static final String TAG = "TypefaceCompatApi21Impl";
    private static final String FONT_FAMILY_CLASS = "android.graphics.FontFamily";
    private static final String ADD_FONT_WEIGHT_STYLE_METHOD = "addFontWeightStyle";
    private static final String CREATE_FROM_FAMILIES_WITH_DEFAULT_METHOD = "createFromFamiliesWithDefault";
    private static Class<?> sFontFamily;
    private static Constructor<?> sFontFamilyCtor;
    private static Method sAddFontWeightStyle;
    private static Method sCreateFromFamiliesWithDefault;
    private static boolean sHasInitBeenCalled;

    TypefaceCompatApi21Impl() {
    }

    private static void init() {
        Method createFromFamiliesWithDefaultMethod;
        Method addFontMethod;
        Constructor<?> fontFamilyCtor;
        Class<?> fontFamilyClass;
        if (sHasInitBeenCalled) {
            return;
        }
        sHasInitBeenCalled = true;
        try {
            fontFamilyClass = Class.forName(FONT_FAMILY_CLASS);
            fontFamilyCtor = fontFamilyClass.getConstructor(new Class[0]);
            addFontMethod = fontFamilyClass.getMethod(ADD_FONT_WEIGHT_STYLE_METHOD, String.class, Integer.TYPE, Boolean.TYPE);
            Object familyArray = Array.newInstance(fontFamilyClass, 1);
            createFromFamiliesWithDefaultMethod = Typeface.class.getMethod(CREATE_FROM_FAMILIES_WITH_DEFAULT_METHOD, familyArray.getClass());
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            Log.e((String)TAG, (String)e.getClass().getName(), (Throwable)e);
            fontFamilyClass = null;
            fontFamilyCtor = null;
            addFontMethod = null;
            createFromFamiliesWithDefaultMethod = null;
        }
        sFontFamilyCtor = fontFamilyCtor;
        sFontFamily = fontFamilyClass;
        sAddFontWeightStyle = addFontMethod;
        sCreateFromFamiliesWithDefault = createFromFamiliesWithDefaultMethod;
    }

    private File getFile(@NonNull ParcelFileDescriptor fd) {
        try {
            String path = Os.readlink((String)("/proc/self/fd/" + fd.getFd()));
            if (OsConstants.S_ISREG((int)Os.stat((String)path).st_mode)) {
                return new File(path);
            }
            return null;
        }
        catch (ErrnoException e) {
            return null;
        }
    }

    private static Object newFamily() {
        TypefaceCompatApi21Impl.init();
        try {
            return sFontFamilyCtor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static Typeface createFromFamiliesWithDefault(Object family) {
        TypefaceCompatApi21Impl.init();
        try {
            Object familyArray = Array.newInstance(sFontFamily, 1);
            Array.set(familyArray, 0, family);
            return (Typeface)sCreateFromFamiliesWithDefault.invoke(null, familyArray);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean addFontWeightStyle(Object family, String name, int weight, boolean style2) {
        TypefaceCompatApi21Impl.init();
        try {
            Boolean result = (Boolean)sAddFontWeightStyle.invoke(family, name, weight, style2);
            return result;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Typeface createFromFontInfo(Context context, CancellationSignal cancellationSignal, @NonNull FontsContractCompat.FontInfo[] fonts, int style2) {
        if (fonts.length < 1) {
            return null;
        }
        FontsContractCompat.FontInfo bestFont = this.findBestInfo(fonts, style2);
        ContentResolver resolver = context.getContentResolver();
        try (ParcelFileDescriptor pfd = resolver.openFileDescriptor(bestFont.getUri(), "r", cancellationSignal);){
            if (pfd == null) {
                Typeface typeface = null;
                return typeface;
            }
            File file = this.getFile(pfd);
            if (file == null || !file.canRead()) {
                try (FileInputStream fis = new FileInputStream(pfd.getFileDescriptor());){
                    Typeface typeface = super.createFromInputStream(context, fis);
                    return typeface;
                }
            }
            Typeface typeface = Typeface.createFromFile((File)file);
            return typeface;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Typeface createFromFontFamilyFilesResourceEntry(Context context, FontResourcesParserCompat.FontFamilyFilesResourceEntry entry, Resources resources, int style2) {
        Object family = TypefaceCompatApi21Impl.newFamily();
        for (FontResourcesParserCompat.FontFileResourceEntry e : entry.getEntries()) {
            File tmpFile = TypefaceCompatUtil.getTempFile(context);
            if (tmpFile == null) {
                return null;
            }
            try {
                if (!TypefaceCompatUtil.copyToFile(tmpFile, resources, e.getResourceId())) {
                    Typeface typeface = null;
                    return typeface;
                }
                if (TypefaceCompatApi21Impl.addFontWeightStyle(family, tmpFile.getPath(), e.getWeight(), e.isItalic())) continue;
                Typeface typeface = null;
                return typeface;
            }
            catch (RuntimeException exception) {
                Typeface typeface = null;
                return typeface;
            }
            finally {
                tmpFile.delete();
            }
        }
        return TypefaceCompatApi21Impl.createFromFamiliesWithDefault(family);
    }

    @Override
    @NonNull
    Typeface createWeightStyle(@NonNull Context context, @NonNull Typeface base, int weight, boolean italic) {
        Typeface out = null;
        try {
            out = WeightTypefaceApi21.createWeightStyle(base, weight, italic);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (out == null) {
            out = super.createWeightStyle(context, base, weight, italic);
        }
        return out;
    }

    static {
        sHasInitBeenCalled = false;
    }
}

