/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2;

import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.RestrictTo;
import androidx.camera.camera2.internal.Camera2CameraFactory;
import androidx.camera.camera2.internal.Camera2DeviceSurfaceManager;
import androidx.camera.camera2.internal.Camera2UseCaseConfigFactory;
import androidx.camera.core.CameraUnavailableException;
import androidx.camera.core.CameraXConfig;
import androidx.camera.core.InitializationException;
import androidx.camera.core.impl.CameraDeviceSurfaceManager;
import androidx.camera.core.impl.CameraFactory;
import androidx.camera.core.impl.UseCaseConfigFactory;

@RequiresApi(value=21)
public final class Camera2Config {
    private Camera2Config() {
    }

    @NonNull
    public static CameraXConfig defaultConfig() {
        CameraFactory.Provider cameraFactoryProvider = Camera2CameraFactory::new;
        CameraDeviceSurfaceManager.Provider surfaceManagerProvider = (context, cameraManager, availableCameraIds) -> {
            try {
                return new Camera2DeviceSurfaceManager(context, cameraManager, availableCameraIds);
            }
            catch (CameraUnavailableException e) {
                throw new InitializationException((Throwable)e);
            }
        };
        UseCaseConfigFactory.Provider configFactoryProvider = context -> new Camera2UseCaseConfigFactory(context);
        CameraXConfig.Builder appConfigBuilder = new CameraXConfig.Builder().setCameraFactoryProvider(cameraFactoryProvider).setDeviceSurfaceManagerProvider(surfaceManagerProvider).setUseCaseConfigFactoryProvider(configFactoryProvider);
        return appConfigBuilder.build();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY})
    public static final class DefaultProvider
    implements CameraXConfig.Provider {
        @NonNull
        public CameraXConfig getCameraXConfig() {
            return Camera2Config.defaultConfig();
        }
    }
}

