/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.graphics.PointF;
import android.graphics.Rect;
import android.hardware.camera2.CaptureRequest;
import android.hardware.camera2.CaptureResult;
import android.hardware.camera2.params.MeteringRectangle;
import android.os.Build;
import android.util.Rational;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.internal.Camera2CameraControlImpl;
import androidx.camera.camera2.internal.compat.workaround.MeteringRegionCorrection;
import androidx.camera.core.CameraControl;
import androidx.camera.core.FocusMeteringAction;
import androidx.camera.core.FocusMeteringResult;
import androidx.camera.core.MeteringPoint;
import androidx.camera.core.impl.CameraCaptureCallback;
import androidx.camera.core.impl.CameraCaptureFailure;
import androidx.camera.core.impl.CameraCaptureResult;
import androidx.camera.core.impl.CameraControlInternal;
import androidx.camera.core.impl.CaptureConfig;
import androidx.camera.core.impl.Config;
import androidx.camera.core.impl.Quirks;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@RequiresApi(value=21)
class FocusMeteringControl {
    private static final String TAG = "FocusMeteringControl";
    private final Camera2CameraControlImpl mCameraControl;
    final Executor mExecutor;
    private final ScheduledExecutorService mScheduler;
    private volatile boolean mIsActive = false;
    private volatile Rational mPreviewAspectRatio = null;
    private static final MeteringRectangle[] EMPTY_RECTANGLES = new MeteringRectangle[0];
    @NonNull
    private final MeteringRegionCorrection mMeteringRegionCorrection;
    private boolean mIsInAfAutoMode = false;
    @NonNull
    Integer mCurrentAfState = 0;
    private ScheduledFuture<?> mAutoCancelHandle;
    long mFocusTimeoutCounter = 0L;
    boolean mIsAutoFocusCompleted = false;
    boolean mIsFocusSuccessful = false;
    private int mTemplate = 1;
    private Camera2CameraControlImpl.CaptureResultListener mSessionListenerForFocus = null;
    private Camera2CameraControlImpl.CaptureResultListener mSessionListenerForCancel = null;
    private MeteringRectangle[] mAfRects = EMPTY_RECTANGLES;
    private MeteringRectangle[] mAeRects = EMPTY_RECTANGLES;
    private MeteringRectangle[] mAwbRects = EMPTY_RECTANGLES;
    CallbackToFutureAdapter.Completer<FocusMeteringResult> mRunningActionCompleter = null;
    CallbackToFutureAdapter.Completer<Void> mRunningCancelCompleter = null;

    FocusMeteringControl(@NonNull Camera2CameraControlImpl cameraControl, @NonNull ScheduledExecutorService scheduler, @NonNull Executor executor, @NonNull Quirks cameraQuirks) {
        this.mCameraControl = cameraControl;
        this.mExecutor = executor;
        this.mScheduler = scheduler;
        this.mMeteringRegionCorrection = new MeteringRegionCorrection(cameraQuirks);
    }

    void setActive(boolean isActive) {
        if (isActive == this.mIsActive) {
            return;
        }
        this.mIsActive = isActive;
        if (!this.mIsActive) {
            this.cancelFocusAndMeteringWithoutAsyncResult();
        }
    }

    public void setPreviewAspectRatio(@Nullable Rational previewAspectRatio) {
        this.mPreviewAspectRatio = previewAspectRatio;
    }

    private Rational getDefaultAspectRatio() {
        if (this.mPreviewAspectRatio != null) {
            return this.mPreviewAspectRatio;
        }
        Rect cropSensorRegion = this.mCameraControl.getCropSensorRegion();
        Rational cropRegionAspectRatio = new Rational(cropSensorRegion.width(), cropSensorRegion.height());
        return cropRegionAspectRatio;
    }

    void setTemplate(int template) {
        this.mTemplate = template;
    }

    void addFocusMeteringOptions(@NonNull Camera2ImplConfig.Builder configBuilder) {
        int afMode = this.mIsInAfAutoMode ? 1 : this.getDefaultAfMode();
        configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AF_MODE, this.mCameraControl.getSupportedAfMode(afMode));
        if (this.mAfRects.length != 0) {
            configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AF_REGIONS, this.mAfRects);
        }
        if (this.mAeRects.length != 0) {
            configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AE_REGIONS, this.mAeRects);
        }
        if (this.mAwbRects.length != 0) {
            configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AWB_REGIONS, this.mAwbRects);
        }
    }

    private static boolean isValid(@NonNull MeteringPoint pt) {
        return pt.getX() >= 0.0f && pt.getX() <= 1.0f && pt.getY() >= 0.0f && pt.getY() <= 1.0f;
    }

    private static PointF getFovAdjustedPoint(@NonNull MeteringPoint meteringPoint, @NonNull Rational cropRegionAspectRatio, @NonNull Rational defaultAspectRatio, int meteringMode, MeteringRegionCorrection correction) {
        Rational fovAspectRatio = defaultAspectRatio;
        if (meteringPoint.getSurfaceAspectRatio() != null) {
            fovAspectRatio = meteringPoint.getSurfaceAspectRatio();
        }
        PointF adjustedPoint = correction.getCorrectedPoint(meteringPoint, meteringMode);
        if (!fovAspectRatio.equals((Object)cropRegionAspectRatio)) {
            if (fovAspectRatio.compareTo(cropRegionAspectRatio) > 0) {
                float heightOfCropRegion = (float)(fovAspectRatio.doubleValue() / cropRegionAspectRatio.doubleValue());
                float top_padding = (float)(((double)heightOfCropRegion - 1.0) / 2.0);
                adjustedPoint.y = (top_padding + adjustedPoint.y) * (1.0f / heightOfCropRegion);
            } else {
                float widthOfCropRegion = (float)(cropRegionAspectRatio.doubleValue() / fovAspectRatio.doubleValue());
                float left_padding = (float)(((double)widthOfCropRegion - 1.0) / 2.0);
                adjustedPoint.x = (left_padding + adjustedPoint.x) * (1.0f / widthOfCropRegion);
            }
        }
        return adjustedPoint;
    }

    private static MeteringRectangle getMeteringRect(MeteringPoint meteringPoint, PointF adjustedPoint, Rect cropRegion) {
        int centerX = (int)((float)cropRegion.left + adjustedPoint.x * (float)cropRegion.width());
        int centerY = (int)((float)cropRegion.top + adjustedPoint.y * (float)cropRegion.height());
        int width = (int)(meteringPoint.getSize() * (float)cropRegion.width());
        int height = (int)(meteringPoint.getSize() * (float)cropRegion.height());
        Rect focusRect = new Rect(centerX - width / 2, centerY - height / 2, centerX + width / 2, centerY + height / 2);
        focusRect.left = FocusMeteringControl.rangeLimit(focusRect.left, cropRegion.right, cropRegion.left);
        focusRect.right = FocusMeteringControl.rangeLimit(focusRect.right, cropRegion.right, cropRegion.left);
        focusRect.top = FocusMeteringControl.rangeLimit(focusRect.top, cropRegion.bottom, cropRegion.top);
        focusRect.bottom = FocusMeteringControl.rangeLimit(focusRect.bottom, cropRegion.bottom, cropRegion.top);
        return new MeteringRectangle(focusRect, 1000);
    }

    private static int rangeLimit(int val, int max, int min) {
        return Math.min(Math.max(val, min), max);
    }

    ListenableFuture<FocusMeteringResult> startFocusAndMetering(@NonNull FocusMeteringAction action) {
        return CallbackToFutureAdapter.getFuture(completer -> {
            this.mExecutor.execute(() -> this.startFocusAndMeteringInternal((CallbackToFutureAdapter.Completer<FocusMeteringResult>)completer, action));
            return "startFocusAndMetering";
        });
    }

    @NonNull
    private List<MeteringRectangle> getMeteringRectangles(@NonNull List<MeteringPoint> meteringPoints, int maxRegionCount, @NonNull Rational defaultAspectRatio, @NonNull Rect cropSensorRegion, int meteringMode) {
        if (meteringPoints.isEmpty() || maxRegionCount == 0) {
            return Collections.emptyList();
        }
        ArrayList<MeteringRectangle> meteringRectanglesList = new ArrayList<MeteringRectangle>();
        Rational cropRegionAspectRatio = new Rational(cropSensorRegion.width(), cropSensorRegion.height());
        for (MeteringPoint meteringPoint : meteringPoints) {
            PointF adjustedPoint;
            MeteringRectangle meteringRectangle;
            if (meteringRectanglesList.size() == maxRegionCount) break;
            if (!FocusMeteringControl.isValid(meteringPoint) || (meteringRectangle = FocusMeteringControl.getMeteringRect(meteringPoint, adjustedPoint = FocusMeteringControl.getFovAdjustedPoint(meteringPoint, cropRegionAspectRatio, defaultAspectRatio, meteringMode, this.mMeteringRegionCorrection), cropSensorRegion)).getWidth() == 0 || meteringRectangle.getHeight() == 0) continue;
            meteringRectanglesList.add(meteringRectangle);
        }
        return Collections.unmodifiableList(meteringRectanglesList);
    }

    void startFocusAndMeteringInternal(@NonNull CallbackToFutureAdapter.Completer<FocusMeteringResult> completer, @NonNull FocusMeteringAction action) {
        if (!this.mIsActive) {
            completer.setException((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
            return;
        }
        Rect cropSensorRegion = this.mCameraControl.getCropSensorRegion();
        Rational defaultAspectRatio = this.getDefaultAspectRatio();
        List<MeteringRectangle> rectanglesAf = this.getMeteringRectangles(action.getMeteringPointsAf(), this.mCameraControl.getMaxAfRegionCount(), defaultAspectRatio, cropSensorRegion, 1);
        List<MeteringRectangle> rectanglesAe = this.getMeteringRectangles(action.getMeteringPointsAe(), this.mCameraControl.getMaxAeRegionCount(), defaultAspectRatio, cropSensorRegion, 2);
        List<MeteringRectangle> rectanglesAwb = this.getMeteringRectangles(action.getMeteringPointsAwb(), this.mCameraControl.getMaxAwbRegionCount(), defaultAspectRatio, cropSensorRegion, 4);
        if (rectanglesAf.isEmpty() && rectanglesAe.isEmpty() && rectanglesAwb.isEmpty()) {
            completer.setException((Throwable)new IllegalArgumentException("None of the specified AF/AE/AWB MeteringPoints is supported on this camera."));
            return;
        }
        this.failActionFuture("Cancelled by another startFocusAndMetering()");
        this.failCancelFuture("Cancelled by another startFocusAndMetering()");
        this.disableAutoCancel();
        this.mRunningActionCompleter = completer;
        this.executeMeteringAction(rectanglesAf.toArray(EMPTY_RECTANGLES), rectanglesAe.toArray(EMPTY_RECTANGLES), rectanglesAwb.toArray(EMPTY_RECTANGLES), action);
    }

    void triggerAf(final @Nullable CallbackToFutureAdapter.Completer<CameraCaptureResult> completer, boolean overrideAeMode) {
        if (!this.mIsActive) {
            if (completer != null) {
                completer.setException((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
            }
            return;
        }
        CaptureConfig.Builder builder = new CaptureConfig.Builder();
        builder.setTemplateType(this.mTemplate);
        builder.setUseRepeatingSurface(true);
        Camera2ImplConfig.Builder configBuilder = new Camera2ImplConfig.Builder();
        configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AF_TRIGGER, 1);
        if (overrideAeMode) {
            configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AE_MODE, this.mCameraControl.getSupportedAeMode(1));
        }
        builder.addImplementationOptions((Config)configBuilder.build());
        builder.addCameraCaptureCallback(new CameraCaptureCallback(){

            public void onCaptureCompleted(@NonNull CameraCaptureResult cameraCaptureResult) {
                if (completer != null) {
                    completer.set((Object)cameraCaptureResult);
                }
            }

            public void onCaptureFailed(@NonNull CameraCaptureFailure failure) {
                if (completer != null) {
                    completer.setException((Throwable)new CameraControlInternal.CameraControlException(failure));
                }
            }

            public void onCaptureCancelled() {
                if (completer != null) {
                    completer.setException((Throwable)new CameraControl.OperationCanceledException("Camera is closed"));
                }
            }
        });
        this.mCameraControl.submitCaptureRequestsInternal(Collections.singletonList(builder.build()));
    }

    void triggerAePrecapture(final @Nullable CallbackToFutureAdapter.Completer<Void> completer) {
        if (!this.mIsActive) {
            if (completer != null) {
                completer.setException((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
            }
            return;
        }
        CaptureConfig.Builder builder = new CaptureConfig.Builder();
        builder.setTemplateType(this.mTemplate);
        builder.setUseRepeatingSurface(true);
        Camera2ImplConfig.Builder configBuilder = new Camera2ImplConfig.Builder();
        configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, 1);
        builder.addImplementationOptions((Config)configBuilder.build());
        builder.addCameraCaptureCallback(new CameraCaptureCallback(){

            public void onCaptureCompleted(@NonNull CameraCaptureResult cameraCaptureResult) {
                if (completer != null) {
                    completer.set(null);
                }
            }

            public void onCaptureFailed(@NonNull CameraCaptureFailure failure) {
                if (completer != null) {
                    completer.setException((Throwable)new CameraControlInternal.CameraControlException(failure));
                }
            }

            public void onCaptureCancelled() {
                if (completer != null) {
                    completer.setException((Throwable)new CameraControl.OperationCanceledException("Camera is closed"));
                }
            }
        });
        this.mCameraControl.submitCaptureRequestsInternal(Collections.singletonList(builder.build()));
    }

    void cancelAfAeTrigger(boolean cancelAfTrigger, boolean cancelAePrecaptureTrigger) {
        if (!this.mIsActive) {
            return;
        }
        CaptureConfig.Builder builder = new CaptureConfig.Builder();
        builder.setUseRepeatingSurface(true);
        builder.setTemplateType(this.mTemplate);
        Camera2ImplConfig.Builder configBuilder = new Camera2ImplConfig.Builder();
        if (cancelAfTrigger) {
            configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AF_TRIGGER, 2);
        }
        if (Build.VERSION.SDK_INT >= 23 && cancelAePrecaptureTrigger) {
            configBuilder.setCaptureRequestOption(CaptureRequest.CONTROL_AE_PRECAPTURE_TRIGGER, 2);
        }
        builder.addImplementationOptions((Config)configBuilder.build());
        this.mCameraControl.submitCaptureRequestsInternal(Collections.singletonList(builder.build()));
    }

    private void disableAutoCancel() {
        if (this.mAutoCancelHandle != null) {
            this.mAutoCancelHandle.cancel(true);
            this.mAutoCancelHandle = null;
        }
    }

    @VisibleForTesting
    int getDefaultAfMode() {
        switch (this.mTemplate) {
            case 3: {
                return 3;
            }
        }
        return 4;
    }

    private boolean isAfModeSupported() {
        return this.mCameraControl.getSupportedAfMode(1) == 1;
    }

    private void completeActionFuture(boolean isFocusSuccessful) {
        if (this.mRunningActionCompleter != null) {
            this.mRunningActionCompleter.set((Object)FocusMeteringResult.create((boolean)isFocusSuccessful));
            this.mRunningActionCompleter = null;
        }
    }

    private void failActionFuture(String message) {
        this.mCameraControl.removeCaptureResultListener(this.mSessionListenerForFocus);
        if (this.mRunningActionCompleter != null) {
            this.mRunningActionCompleter.setException((Throwable)new CameraControl.OperationCanceledException(message));
            this.mRunningActionCompleter = null;
        }
    }

    private void failCancelFuture(String message) {
        this.mCameraControl.removeCaptureResultListener(this.mSessionListenerForCancel);
        if (this.mRunningCancelCompleter != null) {
            this.mRunningCancelCompleter.setException((Throwable)new CameraControl.OperationCanceledException(message));
            this.mRunningCancelCompleter = null;
        }
    }

    private void completeCancelFuture() {
        if (this.mRunningCancelCompleter != null) {
            this.mRunningCancelCompleter.set(null);
            this.mRunningCancelCompleter = null;
        }
    }

    private void executeMeteringAction(@NonNull MeteringRectangle[] afRects, @NonNull MeteringRectangle[] aeRects, @NonNull MeteringRectangle[] awbRects, FocusMeteringAction focusMeteringAction) {
        long sessionUpdateId;
        this.mCameraControl.removeCaptureResultListener(this.mSessionListenerForFocus);
        this.disableAutoCancel();
        this.mAfRects = afRects;
        this.mAeRects = aeRects;
        this.mAwbRects = awbRects;
        if (this.shouldTriggerAF()) {
            this.mIsInAfAutoMode = true;
            this.mIsAutoFocusCompleted = false;
            this.mIsFocusSuccessful = false;
            sessionUpdateId = this.mCameraControl.updateSessionConfigSynchronous();
            this.triggerAf(null, true);
        } else {
            this.mIsInAfAutoMode = false;
            this.mIsAutoFocusCompleted = true;
            this.mIsFocusSuccessful = false;
            sessionUpdateId = this.mCameraControl.updateSessionConfigSynchronous();
        }
        this.mCurrentAfState = 0;
        boolean isAfModeSupported = this.isAfModeSupported();
        this.mSessionListenerForFocus = result -> {
            Integer afState = (Integer)result.get(CaptureResult.CONTROL_AF_STATE);
            if (this.shouldTriggerAF()) {
                if (!isAfModeSupported || afState == null) {
                    this.mIsFocusSuccessful = true;
                    this.mIsAutoFocusCompleted = true;
                } else if (this.mCurrentAfState == 3) {
                    if (afState == 4) {
                        this.mIsFocusSuccessful = true;
                        this.mIsAutoFocusCompleted = true;
                    } else if (afState == 5) {
                        this.mIsFocusSuccessful = false;
                        this.mIsAutoFocusCompleted = true;
                    }
                }
            }
            if (this.mIsAutoFocusCompleted && Camera2CameraControlImpl.isSessionUpdated(result, sessionUpdateId)) {
                this.completeActionFuture(this.mIsFocusSuccessful);
                return true;
            }
            if (!this.mCurrentAfState.equals(afState) && afState != null) {
                this.mCurrentAfState = afState;
            }
            return false;
        };
        this.mCameraControl.addCaptureResultListener(this.mSessionListenerForFocus);
        if (focusMeteringAction.isAutoCancelEnabled()) {
            long timeoutId = ++this.mFocusTimeoutCounter;
            Runnable autoCancelRunnable = () -> this.mExecutor.execute(() -> {
                if (timeoutId == this.mFocusTimeoutCounter) {
                    this.cancelFocusAndMeteringWithoutAsyncResult();
                }
            });
            this.mAutoCancelHandle = this.mScheduler.schedule(autoCancelRunnable, focusMeteringAction.getAutoCancelDurationInMillis(), TimeUnit.MILLISECONDS);
        }
    }

    private boolean shouldTriggerAF() {
        return this.mAfRects.length > 0;
    }

    ListenableFuture<Void> cancelFocusAndMetering() {
        return CallbackToFutureAdapter.getFuture(completer -> {
            this.mExecutor.execute(() -> this.cancelFocusAndMeteringInternal((CallbackToFutureAdapter.Completer<Void>)completer));
            return "cancelFocusAndMetering";
        });
    }

    void cancelFocusAndMeteringWithoutAsyncResult() {
        this.cancelFocusAndMeteringInternal(null);
    }

    void cancelFocusAndMeteringInternal(@Nullable CallbackToFutureAdapter.Completer<Void> completer) {
        this.failCancelFuture("Cancelled by another cancelFocusAndMetering()");
        this.failActionFuture("Cancelled by cancelFocusAndMetering()");
        this.mRunningCancelCompleter = completer;
        this.disableAutoCancel();
        if (this.shouldTriggerAF()) {
            this.cancelAfAeTrigger(true, false);
        }
        this.mAfRects = EMPTY_RECTANGLES;
        this.mAeRects = EMPTY_RECTANGLES;
        this.mAwbRects = EMPTY_RECTANGLES;
        this.mIsInAfAutoMode = false;
        long sessionUpdateId = this.mCameraControl.updateSessionConfigSynchronous();
        if (this.mRunningCancelCompleter != null) {
            int targetAfMode = this.mCameraControl.getSupportedAfMode(this.getDefaultAfMode());
            this.mSessionListenerForCancel = captureResult -> {
                Integer afMode = (Integer)captureResult.get(CaptureResult.CONTROL_AF_MODE);
                if (afMode == targetAfMode && Camera2CameraControlImpl.isSessionUpdated(captureResult, sessionUpdateId)) {
                    this.completeCancelFuture();
                    return true;
                }
                return false;
            };
            this.mCameraControl.addCaptureResultListener(this.mSessionListenerForCancel);
        }
    }

    boolean isFocusMeteringSupported(@NonNull FocusMeteringAction action) {
        Rect cropSensorRegion = this.mCameraControl.getCropSensorRegion();
        Rational defaultAspectRatio = this.getDefaultAspectRatio();
        List<MeteringRectangle> rectanglesAf = this.getMeteringRectangles(action.getMeteringPointsAf(), this.mCameraControl.getMaxAfRegionCount(), defaultAspectRatio, cropSensorRegion, 1);
        List<MeteringRectangle> rectanglesAe = this.getMeteringRectangles(action.getMeteringPointsAe(), this.mCameraControl.getMaxAeRegionCount(), defaultAspectRatio, cropSensorRegion, 2);
        List<MeteringRectangle> rectanglesAwb = this.getMeteringRectangles(action.getMeteringPointsAwb(), this.mCameraControl.getMaxAwbRegionCount(), defaultAspectRatio, cropSensorRegion, 4);
        return !rectanglesAf.isEmpty() || !rectanglesAe.isEmpty() || !rectanglesAwb.isEmpty();
    }
}

