/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal;

import android.graphics.Rect;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.TotalCaptureResult;
import android.os.Build;
import android.os.Looper;
import android.util.Range;
import androidx.annotation.FloatRange;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.camera.camera2.impl.Camera2ImplConfig;
import androidx.camera.camera2.internal.AndroidRZoomImpl;
import androidx.camera.camera2.internal.Camera2CameraControlImpl;
import androidx.camera.camera2.internal.CropRegionZoomImpl;
import androidx.camera.camera2.internal.ZoomStateImpl;
import androidx.camera.camera2.internal.compat.CameraCharacteristicsCompat;
import androidx.camera.core.CameraControl;
import androidx.camera.core.Logger;
import androidx.camera.core.ZoomState;
import androidx.camera.core.impl.utils.futures.Futures;
import androidx.camera.core.internal.ImmutableZoomState;
import androidx.concurrent.futures.CallbackToFutureAdapter;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executor;

@RequiresApi(value=21)
final class ZoomControl {
    private static final String TAG = "ZoomControl";
    public static final float DEFAULT_ZOOM_RATIO = 1.0f;
    private final Camera2CameraControlImpl mCamera2CameraControlImpl;
    private final Executor mExecutor;
    @GuardedBy(value="mCurrentZoomState")
    private final ZoomStateImpl mCurrentZoomState;
    private final MutableLiveData<ZoomState> mZoomStateLiveData;
    @NonNull
    final ZoomImpl mZoomImpl;
    private boolean mIsActive = false;
    private Camera2CameraControlImpl.CaptureResultListener mCaptureResultListener = new Camera2CameraControlImpl.CaptureResultListener(){

        @Override
        public boolean onCaptureResult(@NonNull TotalCaptureResult captureResult) {
            ZoomControl.this.mZoomImpl.onCaptureResult(captureResult);
            return false;
        }
    };

    ZoomControl(@NonNull Camera2CameraControlImpl camera2CameraControlImpl, @NonNull CameraCharacteristicsCompat cameraCharacteristics, @NonNull Executor executor) {
        this.mCamera2CameraControlImpl = camera2CameraControlImpl;
        this.mExecutor = executor;
        this.mZoomImpl = ZoomControl.createZoomImpl(cameraCharacteristics);
        this.mCurrentZoomState = new ZoomStateImpl(this.mZoomImpl.getMaxZoom(), this.mZoomImpl.getMinZoom());
        this.mCurrentZoomState.setZoomRatio(1.0f);
        this.mZoomStateLiveData = new MutableLiveData((Object)ImmutableZoomState.create((ZoomState)this.mCurrentZoomState));
        camera2CameraControlImpl.addCaptureResultListener(this.mCaptureResultListener);
    }

    static ZoomState getDefaultZoomState(CameraCharacteristicsCompat cameraCharacteristics) {
        ZoomImpl zoomImpl = ZoomControl.createZoomImpl(cameraCharacteristics);
        ZoomStateImpl zoomState = new ZoomStateImpl(zoomImpl.getMaxZoom(), zoomImpl.getMinZoom());
        zoomState.setZoomRatio(1.0f);
        return ImmutableZoomState.create((ZoomState)zoomState);
    }

    private static ZoomImpl createZoomImpl(@NonNull CameraCharacteristicsCompat cameraCharacteristics) {
        if (ZoomControl.isAndroidRZoomSupported(cameraCharacteristics)) {
            return new AndroidRZoomImpl(cameraCharacteristics);
        }
        return new CropRegionZoomImpl(cameraCharacteristics);
    }

    @VisibleForTesting
    static boolean isAndroidRZoomSupported(CameraCharacteristicsCompat cameraCharacteristics) {
        return Build.VERSION.SDK_INT >= 30 && ZoomControl.getZoomRatioRange(cameraCharacteristics) != null;
    }

    @RequiresApi(value=30)
    private static Range<Float> getZoomRatioRange(CameraCharacteristicsCompat cameraCharacteristics) {
        try {
            return (Range)cameraCharacteristics.get(CameraCharacteristics.CONTROL_ZOOM_RATIO_RANGE);
        }
        catch (AssertionError e) {
            Logger.w((String)TAG, (String)"AssertionError, fail to get camera characteristic.", (Throwable)((Object)e));
            return null;
        }
    }

    void addZoomOption(@NonNull Camera2ImplConfig.Builder builder) {
        this.mZoomImpl.addRequestOption(builder);
    }

    @NonNull
    Rect getCropSensorRegion() {
        return this.mZoomImpl.getCropSensorRegion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setActive(boolean isActive) {
        if (this.mIsActive == isActive) {
            return;
        }
        this.mIsActive = isActive;
        if (!this.mIsActive) {
            ZoomState zoomState;
            ZoomStateImpl zoomStateImpl = this.mCurrentZoomState;
            synchronized (zoomStateImpl) {
                this.mCurrentZoomState.setZoomRatio(1.0f);
                zoomState = ImmutableZoomState.create((ZoomState)this.mCurrentZoomState);
            }
            this.updateLiveData(zoomState);
            this.mZoomImpl.resetZoom();
            this.mCamera2CameraControlImpl.updateSessionConfigSynchronous();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    ListenableFuture<Void> setZoomRatio(float ratio) {
        ZoomState zoomState;
        ZoomStateImpl zoomStateImpl = this.mCurrentZoomState;
        synchronized (zoomStateImpl) {
            try {
                this.mCurrentZoomState.setZoomRatio(ratio);
                zoomState = ImmutableZoomState.create((ZoomState)this.mCurrentZoomState);
            }
            catch (IllegalArgumentException e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
        }
        this.updateLiveData(zoomState);
        return CallbackToFutureAdapter.getFuture(completer -> {
            this.mExecutor.execute(() -> this.submitCameraZoomRatio((CallbackToFutureAdapter.Completer<Void>)completer, zoomState));
            return "setZoomRatio";
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitCameraZoomRatio(@NonNull CallbackToFutureAdapter.Completer<Void> completer, @NonNull ZoomState zoomState) {
        if (!this.mIsActive) {
            ZoomStateImpl zoomStateImpl = this.mCurrentZoomState;
            synchronized (zoomStateImpl) {
                this.mCurrentZoomState.setZoomRatio(1.0f);
                zoomState = ImmutableZoomState.create((ZoomState)this.mCurrentZoomState);
            }
            this.updateLiveData(zoomState);
            completer.setException((Throwable)new CameraControl.OperationCanceledException("Camera is not active."));
            return;
        }
        this.updateLiveData(zoomState);
        this.mZoomImpl.setZoomRatio(zoomState.getZoomRatio(), completer);
        this.mCamera2CameraControlImpl.updateSessionConfigSynchronous();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    ListenableFuture<Void> setLinearZoom(@FloatRange(from=0.0, to=1.0) float linearZoom) {
        ZoomState zoomState;
        ZoomStateImpl zoomStateImpl = this.mCurrentZoomState;
        synchronized (zoomStateImpl) {
            try {
                this.mCurrentZoomState.setLinearZoom(linearZoom);
                zoomState = ImmutableZoomState.create((ZoomState)this.mCurrentZoomState);
            }
            catch (IllegalArgumentException e) {
                return Futures.immediateFailedFuture((Throwable)e);
            }
        }
        this.updateLiveData(zoomState);
        return CallbackToFutureAdapter.getFuture(completer -> {
            this.mExecutor.execute(() -> this.submitCameraZoomRatio((CallbackToFutureAdapter.Completer<Void>)completer, zoomState));
            return "setLinearZoom";
        });
    }

    private void updateLiveData(ZoomState zoomState) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            this.mZoomStateLiveData.setValue((Object)zoomState);
        } else {
            this.mZoomStateLiveData.postValue((Object)zoomState);
        }
    }

    LiveData<ZoomState> getZoomState() {
        return this.mZoomStateLiveData;
    }

    static interface ZoomImpl {
        public float getMinZoom();

        public float getMaxZoom();

        public void addRequestOption(@NonNull Camera2ImplConfig.Builder var1);

        public void resetZoom();

        public void setZoomRatio(float var1, @NonNull CallbackToFutureAdapter.Completer<Void> var2);

        public void onCaptureResult(@NonNull TotalCaptureResult var1);

        @NonNull
        public Rect getCropSensorRegion();
    }
}

