/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.camera2.internal.compat.workaround;

import android.util.Size;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.camera.camera2.internal.compat.quirk.DeviceQuirks;
import androidx.camera.camera2.internal.compat.quirk.RepeatingStreamConstraintForVideoRecordingQuirk;
import androidx.camera.core.impl.utils.CompareSizesByArea;
import java.util.ArrayList;
import java.util.Comparator;

@RequiresApi(value=21)
public class SupportedRepeatingSurfaceSize {
    @Nullable
    private final RepeatingStreamConstraintForVideoRecordingQuirk mQuirk = DeviceQuirks.get(RepeatingStreamConstraintForVideoRecordingQuirk.class);
    private static final Size MINI_PREVIEW_SIZE_HUAWEI_MATE_9 = new Size(320, 240);
    private static final Comparator<Size> SIZE_COMPARATOR = new CompareSizesByArea();

    @NonNull
    public Size[] getSupportedSizes(@NonNull Size[] sizes) {
        if (this.mQuirk != null && RepeatingStreamConstraintForVideoRecordingQuirk.isHuaweiMate9()) {
            ArrayList<Size> supportedSizes = new ArrayList<Size>();
            for (Size s : sizes) {
                if (SIZE_COMPARATOR.compare(s, MINI_PREVIEW_SIZE_HUAWEI_MATE_9) < 0) continue;
                supportedSizes.add(s);
            }
            return supportedSizes.toArray(new Size[0]);
        }
        return sizes;
    }
}

