/*
 * Decompiled with CFR 0.152.
 */
package androidx.webkit.internal;

import android.net.Uri;
import android.webkit.WebView;
import androidx.annotation.NonNull;
import androidx.webkit.WebMessageCompat;
import androidx.webkit.WebViewCompat;
import androidx.webkit.internal.JavaScriptReplyProxyImpl;
import androidx.webkit.internal.WebMessageAdapter;
import java.lang.reflect.InvocationHandler;
import org.chromium.support_lib_boundary.WebMessageBoundaryInterface;
import org.chromium.support_lib_boundary.WebMessageListenerBoundaryInterface;
import org.chromium.support_lib_boundary.util.BoundaryInterfaceReflectionUtil;

public class WebMessageListenerAdapter
implements WebMessageListenerBoundaryInterface {
    private WebViewCompat.WebMessageListener mWebMessageListener;

    public WebMessageListenerAdapter(@NonNull WebViewCompat.WebMessageListener webMessageListener) {
        this.mWebMessageListener = webMessageListener;
    }

    @Override
    public void onPostMessage(@NonNull WebView view, @NonNull InvocationHandler message, @NonNull Uri sourceOrigin, boolean isMainFrame, @NonNull InvocationHandler replyProxy) {
        WebMessageCompat webMessage = WebMessageAdapter.webMessageCompatFromBoundaryInterface(BoundaryInterfaceReflectionUtil.castToSuppLibClass(WebMessageBoundaryInterface.class, message));
        if (webMessage != null) {
            JavaScriptReplyProxyImpl jsReplyProxy = JavaScriptReplyProxyImpl.forInvocationHandler(replyProxy);
            this.mWebMessageListener.onPostMessage(view, webMessage, sourceOrigin, isMainFrame, jsReplyProxy);
        }
    }

    @Override
    @NonNull
    public String[] getSupportedFeatures() {
        return new String[]{"WEB_MESSAGE_LISTENER", "WEB_MESSAGE_ARRAY_BUFFER"};
    }
}

