/*
 * Decompiled with CFR 0.152.
 */
package androidx.webkit.internal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.Objects;
import org.chromium.support_lib_boundary.WebMessagePayloadBoundaryInterface;

public class WebMessagePayloadAdapter
implements WebMessagePayloadBoundaryInterface {
    private final int mType;
    @Nullable
    private final String mString;
    @Nullable
    private final byte[] mArrayBuffer;

    public WebMessagePayloadAdapter(@Nullable String data) {
        this.mType = 0;
        this.mString = data;
        this.mArrayBuffer = null;
    }

    public WebMessagePayloadAdapter(@NonNull byte[] arrayBuffer) {
        this.mType = 1;
        this.mString = null;
        this.mArrayBuffer = arrayBuffer;
    }

    @Override
    @NonNull
    public String[] getSupportedFeatures() {
        return new String[0];
    }

    @Override
    public int getType() {
        return this.mType;
    }

    @Override
    @Nullable
    public String getAsString() {
        this.checkType(0);
        return this.mString;
    }

    @Override
    @NonNull
    public byte[] getAsArrayBuffer() {
        this.checkType(1);
        return Objects.requireNonNull(this.mArrayBuffer);
    }

    private void checkType(int expectedType) {
        if (this.mType != expectedType) {
            throw new IllegalStateException("Expected " + expectedType + ", but type is " + this.mType);
        }
    }
}

