/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view;

import android.annotation.SuppressLint;
import android.os.Build;
import android.os.CancellationSignal;
import android.view.View;
import android.view.Window;
import android.view.WindowInsetsAnimationControlListener;
import android.view.WindowInsetsAnimationController;
import android.view.WindowInsetsController;
import android.view.animation.Interpolator;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.collection.SimpleArrayMap;
import androidx.core.view.SoftwareKeyboardControllerCompat;
import androidx.core.view.WindowInsetsAnimationControlListenerCompat;
import androidx.core.view.WindowInsetsAnimationControllerCompat;

public final class WindowInsetsControllerCompat {
    @Deprecated
    public static final int BEHAVIOR_SHOW_BARS_BY_TOUCH = 0;
    public static final int BEHAVIOR_DEFAULT = 1;
    @Deprecated
    public static final int BEHAVIOR_SHOW_BARS_BY_SWIPE = 1;
    public static final int BEHAVIOR_SHOW_TRANSIENT_BARS_BY_SWIPE = 2;
    private final Impl mImpl;

    @Deprecated
    @RequiresApi(value=30)
    private WindowInsetsControllerCompat(@NonNull WindowInsetsController insetsController) {
        this.mImpl = new Impl30(insetsController, this, new SoftwareKeyboardControllerCompat(insetsController));
    }

    public WindowInsetsControllerCompat(@NonNull Window window, @NonNull View view) {
        SoftwareKeyboardControllerCompat softwareKeyboardControllerCompat = new SoftwareKeyboardControllerCompat(view);
        this.mImpl = Build.VERSION.SDK_INT >= 30 ? new Impl30(window, this, softwareKeyboardControllerCompat) : (Build.VERSION.SDK_INT >= 26 ? new Impl26(window, softwareKeyboardControllerCompat) : (Build.VERSION.SDK_INT >= 23 ? new Impl23(window, softwareKeyboardControllerCompat) : (Build.VERSION.SDK_INT >= 20 ? new Impl20(window, softwareKeyboardControllerCompat) : new Impl())));
    }

    @Deprecated
    @NonNull
    @RequiresApi(value=30)
    public static WindowInsetsControllerCompat toWindowInsetsControllerCompat(@NonNull WindowInsetsController insetsController) {
        return new WindowInsetsControllerCompat(insetsController);
    }

    public void show(int types) {
        this.mImpl.show(types);
    }

    public void hide(int types) {
        this.mImpl.hide(types);
    }

    public boolean isAppearanceLightStatusBars() {
        return this.mImpl.isAppearanceLightStatusBars();
    }

    public void setAppearanceLightStatusBars(boolean isLight) {
        this.mImpl.setAppearanceLightStatusBars(isLight);
    }

    public boolean isAppearanceLightNavigationBars() {
        return this.mImpl.isAppearanceLightNavigationBars();
    }

    public void setAppearanceLightNavigationBars(boolean isLight) {
        this.mImpl.setAppearanceLightNavigationBars(isLight);
    }

    public void controlWindowInsetsAnimation(int types, long durationMillis, @Nullable Interpolator interpolator, @Nullable CancellationSignal cancellationSignal, @NonNull WindowInsetsAnimationControlListenerCompat listener) {
        this.mImpl.controlWindowInsetsAnimation(types, durationMillis, interpolator, cancellationSignal, listener);
    }

    public void setSystemBarsBehavior(int behavior) {
        this.mImpl.setSystemBarsBehavior(behavior);
    }

    @SuppressLint(value={"WrongConstant"})
    public int getSystemBarsBehavior() {
        return this.mImpl.getSystemBarsBehavior();
    }

    public void addOnControllableInsetsChangedListener(@NonNull OnControllableInsetsChangedListener listener) {
        this.mImpl.addOnControllableInsetsChangedListener(listener);
    }

    public void removeOnControllableInsetsChangedListener(@NonNull OnControllableInsetsChangedListener listener) {
        this.mImpl.removeOnControllableInsetsChangedListener(listener);
    }

    @RequiresApi(value=30)
    private static class Impl30
    extends Impl {
        final WindowInsetsControllerCompat mCompatController;
        final WindowInsetsController mInsetsController;
        final SoftwareKeyboardControllerCompat mSoftwareKeyboardControllerCompat;
        private final SimpleArrayMap<OnControllableInsetsChangedListener, WindowInsetsController.OnControllableInsetsChangedListener> mListeners = new SimpleArrayMap();
        protected Window mWindow;

        Impl30(@NonNull Window window, @NonNull WindowInsetsControllerCompat compatController, @NonNull SoftwareKeyboardControllerCompat softwareKeyboardControllerCompat) {
            this(window.getInsetsController(), compatController, softwareKeyboardControllerCompat);
            this.mWindow = window;
        }

        Impl30(@NonNull WindowInsetsController insetsController, @NonNull WindowInsetsControllerCompat compatController, @NonNull SoftwareKeyboardControllerCompat softwareKeyboardControllerCompat) {
            this.mInsetsController = insetsController;
            this.mCompatController = compatController;
            this.mSoftwareKeyboardControllerCompat = softwareKeyboardControllerCompat;
        }

        @Override
        void show(int types) {
            if ((types & 8) != 0) {
                this.mSoftwareKeyboardControllerCompat.show();
            }
            this.mInsetsController.show(types & 0xFFFFFFF7);
        }

        @Override
        void hide(int types) {
            if ((types & 8) != 0) {
                this.mSoftwareKeyboardControllerCompat.hide();
            }
            this.mInsetsController.hide(types & 0xFFFFFFF7);
        }

        @Override
        public boolean isAppearanceLightStatusBars() {
            return (this.mInsetsController.getSystemBarsAppearance() & 8) != 0;
        }

        @Override
        public void setAppearanceLightStatusBars(boolean isLight) {
            if (isLight) {
                if (this.mWindow != null) {
                    this.setSystemUiFlag(8192);
                }
                this.mInsetsController.setSystemBarsAppearance(8, 8);
            } else {
                if (this.mWindow != null) {
                    this.unsetSystemUiFlag(8192);
                }
                this.mInsetsController.setSystemBarsAppearance(0, 8);
            }
        }

        @Override
        public boolean isAppearanceLightNavigationBars() {
            return (this.mInsetsController.getSystemBarsAppearance() & 0x10) != 0;
        }

        @Override
        public void setAppearanceLightNavigationBars(boolean isLight) {
            if (isLight) {
                if (this.mWindow != null) {
                    this.setSystemUiFlag(16);
                }
                this.mInsetsController.setSystemBarsAppearance(16, 16);
            } else {
                if (this.mWindow != null) {
                    this.unsetSystemUiFlag(16);
                }
                this.mInsetsController.setSystemBarsAppearance(0, 16);
            }
        }

        @Override
        void controlWindowInsetsAnimation(int types, long durationMillis, @Nullable Interpolator interpolator, @Nullable CancellationSignal cancellationSignal, final @NonNull WindowInsetsAnimationControlListenerCompat listener) {
            WindowInsetsAnimationControlListener fwListener = new WindowInsetsAnimationControlListener(){
                private WindowInsetsAnimationControllerCompat mCompatAnimController = null;

                public void onReady(@NonNull WindowInsetsAnimationController controller, int types) {
                    this.mCompatAnimController = new WindowInsetsAnimationControllerCompat(controller);
                    listener.onReady(this.mCompatAnimController, types);
                }

                public void onFinished(@NonNull WindowInsetsAnimationController controller) {
                    listener.onFinished(this.mCompatAnimController);
                }

                public void onCancelled(@Nullable WindowInsetsAnimationController controller) {
                    listener.onCancelled(controller == null ? null : this.mCompatAnimController);
                }
            };
            this.mInsetsController.controlWindowInsetsAnimation(types, durationMillis, interpolator, cancellationSignal, fwListener);
        }

        @Override
        void setSystemBarsBehavior(int behavior) {
            this.mInsetsController.setSystemBarsBehavior(behavior);
        }

        @Override
        @SuppressLint(value={"WrongConstant"})
        int getSystemBarsBehavior() {
            return this.mInsetsController.getSystemBarsBehavior();
        }

        @Override
        void addOnControllableInsetsChangedListener(@NonNull OnControllableInsetsChangedListener listener) {
            if (this.mListeners.containsKey((Object)listener)) {
                return;
            }
            WindowInsetsController.OnControllableInsetsChangedListener fwListener = (controller, typeMask) -> {
                if (this.mInsetsController == controller) {
                    listener.onControllableInsetsChanged(this.mCompatController, typeMask);
                }
            };
            this.mListeners.put((Object)listener, (Object)fwListener);
            this.mInsetsController.addOnControllableInsetsChangedListener(fwListener);
        }

        @Override
        void removeOnControllableInsetsChangedListener(@NonNull OnControllableInsetsChangedListener listener) {
            WindowInsetsController.OnControllableInsetsChangedListener fwListener = (WindowInsetsController.OnControllableInsetsChangedListener)this.mListeners.remove((Object)listener);
            if (fwListener != null) {
                this.mInsetsController.removeOnControllableInsetsChangedListener(fwListener);
            }
        }

        protected void unsetSystemUiFlag(int systemUiFlag) {
            View decorView = this.mWindow.getDecorView();
            decorView.setSystemUiVisibility(decorView.getSystemUiVisibility() & ~systemUiFlag);
        }

        protected void setSystemUiFlag(int systemUiFlag) {
            View decorView = this.mWindow.getDecorView();
            decorView.setSystemUiVisibility(decorView.getSystemUiVisibility() | systemUiFlag);
        }
    }

    private static class Impl {
        Impl() {
        }

        void show(int types) {
        }

        void hide(int types) {
        }

        void controlWindowInsetsAnimation(int types, long durationMillis, Interpolator interpolator, CancellationSignal cancellationSignal, WindowInsetsAnimationControlListenerCompat listener) {
        }

        void setSystemBarsBehavior(int behavior) {
        }

        int getSystemBarsBehavior() {
            return 0;
        }

        public boolean isAppearanceLightStatusBars() {
            return false;
        }

        public void setAppearanceLightStatusBars(boolean isLight) {
        }

        public boolean isAppearanceLightNavigationBars() {
            return false;
        }

        public void setAppearanceLightNavigationBars(boolean isLight) {
        }

        void addOnControllableInsetsChangedListener(OnControllableInsetsChangedListener listener) {
        }

        void removeOnControllableInsetsChangedListener(@NonNull OnControllableInsetsChangedListener listener) {
        }
    }

    @RequiresApi(value=26)
    private static class Impl26
    extends Impl23 {
        Impl26(@NonNull Window window, @NonNull SoftwareKeyboardControllerCompat softwareKeyboardControllerCompat) {
            super(window, softwareKeyboardControllerCompat);
        }

        @Override
        public boolean isAppearanceLightNavigationBars() {
            return (this.mWindow.getDecorView().getSystemUiVisibility() & 0x10) != 0;
        }

        @Override
        public void setAppearanceLightNavigationBars(boolean isLight) {
            if (isLight) {
                this.unsetWindowFlag(0x8000000);
                this.setWindowFlag(Integer.MIN_VALUE);
                this.setSystemUiFlag(16);
            } else {
                this.unsetSystemUiFlag(16);
            }
        }
    }

    @RequiresApi(value=23)
    private static class Impl23
    extends Impl20 {
        Impl23(@NonNull Window window, @NonNull SoftwareKeyboardControllerCompat softwareKeyboardControllerCompat) {
            super(window, softwareKeyboardControllerCompat);
        }

        @Override
        public boolean isAppearanceLightStatusBars() {
            return (this.mWindow.getDecorView().getSystemUiVisibility() & 0x2000) != 0;
        }

        @Override
        public void setAppearanceLightStatusBars(boolean isLight) {
            if (isLight) {
                this.unsetWindowFlag(0x4000000);
                this.setWindowFlag(Integer.MIN_VALUE);
                this.setSystemUiFlag(8192);
            } else {
                this.unsetSystemUiFlag(8192);
            }
        }
    }

    @RequiresApi(value=20)
    private static class Impl20
    extends Impl {
        @NonNull
        protected final Window mWindow;
        @NonNull
        private final SoftwareKeyboardControllerCompat mSoftwareKeyboardControllerCompat;

        Impl20(@NonNull Window window, @NonNull SoftwareKeyboardControllerCompat softwareKeyboardControllerCompat) {
            this.mWindow = window;
            this.mSoftwareKeyboardControllerCompat = softwareKeyboardControllerCompat;
        }

        @Override
        void show(int typeMask) {
            for (int i = 1; i <= 256; i <<= 1) {
                if ((typeMask & i) == 0) continue;
                this.showForType(i);
            }
        }

        private void showForType(int type) {
            switch (type) {
                case 1: {
                    this.unsetSystemUiFlag(4);
                    this.unsetWindowFlag(1024);
                    return;
                }
                case 2: {
                    this.unsetSystemUiFlag(2);
                    return;
                }
                case 8: {
                    this.mSoftwareKeyboardControllerCompat.show();
                }
            }
        }

        @Override
        void hide(int typeMask) {
            for (int i = 1; i <= 256; i <<= 1) {
                if ((typeMask & i) == 0) continue;
                this.hideForType(i);
            }
        }

        private void hideForType(int type) {
            switch (type) {
                case 1: {
                    this.setSystemUiFlag(4);
                    return;
                }
                case 2: {
                    this.setSystemUiFlag(2);
                    return;
                }
                case 8: {
                    this.mSoftwareKeyboardControllerCompat.hide();
                }
            }
        }

        protected void setSystemUiFlag(int systemUiFlag) {
            View decorView = this.mWindow.getDecorView();
            decorView.setSystemUiVisibility(decorView.getSystemUiVisibility() | systemUiFlag);
        }

        protected void unsetSystemUiFlag(int systemUiFlag) {
            View decorView = this.mWindow.getDecorView();
            decorView.setSystemUiVisibility(decorView.getSystemUiVisibility() & ~systemUiFlag);
        }

        protected void setWindowFlag(int windowFlag) {
            this.mWindow.addFlags(windowFlag);
        }

        protected void unsetWindowFlag(int windowFlag) {
            this.mWindow.clearFlags(windowFlag);
        }

        @Override
        void controlWindowInsetsAnimation(int types, long durationMillis, Interpolator interpolator, CancellationSignal cancellationSignal, WindowInsetsAnimationControlListenerCompat listener) {
        }

        @Override
        void setSystemBarsBehavior(int behavior) {
            switch (behavior) {
                case 1: {
                    this.unsetSystemUiFlag(4096);
                    this.setSystemUiFlag(2048);
                    break;
                }
                case 2: {
                    this.unsetSystemUiFlag(2048);
                    this.setSystemUiFlag(4096);
                    break;
                }
                case 0: {
                    this.unsetSystemUiFlag(6144);
                }
            }
        }

        @Override
        int getSystemBarsBehavior() {
            return 0;
        }

        @Override
        void addOnControllableInsetsChangedListener(OnControllableInsetsChangedListener listener) {
        }

        @Override
        void removeOnControllableInsetsChangedListener(@NonNull OnControllableInsetsChangedListener listener) {
        }
    }

    public static interface OnControllableInsetsChangedListener {
        public void onControllableInsetsChanged(@NonNull WindowInsetsControllerCompat var1, int var2);
    }
}

