/*
 * Decompiled with CFR 0.152.
 */
package androidx.core.view.inputmethod;

import android.content.ClipDescription;
import android.net.Uri;
import android.os.Build;
import android.view.inputmethod.InputContentInfo;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;

public final class InputContentInfoCompat {
    private final InputContentInfoCompatImpl mImpl;

    public InputContentInfoCompat(@NonNull Uri contentUri, @NonNull ClipDescription description, @Nullable Uri linkUri) {
        this.mImpl = Build.VERSION.SDK_INT >= 25 ? new InputContentInfoCompatApi25Impl(contentUri, description, linkUri) : new InputContentInfoCompatBaseImpl(contentUri, description, linkUri);
    }

    private InputContentInfoCompat(@NonNull InputContentInfoCompatImpl impl) {
        this.mImpl = impl;
    }

    @NonNull
    public Uri getContentUri() {
        return this.mImpl.getContentUri();
    }

    @NonNull
    public ClipDescription getDescription() {
        return this.mImpl.getDescription();
    }

    @Nullable
    public Uri getLinkUri() {
        return this.mImpl.getLinkUri();
    }

    @Nullable
    public static InputContentInfoCompat wrap(@Nullable Object inputContentInfo) {
        if (inputContentInfo == null) {
            return null;
        }
        if (Build.VERSION.SDK_INT < 25) {
            return null;
        }
        return new InputContentInfoCompat(new InputContentInfoCompatApi25Impl(inputContentInfo));
    }

    @Nullable
    public Object unwrap() {
        return this.mImpl.getInputContentInfo();
    }

    public void requestPermission() {
        this.mImpl.requestPermission();
    }

    public void releasePermission() {
        this.mImpl.releasePermission();
    }

    @RequiresApi(value=25)
    private static final class InputContentInfoCompatApi25Impl
    implements InputContentInfoCompatImpl {
        @NonNull
        final InputContentInfo mObject;

        InputContentInfoCompatApi25Impl(@NonNull Object inputContentInfo) {
            this.mObject = (InputContentInfo)inputContentInfo;
        }

        InputContentInfoCompatApi25Impl(@NonNull Uri contentUri, @NonNull ClipDescription description, @Nullable Uri linkUri) {
            this.mObject = new InputContentInfo(contentUri, description, linkUri);
        }

        @Override
        @NonNull
        public Uri getContentUri() {
            return this.mObject.getContentUri();
        }

        @Override
        @NonNull
        public ClipDescription getDescription() {
            return this.mObject.getDescription();
        }

        @Override
        @Nullable
        public Uri getLinkUri() {
            return this.mObject.getLinkUri();
        }

        @Override
        @NonNull
        public Object getInputContentInfo() {
            return this.mObject;
        }

        @Override
        public void requestPermission() {
            this.mObject.requestPermission();
        }

        @Override
        public void releasePermission() {
            this.mObject.releasePermission();
        }
    }

    private static interface InputContentInfoCompatImpl {
        @NonNull
        public Uri getContentUri();

        @NonNull
        public ClipDescription getDescription();

        @Nullable
        public Uri getLinkUri();

        @Nullable
        public Object getInputContentInfo();

        public void requestPermission();

        public void releasePermission();
    }

    private static final class InputContentInfoCompatBaseImpl
    implements InputContentInfoCompatImpl {
        @NonNull
        private final Uri mContentUri;
        @NonNull
        private final ClipDescription mDescription;
        @Nullable
        private final Uri mLinkUri;

        InputContentInfoCompatBaseImpl(@NonNull Uri contentUri, @NonNull ClipDescription description, @Nullable Uri linkUri) {
            this.mContentUri = contentUri;
            this.mDescription = description;
            this.mLinkUri = linkUri;
        }

        @Override
        @NonNull
        public Uri getContentUri() {
            return this.mContentUri;
        }

        @Override
        @NonNull
        public ClipDescription getDescription() {
            return this.mDescription;
        }

        @Override
        @Nullable
        public Uri getLinkUri() {
            return this.mLinkUri;
        }

        @Override
        @Nullable
        public Object getInputContentInfo() {
            return null;
        }

        @Override
        public void requestPermission() {
        }

        @Override
        public void releasePermission() {
        }
    }
}

