/*
 * Decompiled with CFR 0.152.
 */
package androidx.webkit.internal;

import android.content.Context;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.os.Build;
import android.util.TypedValue;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.webkit.internal.ApiHelperForN;
import androidx.webkit.internal.MimeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class AssetHelper {
    public static final String DEFAULT_MIME_TYPE = "text/plain";
    @NonNull
    private Context mContext;

    public AssetHelper(@NonNull Context context) {
        this.mContext = context;
    }

    @NonNull
    private static InputStream handleSvgzStream(@NonNull String path, @NonNull InputStream stream) throws IOException {
        return path.endsWith(".svgz") ? new GZIPInputStream(stream) : stream;
    }

    @NonNull
    private static String removeLeadingSlash(@NonNull String path) {
        if (path.length() > 1 && path.charAt(0) == '/') {
            path = path.substring(1);
        }
        return path;
    }

    private int getFieldId(@NonNull String resourceType, @NonNull String resourceName) {
        String packageName = this.mContext.getPackageName();
        int id = this.mContext.getResources().getIdentifier(resourceName, resourceType, packageName);
        return id;
    }

    private int getValueType(int fieldId) {
        TypedValue value = new TypedValue();
        this.mContext.getResources().getValue(fieldId, value, true);
        return value.type;
    }

    @NonNull
    public InputStream openResource(@NonNull String path) throws Resources.NotFoundException, IOException {
        int fieldId;
        int valueType;
        String[] pathSegments = (path = AssetHelper.removeLeadingSlash(path)).split("/", -1);
        if (pathSegments.length != 2) {
            throw new IllegalArgumentException("Incorrect resource path: " + path);
        }
        String resourceType = pathSegments[0];
        String resourceName = pathSegments[1];
        int dotIndex = resourceName.lastIndexOf(46);
        if (dotIndex != -1) {
            resourceName = resourceName.substring(0, dotIndex);
        }
        if ((valueType = this.getValueType(fieldId = this.getFieldId(resourceType, resourceName))) != 3) {
            throw new IOException(String.format("Expected %s resource to be of TYPE_STRING but was %d", path, valueType));
        }
        return AssetHelper.handleSvgzStream(path, this.mContext.getResources().openRawResource(fieldId));
    }

    @NonNull
    public InputStream openAsset(@NonNull String path) throws IOException {
        path = AssetHelper.removeLeadingSlash(path);
        AssetManager assets = this.mContext.getAssets();
        return AssetHelper.handleSvgzStream(path, assets.open(path, 2));
    }

    @NonNull
    public static InputStream openFile(@NonNull File file) throws FileNotFoundException, IOException {
        FileInputStream fis = new FileInputStream(file);
        return AssetHelper.handleSvgzStream(file.getPath(), fis);
    }

    @Nullable
    public static File getCanonicalFileIfChild(@NonNull File parent, @NonNull String child) throws IOException {
        String parentCanonicalPath = AssetHelper.getCanonicalDirPath(parent);
        String childCanonicalPath = new File(parent, child).getCanonicalPath();
        if (childCanonicalPath.startsWith(parentCanonicalPath)) {
            return new File(childCanonicalPath);
        }
        return null;
    }

    @NonNull
    public static String getCanonicalDirPath(@NonNull File file) throws IOException {
        String canonicalPath = file.getCanonicalPath();
        if (!canonicalPath.endsWith("/")) {
            canonicalPath = canonicalPath + "/";
        }
        return canonicalPath;
    }

    @NonNull
    public static File getDataDir(@NonNull Context context) {
        if (Build.VERSION.SDK_INT >= 24) {
            return ApiHelperForN.getDataDir(context);
        }
        return context.getCacheDir().getParentFile();
    }

    @NonNull
    public static String guessMimeType(@NonNull String filePath) {
        String mimeType = MimeUtil.getMimeFromFileName(filePath);
        return mimeType == null ? DEFAULT_MIME_TYPE : mimeType;
    }
}

