/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.hardware.display.DisplayManager;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Rational;
import android.util.Size;
import android.view.Display;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewConfiguration;
import android.widget.FrameLayout;
import androidx.annotation.AnyThread;
import androidx.annotation.ColorRes;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.OptIn;
import androidx.annotation.RequiresApi;
import androidx.annotation.UiThread;
import androidx.annotation.VisibleForTesting;
import androidx.camera.core.Logger;
import androidx.camera.core.MeteringPointFactory;
import androidx.camera.core.Preview;
import androidx.camera.core.SurfaceRequest;
import androidx.camera.core.ViewPort;
import androidx.camera.core.impl.CameraInfoInternal;
import androidx.camera.core.impl.CameraInternal;
import androidx.camera.core.impl.Observable;
import androidx.camera.core.impl.utils.Threads;
import androidx.camera.view.CameraController;
import androidx.camera.view.PreviewStreamStateObserver;
import androidx.camera.view.PreviewTransformation;
import androidx.camera.view.PreviewViewImplementation;
import androidx.camera.view.PreviewViewMeteringPointFactory;
import androidx.camera.view.R;
import androidx.camera.view.SurfaceViewImplementation;
import androidx.camera.view.TextureViewImplementation;
import androidx.camera.view.TransformExperimental;
import androidx.camera.view.TransformUtils;
import androidx.camera.view.internal.compat.quirk.DeviceQuirks;
import androidx.camera.view.internal.compat.quirk.SurfaceViewNotCroppedByParentQuirk;
import androidx.camera.view.internal.compat.quirk.SurfaceViewStretchedQuirk;
import androidx.camera.view.transform.OutputTransform;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import androidx.lifecycle.LiveData;
import androidx.lifecycle.MutableLiveData;
import java.util.concurrent.atomic.AtomicReference;

@RequiresApi(value=21)
public final class PreviewView
extends FrameLayout {
    private static final String TAG = "PreviewView";
    @ColorRes
    static final int DEFAULT_BACKGROUND_COLOR = 17170444;
    private static final ImplementationMode DEFAULT_IMPL_MODE = ImplementationMode.PERFORMANCE;
    @NonNull
    ImplementationMode mImplementationMode = DEFAULT_IMPL_MODE;
    @VisibleForTesting
    @Nullable
    PreviewViewImplementation mImplementation;
    @NonNull
    final PreviewTransformation mPreviewTransform = new PreviewTransformation();
    boolean mUseDisplayRotation = true;
    @NonNull
    final MutableLiveData<StreamState> mPreviewStreamStateLiveData = new MutableLiveData((Object)StreamState.IDLE);
    @Nullable
    final AtomicReference<PreviewStreamStateObserver> mActiveStreamStateObserver = new AtomicReference();
    CameraController mCameraController;
    @NonNull
    PreviewViewMeteringPointFactory mPreviewViewMeteringPointFactory = new PreviewViewMeteringPointFactory(this.mPreviewTransform);
    @NonNull
    private final ScaleGestureDetector mScaleGestureDetector;
    @Nullable
    CameraInfoInternal mCameraInfoInternal;
    @Nullable
    private MotionEvent mTouchUpEvent;
    @NonNull
    private final DisplayRotationListener mDisplayRotationListener = new DisplayRotationListener();
    private final View.OnLayoutChangeListener mOnLayoutChangeListener = (v, left, top, right, bottom, oldLeft, oldTop, oldRight, oldBottom) -> {
        boolean isSizeChanged;
        boolean bl = isSizeChanged = right - left != oldRight - oldLeft || bottom - top != oldBottom - oldTop;
        if (isSizeChanged) {
            this.redrawPreview();
            this.attachToControllerIfReady(true);
        }
    };
    final Preview.SurfaceProvider mSurfaceProvider = new Preview.SurfaceProvider(){

        @AnyThread
        public void onSurfaceRequested(@NonNull SurfaceRequest surfaceRequest) {
            if (!Threads.isMainThread()) {
                ContextCompat.getMainExecutor((Context)PreviewView.this.getContext()).execute(() -> PreviewView.this.mSurfaceProvider.onSurfaceRequested(surfaceRequest));
                return;
            }
            Logger.d((String)PreviewView.TAG, (String)"Surface requested by Preview.");
            CameraInternal camera = surfaceRequest.getCamera();
            PreviewView.this.mCameraInfoInternal = camera.getCameraInfoInternal();
            surfaceRequest.setTransformationInfoListener(ContextCompat.getMainExecutor((Context)PreviewView.this.getContext()), transformationInfo -> {
                Logger.d((String)PreviewView.TAG, (String)("Preview transformation info updated. " + transformationInfo));
                boolean isFrontCamera = camera.getCameraInfoInternal().getLensFacing() == 0;
                PreviewView.this.mPreviewTransform.setTransformationInfo(transformationInfo, surfaceRequest.getResolution(), isFrontCamera);
                PreviewView.this.mUseDisplayRotation = transformationInfo.getTargetRotation() == -1 || PreviewView.this.mImplementation != null && PreviewView.this.mImplementation instanceof SurfaceViewImplementation;
                PreviewView.this.updateDisplayRotationIfNeeded();
                PreviewView.this.redrawPreview();
            });
            PreviewView.this.mImplementation = PreviewView.shouldUseTextureView(surfaceRequest, PreviewView.this.mImplementationMode) ? new TextureViewImplementation(PreviewView.this, PreviewView.this.mPreviewTransform) : new SurfaceViewImplementation(PreviewView.this, PreviewView.this.mPreviewTransform);
            PreviewStreamStateObserver streamStateObserver = new PreviewStreamStateObserver(camera.getCameraInfoInternal(), PreviewView.this.mPreviewStreamStateLiveData, PreviewView.this.mImplementation);
            PreviewView.this.mActiveStreamStateObserver.set(streamStateObserver);
            camera.getCameraState().addObserver(ContextCompat.getMainExecutor((Context)PreviewView.this.getContext()), (Observable.Observer)streamStateObserver);
            PreviewView.this.mImplementation.onSurfaceRequested(surfaceRequest, () -> {
                if (PreviewView.this.mActiveStreamStateObserver.compareAndSet(streamStateObserver, null)) {
                    streamStateObserver.updatePreviewStreamState(StreamState.IDLE);
                }
                streamStateObserver.clear();
                camera.getCameraState().removeObserver((Observable.Observer)streamStateObserver);
            });
        }
    };

    @UiThread
    public PreviewView(@NonNull Context context) {
        this(context, null);
    }

    @UiThread
    public PreviewView(@NonNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    @UiThread
    public PreviewView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @UiThread
    public PreviewView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        Threads.checkMainThread();
        TypedArray attributes = context.getTheme().obtainStyledAttributes(attrs, R.styleable.PreviewView, defStyleAttr, defStyleRes);
        ViewCompat.saveAttributeDataForStyleable((View)this, (Context)context, (int[])R.styleable.PreviewView, (AttributeSet)attrs, (TypedArray)attributes, (int)defStyleAttr, (int)defStyleRes);
        try {
            int scaleTypeId = attributes.getInteger(R.styleable.PreviewView_scaleType, this.mPreviewTransform.getScaleType().getId());
            this.setScaleType(ScaleType.fromId(scaleTypeId));
            int implementationModeId = attributes.getInteger(R.styleable.PreviewView_implementationMode, DEFAULT_IMPL_MODE.getId());
            this.setImplementationMode(ImplementationMode.fromId(implementationModeId));
        }
        finally {
            attributes.recycle();
        }
        this.mScaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new PinchToZoomOnScaleGestureListener());
        if (this.getBackground() == null) {
            this.setBackgroundColor(ContextCompat.getColor((Context)this.getContext(), (int)17170444));
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.updateDisplayRotationIfNeeded();
        this.startListeningToDisplayChange();
        this.addOnLayoutChangeListener(this.mOnLayoutChangeListener);
        if (this.mImplementation != null) {
            this.mImplementation.onAttachedToWindow();
        }
        this.attachToControllerIfReady(true);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeOnLayoutChangeListener(this.mOnLayoutChangeListener);
        if (this.mImplementation != null) {
            this.mImplementation.onDetachedFromWindow();
        }
        if (this.mCameraController != null) {
            this.mCameraController.clearPreviewSurface();
        }
        this.stopListeningToDisplayChange();
    }

    public boolean onTouchEvent(@NonNull MotionEvent event) {
        boolean notALongPress;
        if (this.mCameraController == null) {
            return super.onTouchEvent(event);
        }
        boolean isSingleTouch = event.getPointerCount() == 1;
        boolean isUpEvent = event.getAction() == 1;
        boolean bl = notALongPress = event.getEventTime() - event.getDownTime() < (long)ViewConfiguration.getLongPressTimeout();
        if (isSingleTouch && isUpEvent && notALongPress) {
            this.mTouchUpEvent = event;
            this.performClick();
            return true;
        }
        return this.mScaleGestureDetector.onTouchEvent(event) || super.onTouchEvent(event);
    }

    public boolean performClick() {
        if (this.mCameraController != null) {
            float x = this.mTouchUpEvent != null ? this.mTouchUpEvent.getX() : (float)this.getWidth() / 2.0f;
            float y = this.mTouchUpEvent != null ? this.mTouchUpEvent.getY() : (float)this.getHeight() / 2.0f;
            this.mCameraController.onTapToFocus(this.mPreviewViewMeteringPointFactory, x, y);
        }
        this.mTouchUpEvent = null;
        return super.performClick();
    }

    @UiThread
    public void setImplementationMode(@NonNull ImplementationMode implementationMode) {
        Threads.checkMainThread();
        this.mImplementationMode = implementationMode;
    }

    @UiThread
    @NonNull
    public ImplementationMode getImplementationMode() {
        Threads.checkMainThread();
        return this.mImplementationMode;
    }

    @UiThread
    @NonNull
    public Preview.SurfaceProvider getSurfaceProvider() {
        Threads.checkMainThread();
        return this.mSurfaceProvider;
    }

    @UiThread
    public void setScaleType(@NonNull ScaleType scaleType) {
        Threads.checkMainThread();
        this.mPreviewTransform.setScaleType(scaleType);
        this.redrawPreview();
        this.attachToControllerIfReady(false);
    }

    @UiThread
    @NonNull
    public ScaleType getScaleType() {
        Threads.checkMainThread();
        return this.mPreviewTransform.getScaleType();
    }

    @UiThread
    @NonNull
    public MeteringPointFactory getMeteringPointFactory() {
        Threads.checkMainThread();
        return this.mPreviewViewMeteringPointFactory;
    }

    @NonNull
    public LiveData<StreamState> getPreviewStreamState() {
        return this.mPreviewStreamStateLiveData;
    }

    @UiThread
    @Nullable
    public Bitmap getBitmap() {
        Threads.checkMainThread();
        return this.mImplementation == null ? null : this.mImplementation.getBitmap();
    }

    @UiThread
    @Nullable
    public ViewPort getViewPort() {
        Threads.checkMainThread();
        if (this.getDisplay() == null) {
            return null;
        }
        return this.getViewPort(this.getDisplay().getRotation());
    }

    @UiThread
    @SuppressLint(value={"WrongConstant"})
    @Nullable
    public ViewPort getViewPort(int targetRotation) {
        Threads.checkMainThread();
        if (this.getWidth() == 0 || this.getHeight() == 0) {
            return null;
        }
        return new ViewPort.Builder(new Rational(this.getWidth(), this.getHeight()), targetRotation).setScaleType(this.getViewPortScaleType()).setLayoutDirection(this.getLayoutDirection()).build();
    }

    private int getViewPortScaleType() {
        switch (this.getScaleType()) {
            case FILL_END: {
                return 2;
            }
            case FILL_CENTER: {
                return 1;
            }
            case FILL_START: {
                return 0;
            }
            case FIT_END: 
            case FIT_CENTER: 
            case FIT_START: {
                return 3;
            }
        }
        throw new IllegalStateException("Unexpected scale type: " + (Object)((Object)this.getScaleType()));
    }

    @MainThread
    @OptIn(markerClass={TransformExperimental.class})
    void redrawPreview() {
        Threads.checkMainThread();
        if (this.mImplementation != null) {
            this.mImplementation.redrawPreview();
        }
        this.mPreviewViewMeteringPointFactory.recalculate(new Size(this.getWidth(), this.getHeight()), this.getLayoutDirection());
        if (this.mCameraController != null) {
            this.mCameraController.updatePreviewViewTransform(this.getOutputTransform());
        }
    }

    static boolean shouldUseTextureView(@NonNull SurfaceRequest surfaceRequest, @NonNull ImplementationMode implementationMode) {
        boolean hasSurfaceViewQuirk;
        boolean isLegacyDevice = surfaceRequest.getCamera().getCameraInfoInternal().getImplementationType().equals("androidx.camera.camera2.legacy");
        boolean bl = hasSurfaceViewQuirk = DeviceQuirks.get(SurfaceViewStretchedQuirk.class) != null || DeviceQuirks.get(SurfaceViewNotCroppedByParentQuirk.class) != null;
        if (surfaceRequest.isRGBA8888Required() || Build.VERSION.SDK_INT <= 24 || isLegacyDevice || hasSurfaceViewQuirk) {
            return true;
        }
        switch (implementationMode) {
            case COMPATIBLE: {
                return true;
            }
            case PERFORMANCE: {
                return false;
            }
        }
        throw new IllegalArgumentException("Invalid implementation mode: " + (Object)((Object)implementationMode));
    }

    void updateDisplayRotationIfNeeded() {
        Display display;
        if (this.mUseDisplayRotation && (display = this.getDisplay()) != null && this.mCameraInfoInternal != null) {
            this.mPreviewTransform.overrideWithDisplayRotation(this.mCameraInfoInternal.getSensorRotationDegrees(display.getRotation()), display.getRotation());
        }
    }

    @UiThread
    public void setController(@Nullable CameraController cameraController) {
        Threads.checkMainThread();
        if (this.mCameraController != null && this.mCameraController != cameraController) {
            this.mCameraController.clearPreviewSurface();
        }
        this.mCameraController = cameraController;
        this.attachToControllerIfReady(false);
    }

    @Nullable
    @UiThread
    public CameraController getController() {
        Threads.checkMainThread();
        return this.mCameraController;
    }

    @TransformExperimental
    @Nullable
    public OutputTransform getOutputTransform() {
        Threads.checkMainThread();
        Matrix matrix = null;
        try {
            matrix = this.mPreviewTransform.getSurfaceToPreviewViewMatrix(new Size(this.getWidth(), this.getHeight()), this.getLayoutDirection());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Rect surfaceCropRect = this.mPreviewTransform.getSurfaceCropRect();
        if (matrix == null || surfaceCropRect == null) {
            Logger.d((String)TAG, (String)"Transform info is not ready");
            return null;
        }
        matrix.preConcat(TransformUtils.getNormalizedToBuffer(surfaceCropRect));
        if (this.mImplementation instanceof TextureViewImplementation) {
            matrix.postConcat(this.getMatrix());
        } else {
            Logger.w((String)TAG, (String)"PreviewView needs to be in COMPATIBLE mode for the transform to work correctly.");
        }
        return new OutputTransform(matrix, new Size(surfaceCropRect.width(), surfaceCropRect.height()));
    }

    @MainThread
    private void attachToControllerIfReady(boolean shouldFailSilently) {
        Threads.checkMainThread();
        Display display = this.getDisplay();
        ViewPort viewPort = this.getViewPort();
        if (this.mCameraController != null && viewPort != null && this.isAttachedToWindow() && display != null) {
            try {
                this.mCameraController.attachPreviewSurface(this.getSurfaceProvider(), viewPort, display);
            }
            catch (IllegalStateException ex) {
                if (shouldFailSilently) {
                    Logger.e((String)TAG, (String)ex.toString(), (Throwable)ex);
                }
                throw ex;
            }
        }
    }

    private void startListeningToDisplayChange() {
        DisplayManager displayManager = this.getDisplayManager();
        if (displayManager == null) {
            return;
        }
        displayManager.registerDisplayListener((DisplayManager.DisplayListener)this.mDisplayRotationListener, new Handler(Looper.getMainLooper()));
    }

    private void stopListeningToDisplayChange() {
        DisplayManager displayManager = this.getDisplayManager();
        if (displayManager == null) {
            return;
        }
        displayManager.unregisterDisplayListener((DisplayManager.DisplayListener)this.mDisplayRotationListener);
    }

    @Nullable
    private DisplayManager getDisplayManager() {
        Context context = this.getContext();
        if (context == null) {
            return null;
        }
        return (DisplayManager)context.getApplicationContext().getSystemService("display");
    }

    class DisplayRotationListener
    implements DisplayManager.DisplayListener {
        DisplayRotationListener() {
        }

        public void onDisplayAdded(int displayId) {
        }

        public void onDisplayRemoved(int displayId) {
        }

        public void onDisplayChanged(int displayId) {
            Display display = PreviewView.this.getDisplay();
            if (display != null && display.getDisplayId() == displayId) {
                PreviewView.this.updateDisplayRotationIfNeeded();
                PreviewView.this.redrawPreview();
            }
        }
    }

    class PinchToZoomOnScaleGestureListener
    extends ScaleGestureDetector.SimpleOnScaleGestureListener {
        PinchToZoomOnScaleGestureListener() {
        }

        public boolean onScale(ScaleGestureDetector detector) {
            if (PreviewView.this.mCameraController != null) {
                PreviewView.this.mCameraController.onPinchToZoom(detector.getScaleFactor());
            }
            return true;
        }
    }

    public static enum StreamState {
        IDLE,
        STREAMING;

    }

    @RequiresApi(value=21)
    public static enum ScaleType {
        FILL_START(0),
        FILL_CENTER(1),
        FILL_END(2),
        FIT_START(3),
        FIT_CENTER(4),
        FIT_END(5);

        private final int mId;

        private ScaleType(int id2) {
            this.mId = id2;
        }

        int getId() {
            return this.mId;
        }

        static ScaleType fromId(int id2) {
            for (ScaleType scaleType : ScaleType.values()) {
                if (scaleType.mId != id2) continue;
                return scaleType;
            }
            throw new IllegalArgumentException("Unknown scale type id " + id2);
        }
    }

    @RequiresApi(value=21)
    public static enum ImplementationMode {
        PERFORMANCE(0),
        COMPATIBLE(1);

        private final int mId;

        private ImplementationMode(int id2) {
            this.mId = id2;
        }

        int getId() {
            return this.mId;
        }

        static ImplementationMode fromId(int id2) {
            for (ImplementationMode implementationMode : ImplementationMode.values()) {
                if (implementationMode.mId != id2) continue;
                return implementationMode;
            }
            throw new IllegalArgumentException("Unknown implementation mode id " + id2);
        }
    }
}

