/*
 * Decompiled with CFR 0.152.
 */
package androidx.camera.view;

import android.content.Context;
import android.view.OrientationEventListener;
import androidx.annotation.CheckResult;
import androidx.annotation.GuardedBy;
import androidx.annotation.NonNull;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;

@RequiresApi(value=21)
public final class RotationProvider {
    final Object mLock = new Object();
    @GuardedBy(value="mLock")
    @VisibleForTesting
    @NonNull
    final OrientationEventListener mOrientationListener;
    @GuardedBy(value="mLock")
    @NonNull
    final Map<Listener, ListenerWrapper> mListeners = new HashMap<Listener, ListenerWrapper>();
    @VisibleForTesting
    boolean mIgnoreCanDetectForTest = false;

    public RotationProvider(@NonNull Context context) {
        this.mOrientationListener = new OrientationEventListener(context){
            private static final int INVALID_SURFACE_ROTATION = -1;
            private int mRotation;
            {
                this.mRotation = -1;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onOrientationChanged(int orientation) {
                if (orientation == -1) {
                    return;
                }
                int newRotation = RotationProvider.orientationToSurfaceRotation(orientation);
                if (this.mRotation != newRotation) {
                    ArrayList<ListenerWrapper> listeners;
                    this.mRotation = newRotation;
                    Iterator iterator = RotationProvider.this.mLock;
                    synchronized (iterator) {
                        listeners = new ArrayList<ListenerWrapper>(RotationProvider.this.mListeners.values());
                    }
                    if (!listeners.isEmpty()) {
                        for (ListenerWrapper listenerWrapper : listeners) {
                            listenerWrapper.onRotationChanged(newRotation);
                        }
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckResult
    public boolean addListener(@NonNull Executor executor, @NonNull Listener listener) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mOrientationListener.canDetectOrientation() && !this.mIgnoreCanDetectForTest) {
                return false;
            }
            this.mListeners.put(listener, new ListenerWrapper(listener, executor));
            this.mOrientationListener.enable();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NonNull Listener listener) {
        Object object = this.mLock;
        synchronized (object) {
            ListenerWrapper listenerWrapper = this.mListeners.get(listener);
            if (listenerWrapper != null) {
                listenerWrapper.disable();
                this.mListeners.remove(listener);
            }
            if (this.mListeners.isEmpty()) {
                this.mOrientationListener.disable();
            }
        }
    }

    @VisibleForTesting
    static int orientationToSurfaceRotation(int orientation) {
        if (orientation >= 315 || orientation < 45) {
            return 0;
        }
        if (orientation >= 225) {
            return 1;
        }
        if (orientation >= 135) {
            return 2;
        }
        return 3;
    }

    public static interface Listener {
        public void onRotationChanged(int var1);
    }

    private static class ListenerWrapper {
        private final Listener mListener;
        private final Executor mExecutor;
        private final AtomicBoolean mEnabled;

        ListenerWrapper(Listener listener, Executor executor) {
            this.mListener = listener;
            this.mExecutor = executor;
            this.mEnabled = new AtomicBoolean(true);
        }

        void onRotationChanged(int rotation) {
            this.mExecutor.execute(() -> {
                if (this.mEnabled.get()) {
                    this.mListener.onRotationChanged(rotation);
                }
            });
        }

        void disable() {
            this.mEnabled.set(false);
        }
    }
}

