/*
 * Decompiled with CFR 0.152.
 */
package androidx.webkit.internal;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.webkit.WebViewCompat;
import androidx.webkit.internal.ApiHelperForTiramisu;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public abstract class StartupApiFeature {
    private static final Set<StartupApiFeature> sValues = new HashSet<StartupApiFeature>();
    @VisibleForTesting
    public static final String METADATA_HOLDER_SERVICE_NAME = "org.chromium.android_webview.services.StartupFeatureMetadataHolder";
    private final String mPublicFeatureValue;
    private final String mInternalFeatureValue;

    StartupApiFeature(@NonNull String publicFeatureValue, @NonNull String internalFeatureValue) {
        this.mPublicFeatureValue = publicFeatureValue;
        this.mInternalFeatureValue = internalFeatureValue;
        sValues.add(this);
    }

    @NonNull
    public String getPublicFeatureName() {
        return this.mPublicFeatureValue;
    }

    public boolean isSupported(@NonNull Context context) {
        return this.isSupportedByFramework() || this.isSupportedByWebView(context);
    }

    public abstract boolean isSupportedByFramework();

    @ChecksSdkIntAtLeast(api=21)
    public boolean isSupportedByWebView(@NonNull Context context) {
        Bundle bundle = StartupApiFeature.getMetaDataFromWebViewManifestOrNull(context);
        if (bundle == null) {
            return false;
        }
        return bundle.containsKey(this.mInternalFeatureValue);
    }

    @NonNull
    public static Set<StartupApiFeature> values() {
        return Collections.unmodifiableSet(sValues);
    }

    @Nullable
    private static Bundle getMetaDataFromWebViewManifestOrNull(@NonNull Context context) {
        PackageInfo systemWebViewPackage = WebViewCompat.getCurrentWebViewPackage(context);
        if (systemWebViewPackage == null) {
            return null;
        }
        ComponentName compName = new ComponentName(systemWebViewPackage.packageName, METADATA_HOLDER_SERVICE_NAME);
        if (Build.VERSION.SDK_INT >= 33) {
            PackageManager.ComponentInfoFlags flags = ApiHelperForTiramisu.of(640L);
            try {
                return ApiHelperForTiramisu.getServiceInfo((PackageManager)context.getPackageManager(), (ComponentName)compName, (PackageManager.ComponentInfoFlags)flags).metaData;
            }
            catch (PackageManager.NameNotFoundException e) {
                return null;
            }
        }
        int flags = 128;
        if (Build.VERSION.SDK_INT >= 24) {
            flags |= 0x200;
        }
        try {
            return StartupApiFeature.getServiceInfo((Context)context, (ComponentName)compName, (int)flags).metaData;
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    private static ServiceInfo getServiceInfo(@NonNull Context context, ComponentName compName, int flags) throws PackageManager.NameNotFoundException {
        assert (Build.VERSION.SDK_INT < 33);
        return context.getPackageManager().getServiceInfo(compName, flags);
    }

    public static class NoFramework
    extends StartupApiFeature {
        NoFramework(@NonNull String publicFeatureValue, @NonNull String internalFeatureValue) {
            super(publicFeatureValue, internalFeatureValue);
        }

        @Override
        public final boolean isSupportedByFramework() {
            return false;
        }
    }

    public static class P
    extends StartupApiFeature {
        P(@NonNull String publicFeatureValue, @NonNull String internalFeatureValue) {
            super(publicFeatureValue, internalFeatureValue);
        }

        @Override
        public final boolean isSupportedByFramework() {
            return Build.VERSION.SDK_INT >= 28;
        }
    }
}

