/*
 * Decompiled with CFR 0.152.
 */
package io.capawesome.capacitorjs.plugins.mlkit.barcodescanning;

import android.graphics.Point;
import android.util.DisplayMetrics;
import androidx.activity.result.ActivityResult;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.getcapacitor.JSArray;
import com.getcapacitor.JSObject;
import com.getcapacitor.Logger;
import com.getcapacitor.Plugin;
import com.getcapacitor.PluginCall;
import com.getcapacitor.PluginMethod;
import com.getcapacitor.annotation.ActivityCallback;
import com.getcapacitor.annotation.CapacitorPlugin;
import com.getcapacitor.annotation.Permission;
import com.getcapacitor.annotation.PermissionCallback;
import com.google.mlkit.vision.barcode.common.Barcode;
import io.capawesome.capacitorjs.plugins.mlkit.barcodescanning.BarcodeScanner;
import io.capawesome.capacitorjs.plugins.mlkit.barcodescanning.BarcodeScannerHelper;
import io.capawesome.capacitorjs.plugins.mlkit.barcodescanning.InstallGoogleBarcodeScannerModuleResultCallback;
import io.capawesome.capacitorjs.plugins.mlkit.barcodescanning.IsGoogleBarodeScannerModuleAvailableResultCallback;
import io.capawesome.capacitorjs.plugins.mlkit.barcodescanning.ReadBarcodesFromImageResultCallback;
import io.capawesome.capacitorjs.plugins.mlkit.barcodescanning.ScanResultCallback;
import io.capawesome.capacitorjs.plugins.mlkit.barcodescanning.ScanSettings;
import io.capawesome.capacitorjs.plugins.mlkit.barcodescanning.StartScanResultCallback;
import io.capawesome.capacitorjs.plugins.mlkit.barcodescanning.classes.options.SetZoomRatioOptions;
import io.capawesome.capacitorjs.plugins.mlkit.barcodescanning.classes.results.GetMaxZoomRatioResult;
import io.capawesome.capacitorjs.plugins.mlkit.barcodescanning.classes.results.GetMinZoomRatioResult;
import io.capawesome.capacitorjs.plugins.mlkit.barcodescanning.classes.results.GetZoomRatioResult;
import java.util.List;

@CapacitorPlugin(name="BarcodeScanner", permissions={@Permission(strings={"android.permission.CAMERA"}, alias="camera")})
public class BarcodeScannerPlugin
extends Plugin {
    public static final String TAG = "BarcodeScanner";
    public static final String CAMERA = "camera";
    public static final String BARCODE_SCANNED_EVENT = "barcodeScanned";
    public static final String BARCODES_SCANNED_EVENT = "barcodesScanned";
    public static final String SCAN_ERROR_EVENT = "scanError";
    public static final String GOOGLE_BARCODE_SCANNER_MODULE_INSTALL_PROGRESS_EVENT = "googleBarcodeScannerModuleInstallProgress";
    public static final String ERROR_SCAN_CANCELED = "scan canceled.";
    public static final String ERROR_PATH_MISSING = "path must be provided.";
    public static final String ERROR_LOAD_IMAGE_FAILED = "The image could not be loaded.";
    public static final String ERROR_ZOOM_RATIO_MISSING = "zoomRatio must be provided.";
    public static final String ERROR_NO_ACTIVE_SCAN_SESSION = "There is no active scan session.";
    public static final String ERROR_GOOGLE_BARCODE_SCANNER_MODULE_NOT_AVAILABLE = "The Google Barcode Scanner Module is not available. You must install it first using the installGoogleBarcodeScannerModule method.";
    public static final String ERROR_GOOGLE_BARCODE_SCANNER_MODULE_ALREADY_INSTALLED = "The Google Barcode Scanner Module is already installed.";
    public static final String ERROR_PERMISSION_DENIED = "User denied access to camera.";
    private BarcodeScanner implementation;

    public void load() {
        try {
            this.implementation = new BarcodeScanner(this);
        }
        catch (Exception exception) {
            Logger.error((String)TAG, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    @PluginMethod
    public void startScan(final PluginCall call) {
        try {
            List formatsOption = call.getArray("formats", new JSArray()).toList();
            int[] formats = BarcodeScannerHelper.convertStringsToBarcodeScannerFormats(formatsOption.toArray(new String[0]));
            String lensFacingOption = call.getString("lensFacing", "BACK");
            int lensFacing = lensFacingOption.equals("FRONT") ? 0 : 1;
            ScanSettings scanSettings = new ScanSettings();
            scanSettings.formats = formats;
            scanSettings.lensFacing = lensFacing;
            boolean granted = this.implementation.requestCameraPermissionIfNotDetermined(call);
            if (!granted) {
                return;
            }
            this.getActivity().runOnUiThread(() -> this.implementation.startScan(scanSettings, new StartScanResultCallback(){

                @Override
                public void success() {
                    call.resolve();
                }

                @Override
                public void error(Exception exception) {
                    Logger.error((String)BarcodeScannerPlugin.TAG, (String)exception.getMessage(), (Throwable)exception);
                    call.reject(exception.getMessage());
                }
            }));
        }
        catch (Exception exception) {
            Logger.error((String)TAG, (String)exception.getMessage(), (Throwable)exception);
            call.reject(exception.getMessage());
        }
    }

    @PluginMethod
    public void stopScan(PluginCall call) {
        try {
            this.getActivity().runOnUiThread(() -> {
                this.implementation.stopScan();
                call.resolve();
            });
        }
        catch (Exception exception) {
            Logger.error((String)TAG, (String)exception.getMessage(), (Throwable)exception);
            call.reject(exception.getMessage());
        }
    }

    @PluginMethod
    public void readBarcodesFromImage(final PluginCall call) {
        try {
            String path = call.getString("path");
            if (path == null) {
                call.reject(ERROR_PATH_MISSING);
                return;
            }
            List formatsOption = call.getArray("formats", new JSArray()).toList();
            int[] formats = BarcodeScannerHelper.convertStringsToBarcodeScannerFormats(formatsOption.toArray(new String[0]));
            ScanSettings scanSettings = new ScanSettings();
            scanSettings.formats = formats;
            this.implementation.readBarcodesFromImage(path, scanSettings, new ReadBarcodesFromImageResultCallback(){

                @Override
                public void success(List<Barcode> barcodes) {
                    JSArray barcodeResults = new JSArray();
                    for (Barcode barcode : barcodes) {
                        barcodeResults.put((Object)BarcodeScannerHelper.createBarcodeResultForBarcode(barcode, null, null));
                    }
                    JSObject result = new JSObject();
                    result.put("barcodes", (Object)barcodeResults);
                    call.resolve(result);
                }

                @Override
                public void error(Exception exception) {
                    Logger.error((String)BarcodeScannerPlugin.TAG, (String)"readBarcodeFromImage failed.", (Throwable)exception);
                    call.reject(exception.getMessage());
                }
            });
        }
        catch (Exception exception) {
            Logger.error((String)TAG, (String)exception.getMessage(), (Throwable)exception);
            call.reject(exception.getMessage());
        }
    }

    @PluginMethod
    public void scan(final PluginCall call) {
        try {
            List formatsOption = call.getArray("formats", new JSArray()).toList();
            int[] formats = BarcodeScannerHelper.convertStringsToBarcodeScannerFormats(formatsOption.toArray(new String[0]));
            final ScanSettings scanSettings = new ScanSettings();
            scanSettings.formats = formats;
            this.implementation.isGoogleBarcodeScannerModuleAvailable(new IsGoogleBarodeScannerModuleAvailableResultCallback(){

                @Override
                public void success(boolean isAvailable) {
                    if (isAvailable) {
                        BarcodeScannerPlugin.this.implementation.scan(scanSettings, new ScanResultCallback(){

                            @Override
                            public void success(Barcode barcode) {
                                JSObject barcodeResult = BarcodeScannerHelper.createBarcodeResultForBarcode(barcode, null, null);
                                JSArray barcodeResults = new JSArray();
                                barcodeResults.put((Object)barcodeResult);
                                JSObject result = new JSObject();
                                result.put("barcodes", (Object)barcodeResults);
                                call.resolve(result);
                            }

                            @Override
                            public void cancel() {
                                call.reject(BarcodeScannerPlugin.ERROR_SCAN_CANCELED);
                            }

                            @Override
                            public void error(Exception exception) {
                                Logger.error((String)BarcodeScannerPlugin.TAG, (String)exception.getMessage(), (Throwable)exception);
                                call.reject(exception.getMessage());
                            }
                        });
                    } else {
                        call.reject(BarcodeScannerPlugin.ERROR_GOOGLE_BARCODE_SCANNER_MODULE_NOT_AVAILABLE);
                    }
                }

                @Override
                public void error(Exception exception) {
                    Logger.error((String)BarcodeScannerPlugin.TAG, (String)exception.getMessage(), (Throwable)exception);
                    call.reject(exception.getMessage());
                }
            });
        }
        catch (Exception exception) {
            Logger.error((String)TAG, (String)exception.getMessage(), (Throwable)exception);
            call.reject(exception.getMessage());
        }
    }

    @PluginMethod
    public void isSupported(PluginCall call) {
        try {
            JSObject result = new JSObject();
            result.put("supported", this.implementation.isSupported());
            call.resolve(result);
        }
        catch (Exception exception) {
            Logger.error((String)TAG, (String)exception.getMessage(), (Throwable)exception);
            call.reject(exception.getMessage());
        }
    }

    @PluginMethod
    public void enableTorch(PluginCall call) {
        try {
            this.implementation.enableTorch();
            call.resolve();
        }
        catch (Exception exception) {
            Logger.error((String)TAG, (String)exception.getMessage(), (Throwable)exception);
            call.reject(exception.getMessage());
        }
    }

    @PluginMethod
    public void disableTorch(PluginCall call) {
        try {
            this.implementation.disableTorch();
            call.resolve();
        }
        catch (Exception exception) {
            Logger.error((String)TAG, (String)exception.getMessage(), (Throwable)exception);
            call.reject(exception.getMessage());
        }
    }

    @PluginMethod
    public void toggleTorch(PluginCall call) {
        try {
            this.implementation.toggleTorch();
            call.resolve();
        }
        catch (Exception exception) {
            Logger.error((String)TAG, (String)exception.getMessage(), (Throwable)exception);
            call.reject(exception.getMessage());
        }
    }

    @PluginMethod
    public void isTorchEnabled(PluginCall call) {
        try {
            JSObject result = new JSObject();
            result.put("enabled", this.implementation.isTorchEnabled());
            call.resolve(result);
        }
        catch (Exception exception) {
            Logger.error((String)TAG, (String)exception.getMessage(), (Throwable)exception);
            call.reject(exception.getMessage());
        }
    }

    @PluginMethod
    public void isTorchAvailable(PluginCall call) {
        try {
            JSObject result = new JSObject();
            result.put("available", this.implementation.isTorchAvailable());
            call.resolve(result);
        }
        catch (Exception exception) {
            Logger.error((String)TAG, (String)exception.getMessage(), (Throwable)exception);
            call.reject(exception.getMessage());
        }
    }

    @PluginMethod
    public void setZoomRatio(PluginCall call) {
        try {
            Float zoomRatio = call.getFloat("zoomRatio");
            if (zoomRatio == null) {
                call.reject(ERROR_ZOOM_RATIO_MISSING);
                return;
            }
            SetZoomRatioOptions options = new SetZoomRatioOptions(zoomRatio.floatValue());
            this.implementation.setZoomRatio(options);
            call.resolve();
        }
        catch (Exception exception) {
            Logger.error((String)TAG, (String)exception.getMessage(), (Throwable)exception);
            call.reject(exception.getMessage());
        }
    }

    @PluginMethod
    public void getZoomRatio(PluginCall call) {
        try {
            boolean isCameraActive = this.implementation.isCameraActive();
            if (!isCameraActive) {
                call.reject(ERROR_NO_ACTIVE_SCAN_SESSION);
                return;
            }
            GetZoomRatioResult result = this.implementation.getZoomRatio();
            call.resolve(result.toJSObject());
        }
        catch (Exception exception) {
            Logger.error((String)TAG, (String)exception.getMessage(), (Throwable)exception);
            call.reject(exception.getMessage());
        }
    }

    @PluginMethod
    public void getMinZoomRatio(PluginCall call) {
        try {
            boolean isCameraActive = this.implementation.isCameraActive();
            if (!isCameraActive) {
                call.reject(ERROR_NO_ACTIVE_SCAN_SESSION);
                return;
            }
            GetMinZoomRatioResult result = this.implementation.getMinZoomRatio();
            call.resolve(result.toJSObject());
        }
        catch (Exception exception) {
            Logger.error((String)TAG, (String)exception.getMessage(), (Throwable)exception);
            call.reject(exception.getMessage());
        }
    }

    @PluginMethod
    public void getMaxZoomRatio(PluginCall call) {
        try {
            boolean isCameraActive = this.implementation.isCameraActive();
            if (!isCameraActive) {
                call.reject(ERROR_NO_ACTIVE_SCAN_SESSION);
                return;
            }
            GetMaxZoomRatioResult result = this.implementation.getMaxZoomRatio();
            call.resolve(result.toJSObject());
        }
        catch (Exception exception) {
            Logger.error((String)TAG, (String)exception.getMessage(), (Throwable)exception);
            call.reject(exception.getMessage());
        }
    }

    @PluginMethod
    public void openSettings(PluginCall call) {
        try {
            this.implementation.openSettings(call);
        }
        catch (Exception exception) {
            Logger.error((String)TAG, (String)exception.getMessage(), (Throwable)exception);
            call.reject(exception.getMessage());
        }
    }

    @PluginMethod
    public void isGoogleBarcodeScannerModuleAvailable(final PluginCall call) {
        try {
            this.implementation.isGoogleBarcodeScannerModuleAvailable(new IsGoogleBarodeScannerModuleAvailableResultCallback(){

                @Override
                public void success(boolean isAvailable) {
                    JSObject result = new JSObject();
                    result.put("available", isAvailable);
                    call.resolve(result);
                }

                @Override
                public void error(Exception exception) {
                    Logger.error((String)BarcodeScannerPlugin.TAG, (String)exception.getMessage(), (Throwable)exception);
                    call.reject(exception.getMessage());
                }
            });
        }
        catch (Exception exception) {
            Logger.error((String)TAG, (String)exception.getMessage(), (Throwable)exception);
            call.reject(exception.getMessage());
        }
    }

    @PluginMethod
    public void installGoogleBarcodeScannerModule(final PluginCall call) {
        try {
            this.implementation.installGoogleBarcodeScannerModule(new InstallGoogleBarcodeScannerModuleResultCallback(){

                @Override
                public void success() {
                    call.resolve();
                }

                @Override
                public void error(Exception exception) {
                    Logger.error((String)BarcodeScannerPlugin.TAG, (String)exception.getMessage(), (Throwable)exception);
                    call.reject(exception.getMessage());
                }
            });
        }
        catch (Exception exception) {
            Logger.error((String)TAG, (String)exception.getMessage(), (Throwable)exception);
            call.reject(exception.getMessage());
        }
    }

    @PluginMethod
    public void requestPermissions(PluginCall call) {
        if (this.isPermissionDeclared(CAMERA)) {
            super.requestPermissions(call);
        } else {
            this.checkPermissions(call);
        }
    }

    public void requestPermissionForAlias(@NonNull String alias, @NonNull PluginCall call, @NonNull String callbackName) {
        super.requestPermissionForAlias(alias, call, callbackName);
    }

    @ActivityCallback
    public void openSettingsResult(PluginCall call, ActivityResult result) {
        try {
            if (call == null) {
                Logger.debug((String)"openSettingsResult was called with empty call parameter.");
                return;
            }
            call.resolve();
        }
        catch (Exception exception) {
            Logger.error((String)TAG, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    @PermissionCallback
    private void cameraPermissionsCallback(PluginCall call) {
        if (call.getMethodName().equals("startScan")) {
            this.startScan(call);
        }
    }

    public void notifyBarcodeScannedListener(Barcode barcode, Point imageSize) {
        try {
            Point screenSize = this.getScreenSize();
            JSObject barcodeResult = BarcodeScannerHelper.createBarcodeResultForBarcode(barcode, imageSize, screenSize);
            JSObject result = new JSObject();
            result.put("barcode", (Object)barcodeResult);
            this.notifyListeners(BARCODE_SCANNED_EVENT, result);
        }
        catch (Exception exception) {
            Logger.error((String)TAG, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    public void notifyBarcodesScannedListener(Barcode[] barcodes, Point imageSize) {
        try {
            Point screenSize = this.getScreenSize();
            JSArray barcodesResult = new JSArray();
            for (Barcode barcode : barcodes) {
                JSObject barcodeResult = BarcodeScannerHelper.createBarcodeResultForBarcode(barcode, imageSize, screenSize);
                barcodesResult.put((Object)barcodeResult);
            }
            JSObject result = new JSObject();
            result.put("barcodes", (Object)barcodesResult);
            this.notifyListeners(BARCODES_SCANNED_EVENT, result);
        }
        catch (Exception exception) {
            Logger.error((String)TAG, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    public void notifyScanErrorListener(String message) {
        try {
            JSObject result = new JSObject();
            result.put("message", message);
            this.notifyListeners(SCAN_ERROR_EVENT, result);
        }
        catch (Exception exception) {
            Logger.error((String)TAG, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    public void notifyGoogleBarcodeScannerModuleInstallProgressListener(int state, @Nullable Integer progress) {
        try {
            JSObject result = new JSObject();
            result.put("state", state);
            if (progress != null) {
                result.put("progress", (Object)progress);
            }
            this.notifyListeners(GOOGLE_BARCODE_SCANNER_MODULE_INSTALL_PROGRESS_EVENT, result);
        }
        catch (Exception exception) {
            Logger.error((String)TAG, (String)exception.getMessage(), (Throwable)exception);
        }
    }

    private Point getScreenSize() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.getActivity().getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        Point displaySize = new Point(displayMetrics.widthPixels, displayMetrics.heightPixels);
        return displaySize;
    }
}

