/*
 * Decompiled with CFR 0.152.
 */
package io.capawesome.capacitorjs.plugins.mlkit.barcodescanning;

import android.content.Context;
import android.content.Intent;
import android.graphics.Point;
import android.media.Image;
import android.net.Uri;
import android.view.Display;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.camera.core.Camera;
import androidx.camera.core.CameraSelector;
import androidx.camera.core.ImageAnalysis;
import androidx.camera.core.ImageProxy;
import androidx.camera.core.Preview;
import androidx.camera.core.UseCase;
import androidx.camera.core.ZoomState;
import androidx.camera.lifecycle.ProcessCameraProvider;
import androidx.camera.view.PreviewView;
import androidx.core.content.ContextCompat;
import androidx.lifecycle.LifecycleOwner;
import com.getcapacitor.PermissionState;
import com.getcapacitor.PluginCall;
import com.google.android.gms.common.api.OptionalModuleApi;
import com.google.android.gms.common.moduleinstall.InstallStatusListener;
import com.google.android.gms.common.moduleinstall.ModuleInstall;
import com.google.android.gms.common.moduleinstall.ModuleInstallClient;
import com.google.android.gms.common.moduleinstall.ModuleInstallRequest;
import com.google.android.gms.common.moduleinstall.ModuleInstallStatusUpdate;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.mlkit.vision.barcode.BarcodeScannerOptions;
import com.google.mlkit.vision.barcode.BarcodeScanning;
import com.google.mlkit.vision.barcode.common.Barcode;
import com.google.mlkit.vision.codescanner.GmsBarcodeScanner;
import com.google.mlkit.vision.codescanner.GmsBarcodeScannerOptions;
import com.google.mlkit.vision.codescanner.GmsBarcodeScanning;
import com.google.mlkit.vision.common.InputImage;
import io.capawesome.capacitorjs.plugins.mlkit.barcodescanning.BarcodeScannerPlugin;
import io.capawesome.capacitorjs.plugins.mlkit.barcodescanning.InstallGoogleBarcodeScannerModuleResultCallback;
import io.capawesome.capacitorjs.plugins.mlkit.barcodescanning.IsGoogleBarodeScannerModuleAvailableResultCallback;
import io.capawesome.capacitorjs.plugins.mlkit.barcodescanning.ModuleInstallProgressListener;
import io.capawesome.capacitorjs.plugins.mlkit.barcodescanning.R;
import io.capawesome.capacitorjs.plugins.mlkit.barcodescanning.ReadBarcodesFromImageResultCallback;
import io.capawesome.capacitorjs.plugins.mlkit.barcodescanning.ScanResultCallback;
import io.capawesome.capacitorjs.plugins.mlkit.barcodescanning.ScanSettings;
import io.capawesome.capacitorjs.plugins.mlkit.barcodescanning.StartScanResultCallback;
import io.capawesome.capacitorjs.plugins.mlkit.barcodescanning.classes.options.SetZoomRatioOptions;
import io.capawesome.capacitorjs.plugins.mlkit.barcodescanning.classes.results.GetMaxZoomRatioResult;
import io.capawesome.capacitorjs.plugins.mlkit.barcodescanning.classes.results.GetMinZoomRatioResult;
import io.capawesome.capacitorjs.plugins.mlkit.barcodescanning.classes.results.GetZoomRatioResult;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class BarcodeScanner
implements ImageAnalysis.Analyzer {
    @NonNull
    private final BarcodeScannerPlugin plugin;
    private final Point displaySize;
    @Nullable
    private com.google.mlkit.vision.barcode.BarcodeScanner barcodeScannerInstance;
    @Nullable
    private Camera camera;
    @Nullable
    private ProcessCameraProvider processCameraProvider;
    @Nullable
    private PreviewView previewView;
    @Nullable
    private ScanSettings scanSettings;
    @Nullable
    private ModuleInstallProgressListener moduleInstallProgressListener;
    private HashMap<String, Integer> barcodeRawValueVotes = new HashMap();
    private boolean isTorchEnabled = false;

    public BarcodeScanner(BarcodeScannerPlugin plugin) {
        this.plugin = plugin;
        this.displaySize = this.getDisplaySize();
    }

    public void startScan(ScanSettings scanSettings, StartScanResultCallback callback) {
        this.stopScan();
        this.hideWebViewBackground();
        this.scanSettings = scanSettings;
        BarcodeScannerOptions options = this.buildBarcodeScannerOptions(scanSettings);
        this.barcodeScannerInstance = BarcodeScanning.getClient((BarcodeScannerOptions)options);
        ImageAnalysis imageAnalysis = new ImageAnalysis.Builder().setBackpressureStrategy(0).build();
        imageAnalysis.setAnalyzer(ContextCompat.getMainExecutor((Context)this.plugin.getContext()), (ImageAnalysis.Analyzer)this);
        ListenableFuture cameraProviderFuture = ProcessCameraProvider.getInstance((Context)this.plugin.getContext());
        cameraProviderFuture.addListener(() -> {
            try {
                this.processCameraProvider = (ProcessCameraProvider)cameraProviderFuture.get();
                CameraSelector cameraSelector = new CameraSelector.Builder().requireLensFacing(this.scanSettings.lensFacing.intValue()).build();
                this.previewView = (PreviewView)this.plugin.getActivity().findViewById(R.id.preview_view);
                this.previewView.setScaleType(PreviewView.ScaleType.FILL_CENTER);
                Preview preview = new Preview.Builder().build();
                preview.setSurfaceProvider(this.previewView.getSurfaceProvider());
                this.camera = this.processCameraProvider.bindToLifecycle((LifecycleOwner)this.plugin.getContext(), cameraSelector, new UseCase[]{preview, imageAnalysis});
                callback.success();
            }
            catch (Exception exception) {
                callback.error(exception);
            }
        }, ContextCompat.getMainExecutor((Context)this.plugin.getContext()));
    }

    public void stopScan() {
        this.showWebViewBackground();
        this.disableTorch();
        if (this.processCameraProvider != null) {
            this.processCameraProvider.unbindAll();
        }
        this.processCameraProvider = null;
        this.camera = null;
        this.barcodeScannerInstance = null;
        this.scanSettings = null;
        this.barcodeRawValueVotes.clear();
    }

    public void readBarcodesFromImage(String path, ScanSettings scanSettings, ReadBarcodesFromImageResultCallback callback) throws Exception {
        InputImage inputImage;
        try {
            inputImage = InputImage.fromFilePath((Context)this.plugin.getContext(), (Uri)Uri.parse((String)path));
        }
        catch (Exception exception2) {
            throw new Exception("The image could not be loaded.");
        }
        BarcodeScannerOptions options = this.buildBarcodeScannerOptions(scanSettings);
        com.google.mlkit.vision.barcode.BarcodeScanner barcodeScannerInstance = BarcodeScanning.getClient((BarcodeScannerOptions)options);
        barcodeScannerInstance.process(inputImage).addOnSuccessListener(barcodes -> callback.success((List<Barcode>)barcodes)).addOnFailureListener(exception -> callback.error(exception));
    }

    public void scan(ScanSettings scanSettings, ScanResultCallback callback) {
        GmsBarcodeScannerOptions options = this.buildGmsBarcodeScannerOptions(scanSettings);
        GmsBarcodeScanner scanner = GmsBarcodeScanning.getClient((Context)this.plugin.getContext(), (GmsBarcodeScannerOptions)options);
        scanner.startScan().addOnSuccessListener(barcode -> callback.success((Barcode)barcode)).addOnCanceledListener(() -> callback.cancel()).addOnFailureListener(exception -> callback.error(exception));
    }

    public void isGoogleBarcodeScannerModuleAvailable(IsGoogleBarodeScannerModuleAvailableResultCallback callback) {
        GmsBarcodeScanner scanner = GmsBarcodeScanning.getClient((Context)this.plugin.getContext());
        ModuleInstallClient moduleInstallClient = ModuleInstall.getClient((Context)this.plugin.getContext());
        moduleInstallClient.areModulesAvailable(new OptionalModuleApi[]{scanner}).addOnSuccessListener(response -> {
            boolean isAvailable = response.areModulesAvailable();
            callback.success(isAvailable);
        }).addOnFailureListener(exception -> callback.error(exception));
    }

    public void installGoogleBarcodeScannerModule(InstallGoogleBarcodeScannerModuleResultCallback callback) {
        GmsBarcodeScanner scanner = GmsBarcodeScanning.getClient((Context)this.plugin.getContext());
        ModuleInstallProgressListener listener = new ModuleInstallProgressListener(this);
        ModuleInstallRequest moduleInstallRequest = ModuleInstallRequest.newBuilder().addApi((OptionalModuleApi)scanner).setListener((InstallStatusListener)listener).build();
        ModuleInstallClient moduleInstallClient = ModuleInstall.getClient((Context)this.plugin.getContext());
        moduleInstallClient.installModules(moduleInstallRequest).addOnSuccessListener(moduleInstallResponse -> {
            if (moduleInstallResponse.areModulesAlreadyInstalled()) {
                callback.error(new Exception("The Google Barcode Scanner Module is already installed."));
            } else {
                callback.success();
            }
        }).addOnFailureListener(exception -> callback.error(exception));
    }

    public boolean isSupported() {
        return this.plugin.getContext().getPackageManager().hasSystemFeature("android.hardware.camera.any");
    }

    public void enableTorch() {
        if (this.camera == null) {
            return;
        }
        this.camera.getCameraControl().enableTorch(true);
        this.isTorchEnabled = true;
    }

    public void disableTorch() {
        if (this.camera == null) {
            return;
        }
        this.camera.getCameraControl().enableTorch(false);
        this.isTorchEnabled = false;
    }

    public void toggleTorch() {
        if (this.isTorchEnabled) {
            this.disableTorch();
        } else {
            this.enableTorch();
        }
    }

    public boolean isTorchEnabled() {
        return this.isTorchEnabled;
    }

    public boolean isTorchAvailable() {
        return this.plugin.getContext().getPackageManager().hasSystemFeature("android.hardware.camera.flash");
    }

    public void setZoomRatio(SetZoomRatioOptions options) {
        float zoomRatio = options.getZoomRatio();
        if (this.camera == null) {
            return;
        }
        this.camera.getCameraControl().setZoomRatio(zoomRatio);
    }

    @Nullable
    public GetZoomRatioResult getZoomRatio() {
        if (this.camera == null) {
            return null;
        }
        float zoomRatio = ((ZoomState)this.camera.getCameraInfo().getZoomState().getValue()).getZoomRatio();
        return new GetZoomRatioResult(zoomRatio);
    }

    @Nullable
    public GetMinZoomRatioResult getMinZoomRatio() {
        if (this.camera == null) {
            return null;
        }
        float minZoomRatio = ((ZoomState)this.camera.getCameraInfo().getZoomState().getValue()).getMinZoomRatio();
        return new GetMinZoomRatioResult(minZoomRatio);
    }

    @Nullable
    public GetMaxZoomRatioResult getMaxZoomRatio() {
        if (this.camera == null) {
            return null;
        }
        float maxZoomRatio = ((ZoomState)this.camera.getCameraInfo().getZoomState().getValue()).getMaxZoomRatio();
        return new GetMaxZoomRatioResult(maxZoomRatio);
    }

    public void openSettings(PluginCall call) {
        Uri uri = Uri.fromParts((String)"package", (String)this.plugin.getAppId(), null);
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS", uri);
        this.plugin.startActivityForResult(call, intent, "openSettingsResult");
    }

    public PermissionState getCameraPermission() {
        return this.plugin.getPermissionState("camera");
    }

    public void requestCameraPermission(PluginCall call) {
        this.plugin.requestPermissionForAlias("camera", call, "cameraPermissionsCallback");
    }

    public boolean requestCameraPermissionIfNotDetermined(PluginCall call) throws Exception {
        PermissionState state = this.getCameraPermission();
        if (state == PermissionState.GRANTED) {
            return true;
        }
        if (state == PermissionState.DENIED) {
            throw new Exception("User denied access to camera.");
        }
        this.requestCameraPermission(call);
        return false;
    }

    public boolean isCameraActive() {
        return this.camera != null;
    }

    public void analyze(@NonNull ImageProxy imageProxy) {
        Image image = imageProxy.getImage();
        if (image == null || this.barcodeScannerInstance == null) {
            return;
        }
        InputImage inputImage = InputImage.fromMediaImage((Image)image, (int)imageProxy.getImageInfo().getRotationDegrees());
        Point imageSize = new Point(inputImage.getWidth(), inputImage.getHeight());
        this.barcodeScannerInstance.process(inputImage).addOnSuccessListener(barcodes -> {
            if (this.scanSettings == null) {
                return;
            }
            List<Barcode> barcodesWithEnoughVotes = this.voteForBarcodes((List<Barcode>)barcodes);
            for (Barcode barcode : barcodesWithEnoughVotes) {
                this.handleScannedBarcode(barcode, imageSize);
            }
            if (barcodesWithEnoughVotes.size() > 0) {
                this.handleScannedBarcodes(barcodesWithEnoughVotes.toArray(new Barcode[0]), imageSize);
            }
        }).addOnFailureListener(exception -> this.handleScanError(exception)).addOnCompleteListener(task -> {
            imageProxy.close();
            image.close();
        });
    }

    public void handleGoogleBarcodeScannerModuleInstallProgress(@ModuleInstallStatusUpdate.InstallState int state, @Nullable Integer progress) {
        this.plugin.notifyGoogleBarcodeScannerModuleInstallProgressListener(state, progress);
        boolean isTerminateState = ModuleInstallProgressListener.isTerminateState(state);
        if (isTerminateState && this.moduleInstallProgressListener != null) {
            ModuleInstallClient moduleInstallClient = ModuleInstall.getClient((Context)this.plugin.getContext());
            moduleInstallClient.unregisterListener((InstallStatusListener)this.moduleInstallProgressListener);
            this.moduleInstallProgressListener = null;
        }
    }

    private Point getDisplaySize() {
        WindowManager wm = (WindowManager)this.plugin.getContext().getSystemService("window");
        Display display = wm.getDefaultDisplay();
        Point size = new Point();
        display.getRealSize(size);
        return size;
    }

    private void hideWebViewBackground() {
        this.plugin.getBridge().getWebView().setBackgroundColor(0);
    }

    private void showWebViewBackground() {
        this.plugin.getBridge().getWebView().setBackgroundColor(-1);
    }

    private void handleScannedBarcode(Barcode barcode, Point imageSize) {
        this.plugin.notifyBarcodeScannedListener(barcode, imageSize);
    }

    private void handleScannedBarcodes(Barcode[] barcodes, Point imageSize) {
        this.plugin.notifyBarcodesScannedListener(barcodes, imageSize);
    }

    private void handleScanError(Exception exception) {
        this.plugin.notifyScanErrorListener(exception.getMessage());
    }

    private BarcodeScannerOptions buildBarcodeScannerOptions(ScanSettings scanSettings) {
        int[] nArray;
        if (scanSettings.formats.length == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = scanSettings.formats;
        }
        int[] formats = nArray;
        BarcodeScannerOptions options = new BarcodeScannerOptions.Builder().setBarcodeFormats(formats[0], formats).build();
        return options;
    }

    private GmsBarcodeScannerOptions buildGmsBarcodeScannerOptions(ScanSettings scanSettings) {
        int[] nArray;
        if (scanSettings.formats.length == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = scanSettings.formats;
        }
        int[] formats = nArray;
        GmsBarcodeScannerOptions options = new GmsBarcodeScannerOptions.Builder().setBarcodeFormats(formats[0], formats).build();
        return options;
    }

    private Integer voteForBarcode(Barcode barcode) {
        String rawValue = barcode.getRawValue();
        if (rawValue == null) {
            return 1;
        }
        if (this.barcodeRawValueVotes.containsKey(rawValue)) {
            this.barcodeRawValueVotes.put(rawValue, this.barcodeRawValueVotes.get(rawValue) + 1);
        } else {
            this.barcodeRawValueVotes.put(rawValue, 1);
        }
        return this.barcodeRawValueVotes.get(rawValue);
    }

    private List<Barcode> voteForBarcodes(List<Barcode> barcodes) {
        ArrayList<Barcode> barcodesWithEnoughVotes = new ArrayList<Barcode>();
        for (Barcode barcode : barcodes) {
            Integer votes = this.voteForBarcode(barcode);
            if (votes < 10) continue;
            barcodesWithEnoughVotes.add(barcode);
        }
        return barcodesWithEnoughVotes;
    }
}

