/*
 * Decompiled with CFR 0.152.
 */
package com.capacitorjs.plugins.app;

import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import androidx.activity.OnBackPressedCallback;
import androidx.core.content.pm.PackageInfoCompat;
import androidx.lifecycle.LifecycleOwner;
import com.getcapacitor.JSObject;
import com.getcapacitor.Logger;
import com.getcapacitor.Plugin;
import com.getcapacitor.PluginCall;
import com.getcapacitor.PluginMethod;
import com.getcapacitor.annotation.CapacitorPlugin;
import com.getcapacitor.util.InternalUtils;

@CapacitorPlugin(name="App")
public class AppPlugin
extends Plugin {
    private static final String EVENT_BACK_BUTTON = "backButton";
    private static final String EVENT_URL_OPEN = "appUrlOpen";
    private static final String EVENT_STATE_CHANGE = "appStateChange";
    private static final String EVENT_RESTORED_RESULT = "appRestoredResult";
    private static final String EVENT_PAUSE = "pause";
    private static final String EVENT_RESUME = "resume";
    private boolean hasPausedEver = false;

    public void load() {
        this.bridge.getApp().setStatusChangeListener(isActive -> {
            Logger.debug((String)this.getLogTag(), (String)("Firing change: " + isActive));
            JSObject data = new JSObject();
            data.put("isActive", (Object)isActive);
            this.notifyListeners(EVENT_STATE_CHANGE, data, false);
        });
        this.bridge.getApp().setAppRestoredListener(result -> {
            Logger.debug((String)this.getLogTag(), (String)"Firing restored result");
            this.notifyListeners(EVENT_RESTORED_RESULT, result.getWrappedResult(), true);
        });
        OnBackPressedCallback callback = new OnBackPressedCallback(true){

            public void handleOnBackPressed() {
                if (!AppPlugin.this.hasListeners(AppPlugin.EVENT_BACK_BUTTON)) {
                    if (AppPlugin.this.bridge.getWebView().canGoBack()) {
                        AppPlugin.this.bridge.getWebView().goBack();
                    }
                } else {
                    JSObject data = new JSObject();
                    data.put("canGoBack", AppPlugin.this.bridge.getWebView().canGoBack());
                    AppPlugin.this.notifyListeners(AppPlugin.EVENT_BACK_BUTTON, data, true);
                    AppPlugin.this.bridge.triggerJSEvent("backbutton", "document");
                }
            }
        };
        this.getActivity().getOnBackPressedDispatcher().addCallback((LifecycleOwner)this.getActivity(), callback);
    }

    @PluginMethod
    public void exitApp(PluginCall call) {
        this.unsetAppListeners();
        call.resolve();
        this.getBridge().getActivity().finish();
    }

    @PluginMethod
    public void getInfo(PluginCall call) {
        JSObject data = new JSObject();
        try {
            PackageInfo pinfo = InternalUtils.getPackageInfo((PackageManager)this.getContext().getPackageManager(), (String)this.getContext().getPackageName());
            ApplicationInfo applicationInfo = this.getContext().getApplicationInfo();
            int stringId = applicationInfo.labelRes;
            String appName = stringId == 0 ? applicationInfo.nonLocalizedLabel.toString() : this.getContext().getString(stringId);
            data.put("name", appName);
            data.put("id", pinfo.packageName);
            data.put("build", Integer.toString((int)PackageInfoCompat.getLongVersionCode((PackageInfo)pinfo)));
            data.put("version", pinfo.versionName);
            call.resolve(data);
        }
        catch (Exception ex) {
            call.reject("Unable to get App Info");
        }
    }

    @PluginMethod
    public void getLaunchUrl(PluginCall call) {
        Uri launchUri = this.bridge.getIntentUri();
        if (launchUri != null) {
            JSObject d = new JSObject();
            d.put("url", launchUri.toString());
            call.resolve(d);
        } else {
            call.resolve();
        }
    }

    @PluginMethod
    public void getState(PluginCall call) {
        JSObject data = new JSObject();
        data.put("isActive", this.bridge.getApp().isActive());
        call.resolve(data);
    }

    @PluginMethod
    public void minimizeApp(PluginCall call) {
        this.getActivity().moveTaskToBack(true);
        call.resolve();
    }

    protected void handleOnNewIntent(Intent intent) {
        super.handleOnNewIntent(intent);
        String action = intent.getAction();
        Uri url = intent.getData();
        if (!"android.intent.action.VIEW".equals(action) || url == null) {
            return;
        }
        JSObject ret = new JSObject();
        ret.put("url", url.toString());
        this.notifyListeners(EVENT_URL_OPEN, ret, true);
    }

    protected void handleOnPause() {
        super.handleOnPause();
        this.hasPausedEver = true;
        this.notifyListeners(EVENT_PAUSE, null);
    }

    protected void handleOnResume() {
        super.handleOnResume();
        if (this.hasPausedEver) {
            this.notifyListeners(EVENT_RESUME, null);
        }
    }

    protected void handleOnDestroy() {
        this.unsetAppListeners();
    }

    private void unsetAppListeners() {
        this.bridge.getApp().setStatusChangeListener(null);
        this.bridge.getApp().setAppRestoredListener(null);
    }
}

