/*
 * Decompiled with CFR 0.152.
 */
package com.capacitorjs.plugins.filesystem;

import android.content.Context;
import android.media.MediaScannerConnection;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import com.capacitorjs.plugins.filesystem.Filesystem;
import com.capacitorjs.plugins.filesystem.exceptions.CopyFailedException;
import com.capacitorjs.plugins.filesystem.exceptions.DirectoryExistsException;
import com.capacitorjs.plugins.filesystem.exceptions.DirectoryNotFoundException;
import com.getcapacitor.JSArray;
import com.getcapacitor.JSObject;
import com.getcapacitor.Logger;
import com.getcapacitor.PermissionState;
import com.getcapacitor.Plugin;
import com.getcapacitor.PluginCall;
import com.getcapacitor.PluginMethod;
import com.getcapacitor.annotation.CapacitorPlugin;
import com.getcapacitor.annotation.Permission;
import com.getcapacitor.annotation.PermissionCallback;
import com.getcapacitor.plugin.util.HttpRequestHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import org.json.JSONException;

@CapacitorPlugin(name="Filesystem", permissions={@Permission(strings={"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"}, alias="publicStorage")})
public class FilesystemPlugin
extends Plugin {
    static final String PUBLIC_STORAGE = "publicStorage";
    private Filesystem implementation;
    private static final String PERMISSION_DENIED_ERROR = "Unable to do file operation, user denied permission request";

    public void load() {
        this.implementation = new Filesystem(this.getContext());
    }

    @PluginMethod
    public void readFile(PluginCall call) {
        String path = call.getString("path");
        String directory = this.getDirectoryParameter(call);
        String encoding = call.getString("encoding");
        Charset charset = this.implementation.getEncoding(encoding);
        if (encoding != null && charset == null) {
            call.reject("Unsupported encoding provided: " + encoding);
            return;
        }
        if (this.isPublicDirectory(directory) && !this.isStoragePermissionGranted()) {
            this.requestAllPermissions(call, "permissionCallback");
        } else {
            try {
                String dataStr = this.implementation.readFile(path, directory, charset);
                JSObject ret = new JSObject();
                ret.putOpt("data", (Object)dataStr);
                call.resolve(ret);
            }
            catch (FileNotFoundException ex) {
                call.reject("File does not exist", (Exception)ex);
            }
            catch (IOException ex) {
                call.reject("Unable to read file", (Exception)ex);
            }
            catch (JSONException ex) {
                call.reject("Unable to return value for reading file", (Exception)((Object)ex));
            }
        }
    }

    @PluginMethod
    public void writeFile(PluginCall call) {
        String path = call.getString("path");
        String data = call.getString("data");
        Boolean recursive = call.getBoolean("recursive", Boolean.valueOf(false));
        if (path == null) {
            Logger.error((String)this.getLogTag(), (String)"No path or filename retrieved from call", null);
            call.reject("NO_PATH");
            return;
        }
        if (data == null) {
            Logger.error((String)this.getLogTag(), (String)"No data retrieved from call", null);
            call.reject("NO_DATA");
            return;
        }
        String directory = this.getDirectoryParameter(call);
        if (directory != null) {
            if (this.isPublicDirectory(directory) && !this.isStoragePermissionGranted()) {
                this.requestAllPermissions(call, "permissionCallback");
            } else {
                File androidDir = this.implementation.getDirectory(directory);
                if (androidDir != null) {
                    if (androidDir.exists() || androidDir.mkdirs()) {
                        File fileObject = new File(androidDir, path);
                        if (fileObject.getParentFile().exists() || recursive.booleanValue() && fileObject.getParentFile().mkdirs()) {
                            this.saveFile(call, fileObject, data);
                        } else {
                            call.reject("Parent folder doesn't exist");
                        }
                    } else {
                        Logger.error((String)this.getLogTag(), (String)("Not able to create '" + directory + "'!"), null);
                        call.reject("NOT_CREATED_DIR");
                    }
                } else {
                    Logger.error((String)this.getLogTag(), (String)("Directory ID '" + directory + "' is not supported by plugin"), null);
                    call.reject("INVALID_DIR");
                }
            }
        } else {
            Uri u = Uri.parse((String)path);
            if (u.getScheme() == null || u.getScheme().equals("file")) {
                File fileObject = new File(u.getPath());
                if (!this.isStoragePermissionGranted()) {
                    this.requestAllPermissions(call, "permissionCallback");
                } else if (fileObject.getParentFile() == null || fileObject.getParentFile().exists() || recursive.booleanValue() && fileObject.getParentFile().mkdirs()) {
                    this.saveFile(call, fileObject, data);
                } else {
                    call.reject("Parent folder doesn't exist");
                }
            } else {
                call.reject(u.getScheme() + " scheme not supported");
            }
        }
    }

    private void saveFile(PluginCall call, File file, String data) {
        String encoding = call.getString("encoding");
        boolean append = call.getBoolean("append", Boolean.valueOf(false));
        Charset charset = this.implementation.getEncoding(encoding);
        if (encoding != null && charset == null) {
            call.reject("Unsupported encoding provided: " + encoding);
            return;
        }
        try {
            this.implementation.saveFile(file, data, charset, append);
            if (this.isPublicDirectory(this.getDirectoryParameter(call))) {
                MediaScannerConnection.scanFile((Context)this.getContext(), (String[])new String[]{file.getAbsolutePath()}, null, null);
            }
            Logger.debug((String)this.getLogTag(), (String)("File '" + file.getAbsolutePath() + "' saved!"));
            JSObject result = new JSObject();
            result.put("uri", Uri.fromFile((File)file).toString());
            call.resolve(result);
        }
        catch (IOException ex) {
            Logger.error((String)this.getLogTag(), (String)("Creating file '" + file.getPath() + "' with charset '" + charset + "' failed. Error: " + ex.getMessage()), (Throwable)ex);
            call.reject("FILE_NOTCREATED");
        }
        catch (IllegalArgumentException ex) {
            call.reject("The supplied data is not valid base64 content.");
        }
    }

    @PluginMethod
    public void appendFile(PluginCall call) {
        try {
            call.getData().putOpt("append", (Object)true);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.writeFile(call);
    }

    @PluginMethod
    public void deleteFile(PluginCall call) {
        String file = call.getString("path");
        String directory = this.getDirectoryParameter(call);
        if (this.isPublicDirectory(directory) && !this.isStoragePermissionGranted()) {
            this.requestAllPermissions(call, "permissionCallback");
        } else {
            try {
                boolean deleted = this.implementation.deleteFile(file, directory);
                if (!deleted) {
                    call.reject("Unable to delete file");
                } else {
                    call.resolve();
                }
            }
            catch (FileNotFoundException ex) {
                call.reject(ex.getMessage());
            }
        }
    }

    @PluginMethod
    public void mkdir(PluginCall call) {
        String path = call.getString("path");
        String directory = this.getDirectoryParameter(call);
        boolean recursive = call.getBoolean("recursive", Boolean.valueOf(false));
        if (this.isPublicDirectory(directory) && !this.isStoragePermissionGranted()) {
            this.requestAllPermissions(call, "permissionCallback");
        } else {
            try {
                boolean created = this.implementation.mkdir(path, directory, recursive);
                if (!created) {
                    call.reject("Unable to create directory, unknown reason");
                } else {
                    call.resolve();
                }
            }
            catch (DirectoryExistsException ex) {
                call.reject(ex.getMessage());
            }
        }
    }

    @PluginMethod
    public void rmdir(PluginCall call) {
        String path = call.getString("path");
        String directory = this.getDirectoryParameter(call);
        Boolean recursive = call.getBoolean("recursive", Boolean.valueOf(false));
        File fileObject = this.implementation.getFileObject(path, directory);
        if (this.isPublicDirectory(directory) && !this.isStoragePermissionGranted()) {
            this.requestAllPermissions(call, "permissionCallback");
        } else {
            if (!fileObject.exists()) {
                call.reject("Directory does not exist");
                return;
            }
            if (fileObject.isDirectory() && fileObject.listFiles().length != 0 && !recursive.booleanValue()) {
                call.reject("Directory is not empty");
                return;
            }
            boolean deleted = false;
            try {
                this.implementation.deleteRecursively(fileObject);
                deleted = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!deleted) {
                call.reject("Unable to delete directory, unknown reason");
            } else {
                call.resolve();
            }
        }
    }

    @PluginMethod
    public void readdir(PluginCall call) {
        block12: {
            String path = call.getString("path");
            String directory = this.getDirectoryParameter(call);
            if (this.isPublicDirectory(directory) && !this.isStoragePermissionGranted()) {
                this.requestAllPermissions(call, "permissionCallback");
            } else {
                try {
                    File[] files = this.implementation.readdir(path, directory);
                    JSArray filesArray = new JSArray();
                    if (files != null) {
                        for (int i = 0; i < files.length; ++i) {
                            JSObject data;
                            block11: {
                                File fileObject = files[i];
                                data = new JSObject();
                                data.put("name", fileObject.getName());
                                data.put("type", fileObject.isDirectory() ? "directory" : "file");
                                data.put("size", fileObject.length());
                                data.put("mtime", fileObject.lastModified());
                                data.put("uri", Uri.fromFile((File)fileObject).toString());
                                if (Build.VERSION.SDK_INT >= 26) {
                                    try {
                                        BasicFileAttributes attr = Files.readAttributes(fileObject.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                                        if (attr.creationTime().toMillis() < attr.lastAccessTime().toMillis()) {
                                            data.put("ctime", attr.creationTime().toMillis());
                                            break block11;
                                        }
                                        data.put("ctime", attr.lastAccessTime().toMillis());
                                    }
                                    catch (Exception exception) {}
                                } else {
                                    data.put("ctime", null);
                                }
                            }
                            filesArray.put((Object)data);
                        }
                        JSObject ret = new JSObject();
                        ret.put("files", (Object)filesArray);
                        call.resolve(ret);
                        break block12;
                    }
                    call.reject("Unable to read directory");
                }
                catch (DirectoryNotFoundException ex) {
                    call.reject(ex.getMessage());
                }
            }
        }
    }

    @PluginMethod
    public void getUri(PluginCall call) {
        String path = call.getString("path");
        String directory = this.getDirectoryParameter(call);
        File fileObject = this.implementation.getFileObject(path, directory);
        if (this.isPublicDirectory(directory) && !this.isStoragePermissionGranted()) {
            this.requestAllPermissions(call, "permissionCallback");
        } else {
            JSObject data = new JSObject();
            data.put("uri", Uri.fromFile((File)fileObject).toString());
            call.resolve(data);
        }
    }

    @PluginMethod
    public void stat(PluginCall call) {
        String path = call.getString("path");
        String directory = this.getDirectoryParameter(call);
        File fileObject = this.implementation.getFileObject(path, directory);
        if (this.isPublicDirectory(directory) && !this.isStoragePermissionGranted()) {
            this.requestAllPermissions(call, "permissionCallback");
        } else {
            JSObject data;
            block8: {
                if (!fileObject.exists()) {
                    call.reject("File does not exist");
                    return;
                }
                data = new JSObject();
                data.put("type", fileObject.isDirectory() ? "directory" : "file");
                data.put("size", fileObject.length());
                data.put("mtime", fileObject.lastModified());
                data.put("uri", Uri.fromFile((File)fileObject).toString());
                if (Build.VERSION.SDK_INT >= 26) {
                    try {
                        BasicFileAttributes attr = Files.readAttributes(fileObject.toPath(), BasicFileAttributes.class, new LinkOption[0]);
                        if (attr.creationTime().toMillis() < attr.lastAccessTime().toMillis()) {
                            data.put("ctime", attr.creationTime().toMillis());
                            break block8;
                        }
                        data.put("ctime", attr.lastAccessTime().toMillis());
                    }
                    catch (Exception exception) {}
                } else {
                    data.put("ctime", null);
                }
            }
            call.resolve(data);
        }
    }

    @PluginMethod
    public void rename(PluginCall call) {
        this._copy(call, true);
    }

    @PluginMethod
    public void copy(PluginCall call) {
        this._copy(call, false);
    }

    @PluginMethod
    public void downloadFile(final PluginCall call) {
        try {
            final String directory = call.getString("directory", Environment.DIRECTORY_DOWNLOADS);
            if (this.isPublicDirectory(directory) && !this.isStoragePermissionGranted()) {
                this.requestAllPermissions(call, "permissionCallback");
                return;
            }
            HttpRequestHandler.ProgressEmitter emitter = (bytes, contentLength) -> {
                JSObject ret = new JSObject();
                ret.put("url", call.getString("url"));
                ret.put("bytes", (Object)bytes);
                ret.put("contentLength", (Object)contentLength);
                this.notifyListeners("progress", ret);
            };
            this.implementation.downloadFile(call, this.bridge, emitter, new Filesystem.FilesystemDownloadCallback(){

                @Override
                public void onSuccess(JSObject response) {
                    if (FilesystemPlugin.this.isPublicDirectory(directory)) {
                        MediaScannerConnection.scanFile((Context)FilesystemPlugin.this.getContext(), (String[])new String[]{response.getString("path")}, null, null);
                    }
                    call.resolve(response);
                }

                @Override
                public void onError(Exception error) {
                    call.reject("Error downloading file: " + error.getLocalizedMessage(), error);
                }
            });
        }
        catch (Exception ex) {
            call.reject("Error downloading file: " + ex.getLocalizedMessage(), ex);
        }
    }

    private void _copy(PluginCall call, Boolean doRename) {
        String from = call.getString("from");
        String to = call.getString("to");
        String directory = call.getString("directory");
        String toDirectory = call.getString("toDirectory");
        if (from == null || from.isEmpty() || to == null || to.isEmpty()) {
            call.reject("Both to and from must be provided");
            return;
        }
        if ((this.isPublicDirectory(directory) || this.isPublicDirectory(toDirectory)) && !this.isStoragePermissionGranted()) {
            this.requestAllPermissions(call, "permissionCallback");
            return;
        }
        try {
            File file = this.implementation.copy(from, directory, to, toDirectory, doRename);
            if (!doRename.booleanValue()) {
                JSObject result = new JSObject();
                result.put("uri", Uri.fromFile((File)file).toString());
                call.resolve(result);
            } else {
                call.resolve();
            }
        }
        catch (CopyFailedException ex) {
            call.reject(ex.getMessage());
        }
        catch (IOException ex) {
            call.reject("Unable to perform action: " + ex.getLocalizedMessage());
        }
    }

    @PluginMethod
    public void checkPermissions(PluginCall call) {
        if (this.isStoragePermissionGranted()) {
            JSObject permissionsResultJSON = new JSObject();
            permissionsResultJSON.put(PUBLIC_STORAGE, "granted");
            call.resolve(permissionsResultJSON);
        } else {
            super.checkPermissions(call);
        }
    }

    @PluginMethod
    public void requestPermissions(PluginCall call) {
        if (this.isStoragePermissionGranted()) {
            JSObject permissionsResultJSON = new JSObject();
            permissionsResultJSON.put(PUBLIC_STORAGE, "granted");
            call.resolve(permissionsResultJSON);
        } else {
            super.requestPermissions(call);
        }
    }

    @PermissionCallback
    private void permissionCallback(PluginCall call) {
        if (!this.isStoragePermissionGranted()) {
            Logger.debug((String)this.getLogTag(), (String)"User denied storage permission");
            call.reject(PERMISSION_DENIED_ERROR);
            return;
        }
        switch (call.getMethodName()) {
            case "appendFile": 
            case "writeFile": {
                this.writeFile(call);
                break;
            }
            case "deleteFile": {
                this.deleteFile(call);
                break;
            }
            case "mkdir": {
                this.mkdir(call);
                break;
            }
            case "rmdir": {
                this.rmdir(call);
                break;
            }
            case "rename": {
                this.rename(call);
                break;
            }
            case "copy": {
                this.copy(call);
                break;
            }
            case "readFile": {
                this.readFile(call);
                break;
            }
            case "readdir": {
                this.readdir(call);
                break;
            }
            case "getUri": {
                this.getUri(call);
                break;
            }
            case "stat": {
                this.stat(call);
                break;
            }
            case "downloadFile": {
                this.downloadFile(call);
            }
        }
    }

    private boolean isStoragePermissionGranted() {
        return Build.VERSION.SDK_INT >= 30 || this.getPermissionState(PUBLIC_STORAGE) == PermissionState.GRANTED;
    }

    private String getDirectoryParameter(PluginCall call) {
        return call.getString("directory");
    }

    private boolean isPublicDirectory(String directory) {
        return "DOCUMENTS".equals(directory) || "EXTERNAL_STORAGE".equals(directory);
    }
}

